@extends('layouts.frontend')

@section('title', __('Payment Successful'))

@section('content')
<main class="flex-1 pt-32 pb-20 overflow-hidden relative">
    <!-- Ambient Background -->
    <div class="absolute top-0 right-0 w-[50%] h-[50%] bg-primary/5 blur-[120px] rounded-full -z-10"></div>
    <div class="absolute bottom-0 left-0 w-[50%] h-[50%] bg-accent/5 blur-[120px] rounded-full -z-10"></div>

    <div class="container mx-auto px-4">
        <div class="max-w-2xl mx-auto">
            <div
                x-data="{ shown: false }"
                x-init="setTimeout(() => shown = true, 0)"
                class="p-10 md:p-14 rounded-[3rem] bg-card border border-border shadow-2xl text-center transition-all duration-700 transform"
                :class="shown ? 'opacity-100 scale-100' : 'opacity-0 scale-95'">

                @if($order->status === 'pending_verification')
                    <!-- Pending Icon -->
                    <div class="mx-auto mb-8 h-20 w-20 rounded-full bg-amber-500/10 flex items-center justify-center">
                        <div class="h-14 w-14 rounded-full bg-amber-500/20 flex items-center justify-center">
                            <svg xmlns="http://www.w3.org/2000/svg" width="28" height="28" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2.5" stroke-linecap="round" stroke-linejoin="round" class="text-amber-500"><circle cx="12" cy="12" r="10"/><polyline points="12 6 12 12 16 14"/></svg>
                        </div>
                    </div>

                    <h1 class="text-3xl md:text-4xl font-bold tracking-tight mb-3">{{ __('Payment Pending') }}</h1>
                    <p class="text-lg text-muted-foreground mb-4">{{ __('Your order has been placed. Payment is awaiting verification.') }}</p>

                    @if(session('payment_pending'))
                        <div class="bg-amber-500/10 border border-amber-500/20 rounded-2xl p-4 mb-10">
                            <p class="text-sm font-medium text-amber-600 dark:text-amber-400">{{ session('payment_pending') }}</p>
                        </div>
                    @else
                        <p class="text-sm text-muted-foreground mb-10">{{ __('Once your payment is confirmed, your plan will be activated automatically. You will be notified by email.') }}</p>
                    @endif
                @else
                    <!-- Success Icon -->
                    <div class="mx-auto mb-8 h-20 w-20 rounded-full bg-green-500/10 flex items-center justify-center">
                        <div class="h-14 w-14 rounded-full bg-green-500/20 flex items-center justify-center">
                            <svg xmlns="http://www.w3.org/2000/svg" width="28" height="28" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2.5" stroke-linecap="round" stroke-linejoin="round" class="text-green-500"><path d="M20 6 9 17l-5-5"/></svg>
                        </div>
                    </div>

                    <h1 class="text-3xl md:text-4xl font-bold tracking-tight mb-3">{{ __('Payment Successful') }}</h1>
                    <p class="text-lg text-muted-foreground mb-10">{{ __('Thank you for your purchase. Your plan has been activated.') }}</p>
                @endif

                <!-- Order Details -->
                <div class="bg-muted/30 rounded-2xl p-6 text-left space-y-4 mb-10 border border-border/50">
                    <div class="flex items-center justify-between">
                        <span class="text-sm text-muted-foreground font-medium">{{ __('Order Number') }}</span>
                        <span class="text-sm font-bold font-mono">{{ $order->order_number }}</span>
                    </div>
                    <div class="border-t border-border/30"></div>
                    <div class="flex items-center justify-between">
                        <span class="text-sm text-muted-foreground font-medium">{{ __('Plan') }}</span>
                        <span class="text-sm font-bold">{{ $order->plan?->name ?? 'N/A' }}</span>
                    </div>
                    <div class="border-t border-border/30"></div>
                    <div class="flex items-center justify-between">
                        <span class="text-sm text-muted-foreground font-medium">{{ $order->status === 'pending_verification' ? __('Amount') : __('Amount Paid') }}</span>
                        <span class="text-sm font-bold text-primary">{{ $currencySymbol }}{{ number_format($order->amount, 2) }} {{ $order->currency }}</span>
                    </div>
                    <div class="border-t border-border/30"></div>
                    <div class="flex items-center justify-between">
                        <span class="text-sm text-muted-foreground font-medium">{{ __('Status') }}</span>
                        @if($order->status === 'completed')
                            <span class="text-xs font-bold uppercase tracking-wider text-green-600 bg-green-500/10 px-3 py-1 rounded-lg">{{ __('Completed') }}</span>
                        @elseif($order->status === 'pending_verification')
                            <span class="text-xs font-bold uppercase tracking-wider text-amber-600 bg-amber-500/10 px-3 py-1 rounded-lg">{{ __('Awaiting Verification') }}</span>
                        @else
                            <span class="text-xs font-bold uppercase tracking-wider text-muted-foreground bg-muted px-3 py-1 rounded-lg">{{ ucfirst($order->status) }}</span>
                        @endif
                    </div>
                    @if($order->payment_method)
                    <div class="border-t border-border/30"></div>
                    <div class="flex items-center justify-between">
                        <span class="text-sm text-muted-foreground font-medium">{{ __('Payment Method') }}</span>
                        <span class="text-sm font-bold">{{ $order->payment_method }}</span>
                    </div>
                    @endif
                    <div class="border-t border-border/30"></div>
                    <div class="flex items-center justify-between">
                        <span class="text-sm text-muted-foreground font-medium">{{ __('Date') }}</span>
                        <span class="text-sm font-bold">{{ $order->created_at->format('M d, Y h:i A') }}</span>
                    </div>
                </div>

                <!-- Actions -->
                <div class="flex flex-col sm:flex-row gap-4">
                    <a href="{{ route('admin.dashboard') }}" class="flex-1 h-14 rounded-2xl bg-primary hover:bg-primary/90 text-primary-foreground font-bold flex items-center justify-center transition-all shadow-lg shadow-primary/20 group">
                        {{ __('Go to Dashboard') }}
                        <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="ml-2 group-hover:translate-x-1 transition-transform"><path d="M5 12h14"/><path d="m12 5 7 7-7 7"/></svg>
                    </a>
                    <a href="{{ route('home') }}" class="flex-1 h-14 rounded-2xl bg-muted/50 hover:bg-muted text-foreground font-bold flex items-center justify-center transition-all">
                        {{ __('Back to Home') }}
                    </a>
                </div>
            </div>
        </div>
    </div>
</main>
@endsection
