@php
$faqs = [
    ["question" => __("How accurate is the AI face recognition?"), "answer" => __("Our AI model is trained specifically for diverse lighting and angles common in events. It achieves 99.9% accuracy, even with masks, sunglasses, and rapid movement.")],
    ["question" => __("Is there a storage limit?"), "answer" => __("The Starter plan includes 5GB. Professional and Studio plans offer expansive and redundant storage for your high-resolution assets.")],
    ["question" => __("Can I use my own branding?"), "answer" => __("Absolutely. Our white-label solution allows you to use your own domain, custom colors, and logo, making it look like your own custom-built app.")],
    ["question" => __("How does the WhatsApp integration work?"), "answer" => __("You can set up automated campaigns that trigger as soon as photos are uploaded. Guests receive a personalized link to their private gallery via WhatsApp.")],
    ["question" => __("What is Dual-Copy Cloud storage?"), "answer" => __("We simultaneously store your photos in two different geographic regions and across different cloud providers, ensuring your client's memories are never lost.")]
];
@endphp

<section id="faq" class="py-16 md:py-32 bg-background relative overflow-hidden">
    <div class="container mx-auto px-4 max-w-4xl">
        <div class="text-center mb-20 space-y-4">
            <h2 class="text-3xl md:text-5xl font-bold tracking-tight">
                {{ __('Frequently Asked') }} <span class="text-primary italic">{{ __('Questions.') }}</span>
            </h2>
        </div>
        
        <div class="bg-white/5 backdrop-blur-3xl border border-white/10 rounded-[2rem] sm:rounded-[2.5rem] p-5 sm:p-8 md:p-12 shadow-2xl space-y-2">
            @foreach($faqs as $index => $faq)
            <div class="border-b border-white/10 py-2 last:border-0" x-data="{ open: false }">
                <button 
                    @click="open = !open" 
                    class="w-full text-left flex justify-between items-center gap-4 text-base sm:text-lg md:text-xl font-bold hover:text-primary transition-colors py-4">
                    <span>{{ $faq['question'] }}</span>
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-5 w-5 shrink-0 transition-transform" :class="open ? 'rotate-180' : ''"><path d="m6 9 6 6 6-6"/></svg>
                </button>
                <div 
                    x-show="open" 
                    x-collapse
                    class="text-muted-foreground text-sm sm:text-base md:text-lg leading-relaxed pb-4">
                    {{ $faq['answer'] }}
                </div>
            </div>
            @endforeach
        </div>
    </div>
</section>
