@php
$features = [
  [
    'title' => __("Face Search"),
    'description' => __("Guests find their photos instantly by uploading a selfie. Powered by advanced facial recognition that matches faces across thousands of event photos in seconds."),
    'icon' => '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-8 w-8 text-primary"><path d="M3 7V5a2 2 0 0 1 2-2h2"/><path d="M17 3h2a2 2 0 0 1 2 2v2"/><path d="M21 17v2a2 2 0 0 1-2 2h-2"/><path d="M7 21H5a2 2 0 0 1-2-2v-2"/><path d="M8 14s1.5 2 4 2 4-2 4-2"/><path d="M9 9h.01"/><path d="M15 9h.01"/></svg>',
    'className' => "md:col-span-2 md:row-span-2 bg-primary/5",
    'hasVisual' => true
  ],
  [
    'title' => __("Cloud Storage"),
    'description' => __("Store event media on AWS S3, Google Cloud Storage, or local disk. Seamlessly migrate between storage providers anytime."),
    'icon' => '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-8 w-8 text-primary"><path d="M17.5 19H9a7 7 0 1 1 6.71-9h1.79a4.5 4.5 0 1 1 0 9Z"/></svg>',
    'className' => "bg-teal-600/5 border-teal-600/10",
    'hasVisual' => false
  ],
  [
    'title' => __("FTP Camera Tethering"),
    'description' => __("Connect your camera directly via WiFi FTP. Photos are auto-imported into the event gallery every 2 minutes, no manual upload needed."),
    'icon' => '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-8 w-8 text-primary"><path d="M15 7h1a2 2 0 0 1 2 2v6a2 2 0 0 1-2 2h-2"/><path d="M6 7H5a2 2 0 0 0-2 2v6a2 2 0 0 0 2 2h2"/><circle cx="12" cy="12" r="3"/><path d="m8 5 1.5 1.5"/><path d="M14.5 6.5 16 5"/><path d="m8 19 1.5-1.5"/><path d="M14.5 17.5 16 19"/></svg>',
    'className' => "bg-emerald-500/5 border-emerald-500/10",
    'hasVisual' => false
  ],
  [
    'title' => __("Custom Branding & Design Editor"),
    'description' => __("Customize gallery designs, colors, and layouts. Remove platform branding and make every event page match your studio identity."),
    'icon' => '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-8 w-8 text-primary"><path d="m12 3-1.912 5.813a2 2 0 0 1-1.275 1.275L3 12l5.813 1.912a2 2 0 0 1 1.275 1.275L12 21l1.912-5.813a2 2 0 0 1 1.275-1.275L21 12l-5.813-1.912a2 2 0 0 1-1.275-1.275L12 3Z"/></svg>',
    'className' => "bg-teal-600/5 border-teal-600/10",
    'hasVisual' => false
  ],
  [
    'title' => __("PIN-Protected Galleries"),
    'description' => __("Secure every event with separate Admin and Guest PINs. Control who can view, download, and upload photos to your galleries."),
    'icon' => '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-8 w-8 text-primary"><path d="M12 22s8-4 8-10V5l-8-3-8 3v7c0 6 8 10 8 10z"/><path d="m9 12 2 2 4-4"/></svg>',
    'className' => "bg-orange-500/5 border-orange-500/10",
    'hasVisual' => false
  ],
  [
    'title' => __("Google Drive Import & Guest Upload"),
    'description' => __("Import entire albums from Google Drive with one click. Let guests contribute their own photos directly to your event galleries."),
    'icon' => '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-8 w-8 text-primary"><path d="M21 15v4a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2v-4"/><polyline points="17 8 12 3 7 8"/><line x1="12" x2="12" y1="3" y2="15"/></svg>',
    'className' => "bg-orange-500/5 border-orange-500/10",
    'hasVisual' => false
  ]
];
@endphp

<section id="features" class="py-16 md:py-32 relative overflow-hidden">
  <div class="container mx-auto px-4">
    <div class="max-w-3xl mx-auto mb-12 md:mb-20 text-balance space-y-4 text-center">
        <h2
            x-data="{ shown: false }"
            x-intersect="shown = true"
            class="text-4xl md:text-5xl lg:text-6xl font-bold tracking-tight transition-all duration-700 transform"
            :class="shown ? 'opacity-100 translate-y-0' : 'opacity-0 translate-y-10'">
            {{ __('Engineered for') }} <br />
            <span class="text-primary italic">{{ __('Professional Standards.') }}</span>
        </h2>
        <p class="text-xl text-muted-foreground">
            {{ __('We\'ve built the most feature-rich platform for event photographers, focusing on speed, security, and high-conversion client experiences.') }}
        </p>
    </div>

    <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
        @foreach($features as $index => $feature)
        <div
            x-data="{ shown: false }"
            x-intersect="shown = true"
            style="transition-delay: {{ $index * 100 }}ms"
            class="group relative p-8 rounded-[2rem] border transition-all hover:shadow-2xl hover:-translate-y-1 {{ $feature['className'] }} transform duration-700"
            :class="shown ? 'opacity-100 translate-y-0' : 'opacity-0 translate-y-8'">
            <div class="mb-6 p-3 rounded-2xl bg-muted/50 w-fit border border-border/50 shadow-sm group-hover:scale-110 transition-transform">
                {!! $feature['icon'] !!}
            </div>
            <h3 class="text-2xl font-bold mb-3">{{ $feature['title'] }}</h3>
            <p class="text-muted-foreground leading-relaxed">
                {{ $feature['description'] }}
            </p>

            @if(isset($feature['hasVisual']) && $feature['hasVisual'])
                <!-- Simple visual placeholder for the complex React one for now -->
                <div class="mt-8 relative h-48 w-full bg-background/50 rounded-2xl border border-primary/10 overflow-hidden flex items-center justify-center">
                    <div class="relative">
                        <div class="absolute inset-0 bg-primary/20 blur-2xl rounded-full animate-pulse"></div>
                        <div class="relative h-20 w-20 rounded-full bg-primary/10 border border-primary/20 flex items-center justify-center">
                             {!! $feature['icon'] !!}
                        </div>
                    </div>
                </div>
            @endif
        </div>
        @endforeach
    </div>
  </div>
</section>
