<header
    x-data="{ scrolled: false, mobileMenuOpen: false, langOpen: false }"
    @scroll.window="scrolled = (window.pageYOffset > 20)"
    :class="scrolled ? 'bg-background/80 backdrop-blur-xl border-border/50' : 'bg-transparent border-transparent'"
    class="fixed top-0 z-50 w-full border-b transition-all duration-300">

    <div class="container mx-auto px-4 flex h-20 items-center justify-between">
        <a href="{{ url('/') }}">
            @include('components.frontend.logo')
        </a>

        <!-- Desktop Nav (absolute-centered so it stays perfectly middle regardless of logo/actions width) -->
        <nav class="hidden md:flex items-center gap-10 text-xs font-bold uppercase tracking-widest text-muted-foreground/80 absolute left-1/2 -translate-x-1/2">
            <a href="{{ route('features') }}" class="hover:text-primary transition-colors">{{ __('Features') }}</a>
            <a href="{{ route('pricing') }}" class="hover:text-primary transition-colors">{{ __('Pricing') }}</a>
            <a href="{{ route('about') }}" class="hover:text-primary transition-colors">{{ __('About') }}</a>
            <a href="{{ route('contact') }}" class="hover:text-primary transition-colors">{{ __('Contact') }}</a>
            <a href="{{ route('blog.index') }}" class="hover:text-primary transition-colors">{{ __('Insights') }}</a>
        </nav>

        <div class="flex items-center gap-2">
            {{-- ── Language Selector (Desktop) ── --}}
            @if(!empty($multiLanguageEnabled) && isset($languageOptions) && $languageOptions->count() > 1)
                <div class="hidden md:block relative ltr:mr-4 rtl:ml-4" @click.away="langOpen = false">
                    <button
                        @click="langOpen = !langOpen"
                        class="flex items-center gap-1.5 text-[10px] font-bold uppercase tracking-widest text-muted-foreground hover:text-foreground transition-colors"
                        aria-haspopup="true"
                        :aria-expanded="langOpen">
                        <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="opacity-60"><circle cx="12" cy="12" r="10"/><path d="M12 2a14.5 14.5 0 0 0 0 20 14.5 14.5 0 0 0 0-20"/><path d="M2 12h20"/></svg>
                        {{ strtoupper($currentLocale ?? app()->getLocale()) }}
                        <svg xmlns="http://www.w3.org/2000/svg" width="10" height="10" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="3" stroke-linecap="round" stroke-linejoin="round" class="opacity-50 transition-transform" :class="langOpen ? 'rotate-180' : ''"><polyline points="6 9 12 15 18 9"/></svg>
                    </button>

                    {{-- Dropdown --}}
                    <div
                        x-show="langOpen"
                        x-transition:enter="transition ease-out duration-150"
                        x-transition:enter-start="opacity-0 scale-95 -translate-y-1"
                        x-transition:enter-end="opacity-100 scale-100 translate-y-0"
                        x-transition:leave="transition ease-in duration-100"
                        x-transition:leave-start="opacity-100 scale-100"
                        x-transition:leave-end="opacity-0 scale-95"
                        x-cloak
                        class="absolute ltr:right-0 rtl:left-0 top-full mt-2 w-44 bg-background border border-border rounded-xl shadow-xl overflow-hidden py-1 z-50">
                        @foreach($languageOptions as $lang)
                            <form method="POST" action="{{ route('frontend.locale.update') }}">
                                @csrf
                                <input type="hidden" name="locale" value="{{ $lang->code }}">
                                <button type="submit"
                                    @click="langOpen = false"
                                    class="w-full flex items-center justify-between gap-2 px-3.5 py-2 text-xs transition-colors
                                           {{ ($currentLocale ?? app()->getLocale()) === $lang->code ? 'text-primary font-bold bg-primary/5' : 'text-foreground/70 hover:bg-muted hover:text-foreground' }}">
                                    <span class="flex items-center gap-2">
                                        <span class="font-semibold">{{ $lang->native_name ?: $lang->name }}</span>
                                        @if($lang->direction === 'rtl')
                                            <span class="text-[9px] font-medium uppercase tracking-wider text-muted-foreground/60 bg-muted px-1 py-0.5 rounded">RTL</span>
                                        @endif
                                    </span>
                                    <span class="text-[10px] uppercase tracking-wider text-muted-foreground/50">{{ $lang->code }}</span>
                                </button>
                            </form>
                        @endforeach
                    </div>
                </div>
            @else
                {{-- Single language — show static label --}}
                <span class="hidden md:block text-[10px] font-bold uppercase tracking-widest text-muted-foreground ltr:mr-4 rtl:ml-4">{{ strtoupper($currentLocale ?? app()->getLocale()) }}</span>
            @endif

            <div class="hidden md:flex items-center ltr:border-r rtl:border-l border-white/5 ltr:pr-2 ltr:mr-2 rtl:pl-2 rtl:ml-2">
                <!-- Theme Toggle -->
                <button
                    @click="document.documentElement.classList.toggle('dark'); localStorage.setItem('admin-theme', document.documentElement.classList.contains('dark') ? 'dark' : 'light')"
                    class="p-2 text-muted-foreground hover:text-foreground relative h-9 w-9 flex items-center justify-center">

                    <!-- Sun Icon (Show in Light Mode) -->
                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
                        class="absolute transition-all duration-300 transform dark:rotate-90 dark:opacity-0 opacity-100 rotate-0 scale-100 dark:scale-0">
                        <circle cx="12" cy="12" r="4"/><path d="M12 2v2"/><path d="M12 20v2"/><path d="m4.93 4.93 1.41 1.41"/><path d="m17.66 17.66 1.41 1.41"/><path d="M2 12h2"/><path d="M20 12h2"/><path d="m6.34 17.66-1.41 1.41"/><path d="m19.07 4.93-1.41 1.41"/>
                    </svg>

                    <!-- Moon Icon (Show in Dark Mode) -->
                    <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
                        class="absolute transition-all duration-300 transform rotate-90 opacity-0 scale-0 dark:rotate-0 dark:opacity-100 dark:scale-100">
                        <path d="M12 3a6 6 0 0 0 9 9 9 9 0 1 1-9-9Z"/>
                    </svg>

                    <span class="sr-only">Toggle theme</span>
                </button>
            </div>

            @auth
                <a href="{{ route('admin.dashboard') }}" class="text-sm font-bold hover:text-primary transition-colors px-4">{{ __('Dashboard') }}</a>
            @else
                <a href="{{ route('login') }}" class="text-sm font-bold hover:text-primary transition-colors px-4">{{ __('Login') }}</a>
                <a href="{{ route('register') }}" class="hidden md:inline-flex h-11 items-center justify-center rounded-xl bg-primary px-6 text-sm font-bold text-primary-foreground shadow-lg shadow-primary/20 transition-colors hover:bg-primary/90 focus-visible:outline-none focus-visible:ring-1 focus-visible:ring-ring disabled:pointer-events-none disabled:opacity-50">
                    {{ __('Get Started') }} <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="ltr:ml-2 rtl:mr-2 h-4 w-4"><path d="M9.937 15.5A2 2 0 0 0 8.5 14.063l-6.135-1.582a.5.5 0 0 1 0-.962l6.135-1.583A2 2 0 0 0 9.937 8.5l1.582-6.135a.5.5 0 0 1 .962 0l1.583 6.135a2 2 0 0 0 1.437 1.437l6.135 1.583a.5.5 0 0 1 0 .962l-6.135 1.583a2 2 0 0 0-1.437 1.437l-1.583 6.135a.5.5 0 0 1-.962 0z"/><path d="M20 3v4"/><path d="M22 5h-4"/><path d="M4 17v2"/><path d="M5 18H3"/></svg>
                </a>
            @endauth

            <!-- Mobile Menu Toggle -->
            <button @click="mobileMenuOpen = !mobileMenuOpen" class="md:hidden p-2 text-muted-foreground hover:text-foreground">
                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-6 w-6"><line x1="4" x2="20" y1="12" y2="12"/><line x1="4" x2="20" y1="6" y2="6"/><line x1="4" x2="20" y1="18" y2="18"/></svg>
            </button>
        </div>
    </div>

    <!-- Mobile Menu -->
    <div
        x-show="mobileMenuOpen"
        x-transition:enter="transition ease-out duration-200"
        x-transition:enter-start="opacity-0 -translate-y-2"
        x-transition:enter-end="opacity-100 translate-y-0"
        x-transition:leave="transition ease-in duration-150"
        x-transition:leave-start="opacity-100 translate-y-0"
        x-transition:leave-end="opacity-0 -translate-y-2"
        @click.away="mobileMenuOpen = false"
        class="absolute top-20 left-0 w-full bg-background border-b border-border shadow-lg md:hidden p-4 flex flex-col gap-4">
        <a href="{{ route('features') }}" class="text-sm font-bold uppercase tracking-widest hover:text-primary">{{ __('Features') }}</a>
        <a href="{{ route('pricing') }}" class="text-sm font-bold uppercase tracking-widest hover:text-primary">{{ __('Pricing') }}</a>
        <a href="{{ route('about') }}" class="text-sm font-bold uppercase tracking-widest hover:text-primary">{{ __('About') }}</a>
        <a href="{{ route('contact') }}" class="text-sm font-bold uppercase tracking-widest hover:text-primary">{{ __('Contact') }}</a>
        <a href="{{ route('blog.index') }}" class="text-sm font-bold uppercase tracking-widest hover:text-primary">{{ __('Insights') }}</a>
        <hr class="border-border/50">

        {{-- ── Language Selector (Mobile) ── --}}
        @if(!empty($multiLanguageEnabled) && isset($languageOptions) && $languageOptions->count() > 1)
            <div class="flex items-center justify-between">
                <span class="text-xs font-bold uppercase tracking-widest text-muted-foreground">{{ __('Language') }}</span>
                <span class="text-[10px] uppercase tracking-widest text-muted-foreground/50">{{ strtoupper($currentLocale ?? app()->getLocale()) }}</span>
            </div>
            <div class="flex flex-wrap gap-2">
                @foreach($languageOptions as $lang)
                    <form method="POST" action="{{ route('frontend.locale.update') }}" class="inline">
                        @csrf
                        <input type="hidden" name="locale" value="{{ $lang->code }}">
                        <button type="submit"
                            class="px-3 py-1.5 rounded-lg text-xs font-semibold transition-colors border
                                   {{ ($currentLocale ?? app()->getLocale()) === $lang->code
                                       ? 'bg-primary text-primary-foreground border-primary'
                                       : 'border-border text-foreground/70 hover:bg-muted hover:text-foreground' }}">
                            {{ $lang->native_name ?: $lang->name }}
                        </button>
                    </form>
                @endforeach
            </div>
            <hr class="border-border/50">
        @endif

        <div class="flex items-center justify-between">
            <span class="text-xs font-bold uppercase tracking-widest text-muted-foreground">{{ __('Theme') }}</span>
            <button
                @click="document.documentElement.classList.toggle('dark'); localStorage.setItem('admin-theme', document.documentElement.classList.contains('dark') ? 'dark' : 'light')"
                class="p-2 text-muted-foreground hover:text-foreground relative h-9 w-9 flex items-center justify-center rounded-lg border border-border">
                <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
                    class="absolute transition-all duration-300 transform dark:rotate-90 dark:opacity-0 opacity-100 rotate-0 scale-100 dark:scale-0">
                    <circle cx="12" cy="12" r="4"/><path d="M12 2v2"/><path d="M12 20v2"/><path d="m4.93 4.93 1.41 1.41"/><path d="m17.66 17.66 1.41 1.41"/><path d="M2 12h2"/><path d="M20 12h2"/><path d="m6.34 17.66-1.41 1.41"/><path d="m19.07 4.93-1.41 1.41"/>
                </svg>
                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
                    class="absolute transition-all duration-300 transform rotate-90 opacity-0 scale-0 dark:rotate-0 dark:opacity-100 dark:scale-100">
                    <path d="M12 3a6 6 0 0 0 9 9 9 9 0 1 1-9-9Z"/>
                </svg>
                <span class="sr-only">Toggle theme</span>
            </button>
        </div>
        <hr class="border-border/50">
        @auth
           <a href="{{ route('admin.dashboard') }}" class="w-full text-center h-10 rounded-lg bg-primary text-primary-foreground font-bold flex items-center justify-center">{{ __('Dashboard') }}</a>
        @else
           <a href="{{ route('login') }}" class="w-full text-center h-10 rounded-lg border border-border text-foreground font-bold flex items-center justify-center">{{ __('Login') }}</a>
           <a href="{{ route('register') }}" class="w-full text-center h-10 rounded-lg bg-primary text-primary-foreground font-bold flex items-center justify-center">{{ __('Get Started') }}</a>
        @endauth
    </div>
</header>
