<section id="how-it-works" class="py-16 md:py-32 relative overflow-hidden bg-muted/10">
    <div class="container mx-auto px-4">
         <div class="text-center mb-12 md:mb-24 space-y-4">
            <h2
                x-data="{ shown: false }"
                x-intersect="shown = true"
                class="text-4xl md:text-5xl lg:text-6xl font-bold tracking-tight transition-all duration-700 transform"
                :class="shown ? 'opacity-100 translate-y-0' : 'opacity-0 translate-y-10'">
                {{ __('Seamless from') }} <br />
                <span class="text-primary italic">{{ __('Click to Delivery.') }}</span>
            </h2>
            <p class="text-lg text-muted-foreground max-w-2xl mx-auto font-normal">{{ __('Everything automated, so you can focus on the perfect shot.') }}</p>
        </div>

        <div class="relative">
             <!-- Connecting Line (Desktop) -->
            <div class="hidden md:block absolute top-[20%] left-[10%] right-[10%] h-px bg-gradient-to-r from-transparent via-primary/30 to-transparent -z-10"></div>

            <div class="grid grid-cols-1 md:grid-cols-4 gap-12">
                @foreach([
                    ['title' => __("Capture & Create"), 'desc' => __("Shoot your event normally. Create a branded gallery in seconds with just a name and date."), 'icon' => '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-12 w-12 text-primary"><path d="M14.5 4h-5L7 7H4a2 2 0 0 0-2 2v9a2 2 0 0 0 2 2h16a2 2 0 0 0 2-2V9a2 2 0 0 0-2-2h-3l-2.5-3z"/><circle cx="12" cy="13" r="3"/></svg>'],
                    ['title' => __("Bulk Upload"), 'desc' => __("Upload high-res assets. Our multi-cloud engine handles processing at lightning speed."), 'icon' => '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-12 w-12 text-primary"><path d="M4 14.899A7 7 0 1 1 15.71 8h1.79a4.5 4.5 0 0 1 2.5 8.242"/><path d="M12 12v9"/><path d="m16 16-4-4-4 4"/></svg>'],
                    ['title' => __("Analysis"), 'desc' => __("Our proprietary face recognition groups every guest automatically with 99.9% precision."), 'icon' => '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-12 w-12 text-primary"><path d="m12 3-1.912 5.813a2 2 0 0 1-1.275 1.275L3 12l5.813 1.912a2 2 0 0 1 1.275 1.275L12 21l1.912-5.813a2 2 0 0 1 1.275-1.275L21 12l-5.813-1.912a2 2 0 0 1-1.275-1.275L12 3Z"/></svg>'],
                    ['title' => __("Instant Delivery"), 'desc' => __("Guests scan QR codes, take a selfie, and see their personal memories immediately."), 'icon' => '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-12 w-12 text-primary"><path d="M16 21v-2a4 4 0 0 0-4-4H6a4 4 0 0 0-4 4v2"/><circle cx="9" cy="7" r="4"/><polyline points="16 11 18 13 22 9"/></svg>']
                ] as $index => $step)
                    <div
                        x-data="{ shown: false }"
                        x-intersect="shown = true"
                        style="transition-delay: {{ $index * 100 }}ms"
                        class="flex flex-col items-center text-center group transition-all duration-700 transform"
                        :class="shown ? 'opacity-100 translate-y-0' : 'opacity-0 translate-y-8'">
                        <div class="h-28 w-28 rounded-[2rem] bg-background border border-primary/20 flex items-center justify-center mb-8 relative shadow-2xl group-hover:scale-110 group-hover:border-primary/50 transition-all duration-500">
                            {!! $step['icon'] !!}
                            <div class="absolute -top-3 -right-3 h-10 w-10 rounded-2xl bg-primary text-primary-foreground flex items-center justify-center font-black text-lg border-4 border-background shadow-lg">
                                {{ $index + 1 }}
                            </div>
                        </div>
                        <h3 class="text-2xl font-black mb-4 group-hover:text-primary transition-colors">{{ $step['title'] }}</h3>
                        <p class="text-muted-foreground font-medium leading-relaxed">{{ $step['desc'] }}</p>
                    </div>
                @endforeach
            </div>
        </div>
    </div>
</section>
