@php
    $siteName = trim((string) ($siteSettings['site_name'] ?? ''));
    $siteName = $siteName !== '' ? $siteName : config('app.name', 'SnapNest');
    $siteLogo = $siteSettings['site_logo'] ?? null;
@endphp

<div class="flex items-center gap-2.5 group {{ $class ?? '' }}">
    @if ($siteLogo)
        <img src="{{ asset('storage/' . $siteLogo) }}" alt="{{ $siteName }}" class="h-10 w-auto object-contain">
    @else
        <div class="relative h-10 w-10 flex items-center justify-center">
            <!-- Main Icon Background with Gradient -->
            <div class="absolute inset-0 bg-gradient-to-tr from-primary via-primary/80 to-accent rounded-xl rotate-3 group-hover:rotate-6 transition-transform duration-500 shadow-lg shadow-primary/20"></div>

            <!-- The "Snap" Shutter Icon (SVG) -->
            <svg
                viewBox="0 0 24 24"
                fill="none"
                stroke="currentColor"
                stroke-width="2.5"
                stroke-linecap="round"
                stroke-linejoin="round"
                class="h-6 w-6 text-primary-foreground relative z-10 group-hover:scale-110 transition-transform duration-500"
            >
                <!-- Stylized Shutter/Lens -->
                <circle cx="12" cy="12" r="9" class="opacity-40" />
                <path d="M12 3a9 9 0 0 0-9 9" />
                <path d="M12 21a9 9 0 0 0 9-9" />

                <!-- Central Spark/Aperture -->
                <path d="M12 8l-1 4h2l-1 4" class="text-accent animate-pulse" />
                <circle cx="12" cy="12" r="3" />
            </svg>

            <!-- Outer Decorative Rings -->
            <div class="absolute -inset-1 border border-primary/20 rounded-2xl scale-75 group-hover:scale-100 opacity-0 group-hover:opacity-100 transition-all duration-700"></div>
        </div>
    @endif
</div>
