@php
    $currencySymbol = \App\Support\FormatSettings::currencyConfig()['symbol'] ?: '$';
    $currentUser = auth()->user();
    $userPlan = $currentUser?->plan;
    $userPlanPrice = $userPlan ? (float) ($userPlan->offer_price ?? $userPlan->price) : null;
@endphp
<section id="pricing" class="py-16 md:py-32 relative overflow-hidden bg-muted/20" x-data="{ isYearly: false }">
    <div class="container mx-auto px-4">
        <div class="text-center mb-12 md:mb-20 space-y-6">
            <h2
                x-data="{ shown: false }"
                x-intersect="shown = true"
                class="text-4xl md:text-5xl lg:text-6xl font-bold tracking-tight transition-all duration-700 transform"
                :class="shown ? 'opacity-100 translate-y-0' : 'opacity-0 translate-y-10'">
                {{ __('Invest in Your') }} <br />
                <span class="text-primary italic">{{ __('Success.') }}</span>
            </h2>
            <p class="text-xl text-muted-foreground max-w-2xl mx-auto">
                {{ __('No hidden fees. No surprises. Just pure performance for your photography business.') }}
            </p>

            @if(isset($plans) && $plans->count() > 0)
                @php
                    $hasMonthly = $plans->where('duration_type', 'months')->where('duration_months', 1)->count() > 0;
                    $hasYearly = $plans->where('duration_type', 'months')->where('duration_months', 12)->count() > 0
                                 || $plans->where('duration_type', 'yearly')->count() > 0;
                    $showToggle = $hasMonthly && $hasYearly;
                @endphp

                @if($showToggle)
                <div class="flex items-center justify-center gap-6 mt-10">
                    <span class="text-sm font-bold" :class="!isYearly ? 'text-foreground' : 'text-muted-foreground'">{{ __('Monthly') }}</span>
                    <button
                        @click="isYearly = !isYearly"
                        class="group relative inline-flex h-8 w-16 items-center rounded-full transition-all focus:outline-none"
                        :class="isYearly ? 'bg-primary' : 'bg-input'">
                        <span class="inline-block h-6 w-6 transform rounded-full bg-background shadow-lg transition-transform duration-300" :class="isYearly ? 'translate-x-9' : 'translate-x-1'"></span>
                    </button>
                    <span class="text-sm font-bold" :class="isYearly ? 'text-foreground' : 'text-muted-foreground'">
                        {{ __('Yearly') }} <span class="text-primary bg-primary/10 px-2 py-0.5 rounded-full text-xs ml-1 border border-primary/20">{{ __('Save 20%') }}</span>
                    </span>
                </div>
                @endif
            @endif
        </div>

        @if(!isset($plans) || $plans->count() === 0)
            {{-- No plans fallback --}}
            <div class="max-w-2xl mx-auto text-center">
                <div class="p-12 rounded-[2.5rem] border bg-background">
                    <div class="h-16 w-16 rounded-2xl bg-primary/10 flex items-center justify-center text-primary mx-auto mb-6">
                        <svg xmlns="http://www.w3.org/2000/svg" width="28" height="28" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M21 15a2 2 0 0 1-2 2H7l-4 4V5a2 2 0 0 1 2-2h14a2 2 0 0 1 2 2z"/></svg>
                    </div>
                    <h3 class="text-2xl font-bold mb-3">{{ __('Custom Pricing Available') }}</h3>
                    <p class="text-muted-foreground mb-8">{{ __('We offer tailored plans to match your photography business needs. Get in touch with our team for a personalized quote.') }}</p>
                    <a href="{{ route('contact') }}" class="inline-flex h-14 items-center justify-center rounded-2xl bg-primary px-8 text-base font-bold text-primary-foreground shadow-lg shadow-primary/20 transition-colors hover:bg-primary/90">
                        {{ __('Contact Us for Pricing') }}
                        <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="ml-2"><path d="M5 12h14"/><path d="m12 5 7 7-7 7"/></svg>
                    </a>
                </div>
            </div>
        @else
            @php
                // Determine the "popular" plan: middle-priced plan, or highest sort_order if available
                $sortedPlans = $plans->sortBy('price')->values();
                $planCount = $sortedPlans->count();

                if ($planCount >= 3) {
                    $popularIndex = (int) floor($planCount / 2);
                } elseif ($planCount === 2) {
                    $popularIndex = 1;
                } else {
                    $popularIndex = 0;
                }
                $popularPlanId = $sortedPlans[$popularIndex]->id ?? null;

                // Grid columns based on plan count
                $gridCols = match(true) {
                    $planCount === 1 => 'grid-cols-1 max-w-lg',
                    $planCount === 2 => 'grid-cols-1 md:grid-cols-2 max-w-4xl',
                    $planCount === 3 => 'grid-cols-1 md:grid-cols-3 max-w-7xl',
                    default => 'grid-cols-1 md:grid-cols-2 lg:grid-cols-3 xl:grid-cols-4 max-w-7xl',
                };
            @endphp

            <div class="grid {{ $gridCols }} gap-8 mx-auto">
                @foreach($sortedPlans as $plan)
                    @php
                        $isPopular = $plan->id === $popularPlanId;
                        $isFree = (float) $plan->price === 0.0;
                        $effectivePrice = $plan->offer_price !== null ? $plan->offer_price : $plan->price;
                        $hasDiscount = $plan->offer_price !== null && (float) $plan->offer_price < (float) $plan->price;
                        $features = is_array($plan->features) ? $plan->features : [];

                        // Build limit features dynamically
                        $limitFeatures = [];
                        if ($plan->events_limit) {
                            $limitFeatures[] = $plan->events_limit . ' ' . __('Events');
                        } else {
                            $limitFeatures[] = __('Unlimited Events');
                        }
                        if ($plan->images_limit) {
                            $limitFeatures[] = number_format($plan->images_limit) . ' ' . __('Images');
                        } else {
                            $limitFeatures[] = __('Unlimited Images');
                        }
                        if ($plan->storage_limit_gb) {
                            $limitFeatures[] = rtrim(rtrim(number_format($plan->storage_limit_gb, 2), '0'), '.') . ' ' . __('GB Storage');
                        } else {
                            $limitFeatures[] = __('Unlimited Storage');
                        }
                        if ($plan->videos_limit) {
                            $limitFeatures[] = $plan->videos_limit . ' ' . __('Videos');
                        }
                        if ($plan->max_file_size_mb) {
                            $limitFeatures[] = $plan->max_file_size_mb . ' ' . __('MB Max File Size');
                        }

                        // Boolean feature flags
                        $boolFeatures = [];
                        if ($plan->has_watermark) $boolFeatures[] = __('Custom Watermarking');
                        if ($plan->has_design_editor) $boolFeatures[] = __('Design Editor');
                        if ($plan->has_guest_upload) $boolFeatures[] = __('Guest Upload');
                        if ($plan->has_google_drive_import) $boolFeatures[] = __('Google Drive Import');
                        if ($plan->has_ftp_import) $boolFeatures[] = __('FTP Import');
                        if ($plan->has_custom_branding) $boolFeatures[] = __('Custom Branding');
                        if ($plan->has_cloud_storage) $boolFeatures[] = __('Cloud Storage');

                        $allFeatures = array_merge($limitFeatures, $features, $boolFeatures);

                        // Duration label
                        $durationLabel = '';
                        if (!$isFree) {
                            if ($plan->duration_type === 'lifetime') {
                                $durationLabel = __('one-time');
                            } elseif ($plan->duration_months == 12) {
                                $durationLabel = '/' . __('yr');
                            } elseif ($plan->duration_months == 1) {
                                $durationLabel = '/' . __('mo');
                            } elseif ($plan->duration_months) {
                                $durationLabel = '/' . $plan->duration_months . ' mo';
                            }
                        }

                        // For yearly toggle: calculate monthly equivalent
                        $monthlyPrice = null;
                        $yearlyPrice = null;
                        if ($plan->duration_months == 1) {
                            $monthlyPrice = $effectivePrice;
                            $yearlyPrice = round($effectivePrice * 12 * 0.8, 2);
                        } elseif ($plan->duration_months == 12) {
                            $yearlyPrice = $effectivePrice;
                            $monthlyPrice = round($effectivePrice / 12 / 0.8, 2);
                        }
                    @endphp

                    <div class="relative flex flex-col p-6 sm:p-8 rounded-[2rem] sm:rounded-[2.5rem] border bg-background transition-all {{ $isPopular ? 'border-primary shadow-xl md:scale-105 z-10' : 'hover:border-primary/20 hover:shadow-2xl' }}">
                        @if($isPopular)
                        <div class="absolute -top-5 left-1/2 -translate-x-1/2 px-4 py-1.5 bg-primary text-primary-foreground text-xs font-bold rounded-full shadow-lg flex items-center gap-2">
                            <svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-3 w-3"><path d="m12 3-1.912 5.813a2 2 0 0 1-1.275 1.275L3 12l5.813 1.912a2 2 0 0 1 1.275 1.275L12 21l1.912-5.813a2 2 0 0 1 1.275-1.275L21 12l-5.813-1.912a2 2 0 0 1-1.275-1.275L12 3Z"/></svg>
                            {{ __('MOST POPULAR') }}
                        </div>
                        @endif

                        <div class="mb-8">
                            <h3 class="text-2xl font-bold mb-2">{{ $plan->name }}</h3>
                            @if($plan->description ?? false)
                                <p class="text-sm text-muted-foreground font-medium">{{ $plan->description }}</p>
                            @endif
                        </div>

                        <div class="mb-8 flex items-baseline gap-1">
                            @if($isFree)
                                <span class="text-5xl font-bold tracking-tight">{{ $currencySymbol }}0</span>
                            @else
                                @if($hasDiscount)
                                    <span class="text-2xl font-semibold text-muted-foreground line-through mr-2">
                                        {{ $currencySymbol }}{{ number_format($plan->price, 0) }}
                                    </span>
                                @endif

                                @if($showToggle && $monthlyPrice !== null && $yearlyPrice !== null)
                                    <span class="text-5xl font-bold tracking-tight" x-text="isYearly ? '{{ $currencySymbol }}{{ number_format($yearlyPrice, 0) }}' : '{{ $currencySymbol }}{{ number_format($monthlyPrice, 0) }}'">
                                        {{ $currencySymbol }}{{ number_format($monthlyPrice, 0) }}
                                    </span>
                                    <span class="text-muted-foreground font-semibold" x-text="isYearly ? '/yr' : '/mo'">/mo</span>
                                @else
                                    <span class="text-5xl font-bold tracking-tight">
                                        {{ $currencySymbol }}{{ number_format($effectivePrice, 0) }}
                                    </span>
                                    @if($durationLabel)
                                        <span class="text-muted-foreground font-semibold">{{ $durationLabel }}</span>
                                    @endif
                                @endif
                            @endif
                        </div>

                        <div class="flex-1 space-y-4 mb-10">
                            @foreach($allFeatures as $feature)
                            <div class="flex items-center gap-3">
                                <div class="h-5 w-5 rounded-full bg-primary/10 flex items-center justify-center shrink-0">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="3" stroke-linecap="round" stroke-linejoin="round" class="text-primary"><path d="M20 6 9 17l-5-5"/></svg>
                                </div>
                                <span class="text-sm font-medium text-muted-foreground">{{ $feature }}</span>
                            </div>
                            @endforeach
                        </div>

                        @php
                            $isCurrentPlan = $userPlan && $userPlan->id === $plan->id;
                            $isDowngrade = $userPlanPrice !== null && !$isCurrentPlan && $effectivePrice < $userPlanPrice;
                            $isUpgrade = $userPlanPrice !== null && !$isCurrentPlan && $effectivePrice > $userPlanPrice;
                        @endphp

                        @if($isCurrentPlan)
                            <div class="w-full h-14 text-base font-bold rounded-2xl bg-primary/10 border-2 border-primary text-primary flex items-center justify-center gap-2 cursor-default">
                                <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2.5" stroke-linecap="round" stroke-linejoin="round"><path d="M20 6 9 17l-5-5"/></svg>
                                {{ __('Current Plan') }}
                            </div>
                        @elseif($isDowngrade)
                            <div class="w-full h-14 text-base font-bold rounded-2xl bg-muted/30 border border-border text-muted-foreground/50 flex items-center justify-center gap-2 cursor-not-allowed" title="You cannot downgrade your plan">
                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><circle cx="12" cy="12" r="10"/><path d="m4.9 4.9 14.2 14.2"/></svg>
                                {{ __('Cannot Downgrade') }}
                            </div>
                        @elseif($isFree)
                            @if($userPlan)
                                <div class="w-full h-14 text-base font-bold rounded-2xl bg-muted/30 border border-border text-muted-foreground/50 flex items-center justify-center gap-2 cursor-not-allowed" title="You cannot downgrade your plan">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><circle cx="12" cy="12" r="10"/><path d="m4.9 4.9 14.2 14.2"/></svg>
                                    {{ __('Cannot Downgrade') }}
                                </div>
                            @else
                                <a href="{{ route('register') }}" class="w-full h-14 text-base font-bold rounded-2xl transition-all bg-muted/50 hover:bg-muted text-foreground flex items-center justify-center">
                                    {{ __('Start for Free') }}
                                </a>
                            @endif
                        @elseif($isUpgrade)
                            <a href="{{ route('checkout.show', $plan->slug) }}" class="w-full h-14 text-base font-bold rounded-2xl transition-all flex items-center justify-center bg-primary hover:bg-primary/90 shadow-lg shadow-primary/20 text-primary-foreground gap-2">
                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="m18 15-6-6-6 6"/></svg>
                                {{ __('Upgrade Plan') }}
                            </a>
                        @else
                            <a href="{{ route('checkout.show', $plan->slug) }}" class="w-full h-14 text-base font-bold rounded-2xl transition-all flex items-center justify-center {{ $isPopular ? 'bg-primary hover:bg-primary/90 shadow-lg shadow-primary/20 text-primary-foreground' : 'bg-muted/50 hover:bg-muted text-foreground' }}">
                                {{ __('Get Started') }}
                            </a>
                        @endif
                    </div>
                @endforeach
            </div>
        @endif
    </div>
</section>
