@php
    $testimonials = \App\Models\Testimonial::where('is_active', true)->latest()->get();
    $avatarColors = [
        'bg-teal-600/10 text-teal-700',
        'bg-teal-600/10 text-teal-700',
        'bg-emerald-500/10 text-emerald-600',
        'bg-orange-500/10 text-orange-600',
        'bg-pink-500/10 text-pink-600',
        'bg-cyan-500/10 text-cyan-600',
    ];
    $avgRating = $testimonials->avg('rating');
@endphp

@if($testimonials->count())
<section class="py-16 md:py-32 relative overflow-hidden bg-background">
    <div class="container mx-auto px-4">
        <!-- Header Section -->
        <div class="flex flex-col items-center text-center mb-12 md:mb-20 gap-8">
            <div class="max-w-xl space-y-4">
                <h2
                    x-data="{ shown: false }"
                    x-intersect="shown = true"
                    class="text-3xl md:text-5xl font-bold tracking-tight transition-all duration-700 transform"
                    :class="shown ? 'opacity-100 translate-y-0' : 'opacity-0 translate-y-10'">
                    {{ __('Success Stories') }} <br />
                    <span class="text-primary italic">{{ __('In Real-Time.') }}</span>
                </h2>
                <p class="text-lg text-muted-foreground font-normal text-balance">
                    {{ __('Join the community of photographers who have mastered the art of instant delivery.') }}
                </p>
            </div>

            <div class="flex items-center gap-4">
                <div class="flex -space-x-4">
                    @foreach($testimonials->take(4) as $i => $t)
                        <div class="h-12 w-12 rounded-full border-4 border-background bg-background shadow-sm overflow-hidden flex items-center justify-center {{ $avatarColors[$i % count($avatarColors)] }}">
                            @if($t->client_image)
                                <img src="{{ asset('storage/' . $t->client_image) }}" alt="{{ $t->client_name }}" class="h-full w-full object-cover">
                            @else
                                <span class="text-[10px] font-bold">{{ strtoupper(substr($t->client_name, 0, 2)) }}</span>
                            @endif
                        </div>
                    @endforeach
                </div>
                <div class="flex flex-col">
                    <p class="text-sm font-semibold tracking-tight">{{ number_format($avgRating, 1) }}/5 RATING</p>
                    <p class="text-[10px] text-muted-foreground font-medium uppercase tracking-widest">{{ __('Industry Standard') }}</p>
                </div>
            </div>
        </div>

        <!-- Carousel Container -->
        <div
            x-data="{
                scrollPosition: 0,
                maxScroll: 0,
                itemWidth: 0,
                autoplayInterval: null,
                paused: false,
                init() {
                    this.calculateDimensions();
                    window.addEventListener('resize', () => this.calculateDimensions());
                    this.startAutoplay();
                    this.$refs.container.addEventListener('mouseenter', () => this.paused = true);
                    this.$refs.container.addEventListener('mouseleave', () => this.paused = false);
                },
                calculateDimensions() {
                    const container = this.$refs.container;
                    this.maxScroll = container.scrollWidth - container.clientWidth;
                    if (window.innerWidth >= 1024) this.itemWidth = container.clientWidth * 0.28 + 32;
                    else if (window.innerWidth >= 768) this.itemWidth = container.clientWidth * 0.40 + 32;
                    else this.itemWidth = container.clientWidth + 32;
                },
                startAutoplay() {
                    this.autoplayInterval = setInterval(() => {
                        if (this.paused) return;
                        const container = this.$refs.container;
                        if (container.scrollLeft >= this.maxScroll - 10) {
                            container.scrollTo({ left: 0, behavior: 'smooth' });
                        } else {
                            container.scrollBy({ left: this.itemWidth, behavior: 'smooth' });
                        }
                    }, 4000);
                },
                scrollNext() {
                    const container = this.$refs.container;
                    if (container.scrollLeft >= this.maxScroll - 10) {
                        container.scrollTo({ left: 0, behavior: 'smooth' });
                    } else {
                        container.scrollBy({ left: this.itemWidth, behavior: 'smooth' });
                    }
                },
                scrollPrev() {
                    const container = this.$refs.container;
                    if (container.scrollLeft <= 10) {
                        container.scrollTo({ left: this.maxScroll, behavior: 'smooth' });
                    } else {
                        container.scrollBy({ left: -this.itemWidth, behavior: 'smooth' });
                    }
                }
            }"
            class="relative group"
        >
            <!-- Scrollable Area -->
            <div
                x-ref="container"
                class="flex gap-8 overflow-x-auto pb-8 -mx-4 px-4 snap-x snap-mandatory no-scrollbar"
            >
                @foreach($testimonials as $i => $t)
                    <div class="flex-[0_0_100%] md:flex-[0_0_40%] lg:flex-[0_0_28%] min-w-0 snap-center transition-all duration-300">
                        <div class="h-full bg-card border border-border shadow-xl rounded-[2rem] p-8 flex flex-col gap-6 transition-all hover:bg-muted/50 hover:-translate-y-1 relative group/card">
                            <!-- Quote Icon -->
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="absolute top-8 right-8 h-8 w-8 text-primary/10 transition-colors group-hover/card:text-primary/20"><path d="M3 21c3 0 7-1 7-8V5c0-1.25-.756-2.017-2-2H4c-1.25 0-2 .75-2 1.972V11c0 1.25.75 2 2 2 1 0 1 0 1 1v1c0 1-1 2-2 2s-1 .008-1 1.031V20c0 1 0 1 1 1z"/><path d="M15 21c3 0 7-1 7-8V5c0-1.25-.757-2.017-2-2h-4c-1.25 0-2 .75-2 1.972V11c0 1.25.75 2 2 2 1 0 1 0 1 1v1c0 1-1 2-2 2s-1 .008-1 1.031V20c0 1 0 1 1 1z"/></svg>

                            <div class="flex gap-1">
                                @foreach(range(1, $t->rating) as $star)
                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="currentColor" stroke="none" class="h-4 w-4 text-primary"><polygon points="12 2 15.09 8.26 22 9.27 17 14.14 18.18 21.02 12 17.77 5.82 21.02 7 14.14 2 9.27 8.91 8.26 12 2"/></svg>
                                @endforeach
                            </div>
                            <p class="text-lg font-medium leading-relaxed italic flex-1 text-card-foreground">"{{ $t->review }}"</p>

                            <div class="flex items-center gap-4 pt-6 mt-auto border-t border-border/50">
                                <div class="h-12 w-12 rounded-xl flex items-center justify-center font-black text-lg shadow-inner overflow-hidden {{ $avatarColors[$i % count($avatarColors)] }}">
                                    @if($t->client_image)
                                        <img src="{{ asset('storage/' . $t->client_image) }}" alt="{{ $t->client_name }}" class="h-full w-full object-cover">
                                    @else
                                        {{ substr($t->client_name, 0, 1) }}
                                    @endif
                                </div>
                                <div>
                                    <p class="font-bold text-base leading-tight text-foreground">{{ $t->client_name }}</p>
                                    <p class="text-[10px] text-primary font-bold tracking-widest uppercase">{{ $t->client_position }}</p>
                                </div>
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>

            <!-- Navigation Controls -->
            <div class="flex justify-center gap-4 mt-8">
                <button
                    @click="scrollPrev()"
                    class="h-10 w-10 rounded-full border border-border bg-background flex items-center justify-center hover:bg-primary hover:text-primary-foreground hover:border-primary transition-all shadow-sm"
                    aria-label="Previous slide"
                >
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-4 w-4"><path d="m15 18-6-6 6-6"/></svg>
                </button>
                <button
                    @click="scrollNext()"
                    class="h-10 w-10 rounded-full border border-border bg-background flex items-center justify-center hover:bg-primary hover:text-primary-foreground hover:border-primary transition-all shadow-sm"
                    aria-label="Next slide"
                >
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-4 w-4"><path d="m9 18 6-6-6-6"/></svg>
                </button>
            </div>
        </div>
    </div>
</section>
@endif
