<section class="py-16 border-y border-white/5 bg-background overflow-hidden relative">
    <div class="container mx-auto px-4 mb-10">
        <p class="text-center text-xs font-bold tracking-[0.2em] text-muted-foreground/50 uppercase">{{ __('EVERYTHING YOU NEED TO DELIVER STUNNING GALLERIES') }}</p>
    </div>

    <div class="relative flex overflow-hidden">
        <div class="flex flex-wrap justify-center items-center gap-x-12 gap-y-12 md:gap-x-20 w-full">
            @foreach([
                __("Face Search"),
                __("Cloud Storage"),
                __("QR Sharing"),
                __("Chunked Uploads"),
                __("White-Label Branding"),
                __("PIN Protected"),
                __("Guest Uploads"),
                __("Watermarking"),
            ] as $index => $feature)
            <span
                x-data="{ shown: false }"
                x-intersect="shown = true"
                class="text-2xl md:text-4xl font-semibold font-sans text-muted-foreground/15 hover:text-primary/30 transition-colors duration-700 cursor-default select-none tracking-tighter"
                :class="shown ? 'opacity-100' : 'opacity-0'"
                style="transition-delay: {{ $index * 100 }}ms">
                {{ $feature }}
            </span>
            @endforeach
        </div>

        <!-- Gradient Mask -->
        <div class="absolute inset-y-0 left-0 w-32 bg-gradient-to-r from-background to-transparent z-10 pointer-events-none"></div>
        <div class="absolute inset-y-0 right-0 w-32 bg-gradient-to-l from-background to-transparent z-10 pointer-events-none"></div>
    </div>
</section>
