@props(['title' => null, 'settings' => []])

@php
    $brandName = trim((string) ($siteSettings['site_name'] ?? ''));
    $brandName = $brandName !== '' ? $brandName : config('app.name', 'SnapNest');
    $pageTitle = $title ? $title . ' - ' . $brandName : $brandName;
    $siteLogo = $siteSettings['site_logo'] ?? null;
    $favicon = $siteSettings['favicon'] ?? null;
    
    // Default Settings
    $s = array_merge([
        'font_family' => 'Outfit',
        'font_size' => 32,
        'primary_color' => '#156055',
        'background_color' => '#FFFFFF',
        'navbar_bg_color' => '#FFFFFF',
        'navbar_text_color' => '#1E293B',
        'grid_gap' => 16,
        'image_radius' => 0,
        'surface_color' => '#FFFFFF',
        'text_color' => '#0F172A',
        'hero_gradient' => 'linear-gradient(135deg,#EEF2FF 0%,#E0F2FE 50%,#FDF2F8 100%)',
        'card_shadow' => '0 12px 40px rgba(15,23,42,0.08)',
        'card_radius' => 18,
        'button_radius' => 14,
        'grid_layout' => 'masonry',
        'hero_style' => 'standard',
        'card_style' => 'default',
        'pattern' => 'none',
        'tab_style' => 'underline',
    ], $settings ?? []);
@endphp

<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="csrf-token" content="{{ csrf_token() }}">

        <title>{{ $pageTitle }}</title>

        <link rel="preconnect" href="https://fonts.googleapis.com">
        <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
        <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&family=Outfit:wght@400;500;600;700&family=Poppins:wght@400;500;600;700&family=Playfair+Display:wght@400;700&family=Montserrat:wght@400;600&family=Lora:wght@400;700&family=Roboto:wght@400;500;700&family=Open+Sans:wght@400;600&display=swap" rel="stylesheet">
        
        @if ($favicon)
            <link rel="icon" href="{{ asset('storage/' . $favicon) }}">
        @endif
        
        <style id="theme-styles">
            :root {
                --font-family: '{{ $s['font_family'] }}', sans-serif;
                --font-size: {{ $s['font_size'] }}px;
                --primary: {{ $s['primary_color'] }};
                --bg-body: {{ $s['background_color'] }};
                --nav-bg: {{ $s['navbar_bg_color'] }};
                --nav-text: {{ $s['navbar_text_color'] }};
                --grid-gap: {{ $s['grid_gap'] }}px;
                --img-radius: {{ $s['image_radius'] }}px;
                --surface: {{ $s['surface_color'] }};
                --text-color: {{ $s['text_color'] }};
                --hero-bg: {{ $s['hero_gradient'] }};
                --card-shadow: {{ $s['card_shadow'] }};
                --card-radius: {{ $s['card_radius'] }}px;
                --button-radius: {{ $s['button_radius'] }}px;
            }

            [x-cloak] { display: none !important; }
            
            .font-brand { font-family: var(--font-family), sans-serif !important; }
            .hero-title { font-size: var(--font-size) !important; }
            
            body { 
                font-family: var(--font-family) !important; 
                background: var(--bg-body) !important;
                color: var(--text-color);
            }

            .gallery-theme {
                background: var(--bg-body);
                min-height: 100vh;
            }
            
            /* Overrides for dynamic theming */
            .text-red-600, .text-red-500, .text-red-400 { color: var(--primary) !important; }
            .bg-red-600, .bg-red-500 { background-color: var(--primary) !important; }
            .hover\:bg-red-700:hover, .hover\:bg-red-500:hover { background-color: var(--primary) !important; filter: brightness(0.9); }
            .hover\:text-red-500:hover { color: var(--primary) !important; }
            .ring-red-500, .ring-red-600 { --tw-ring-color: var(--primary) !important; }
            .focus\:ring-red-500:focus { --tw-ring-color: var(--primary) !important; }
            .focus\:border-red-500:focus { border-color: var(--primary) !important; }
            .border-red-500, .border-red-600 { border-color: var(--primary) !important; }
            
            /* Grid & Spacing Overrides */
            .gallery-grid {
                gap: var(--grid-gap) !important;
            }
            .gallery-item {
                border-radius: var(--img-radius) !important;
                overflow: hidden;
            }
            .gallery-item img {
                border-radius: var(--img-radius) !important;
            }

            /* Layout Logic */
            [data-grid-layout="square"] .gallery-item {
                aspect-ratio: 1 / 1 !important;
            }
            [data-grid-layout="masonry"] .gallery-item {
                aspect-ratio: 3 / 4 !important;
            }

            /* Grid Logic Variation */
            [data-grid-layout="collage"] .gallery-grid {
                display: grid !important;
                grid-template-columns: repeat(auto-fill, minmax(300px, 1fr)) !important;
                grid-auto-rows: 300px !important;
                grid-auto-flow: dense !important;
            }
            [data-grid-layout="collage"] .gallery-item:nth-child(5n+1) { grid-column: span 2 !important; grid-row: span 2 !important; }
            [data-grid-layout="collage"] .gallery-item:nth-child(8n+3) { grid-column: span 2 !important; }
            [data-grid-layout="collage"] .gallery-item { aspect-ratio: auto !important; }

            /* Hero Styles */
            [data-hero-style="split"] header {
                height: 100vh !important;
                display: flex !important;
                flex-direction: row-reverse !important;
                align-items: stretch !important;
                padding: 0 !important;
                background: var(--bg-body) !important;
            }
            [data-hero-style="split"] header .absolute.inset-0.z-0 {
                position: relative !important;
                flex: 1 !important;
                height: 100% !important;
            }
            [data-hero-style="split"] header .relative.z-10 {
                flex: 1 !important;
                display: flex !important;
                flex-direction: column !important;
                justify-content: center !important;
                text-align: left !important;
                padding: 4rem !important;
                margin: 0 !important;
                background: var(--bg-body) !important;
            }
            [data-hero-style="split"] header .relative.z-10 h1, 
            [data-hero-style="split"] header .relative.z-10 p,
            [data-hero-style="split"] header .relative.z-10 span {
                color: var(--text-color) !important;
            }
            [data-hero-style="split"] header .relative.z-10 button {
                margin-left: 0 !important;
                background: var(--primary) !important;
                color: white !important;
                border: none !important;
            }

            [data-hero-style="minimal"] header {
                height: 40vh !important;
                min-height: 300px !important;
                background: var(--hero-bg) !important;
            }
            [data-hero-style="minimal"] header .absolute.inset-0.z-0 { display: none !important; }
            [data-hero-style="minimal"] header .relative.z-10 h1,
            [data-hero-style="minimal"] header .relative.z-10 p,
            [data-hero-style="minimal"] header .relative.z-10 span {
                color: var(--text-color) !important;
            }

            /* Card Styles */
            [data-card-style="glass"] .gallery-item {
                background: rgba(255, 255, 255, 0.1) !important;
                backdrop-filter: blur(8px) !important;
                border: 1px solid rgba(255, 255, 255, 0.2) !important;
                box-shadow: 0 8px 32px 0 rgba(0, 0, 0, 0.1) !important;
            }
            [data-card-style="bordered"] .gallery-item {
                border: 4px solid var(--primary) !important;
                padding: 10px !important;
            }
            [data-card-style="elevated"] .gallery-item {
                box-shadow: var(--card-shadow) !important;
                transition: transform 0.3s ease, box-shadow 0.3s ease !important;
            }
            [data-card-style="elevated"] .gallery-item:hover {
                transform: translateY(-8px) !important;
                box-shadow: 0 20px 40px rgba(0,0,0,0.15) !important;
            }

            /* Deep Structural Themes */
            [data-theme-style="Minimalist"] { --grid-gap: 48px; --img-radius: 4px; }
            [data-theme-style="Minimalist"] .gallery-grid { grid-template-columns: repeat(auto-fill, minmax(400px, 1fr)) !important; }

            [data-theme-style="Luxe"] { --grid-gap: 12px; --img-radius: 40px; }
            [data-theme-style="Luxe"] .gallery-item { border: 1px solid rgba(0,0,0,0.05); padding: 8px; background: white; }

            [data-theme-style="Bold"] { --grid-gap: 0px; --img-radius: 0px; }
            [data-theme-style="Bold"] .gallery-item { border: 4px solid var(--bg-body); }
            [data-theme-style="Bold"] .hero-title { text-transform: uppercase; letter-spacing: -0.05em; font-weight: 900 !important; }

            [data-theme-style="Editorial"] .gallery-grid { 
                display: flex !important; 
                flex-wrap: wrap !important;
                justify-content: center !important;
            }
            [data-theme-style="Editorial"] .gallery-item { 
                width: 30% !important; 
                margin: 2%;
                aspect-ratio: 2/3 !important;
            }
            [data-theme-style="Editorial"] .gallery-item:nth-child(even) { margin-top: 100px; }

            [data-theme-style="Glassmorphic"] .gallery-theme {
                background: linear-gradient(45deg, var(--bg-body), var(--primary)10) !important;
            }
            [data-theme-style="Glassmorphic"] .gallery-item {
                background: rgba(255,255,255,0.2) !important;
                backdrop-filter: blur(12px) !important;
                border: 1px solid rgba(255,255,255,0.3) !important;
                padding: 15px !important;
            }

            [data-theme-style="Retro"] .gallery-item {
                filter: sepia(0.2) contrast(1.1);
                border: 12px solid white;
                box-shadow: 0 10px 20px rgba(0,0,0,0.1) !important;
            }

            .gallery-theme .panel, .gallery-theme .card, .gallery-theme .gallery-card, .gallery-theme .bg-white {
                background: var(--surface) !important;
                box-shadow: var(--card-shadow);
                border-radius: var(--card-radius) !important;
            }
            .gallery-theme .btn-primary, .gallery-theme .btn-secondary, .gallery-theme button {
                border-radius: var(--button-radius) !important;
            }
            .gallery-theme .text-slate-800 { color: var(--text-color) !important; }
            .gallery-theme .bg-slate-50 { background: var(--surface) !important; }

            /* ── Tab Styles ────────────────────────────────────── */
            /* Reset: remove default border-b for all tab styles except underline */
            [data-tab-style]:not([data-tab-style="underline"]):not([data-tab-style="thick-underline"]):not([data-tab-style="double-line"]):not([data-tab-style="dash"]) .gallery-tabs button {
                border-bottom: none !important;
            }

            /* 1. underline (default) — already styled via Tailwind border-b-2 */

            /* 2. thick-underline */
            [data-tab-style="thick-underline"] .gallery-tabs button { border-bottom-width: 4px !important; }

            /* 3. pill */
            [data-tab-style="pill"] .gallery-tabs button[class*="border-red-600"],
            [data-tab-style="pill"] .gallery-tabs button[class*="text-red-600"] {
                background: var(--primary) !important; color: white !important; border-radius: 9999px !important; padding: 0.5rem 1.25rem !important;
            }

            /* 4. pill-outline */
            [data-tab-style="pill-outline"] .gallery-tabs button[class*="border-red-600"],
            [data-tab-style="pill-outline"] .gallery-tabs button[class*="text-red-600"] {
                border: 2px solid var(--primary) !important; border-radius: 9999px !important; padding: 0.5rem 1.25rem !important; background: transparent !important;
            }

            /* 5. block */
            [data-tab-style="block"] .gallery-tabs button[class*="border-red-600"],
            [data-tab-style="block"] .gallery-tabs button[class*="text-red-600"] {
                background: var(--primary) !important; color: white !important; padding: 0.5rem 1.25rem !important;
            }

            /* 6. rounded-block */
            [data-tab-style="rounded-block"] .gallery-tabs button[class*="border-red-600"],
            [data-tab-style="rounded-block"] .gallery-tabs button[class*="text-red-600"] {
                background: var(--primary) !important; color: white !important; border-radius: 12px !important; padding: 0.5rem 1.25rem !important;
            }

            /* 7. soft-fill */
            [data-tab-style="soft-fill"] .gallery-tabs button[class*="border-red-600"],
            [data-tab-style="soft-fill"] .gallery-tabs button[class*="text-red-600"] {
                background: color-mix(in srgb, var(--primary) 12%, transparent) !important; border-radius: 10px !important; padding: 0.5rem 1.25rem !important;
            }

            /* 8. dot */
            [data-tab-style="dot"] .gallery-tabs button { position: relative !important; }
            [data-tab-style="dot"] .gallery-tabs button[class*="border-red-600"]::after,
            [data-tab-style="dot"] .gallery-tabs button[class*="text-red-600"]::after {
                content: '' !important; position: absolute !important; bottom: -6px !important; left: 50% !important; transform: translateX(-50%) !important;
                width: 6px !important; height: 6px !important; border-radius: 50% !important; background: var(--primary) !important;
            }

            /* 9. double-line */
            [data-tab-style="double-line"] .gallery-tabs button[class*="border-red-600"],
            [data-tab-style="double-line"] .gallery-tabs button[class*="text-red-600"] {
                border-bottom: 2px solid var(--primary) !important; box-shadow: 0 4px 0 -2px var(--primary) !important;
            }

            /* 10. dash */
            [data-tab-style="dash"] .gallery-tabs button[class*="border-red-600"],
            [data-tab-style="dash"] .gallery-tabs button[class*="text-red-600"] {
                border-bottom-style: dashed !important; border-bottom-width: 3px !important; border-color: var(--primary) !important;
            }

            /* 11. glow */
            [data-tab-style="glow"] .gallery-tabs button[class*="border-red-600"],
            [data-tab-style="glow"] .gallery-tabs button[class*="text-red-600"] {
                background: color-mix(in srgb, var(--primary) 10%, transparent) !important; border-radius: 12px !important; padding: 0.5rem 1.25rem !important;
                box-shadow: 0 0 20px color-mix(in srgb, var(--primary) 30%, transparent) !important;
            }

            /* 12. lifted */
            [data-tab-style="lifted"] .gallery-tabs button[class*="border-red-600"],
            [data-tab-style="lifted"] .gallery-tabs button[class*="text-red-600"] {
                transform: translateY(-3px) !important; box-shadow: 0 4px 12px rgba(0,0,0,0.1) !important;
                background: var(--surface, white) !important; border-radius: 10px !important; padding: 0.5rem 1.25rem !important;
            }

            /* 13. gradient-fill */
            [data-tab-style="gradient-fill"] .gallery-tabs button[class*="border-red-600"],
            [data-tab-style="gradient-fill"] .gallery-tabs button[class*="text-red-600"] {
                background: linear-gradient(135deg, var(--primary), color-mix(in srgb, var(--primary) 70%, #000)) !important;
                color: white !important; border-radius: 10px !important; padding: 0.5rem 1.25rem !important;
            }

            /* 14. bracket */
            [data-tab-style="bracket"] .gallery-tabs button[class*="border-red-600"],
            [data-tab-style="bracket"] .gallery-tabs button[class*="text-red-600"] {
                border-top: 2px solid var(--primary) !important; border-bottom: 2px solid var(--primary) !important; padding: 0.4rem 1rem !important;
            }

            /* 15. highlight */
            [data-tab-style="highlight"] .gallery-tabs button { position: relative !important; z-index: 1 !important; }
            [data-tab-style="highlight"] .gallery-tabs button[class*="border-red-600"]::before,
            [data-tab-style="highlight"] .gallery-tabs button[class*="text-red-600"]::before {
                content: '' !important; position: absolute !important; bottom: 0 !important; left: -2px !important; right: -2px !important;
                height: 40% !important; background: color-mix(in srgb, var(--primary) 20%, transparent) !important; z-index: -1 !important;
            }

            /* 16. slide-up */
            [data-tab-style="slide-up"] .gallery-tabs button { position: relative !important; overflow: hidden !important; }
            [data-tab-style="slide-up"] .gallery-tabs button[class*="border-red-600"]::after,
            [data-tab-style="slide-up"] .gallery-tabs button[class*="text-red-600"]::after {
                content: '' !important; position: absolute !important; bottom: 0 !important; left: 0 !important; right: 0 !important;
                height: 3px !important; background: var(--primary) !important; animation: tabSlideUp 0.3s ease forwards !important;
            }
            @keyframes tabSlideUp { from { transform: translateY(100%); } to { transform: translateY(0); } }

            /* 17. boxed */
            [data-tab-style="boxed"] .gallery-tabs button[class*="border-red-600"],
            [data-tab-style="boxed"] .gallery-tabs button[class*="text-red-600"] {
                border: 2px solid var(--primary) !important; padding: 0.4rem 1rem !important;
            }

            /* 18. rounded-box */
            [data-tab-style="rounded-box"] .gallery-tabs button[class*="border-red-600"],
            [data-tab-style="rounded-box"] .gallery-tabs button[class*="text-red-600"] {
                border: 2px solid var(--primary) !important; border-radius: 12px !important; padding: 0.4rem 1rem !important;
            }

            /* 19. fade-bg */
            [data-tab-style="fade-bg"] .gallery-tabs button[class*="border-red-600"],
            [data-tab-style="fade-bg"] .gallery-tabs button[class*="text-red-600"] {
                background: linear-gradient(180deg, transparent 0%, color-mix(in srgb, var(--primary) 15%, transparent) 100%) !important;
                padding: 0.5rem 1.25rem !important; border-radius: 10px 10px 0 0 !important;
            }

            /* 20. minimal */
            [data-tab-style="minimal"] .gallery-tabs button[class*="border-red-600"],
            [data-tab-style="minimal"] .gallery-tabs button[class*="text-red-600"] {
                font-weight: 900 !important;
            }
            [data-tab-style="minimal"] .gallery-tabs button { opacity: 0.5 !important; }
            [data-tab-style="minimal"] .gallery-tabs button[class*="text-red-600"] { opacity: 1 !important; }
        </style>
        
        <script>
            // Set initial settings
            function applyDataAttributes(s) {
                const root = document.documentElement;
                root.setAttribute('data-grid-layout', s.grid_layout || 'masonry');
                root.setAttribute('data-hero-style', s.hero_style || 'standard');
                root.setAttribute('data-card-style', s.card_style || 'default');
                root.setAttribute('data-pattern', s.pattern || 'none');
                root.setAttribute('data-theme-style', s.template_style || 'Modern');
                root.setAttribute('data-tab-style', s.tab_style || 'underline');
            }

            applyDataAttributes(@json($s));
            
            window.addEventListener('message', (event) => {
                if (event.data.type === 'design-update') {
                    const s = event.data.settings;
                    const root = document.documentElement;
                    
                    root.style.setProperty('--font-family', `"${s.font_family}", sans-serif`);
                    root.style.setProperty('--font-size', `${s.font_size}px`);
                    root.style.setProperty('--primary', s.primary_color);
                    root.style.setProperty('--bg-body', s.background_color);
                    root.style.setProperty('--nav-bg', s.navbar_bg_color);
                    root.style.setProperty('--nav-text', s.navbar_text_color);
                    root.style.setProperty('--grid-gap', `${s.grid_gap}px`);
                    root.style.setProperty('--img-radius', `${s.image_radius}px`);
                    root.style.setProperty('--surface', s.surface_color || '#FFFFFF');
                    root.style.setProperty('--text-color', s.text_color || '#0F172A');
                    root.style.setProperty('--hero-bg', s.hero_gradient || root.style.getPropertyValue('--bg-body'));
                    root.style.setProperty('--card-shadow', s.card_shadow || '0 12px 40px rgba(15,23,42,0.08)');
                    root.style.setProperty('--card-radius', `${s.card_radius || 18}px`);
                    root.style.setProperty('--button-radius', `${s.button_radius || 14}px`);
                    
                    applyDataAttributes(s);
                }
            });
        </script>

        @vite(['resources/css/app.css', 'resources/js/app.js'])
        @include('partials.extensions-head')
    </head>
    <body class="min-h-screen font-sans text-slate-800 antialiased bg-white">
        <div class="gallery-theme min-h-screen">
            {{ $slot }}
        </div>

        @include('partials.gdpr-banner')
        @if (! empty($siteSettings['right_click_disable']))
            <script>
                document.addEventListener('contextmenu', function (event) {
                    event.preventDefault();
                });
            </script>
        @endif
        @stack('scripts')
    </body>
</html>
