@props(['title' => null])

@php
    $brandName = trim((string) ($siteSettings['site_name'] ?? ''));
    $brandName = $brandName !== '' ? $brandName : config('app.name', 'SnapNest');
    $pageTitle = $title ? $title . ' - ' . $brandName : $brandName;
    $siteLogo = $siteSettings['site_logo'] ?? null;
    $favicon = $siteSettings['favicon'] ?? null;
@endphp

<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="csrf-token" content="{{ csrf_token() }}">

        <title>{{ $pageTitle }}</title>

        <link rel="preconnect" href="https://fonts.bunny.net">
        <link href="https://fonts.bunny.net/css?family=space+grotesk:400,500,600,700&display=swap" rel="stylesheet">
        @if ($favicon)
            <link rel="icon" href="{{ asset('storage/' . $favicon) }}">
        @endif

        @vite(['resources/css/app.css', 'resources/js/app.js'])
        @include('partials.extensions-head')
    </head>
    <body class="min-h-screen font-sans text-ink antialiased">
        <div class="fixed inset-0 bg-grid opacity-30 pointer-events-none"></div>
        <div class="relative min-h-screen px-6 py-10 lg:px-12">
            <div class="mx-auto w-full max-w-6xl">
                <header class="flex flex-wrap items-center justify-between gap-4">
                    <a href="{{ url('/') }}" class="flex items-center gap-3">
                        <div class="flex h-11 w-11 items-center justify-center overflow-hidden rounded-2xl bg-brand text-white shadow-soft">
                            @if ($siteLogo)
                                <img src="{{ asset('storage/' . $siteLogo) }}" alt="{{ $brandName }}" class="h-full w-full object-cover">
                            @else
                                <svg viewBox="0 0 24 24" class="h-5 w-5" fill="none" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round">
                                    <circle cx="12" cy="12" r="8"></circle>
                                    <circle cx="12" cy="12" r="3"></circle>
                                    <path d="M12 4l3.5 6h-7l3.5-6z"></path>
                                </svg>
                            @endif
                        </div>
                        <span class="text-lg font-semibold">{{ $brandName }}</span>
                    </a>
                    <div class="text-xs text-muted">{{ __('Secure event gallery') }}</div>
                </header>

                <main class="mt-8">
                    {{ $slot }}
                </main>
            </div>
        </div>
        @include('partials.gdpr-banner')
        @if (! empty($siteSettings['right_click_disable']))
            <script>
                document.addEventListener('contextmenu', function (event) {
                    event.preventDefault();
                });
            </script>
        @endif
        @stack('scripts')
    </body>
</html>
