<x-admin-layout :title="__('Dashboard')" :subtitle="__('Real time visibility into events, uploads, and client access.')">
    <div class="space-y-6">

        {{-- Row 1: Key Metrics --}}
        <div class="grid gap-4 sm:grid-cols-2 lg:grid-cols-4">
            <div class="panel p-5">
                <p class="panel-heading">Active Events</p>
                <div class="mt-4 flex items-end justify-between">
                    <div>
                        <p class="text-3xl font-semibold text-ink">{{ number_format($metrics['active_events']) }}</p>
                        @if ($metrics['events_this_week'] > 0)
                            <p class="mt-1 text-sm text-muted">+{{ number_format($metrics['events_this_week']) }} this week</p>
                        @else
                            <p class="mt-1 text-sm text-muted">No new events this week</p>
                        @endif
                    </div>
                    <span class="badge">Live</span>
                </div>
            </div>

            <div class="panel p-5">
                <p class="panel-heading">Total Media</p>
                <div class="mt-4 flex items-end justify-between">
                    <div>
                        <p class="text-3xl font-semibold text-ink">{{ number_format($metrics['total_media']) }}</p>
                        <p class="mt-1 text-sm text-muted">{{ $metrics['queue_count'] ? number_format($metrics['queue_count']) . ' processing' : 'Queue is clear' }}</p>
                    </div>
                    <span class="badge">Assets</span>
                </div>
            </div>

            <div class="panel p-5">
                <p class="panel-heading">Storage Used</p>
                <div class="mt-4 flex items-end justify-between">
                    <div>
                        <p class="text-3xl font-semibold text-ink">{{ $metrics['storage_percent'] }}%</p>
                        <p class="mt-1 text-sm text-muted">{{ $metrics['storage_used_label'] }} of {{ $metrics['storage_limit_label'] }}</p>
                        @if (! empty($metrics['storage_warning']))
                            <p class="mt-1 text-xs {{ $metrics['storage_warning'] >= 90 ? 'text-danger' : 'text-warning' }}">
                                Warning ({{ $metrics['storage_warning'] }}%)
                            </p>
                        @endif
                    </div>
                    <span class="badge">Dual copy</span>
                </div>
            </div>

            @if ($metrics['is_admin'])
                <div class="panel p-5">
                    <p class="panel-heading">Active Users</p>
                    <div class="mt-4 flex items-end justify-between">
                        <div>
                            <p class="text-3xl font-semibold text-ink">{{ number_format($metrics['active_users']) }}</p>
                            @if ($metrics['new_users'] > 0)
                                <p class="mt-1 text-sm text-muted">+{{ number_format($metrics['new_users']) }} this week</p>
                            @else
                                <p class="mt-1 text-sm text-muted">No new users this week</p>
                            @endif
                        </div>
                        <span class="badge">Users</span>
                    </div>
                </div>
            @else
                <div class="panel p-5">
                    <p class="panel-heading">Upload Queue</p>
                    <div class="mt-4 flex items-end justify-between">
                        <div>
                            <p class="text-3xl font-semibold text-ink">{{ number_format($metrics['queue_count']) }}</p>
                            <p class="mt-1 text-sm text-muted">{{ $metrics['queue_count'] ? 'Files processing' : 'Queue is clear' }}</p>
                        </div>
                        <span class="badge">Chunked</span>
                    </div>
                </div>
            @endif
        </div>

        {{-- Row 2: Revenue Stats (admin only) --}}
        @isset($revenueStats)
            <div class="grid gap-4 sm:grid-cols-2 lg:grid-cols-4">
                <div class="panel p-5">
                    <p class="panel-heading">Total Revenue</p>
                    <div class="mt-4 flex items-end justify-between">
                        <div>
                            <p class="text-3xl font-semibold text-ink">{{ $revenueStats['currency_symbol'] }}{{ number_format($revenueStats['total_revenue'], 2) }}</p>
                            <p class="mt-1 text-sm text-muted">All time earnings</p>
                        </div>
                        <span class="badge">Revenue</span>
                    </div>
                </div>

                <div class="panel p-5">
                    <p class="panel-heading">This Month</p>
                    <div class="mt-4 flex items-end justify-between">
                        <div>
                            <p class="text-3xl font-semibold text-ink">{{ $revenueStats['currency_symbol'] }}{{ number_format($revenueStats['revenue_this_month'], 2) }}</p>
                            <p class="mt-1 text-sm text-muted">{{ now()->format('F Y') }}</p>
                        </div>
                        <span class="badge">Monthly</span>
                    </div>
                </div>

                <div class="panel p-5">
                    <p class="panel-heading">Total Orders</p>
                    <div class="mt-4 flex items-end justify-between">
                        <div>
                            <p class="text-3xl font-semibold text-ink">{{ number_format($revenueStats['total_orders']) }}</p>
                            <p class="mt-1 text-sm text-muted">{{ number_format($revenueStats['completed_orders']) }} completed</p>
                        </div>
                        <span class="badge">Orders</span>
                    </div>
                </div>

                <div class="panel p-5">
                    <p class="panel-heading">Pending Orders</p>
                    <div class="mt-4 flex items-end justify-between">
                        <div>
                            <p class="text-3xl font-semibold text-ink">{{ number_format($revenueStats['pending_orders']) }}</p>
                            <p class="mt-1 text-sm text-muted">{{ $revenueStats['pending_orders'] ? 'Awaiting payment' : 'All clear' }}</p>
                        </div>
                        <span class="badge">Pending</span>
                    </div>
                </div>
            </div>
        @endisset

        {{-- Row 3: Upload Throughput + Live Event Health --}}
        <div class="grid gap-6 {{ $metrics['is_admin'] ? 'lg:grid-cols-5' : 'lg:grid-cols-1' }}">
            <div class="panel p-6 {{ $metrics['is_admin'] ? 'lg:col-span-3' : '' }}">
                <div class="flex flex-wrap items-center justify-between gap-4">
                    <div>
                        <p class="panel-heading">Upload Throughput</p>
                        <p class="mt-1 text-sm text-muted">Image ingestion performance across live events.</p>
                    </div>
                    <div class="flex flex-wrap items-center gap-2">
                        <a href="{{ route('admin.events.create') }}" class="btn-primary">Create event</a>
                        @if ($metrics['is_admin'])
                            <a href="{{ route('admin.extensions.index') }}" class="btn-secondary">View analytics</a>
                        @endif
                    </div>
                </div>

                @php
                    $chart = $throughput['chart'] ?? ['line' => '', 'fill' => '', 'points' => []];
                    $chartLine = $chart['line'] ?: 'M20 160 L500 160';
                    $chartFill = $chart['fill'] ?: 'M20 160 L500 160 L500 180 L20 180 Z';
                    $chartPoints = $chart['points'] ?: [['x' => 20, 'y' => 160], ['x' => 500, 'y' => 160]];
                @endphp

                <div class="mt-6 rounded-2xl border border-border/60 bg-surface/80 p-4">
                    <svg viewBox="0 0 520 200" class="h-48 w-full">
                        <defs>
                            <linearGradient id="throughput-line" x1="0" y1="0" x2="0" y2="1">
                                <stop offset="0%" stop-color="rgb(var(--brand))" stop-opacity="0.35"></stop>
                                <stop offset="100%" stop-color="rgb(var(--brand))" stop-opacity="0"></stop>
                            </linearGradient>
                        </defs>
                        <path d="{{ $chartLine }}" fill="none" stroke="rgb(var(--brand))" stroke-width="3" stroke-linecap="round"></path>
                        <path d="{{ $chartFill }}" fill="url(#throughput-line)"></path>
                        <g fill="rgb(var(--accent))">
                            @foreach ($chartPoints as $point)
                                <circle cx="{{ $point['x'] }}" cy="{{ $point['y'] }}" r="4"></circle>
                            @endforeach
                        </g>
                    </svg>
                    <div class="mt-4 grid grid-cols-1 sm:grid-cols-3 gap-3">
                        <div>
                            <p class="text-xs text-muted">Avg / day</p>
                            <p class="mt-1 text-base font-semibold text-ink">{{ number_format($throughput['avg_per_day']) }} images</p>
                        </div>
                        <div>
                            <p class="text-xs text-muted">Peak day</p>
                            <p class="mt-1 text-base font-semibold text-ink">{{ number_format($throughput['peak_per_day']) }} images</p>
                        </div>
                        <div>
                            <p class="text-xs text-muted">Queue ETA</p>
                            <p class="mt-1 text-base font-semibold text-ink">{{ $throughput['queue_eta_label'] }}</p>
                        </div>
                    </div>
                </div>
            </div>

            <div class="panel p-6 {{ $metrics['is_admin'] ? 'lg:col-span-2' : '' }}">
                <p class="panel-heading">Live Event Health</p>
                <p class="mt-1 text-sm text-muted">Priority shoots and delivery status.</p>
                <div class="mt-6 space-y-3">
                    @forelse ($eventHealth as $event)
                        <div class="flex items-center justify-between rounded-xl border border-border/60 bg-surface/70 p-4">
                            <div class="min-w-0 flex-1">
                                <p class="text-sm font-semibold text-ink truncate">{{ $event['name'] }}</p>
                                <p class="mt-1 text-xs text-muted">{{ $event['subtitle'] }}</p>
                            </div>
                            <span class="badge ml-3 shrink-0">{{ $event['status'] }}</span>
                        </div>
                    @empty
                        <div class="rounded-xl border border-dashed border-border/60 bg-surface/70 p-4 text-sm text-muted">
                            No events to display yet.
                        </div>
                    @endforelse
                </div>
            </div>
        </div>

        {{-- Row 4: Recent Deliveries + System Snapshot --}}
        <div class="grid gap-6 {{ $metrics['is_admin'] ? 'lg:grid-cols-3' : 'lg:grid-cols-1' }}">
            <div class="panel p-6 {{ $metrics['is_admin'] ? 'lg:col-span-2' : '' }}">
                <div class="flex flex-wrap items-center justify-between gap-4">
                    <div>
                        <p class="panel-heading">Recent Deliveries</p>
                        <p class="mt-1 text-sm text-muted">Latest albums awaiting review or download.</p>
                    </div>
                    <a href="{{ route('admin.reports.index') }}" class="btn-secondary">Export report</a>
                </div>

                <div class="mt-6 overflow-x-auto">
                    <table class="w-full text-left text-sm">
                        <thead class="text-xs text-muted">
                            <tr>
                                <th class="pb-3">Event</th>
                                <th class="pb-3">Type</th>
                                <th class="pb-3">Status</th>
                                <th class="pb-3 text-right">Assets</th>
                            </tr>
                        </thead>
                        <tbody class="divide-y divide-border/60">
                            @forelse ($recentDeliveries as $delivery)
                                <tr>
                                    <td class="py-3">
                                        <p class="font-semibold text-ink">{{ $delivery['name'] }}</p>
                                        <p class="text-xs text-muted">{{ $delivery['expiry'] }}</p>
                                    </td>
                                    <td class="py-3 text-muted">{{ $delivery['type'] }}</td>
                                    <td class="py-3"><span class="badge">{{ $delivery['status'] }}</span></td>
                                    <td class="py-3 text-right text-ink">{{ number_format($delivery['assets']) }}</td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="4" class="py-6 text-center text-sm text-muted">No deliveries yet.</td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>

            @isset($systemSnapshot)
                <div class="panel p-6">
                    <p class="panel-heading">System Snapshot</p>
                    <p class="mt-1 text-sm text-muted">Security, uptime, and queue status.</p>
                    <div class="mt-6 space-y-4">
                        <div class="flex items-center justify-between">
                            <span class="text-sm text-muted">Admin 2FA</span>
                            <span class="text-sm font-semibold text-ink">{{ $systemSnapshot['two_factor'] }}</span>
                        </div>
                        <div class="flex items-center justify-between">
                            <span class="text-sm text-muted">Blocked IPs</span>
                            <span class="text-sm font-semibold text-ink">{{ number_format($systemSnapshot['blocked_ips']) }}</span>
                        </div>
                        <div class="flex items-center justify-between">
                            <span class="text-sm text-muted">Blocked Locations</span>
                            <span class="text-sm font-semibold text-ink">{{ number_format($systemSnapshot['blocked_locations']) }}</span>
                        </div>
                        <div class="flex items-center justify-between">
                            <span class="text-sm text-muted">Upload Queue</span>
                            <span class="text-sm font-semibold text-ink">{{ number_format($systemSnapshot['queue_pending']) }}</span>
                        </div>
                        <div class="flex items-center justify-between">
                            <span class="text-sm text-muted">Social Login</span>
                            <span class="text-sm font-semibold text-ink">{{ $systemSnapshot['social_login'] }}</span>
                        </div>
                    </div>
                    <div class="mt-6 rounded-xl border border-border/60 bg-surface/70 p-4 text-sm text-muted">
                        @if ($metrics['queue_count'] > 0)
                            Processing <span class="font-semibold text-ink">{{ number_format($metrics['queue_count']) }}</span> upload(s). Watermarks are running in the background.
                        @else
                            No pending uploads. Background queue is idle.
                        @endif
                    </div>
                </div>
            @endisset
        </div>

        {{-- Row 5: Recent Activity + Plan Distribution (admin only) --}}
        @if ($metrics['is_admin'])
            <div class="grid gap-6 lg:grid-cols-3">
                {{-- Recent Activity --}}
                @isset($recentActivity)
                    <div class="panel p-6 lg:col-span-2">
                        <div class="flex flex-wrap items-center justify-between gap-4">
                            <div>
                                <p class="panel-heading">Recent Activity</p>
                                <p class="mt-1 text-sm text-muted">Latest actions across the platform.</p>
                            </div>
                            <a href="{{ route('admin.extensions.index') }}" class="btn-secondary">View all</a>
                        </div>
                        <div class="mt-6 space-y-1">
                            @forelse ($recentActivity as $activity)
                                <div class="flex items-start gap-3 rounded-lg px-3 py-2.5 transition hover:bg-surface/80">
                                    <div class="mt-0.5 flex h-7 w-7 shrink-0 items-center justify-center rounded-full bg-brand/10 text-xs font-bold text-brand">
                                        {{ strtoupper(substr($activity['user'], 0, 1)) }}
                                    </div>
                                    <div class="min-w-0 flex-1">
                                        <p class="text-sm text-ink">
                                            <span class="font-semibold">{{ $activity['user'] }}</span>
                                            <span class="text-muted">&middot; {{ $activity['action'] }}</span>
                                        </p>
                                        <p class="mt-0.5 text-xs text-muted truncate">{{ $activity['description'] }}</p>
                                    </div>
                                    <span class="shrink-0 text-xs text-muted">{{ $activity['time'] }}</span>
                                </div>
                            @empty
                                <div class="rounded-xl border border-dashed border-border/60 bg-surface/70 p-4 text-sm text-muted">
                                    No recent activity.
                                </div>
                            @endforelse
                        </div>
                    </div>
                @endisset

                {{-- Plan Distribution --}}
                @isset($planStats)
                    <div class="panel p-6">
                        <p class="panel-heading">Plan Distribution</p>
                        <p class="mt-1 text-sm text-muted">Orders by active plan.</p>
                        <div class="mt-6 space-y-3">
                            @forelse ($planStats as $plan)
                                @php
                                    $maxOrders = max(array_column($planStats, 'orders')) ?: 1;
                                    $barWidth = ($plan['orders'] / $maxOrders) * 100;
                                @endphp
                                <div>
                                    <div class="flex items-center justify-between text-sm">
                                        <span class="font-medium text-ink">{{ $plan['name'] }}</span>
                                        <span class="text-muted">{{ number_format($plan['orders']) }} orders</span>
                                    </div>
                                    <div class="mt-1.5 h-2 w-full overflow-hidden rounded-full bg-border/40">
                                        <div class="h-full rounded-full bg-brand/70 transition-all" style="width: {{ $barWidth }}%"></div>
                                    </div>
                                </div>
                            @empty
                                <div class="rounded-xl border border-dashed border-border/60 bg-surface/70 p-4 text-sm text-muted">
                                    No active plans.
                                </div>
                            @endforelse
                        </div>
                    </div>
                @endisset
            </div>
        @endif

    </div>
</x-admin-layout>
