<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{{ __('Payment Confirmed') }}</title>
    <style>
        body { font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', sans-serif; background: #f4f4f5; margin: 0; padding: 24px 0; color: #18181b; }
        .wrap { max-width: 560px; margin: 0 auto; }
        .card { background: #fff; border-radius: 12px; overflow: hidden; box-shadow: 0 1px 3px rgba(0,0,0,.1); }
        .header { background: #7c3aed; padding: 32px 32px 24px; text-align: center; }
        .header svg { width: 48px; height: 48px; margin-bottom: 12px; }
        .header h1 { color: #fff; font-size: 22px; font-weight: 700; margin: 0; }
        .body { padding: 32px; }
        .greeting { font-size: 16px; color: #3f3f46; margin-bottom: 20px; }
        .table { width: 100%; border-collapse: collapse; margin: 20px 0; font-size: 14px; }
        .table td { padding: 10px 0; border-bottom: 1px solid #f4f4f5; vertical-align: top; }
        .table td:first-child { color: #71717a; width: 44%; }
        .table td:last-child { font-weight: 500; color: #18181b; text-align: right; }
        .status-badge { display: inline-block; background: #d1fae5; color: #065f46; border-radius: 20px; padding: 3px 12px; font-size: 12px; font-weight: 600; }
        .divider { border: none; border-top: 1px solid #f4f4f5; margin: 24px 0; }
        .total-row td { font-size: 16px; font-weight: 700; border-bottom: none; padding-top: 14px; }
        .btn { display: inline-block; background: #7c3aed; color: #fff !important; text-decoration: none; border-radius: 8px; padding: 12px 28px; font-size: 14px; font-weight: 600; margin: 24px 0 0; }
        .footer { padding: 20px 32px; text-align: center; font-size: 12px; color: #a1a1aa; }
    </style>
</head>
<body>
<div class="wrap">
    <div class="card">

        {{-- Header --}}
        <div class="header">
            <svg viewBox="0 0 48 48" fill="none" xmlns="http://www.w3.org/2000/svg">
                <circle cx="24" cy="24" r="24" fill="rgba(255,255,255,0.15)"/>
                <path d="M16 24l6 6 10-12" stroke="white" stroke-width="3" stroke-linecap="round" stroke-linejoin="round"/>
            </svg>
            <h1>{{ __('Payment Confirmed!') }}</h1>
        </div>

        {{-- Body --}}
        <div class="body">
            @php
                $meta        = $order->metadata ?? [];
                $planName    = $order->plan?->name ?? ($meta['plan_name'] ?? 'Plan');
                $currency    = \App\Models\Currency::where('code', $order->currency)->first();
                $sym         = $currency?->symbol ?: '$';
                $couponCode  = $meta['coupon_code'] ?? null;
                $discount    = (float) ($meta['discount'] ?? 0);
                $originalPrice = (float) ($meta['original_price'] ?? $order->amount);
                $appName     = config('app.name');
            @endphp

            <p class="greeting">
                {{ __('Hi') }} {{ $order->user->name }},<br><br>
                {{ __('Thank you for your purchase. Your payment has been confirmed and your plan is now active.') }}
            </p>

            <table class="table">
                <tr>
                    <td>{{ __('Order Number') }}</td>
                    <td>{{ $order->order_number }}</td>
                </tr>
                <tr>
                    <td>{{ __('Plan') }}</td>
                    <td>{{ $planName }}</td>
                </tr>
                <tr>
                    <td>{{ __('Payment Method') }}</td>
                    <td>{{ $order->payment_method }}</td>
                </tr>
                @if($couponCode && $discount > 0)
                <tr>
                    <td>{{ __('Original Price') }}</td>
                    <td>{{ $sym }}{{ number_format($originalPrice, 2) }}</td>
                </tr>
                <tr>
                    <td>{{ __('Coupon') }} ({{ $couponCode }})</td>
                    <td style="color:#059669">−{{ $sym }}{{ number_format($discount, 2) }}</td>
                </tr>
                @endif
                <tr>
                    <td>{{ __('Date') }}</td>
                    <td>{{ $order->created_at->format('d M Y, h:i A') }}</td>
                </tr>
                <tr>
                    <td>{{ __('Status') }}</td>
                    <td><span class="status-badge">{{ __('Paid') }}</span></td>
                </tr>
                <tr class="total-row">
                    <td>{{ __('Total Paid') }}</td>
                    <td>{{ $sym }}{{ number_format($order->amount, 2) }} {{ $order->currency }}</td>
                </tr>
            </table>

            <center>
                <a href="{{ route('admin.orders.show', $order) }}" class="btn">{{ __('View Invoice') }}</a>
            </center>
        </div>

        <div class="footer">
            {{ __('This email was sent by') }} {{ $appName }}. {{ __('If you have questions, please contact our support team.') }}
        </div>

    </div>
</div>
</body>
</html>
