@extends('errors.layout')

@section('title', __('Forbidden'))
@section('badge', __('Access Denied'))
@section('code', '403')
@section('heading', __('Access forbidden'))
@section('message', isset($exception) && $exception->getMessage() ? $exception->getMessage() : __('You don\'t have permission to access this resource. Contact your administrator if you believe this is a mistake.'))

@section('actions')
    <a href="{{ url('/') }}" class="inline-flex items-center gap-2 rounded-xl bg-brand px-5 py-2.5 text-sm font-semibold text-white shadow-sm transition hover:bg-brand/90">
        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="m3 9 9-7 9 7v11a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2z"/><polyline points="9 22 9 12 15 12 15 22"/></svg>
        {{ __('Go Home') }}
    </a>
    <button onclick="history.back()" class="inline-flex items-center gap-2 rounded-xl border border-border bg-surface px-5 py-2.5 text-sm font-semibold text-ink shadow-sm transition hover:bg-surface-2">
        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><line x1="19" y1="12" x2="5" y2="12"/><polyline points="12 19 5 12 12 5"/></svg>
        {{ __('Go Back') }}
    </button>
@endsection
