@extends('layouts.frontend')

@section('title', __('Blog') . ' - ' . config('app.name', 'SnapNest'))

@section('content')
<main class="flex-1 pt-32 pb-20 bg-background">
    <div class="container mx-auto px-4">
        <div class="text-center mb-16 space-y-4">
            <h1 class="text-4xl md:text-5xl font-bold tracking-tight">{{ __('Latest Insights') }}</h1>
            <p class="text-muted-foreground text-lg max-w-2xl mx-auto">
                {{ __('News, tips, and tutorials for the modern photographer.') }}
            </p>
        </div>

        @if($posts->count())
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
            @foreach($posts as $post)
                <div class="flex flex-col overflow-hidden rounded-[2rem] border border-border bg-card text-card-foreground shadow-sm hover:shadow-xl transition-all hover:-translate-y-1 group">
                    <div class="aspect-video relative overflow-hidden bg-muted/30">
                        @if($post->image)
                            <img
                                src="{{ asset('storage/' . $post->image) }}"
                                alt="{{ $post->title }}"
                                class="h-full w-full object-cover group-hover:scale-105 transition-transform duration-500"
                            />
                        @else
                            <div class="h-full w-full flex items-center justify-center bg-primary/5">
                                <svg xmlns="http://www.w3.org/2000/svg" width="48" height="48" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1" stroke-linecap="round" stroke-linejoin="round" class="text-primary/20"><path d="M4 22h16a2 2 0 0 0 2-2V4a2 2 0 0 0-2-2H8a2 2 0 0 0-2 2v16a2 2 0 0 1-2 2Zm0 0a2 2 0 0 1-2-2v-9c0-1.1.9-2 2-2h2"/><path d="M18 14h-8"/><path d="M15 18h-5"/><path d="M10 6h8v4h-8V6Z"/></svg>
                            </div>
                        @endif
                    </div>
                    <div class="p-6 flex flex-col gap-4 flex-1">
                        <div class="flex items-center justify-between text-xs text-muted-foreground">
                            @if($post->category)
                                <span class="bg-primary/10 text-primary px-3 py-1 rounded-full font-bold uppercase tracking-wider text-[10px]">{{ $post->category->name }}</span>
                            @endif
                            <span class="flex items-center gap-1 text-[10px] font-medium">
                                <svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-3 w-3"><rect width="18" height="18" x="3" y="4" rx="2" ry="2"/><line x1="16" x2="16" y1="2" y2="6"/><line x1="8" x2="8" y1="2" y2="6"/><line x1="3" x2="21" y1="10" y2="10"/></svg>
                                {{ $post->published_at->format('M d, Y') }}
                            </span>
                        </div>
                        <div class="space-y-2">
                            <h3 class="font-bold tracking-tight text-xl line-clamp-2">{{ $post->title }}</h3>
                            <p class="text-sm text-muted-foreground line-clamp-2">{{ $post->excerpt }}</p>
                        </div>
                        <div class="mt-auto pt-4">
                            <a href="{{ route('blog.show', $post->slug) }}" class="text-sm font-bold text-primary hover:underline inline-flex items-center gap-1">
                                {{ __('Read Article') }}
                                <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M5 12h14"/><path d="m12 5 7 7-7 7"/></svg>
                            </a>
                        </div>
                    </div>
                </div>
            @endforeach
        </div>

        <div class="mt-12">
            {{ $posts->links() }}
        </div>
        @else
        <div class="text-center py-20">
            <p class="text-muted-foreground text-lg">{{ __('No blog posts yet. Check back soon!') }}</p>
        </div>
        @endif
    </div>
</main>
@endsection
