@extends('layouts.frontend')

@section('title', $post->title . ' - ' . config('app.name', 'SnapNest'))

@section('content')
<article class="flex-1 pt-32 pb-20 bg-background">
    <div class="container mx-auto px-4 max-w-3xl">
        <a href="{{ route('blog.index') }}" class="inline-flex items-center text-sm font-bold text-muted-foreground hover:text-primary transition-colors mb-8 group">
            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="mr-2 h-4 w-4 group-hover:-translate-x-1 transition-transform"><path d="m12 19-7-7 7-7"/><path d="M19 12H5"/></svg>
            {{ __('Back to Blog') }}
        </a>

        <div class="space-y-4 mb-8 text-center">
            @if($post->category)
            <div class="flex justify-center">
                <span class="bg-primary/10 text-primary px-3 py-1 rounded-full text-[10px] font-bold uppercase tracking-widest">{{ $post->category->name }}</span>
            </div>
            @endif
            <h1 class="text-3xl md:text-5xl font-bold tracking-tight leading-tight">{{ $post->title }}</h1>
            <div class="flex justify-center items-center gap-4 text-muted-foreground text-sm">
                <div class="flex items-center gap-2">
                    <div class="h-8 w-8 rounded-full bg-primary/10 flex items-center justify-center font-bold text-primary text-xs">
                        {{ strtoupper(substr($post->author_name ?? 'A', 0, 1)) }}
                    </div>
                    <span class="font-medium">{{ $post->author_name ?? __('Admin') }}</span>
                </div>
                <span>&bull;</span>
                <span>{{ $post->published_at->format('M d, Y') }}</span>
            </div>
        </div>

        @if($post->image)
        <div class="aspect-video relative rounded-2xl overflow-hidden mb-12 shadow-lg ring-1 ring-border">
            <img src="{{ asset('storage/' . $post->image) }}" alt="{{ $post->title }}" class="object-cover w-full h-full" />
        </div>
        @endif

        <div class="prose prose-lg dark:prose-invert mx-auto max-w-none">
            @if($post->excerpt)
                <p class="lead text-xl text-muted-foreground mb-6">{{ $post->excerpt }}</p>
            @endif
            {!! nl2br(e($post->details)) !!}
        </div>

        @if($post->tags && count($post->tags))
        <div class="mt-10 pt-6 border-t border-border flex flex-wrap gap-2">
            @foreach($post->tags as $tag)
                <span class="px-3 py-1 rounded-full bg-muted text-muted-foreground text-xs font-bold uppercase tracking-wider">#{{ $tag }}</span>
            @endforeach
        </div>
        @endif

        @if(isset($relatedPosts) && $relatedPosts->count())
        <div class="mt-16 pt-10 border-t border-border">
            <h3 class="text-2xl font-bold mb-8">{{ __('Related Articles') }}</h3>
            <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                @foreach($relatedPosts as $related)
                <a href="{{ route('blog.show', $related->slug) }}" class="group p-4 rounded-2xl border border-border hover:border-primary/20 hover:shadow-lg transition-all">
                    <h4 class="font-bold line-clamp-2 group-hover:text-primary transition-colors mb-2">{{ $related->title }}</h4>
                    <p class="text-sm text-muted-foreground line-clamp-2">{{ $related->excerpt }}</p>
                </a>
                @endforeach
            </div>
        </div>
        @endif
    </div>
</article>
@endsection
