@extends('layouts.frontend')

@section('title', ($page->title ?? __('Contact Us')) . ' - ' . config('app.name', 'SnapNest'))

@php
    $c = $page->content ?? [];
@endphp

@section('content')
    <main class="flex-1 pt-32 pb-20 overflow-hidden relative">
        <!-- Ambient Background -->
        <div class="absolute top-0 right-0 w-[50%] h-[50%] bg-primary/5 blur-[120px] rounded-full -z-10"></div>
        <div class="absolute bottom-0 left-0 w-[50%] h-[50%] bg-accent/5 blur-[120px] rounded-full -z-10"></div>

        <div class="container mx-auto px-4">
            <div class="max-w-6xl mx-auto">
                <div class="grid grid-cols-1 lg:grid-cols-2 gap-20 items-start">
                    <!-- Left Side: Info -->
                    <div class="space-y-12">
                        <div class="space-y-6">
                            <div
                                x-data="{ shown: false }"
                                x-init="setTimeout(() => shown = true, 0)"
                                class="inline-flex items-center gap-2 px-3 py-1 rounded-full bg-primary/10 border border-primary/20 text-primary text-[10px] font-bold uppercase tracking-widest transition-all duration-700 transform"
                                :class="shown ? 'opacity-100 translate-y-0' : 'opacity-0 translate-y-5'">
                                <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-3.5 w-3.5"><path d="m12 3-1.912 5.813a2 2 0 0 1-1.275 1.275L3 12l5.813 1.912a2 2 0 0 1 1.275 1.275L12 21l1.912-5.813a2 2 0 0 1 1.275-1.275L12 3Z"/></svg> {{ $c['badge_text'] ?? __('24/7 Support Available') }}
                            </div>
                            <h1
                                x-data="{ shown: false }"
                                x-init="setTimeout(() => shown = true, 100)"
                                class="text-3xl sm:text-5xl md:text-7xl font-bold tracking-tight text-foreground transition-all duration-700 transform"
                                :class="shown ? 'opacity-100 translate-y-0' : 'opacity-0 translate-y-5'">
                                {{ $c['hero_title'] ?? __("Let's start a") }} <br />
                                <span class="bg-gradient-to-r from-primary to-accent bg-clip-text text-transparent italic">{{ $c['hero_title_highlight'] ?? __('Conversation.') }}</span>
                            </h1>
                            <p
                                x-data="{ shown: false }"
                                x-init="setTimeout(() => shown = true, 200)"
                                class="text-xl text-muted-foreground leading-relaxed max-w-sm transition-all duration-700 transform"
                                :class="shown ? 'opacity-100 translate-y-0' : 'opacity-0 translate-y-5'">
                                {{ $c['hero_description'] ?? __('Have a specific query about our platform? Our team is ready to assist you in scaling your photography business.') }}
                            </p>
                        </div>

                        <div class="grid grid-cols-1 md:grid-cols-2 gap-8">
                            <div class="space-y-4 p-6 rounded-3xl bg-muted/30 border border-border/50 hover:bg-muted/50 transition-colors group">
                                <div class="h-10 w-10 rounded-xl bg-primary/10 flex items-center justify-center text-primary group-hover:scale-110 transition-transform">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-5 w-5"><rect width="20" height="16" x="2" y="4" rx="2"/><path d="m22 7-8.97 5.7a1.94 1.94 0 0 1-2.06 0L2 7"/></svg>
                                </div>
                                <div>
                                    <h3 class="font-bold text-sm uppercase tracking-widest text-muted-foreground/60 mb-1">{{ __('Email us') }}</h3>
                                    <p class="font-semibold">{{ $siteSettings['contact_email'] ?? 'support@' . request()->getHost() }}</p>
                                </div>
                            </div>
                            <div class="space-y-4 p-6 rounded-3xl bg-muted/30 border border-border/50 hover:bg-muted/50 transition-colors group">
                                <div class="h-10 w-10 rounded-xl bg-primary/10 flex items-center justify-center text-primary group-hover:scale-110 transition-transform">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-5 w-5"><path d="M21 15a2 2 0 0 1-2 2H7l-4 4V5a2 2 0 0 1 2-2h14a2 2 0 0 1 2 2z"/></svg>
                                </div>
                                <div>
                                    <h3 class="font-bold text-sm uppercase tracking-widest text-muted-foreground/60 mb-1">{{ $c['support_label'] ?? __('Support') }}</h3>
                                    <p class="font-semibold">{{ $c['support_text'] ?? __('Live Chat - 24/7') }}</p>
                                </div>
                            </div>
                        </div>

                        <div class="flex flex-wrap items-center gap-6 sm:gap-10 pt-4 px-2 sm:px-6">
                            <div class="flex flex-col gap-1">
                                <div class="flex items-center gap-2 text-primary">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-4 w-4"><circle cx="12" cy="12" r="10"/><polyline points="12 6 12 12 16 14"/></svg>
                                    <span class="text-xs font-bold uppercase tracking-wider">{{ $c['response_label'] ?? __('Avg. Response') }}</span>
                                </div>
                                <span class="text-2xl font-bold font-mono">{{ $c['response_value'] ?? '15m' }}</span>
                            </div>
                            <div class="flex flex-col gap-1">
                                <div class="flex items-center gap-2 text-primary">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-4 w-4"><circle cx="12" cy="12" r="10"/><path d="M12 2a14.5 14.5 0 0 0 0 20 14.5 14.5 0 0 0 0-20"/><path d="M2 12h20"/></svg>
                                    <span class="text-xs font-bold uppercase tracking-wider">{{ $c['sales_label'] ?? __('Global Sales') }}</span>
                                </div>
                                <span class="text-2xl font-bold font-mono">{{ $c['sales_value'] ?? 'Active' }}</span>
                            </div>
                        </div>
                    </div>

                    <!-- Right Side: Form -->
                    <div
                        x-data="contactForm()"
                        x-init="setTimeout(() => shown = true, 300)"
                        class="p-6 sm:p-8 md:p-12 rounded-[2rem] sm:rounded-[3rem] bg-card border border-border shadow-2xl relative transition-all duration-700 transform"
                        :class="shown ? 'opacity-100 scale-100' : 'opacity-0 scale-95'">

                        <!-- Success Message -->
                        <div x-show="success" x-cloak class="flex flex-col items-center justify-center py-12 space-y-4 text-center">
                            <div class="h-16 w-16 rounded-full bg-emerald-100 dark:bg-emerald-900/30 flex items-center justify-center">
                                <svg xmlns="http://www.w3.org/2000/svg" width="32" height="32" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-8 w-8 text-emerald-500"><path d="M20 6 9 17l-5-5"/></svg>
                            </div>
                            <h3 class="text-xl font-bold">{{ __('Message Sent!') }}</h3>
                            <p class="text-sm text-muted-foreground max-w-xs" x-text="message"></p>
                        </div>

                        <!-- Form -->
                        <form x-show="!success" @submit.prevent="submit" class="space-y-6">
                            <!-- Error Message -->
                            <div x-show="error" x-cloak class="flex items-center gap-3 p-4 rounded-2xl bg-red-50 dark:bg-red-900/20 border border-red-200 dark:border-red-800">
                                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-5 w-5 text-red-500 shrink-0"><circle cx="12" cy="12" r="10"/><line x1="15" x2="9" y1="9" y2="15"/><line x1="9" x2="15" y1="9" y2="15"/></svg>
                                <p class="text-sm font-medium text-red-600 dark:text-red-400" x-text="message"></p>
                            </div>

                            <div class="grid grid-cols-1 sm:grid-cols-2 gap-4 sm:gap-6">
                                <div class="space-y-2">
                                    <label class="text-[10px] font-black uppercase tracking-widest text-muted-foreground/60 ml-1">{{ __('First Name') }}</label>
                                    <input x-model="form.first_name" placeholder="{{ __('Alex') }}" required class="flex h-14 w-full rounded-2xl border border-input bg-muted/20 px-6 py-1 text-base shadow-sm transition-colors file:border-0 file:bg-transparent file:text-sm file:font-medium file:text-foreground placeholder:text-muted-foreground focus-visible:outline-none focus:bg-background focus-visible:ring-1 focus-visible:ring-ring disabled:cursor-not-allowed disabled:opacity-50 md:text-sm" />
                                </div>
                                <div class="space-y-2">
                                    <label class="text-[10px] font-black uppercase tracking-widest text-muted-foreground/60 ml-1">{{ __('Last Name') }}</label>
                                    <input x-model="form.last_name" placeholder="{{ __('Rivera') }}" required class="flex h-14 w-full rounded-2xl border border-input bg-muted/20 px-6 py-1 text-base shadow-sm transition-colors file:border-0 file:bg-transparent file:text-sm file:font-medium file:text-foreground placeholder:text-muted-foreground focus-visible:outline-none focus:bg-background focus-visible:ring-1 focus-visible:ring-ring disabled:cursor-not-allowed disabled:opacity-50 md:text-sm" />
                                </div>
                            </div>
                            <div class="space-y-2">
                                <label class="text-[10px] font-black uppercase tracking-widest text-muted-foreground/60 ml-1">{{ __('Work Email') }}</label>
                                <input x-model="form.email" placeholder="{{ __('alex@studio.com') }}" type="email" required class="flex h-14 w-full rounded-2xl border border-input bg-muted/20 px-6 py-1 text-base shadow-sm transition-colors file:border-0 file:bg-transparent file:text-sm file:font-medium file:text-foreground placeholder:text-muted-foreground focus-visible:outline-none focus:bg-background focus-visible:ring-1 focus-visible:ring-ring disabled:cursor-not-allowed disabled:opacity-50 md:text-sm" />
                            </div>
                            <div class="space-y-2">
                                <label class="text-[10px] font-black uppercase tracking-widest text-muted-foreground/60 ml-1">{{ __('Your Message') }}</label>
                                <textarea
                                    x-model="form.message"
                                    required
                                    class="w-full min-h-[160px] rounded-[2rem] bg-muted/20 border border-border/50 focus:bg-background focus:ring-1 focus:ring-primary transition-all p-6 text-sm resize-none"
                                    placeholder="{{ __('How can we help you today?') }}"
                                ></textarea>
                            </div>
                            <button
                                type="submit"
                                :disabled="loading"
                                class="w-full h-16 rounded-[2rem] bg-primary hover:bg-primary/90 text-lg font-bold shadow-xl shadow-primary/20 group text-primary-foreground flex items-center justify-center transition-all disabled:opacity-50 disabled:cursor-not-allowed">
                                <span x-show="!loading" class="flex items-center">
                                    {{ __('Send Message') }}
                                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="ml-2 h-5 w-5 group-hover:translate-x-1 group-hover:-translate-y-1 transition-transform"><path d="m22 2-7 20-4-9-9-4Z"/><path d="M22 2 11 13"/></svg>
                                </span>
                                <span x-show="loading" x-cloak class="flex items-center">
                                    <svg class="animate-spin -ml-1 mr-3 h-5 w-5" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"><circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle><path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4z"></path></svg>
                                    {{ __('Sending...') }}
                                </span>
                            </button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </main>

    <script>
    function contactForm() {
        return {
            shown: false,
            loading: false,
            success: false,
            error: false,
            message: '',
            form: {
                first_name: '',
                last_name: '',
                email: '',
                message: '',
            },
            async submit() {
                this.loading = true;
                this.error = false;
                this.message = '';
                try {
                    const res = await fetch('{{ route("contact.submit") }}', {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/json',
                            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content,
                            'Accept': 'application/json',
                        },
                        body: JSON.stringify(this.form),
                    });
                    const data = await res.json();
                    if (res.ok && data.success) {
                        this.success = true;
                        this.message = data.message;
                    } else {
                        this.error = true;
                        this.message = data.message || (data.errors ? Object.values(data.errors).flat()[0] : 'Something went wrong.');
                    }
                } catch (e) {
                    this.error = true;
                    this.message = 'Network error. Please try again.';
                } finally {
                    this.loading = false;
                }
            }
        };
    }
    </script>
@endsection
