@extends('layouts.frontend')

@section('title', ($page->title ?? __('Cookie Policy')) . ' - ' . config('app.name', 'SnapNest'))

@php
    $c = $page->content ?? [];
    $cookieTypes = $c['cookie_types'] ?? [
        ['title' => __('Essential Cookies'), 'description' => __('These are necessary for the website to function. They include session management and security cookies.'), 'priority' => __('Mandatory')],
        ['title' => __('Performance Cookies'), 'description' => __('We use these to understand how visitors interact with our platform, help us identify areas for improvement.'), 'priority' => __('Optional')],
        ['title' => __('Functionality Cookies'), 'description' => __('These allow the website to remember choices you make, such as your language preference or layout settings.'), 'priority' => __('Optional')],
    ];
@endphp

@section('content')
<main class="flex-1 pb-20 pt-32">
    <div class="container mx-auto px-4 max-w-4xl">
        <div class="space-y-12 pb-20" x-data="{ shown: false }" x-init="setTimeout(() => shown = true, 0)">
            <div class="space-y-4 transition-all duration-700 transform" :class="shown ? 'opacity-100 translate-x-0' : 'opacity-0 translate-x-5'">
                <h1 class="text-4xl font-bold tracking-tight">{{ $c['title'] ?? __('Cookie') }} <span class="text-primary italic">{{ $c['title_highlight'] ?? __('Policy') }}</span></h1>
                <p class="text-muted-foreground">{{ __('Last updated:') }} {{ $c['last_updated'] ?? 'January 1, 2026' }}</p>
            </div>

            <div class="prose prose-slate dark:prose-invert max-w-none transition-all duration-700 transform delay-100" :class="shown ? 'opacity-100 translate-x-0' : 'opacity-0 translate-x-5'">
                <p>
                    {{ $c['intro_text'] ?? __('At ' . config('app.name', 'SnapNest') . ', we use cookies to provide a better experience and analyze our traffic. This policy explains what cookies are, how we use them, and your choices regarding their use.') }}
                </p>
            </div>

            <div class="grid gap-6 transition-all duration-700 transform delay-200" :class="shown ? 'opacity-100 translate-x-0' : 'opacity-0 translate-x-5'">
                @foreach($cookieTypes as $type)
                <div class="p-6 rounded-3xl bg-card border border-border shadow-sm flex flex-col md:flex-row md:items-center justify-between gap-6">
                    <div class="space-y-2">
                        <h3 class="font-bold text-lg">{{ $type['title'] ?? '' }}</h3>
                        <p class="text-sm text-muted-foreground max-w-md">{{ $type['description'] ?? '' }}</p>
                    </div>
                    <div class="px-4 py-1.5 rounded-full text-[10px] font-bold uppercase tracking-widest {{ ($type['priority'] ?? '') === 'Mandatory' ? 'bg-primary/10 text-primary border border-primary/20' : 'bg-muted text-muted-foreground border border-border' }}">
                        {{ $type['priority'] ?? __('Optional') }}
                    </div>
                </div>
                @endforeach
            </div>

            <div class="prose prose-slate dark:prose-invert max-w-none pt-8 transition-all duration-700 transform delay-300" :class="shown ? 'opacity-100 translate-x-0' : 'opacity-0 translate-x-5'">
                <h3>{{ $c['manage_title'] ?? __('How to Manage Cookies') }}</h3>
                <p>
                    {{ $c['manage_text'] ?? __('Most web browsers allow you to control cookies through their settings preferences. However, if you limit the ability of websites to set cookies, you may worsen your overall user experience, as it will no longer be personalized to you.') }}
                </p>
            </div>
        </div>
    </div>
</main>
@endsection
