@extends('layouts.frontend')

@section('title', ($page->title ?? __('Terms of Service')) . ' - ' . config('app.name', 'SnapNest'))

@php
    $c = $page->content ?? [];
    $appName = config('app.name', 'SnapNest');
    $sections = $c['sections'] ?? [
        ['title' => __('Introduction'), 'content' => __('Welcome to') . ' ' . $appName . '. ' . __('These Terms of Service govern your use of the') . ' ' . $appName . ' ' . __('platform, website, and associated services. By creating an account or using our platform, you agree to these terms in full.')],
        ['title' => __('Services & Licensing'), 'content' => $appName . ' ' . __('provides a photography hosting and distribution platform powered by AI. We grant you a limited, non-exclusive license to use our platform for your professional photography business.')],
        ['title' => __('User Responsibilities'), 'content' => __('As a photographer on our platform, you are responsible for the content you upload. You must ensure you have the necessary rights to distribute the images and that your content does not violate any laws or third-party rights.')],
        ['title' => __('AI Face Recognition'), 'content' => __('Our AI features are designed to enhance guest experience. You agree to inform your clients and participants that AI indexing may be used for the purpose of photo delivery, in accordance with our Privacy Policy.')],
        ['title' => __('Payment & Subscriptions'), 'content' => __('Access to certain features requires a paid subscription. All fees are non-refundable unless otherwise specified. We reserve the right to change our pricing upon reasonable notice.')],
        ['title' => __('Termination of Service'), 'content' => __('We reserve the right to suspend or terminate accounts that violate these terms, engage in fraudulent activity, or disrupt the quality of service for other users.')],
    ];
@endphp

@section('content')
<main class="flex-1 pb-20 pt-32">
    <div class="container mx-auto px-4 max-w-4xl">
        <div class="space-y-12 pb-20" x-data="{ shown: false }" x-init="setTimeout(() => shown = true, 0)">
            <div class="space-y-4 transition-all duration-700 transform" :class="shown ? 'opacity-100 translate-x-0' : 'opacity-0 translate-x-5'">
                <h1 class="text-4xl font-bold tracking-tight">{{ $c['title'] ?? __('Terms of') }} <span class="text-primary italic">{{ $c['title_highlight'] ?? __('Service') }}</span></h1>
                <p class="text-muted-foreground">{{ __('Last updated:') }} {{ $c['last_updated'] ?? 'January 1, 2026' }}</p>
            </div>

            <div class="space-y-16">
                @foreach($sections as $index => $section)
                <section class="space-y-4">
                    <div class="flex items-center gap-4">
                        <span class="flex items-center justify-center h-8 w-8 rounded-lg bg-primary/10 text-primary text-xs font-bold">
                            {{ str_pad($index + 1, 2, '0', STR_PAD_LEFT) }}
                        </span>
                        <h2 class="text-xl font-bold">{{ $section['title'] ?? '' }}</h2>
                    </div>
                    <p class="text-muted-foreground leading-relaxed pl-12">
                        {{ $section['content'] ?? '' }}
                    </p>
                </section>
                @endforeach
            </div>

            <div class="mt-20 p-8 rounded-3xl bg-muted/50 border border-border border-dashed text-center">
                <p class="text-sm text-muted-foreground">
                    {{ __('Questions about our terms? Reach out to us via our') }} <a href="{{ route('contact') }}" class="text-primary font-bold hover:underline">{{ __('contact page') }}</a>
                </p>
            </div>
        </div>
    </div>
</main>
@endsection
