@extends('layouts.frontend')

@section('title', $page->title . ' - ' . config('app.name', 'SnapNest'))

@section('content')
    <main class="flex-1 py-32 bg-background selection:bg-primary/30">
        <div class="container mx-auto px-4">
            <div class="max-w-4xl mx-auto">
                <div x-data="{ shown: false }" x-init="setTimeout(() => shown = true, 0)"
                     class="space-y-6 mb-12 text-center md:text-left transition-all duration-700 transform"
                     :class="shown ? 'opacity-100 translate-y-0' : 'opacity-0 translate-y-5'">
                    <h1 class="text-4xl md:text-6xl font-bold tracking-tight">{{ $page->title }}</h1>
                </div>
                <div x-data="{ shown: false }" x-intersect="shown = true"
                     class="prose prose-lg dark:prose-invert max-w-none transition-all duration-700 transform"
                     :class="shown ? 'opacity-100' : 'opacity-0'">
                    {!! $page->description !!}
                </div>
            </div>
        </div>
    </main>
@endsection
