@extends('install.layout')
@section('title', __('Admin Account'))
@section('step-name', __('Admin Account'))

@section('content')
<div class="space-y-5">
    <div class="space-y-1">
        <h1 class="text-2xl font-bold tracking-tight">
            {{ __('Admin') }} <span class="text-primary italic">{{ __('Account.') }}</span>
        </h1>
        <p class="text-muted-foreground text-xs font-medium">{{ __('Create your administrator account.') }}</p>
    </div>

    @if (session('error'))
        <div class="rounded-xl border border-red-500/30 bg-red-500/10 px-4 py-2 text-xs font-medium text-red-400">
            {{ session('error') }}
        </div>
    @endif
</div>

<form method="POST" action="{{ route('install.admin.save') }}" class="space-y-4 mt-5">
    @csrf

    {{-- Name + Email side by side --}}
    <div class="grid grid-cols-2 gap-3">
        <div class="space-y-1.5 group">
            <label class="text-[10px] font-bold uppercase tracking-widest text-muted-foreground group-focus-within:text-primary transition-colors">{{ __('Full Name') }}</label>
            <input type="text" name="name" value="{{ old('name', $admin['name'] ?? '') }}" placeholder="{{ __('John Smith') }}"
                   class="flex h-11 w-full bg-muted/30 border-border/50 rounded-xl border border-input px-3 py-1 shadow-sm transition-all font-medium text-sm text-foreground placeholder:text-muted-foreground focus-visible:outline-none focus:border-primary/50 focus:ring-0"
                   required autofocus />
            @error('name')
                <span class="text-red-500 text-xs">{{ $message }}</span>
            @enderror
        </div>

        <div class="space-y-1.5 group">
            <label class="text-[10px] font-bold uppercase tracking-widest text-muted-foreground group-focus-within:text-primary transition-colors">{{ __('Email Address') }}</label>
            <input type="email" name="email" value="{{ old('email', $admin['email'] ?? '') }}" placeholder="{{ __('admin@yourdomain.com') }}"
                   class="flex h-11 w-full bg-muted/30 border-border/50 rounded-xl border border-input px-3 py-1 shadow-sm transition-all font-medium text-sm text-foreground placeholder:text-muted-foreground focus-visible:outline-none focus:border-primary/50 focus:ring-0"
                   required />
            @error('email')
                <span class="text-red-500 text-xs">{{ $message }}</span>
            @enderror
        </div>
    </div>

    {{-- Password + Confirm side by side --}}
    <div class="grid grid-cols-2 gap-3">
        <div class="space-y-1.5 group">
            <label class="text-[10px] font-bold uppercase tracking-widest text-muted-foreground group-focus-within:text-primary transition-colors">{{ __('Password') }}</label>
            <input type="password" name="password"
                   class="flex h-11 w-full bg-muted/30 border-border/50 rounded-xl border border-input px-3 py-1 shadow-sm transition-all text-sm text-foreground focus-visible:outline-none focus:border-primary/50 focus:ring-0"
                   required />
            @error('password')
                <span class="text-red-500 text-xs">{{ $message }}</span>
            @enderror
        </div>

        <div class="space-y-1.5 group">
            <label class="text-[10px] font-bold uppercase tracking-widest text-muted-foreground group-focus-within:text-primary transition-colors">{{ __('Confirm Password') }}</label>
            <input type="password" name="password_confirmation"
                   class="flex h-11 w-full bg-muted/30 border-border/50 rounded-xl border border-input px-3 py-1 shadow-sm transition-all text-sm text-foreground focus-visible:outline-none focus:border-primary/50 focus:ring-0"
                   required />
        </div>
    </div>

    <p class="text-[10px] text-muted-foreground font-medium">{{ __('Minimum 8 characters') }}</p>

    <div class="flex gap-3">
        <a href="{{ route('install.application') }}" class="h-11 px-5 rounded-xl bg-muted/30 border border-border/50 hover:bg-muted/50 text-sm font-bold transition-all text-foreground flex items-center justify-center gap-1.5">
            <svg class="h-4 w-4" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2"><path stroke-linecap="round" stroke-linejoin="round" d="M15 19l-7-7 7-7"/></svg>
            {{ __('Back') }}
        </a>
        <button type="submit" class="flex-1 h-11 rounded-xl bg-primary hover:bg-primary/90 text-sm font-bold shadow-lg shadow-primary/20 transition-all text-primary-foreground">
            {{ __('Create Admin & Install') }}
        </button>
    </div>
</form>
@endsection
