@extends('install.layout')
@section('title', __('Application'))
@section('step-name', __('Application'))

@section('content')
<div class="space-y-5">
    <div class="space-y-1">
        <h1 class="text-2xl font-bold tracking-tight">
            {{ __('Application') }} <span class="text-primary italic">{{ __('Settings.') }}</span>
        </h1>
        <p class="text-muted-foreground text-xs font-medium">{{ __('Configure your application details.') }}</p>
    </div>

    @if (session('error'))
        <div class="rounded-xl border border-red-500/30 bg-red-500/10 px-4 py-2 text-xs font-medium text-red-400">
            {{ session('error') }}
        </div>
    @endif
</div>

<form method="POST" action="{{ route('install.application.save') }}" class="space-y-4 mt-5">
    @csrf

    {{-- App Name + URL side by side --}}
    <div class="grid grid-cols-2 gap-3">
        <div class="space-y-1.5 group">
            <label class="text-[10px] font-bold uppercase tracking-widest text-muted-foreground group-focus-within:text-primary transition-colors">{{ __('Application Name') }}</label>
            <input type="text" name="name" value="{{ $app['name'] ?? 'SnapNest' }}" placeholder="SnapNest"
                   class="flex h-11 w-full bg-muted/30 border-border/50 rounded-xl border border-input px-3 py-1 shadow-sm transition-all font-medium text-sm text-foreground placeholder:text-muted-foreground focus-visible:outline-none focus:border-primary/50 focus:ring-0" />
            @error('name')
                <span class="text-red-500 text-xs">{{ $message }}</span>
            @enderror
        </div>

        <div class="space-y-1.5 group">
            <label class="text-[10px] font-bold uppercase tracking-widest text-muted-foreground group-focus-within:text-primary transition-colors">{{ __('Application URL') }}</label>
            <input type="url" name="url" value="{{ $app['url'] ?? url('/') }}" placeholder="https://yourdomain.com"
                   class="flex h-11 w-full bg-muted/30 border-border/50 rounded-xl border border-input px-3 py-1 shadow-sm transition-all font-medium text-sm text-foreground placeholder:text-muted-foreground focus-visible:outline-none focus:border-primary/50 focus:ring-0" />
            @error('url')
                <span class="text-red-500 text-xs">{{ $message }}</span>
            @enderror
        </div>
    </div>

    {{-- Timezone --}}
    <div class="space-y-1.5 group" x-data="timezoneSearch()" @click.outside="open = false">
        <label class="text-[10px] font-bold uppercase tracking-widest text-muted-foreground group-focus-within:text-primary transition-colors">{{ __('Timezone') }}</label>
        <div class="relative">
            <input type="text" x-model="search"
                   @focus="open = true"
                   @input="open = true"
                   placeholder="{{ __('Search timezone...') }}"
                   class="flex h-11 w-full bg-muted/30 border-border/50 rounded-xl border border-input px-3 py-1 shadow-sm transition-all font-medium text-sm text-foreground placeholder:text-muted-foreground focus-visible:outline-none focus:border-primary/50 focus:ring-0" />
            <input type="hidden" name="timezone" x-model="selected" />

            <div x-show="open" x-transition
                 class="absolute z-20 mt-1 w-full bg-background border border-border/50 rounded-xl shadow-xl max-h-48 overflow-y-auto">
                <template x-for="tz in filtered" :key="tz">
                    <div @click="select(tz)"
                         class="px-3 py-2 text-sm font-medium cursor-pointer hover:bg-primary/10 hover:text-primary transition-colors"
                         x-text="tz"></div>
                </template>
                <div x-show="filtered.length === 0" class="px-3 py-2 text-sm text-muted-foreground">
                    {{ __('No timezones found') }}
                </div>
            </div>
        </div>
        @error('timezone')
            <span class="text-red-500 text-xs">{{ $message }}</span>
        @enderror
    </div>

    {{-- Navigation --}}
    <div class="flex gap-3">
        <a href="{{ route('install.database') }}" class="h-11 px-5 rounded-xl bg-muted/30 border border-border/50 hover:bg-muted/50 text-sm font-bold transition-all text-foreground flex items-center justify-center gap-1.5">
            <svg class="h-4 w-4" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2"><path stroke-linecap="round" stroke-linejoin="round" d="M15 19l-7-7 7-7"/></svg>
            {{ __('Back') }}
        </a>
        <button type="submit" class="flex-1 h-11 rounded-xl bg-primary hover:bg-primary/90 text-sm font-bold shadow-lg shadow-primary/20 transition-all text-primary-foreground">
            {{ __('Continue') }}
        </button>
    </div>
</form>

<script>
function timezoneSearch() {
    return {
        open: false,
        search: '',
        selected: '{{ $app["timezone"] ?? "UTC" }}',
        timezones: @json(timezone_identifiers_list()),
        get filtered() {
            if (!this.search) return this.timezones.slice(0, 20);
            return this.timezones.filter(tz => tz.toLowerCase().includes(this.search.toLowerCase())).slice(0, 20);
        },
        select(tz) {
            this.selected = tz;
            this.search = tz;
            this.open = false;
        },
        init() {
            this.search = this.selected;
        }
    }
}
</script>
@endsection
