@extends('install.layout')
@section('title', __('Complete'))
@section('step-name', __('Complete'))

@section('content')
<style>
    @keyframes checkmark-scale {
        0% { transform: scale(0); opacity: 0; }
        50% { transform: scale(1.2); }
        100% { transform: scale(1); opacity: 1; }
    }
    .checkmark-animated { animation: checkmark-scale 0.6s ease-out forwards; }
</style>

<div class="flex flex-col items-center text-center space-y-6">
    {{-- Animated Success Checkmark --}}
    <div class="checkmark-animated">
        <div class="w-16 h-16 rounded-full bg-emerald-500/10 border-2 border-emerald-500 flex items-center justify-center">
            <svg class="w-8 h-8 text-emerald-500" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2.5">
                <path stroke-linecap="round" stroke-linejoin="round" d="M5 13l4 4L19 7" />
            </svg>
        </div>
    </div>

    {{-- Heading --}}
    <div class="space-y-1">
        <h1 class="text-2xl font-bold tracking-tight">
            {{ __('Installation') }} <span class="text-primary italic">{{ __('Complete!') }}</span>
        </h1>
        <p class="text-muted-foreground text-xs font-medium">{{ __('SnapNest has been successfully installed and is ready to use.') }}</p>
    </div>

    {{-- Info Cards side by side --}}
    <div class="w-full grid grid-cols-2 gap-3 text-left">
        <div class="bg-muted/30 rounded-xl p-4 border border-border/50">
            <p class="text-[10px] font-bold uppercase tracking-widest text-muted-foreground mb-1.5">{{ __('Admin Panel URL') }}</p>
            <p class="text-sm font-medium text-foreground break-all">{{ $appUrl }}/admin</p>
        </div>
        <div class="bg-muted/30 rounded-xl p-4 border border-border/50">
            <p class="text-[10px] font-bold uppercase tracking-widest text-muted-foreground mb-1.5">{{ __('Admin Email') }}</p>
            <p class="text-sm font-medium text-foreground break-all">{{ $adminEmail }}</p>
        </div>
    </div>

    {{-- Security Reminder --}}
    <div class="w-full bg-amber-500/5 rounded-xl p-3 border border-amber-500/20 text-left">
        <p class="text-xs font-medium text-amber-400">{{ __('Please save your login credentials. For security, the password is not displayed here.') }}</p>
    </div>

    {{-- Buttons side by side --}}
    <div class="w-full grid grid-cols-2 gap-3">
        <a href="{{ $appUrl }}/admin" class="h-11 rounded-xl bg-primary hover:bg-primary/90 text-sm font-bold shadow-lg shadow-primary/20 transition-all text-primary-foreground flex items-center justify-center">
            {{ __('Go to Admin Panel') }}
        </a>
        <a href="{{ $appUrl }}" class="h-11 rounded-xl bg-muted/30 border border-border/50 hover:bg-muted/50 text-sm font-bold transition-all text-foreground flex items-center justify-center">
            {{ __('Visit Homepage') }}
        </a>
    </div>
</div>
@endsection
