@extends('install.layout')
@section('title', __('Database'))
@section('step-name', __('Database'))

@section('content')
<div class="space-y-5">
    <div class="space-y-1">
        <h1 class="text-2xl font-bold tracking-tight">
            {{ __('Database') }} <span class="text-primary italic">{{ __('Configuration.') }}</span>
        </h1>
        <p class="text-muted-foreground text-xs font-medium">{{ __('Configure your database connection.') }}</p>
    </div>

    @if (session('error'))
        <div class="rounded-xl border border-red-500/30 bg-red-500/10 px-4 py-2 text-xs font-medium text-red-400">
            {{ session('error') }}
        </div>
    @endif
</div>

<div x-data="databaseForm()" class="space-y-5 mt-5">
    {{-- Driver Selection --}}
    <div class="space-y-2">
        <label class="text-[10px] font-bold uppercase tracking-widest text-muted-foreground">{{ __('Database Driver') }}</label>
        <div class="grid grid-cols-1 gap-2">
            <div class="py-2.5 px-4 rounded-xl border bg-primary/10 border-primary/50 text-primary text-center text-xs font-bold uppercase tracking-widest">
                MySQL
            </div>
        </div>
    </div>

    {{-- MySQL Fields --}}
    <div class="space-y-4">
        {{-- Host + Port side by side --}}
        <div class="grid grid-cols-3 gap-3">
            <div class="col-span-2 space-y-1.5 group">
                <label class="text-[10px] font-bold uppercase tracking-widest text-muted-foreground group-focus-within:text-primary transition-colors">{{ __('Host') }}</label>
                <input type="text" x-model="host" placeholder="127.0.0.1"
                       class="flex h-11 w-full bg-muted/30 border-border/50 rounded-xl border border-input px-3 py-1 shadow-sm transition-all font-medium text-sm text-foreground placeholder:text-muted-foreground focus-visible:outline-none focus:border-primary/50 focus:ring-0" />
            </div>
            <div class="space-y-1.5 group">
                <label class="text-[10px] font-bold uppercase tracking-widest text-muted-foreground group-focus-within:text-primary transition-colors">{{ __('Port') }}</label>
                <input type="text" x-model="port" placeholder="3306"
                       class="flex h-11 w-full bg-muted/30 border-border/50 rounded-xl border border-input px-3 py-1 shadow-sm transition-all font-medium text-sm text-foreground placeholder:text-muted-foreground focus-visible:outline-none focus:border-primary/50 focus:ring-0" />
            </div>
        </div>

        {{-- Database Name --}}
        <div class="space-y-1.5 group">
            <label class="text-[10px] font-bold uppercase tracking-widest text-muted-foreground group-focus-within:text-primary transition-colors">{{ __('Database Name') }}</label>
            <input type="text" x-model="database" placeholder="snapnest"
                   class="flex h-11 w-full bg-muted/30 border-border/50 rounded-xl border border-input px-3 py-1 shadow-sm transition-all font-medium text-sm text-foreground placeholder:text-muted-foreground focus-visible:outline-none focus:border-primary/50 focus:ring-0" />
        </div>

        {{-- Username + Password side by side --}}
        <div class="grid grid-cols-2 gap-3">
            <div class="space-y-1.5 group">
                <label class="text-[10px] font-bold uppercase tracking-widest text-muted-foreground group-focus-within:text-primary transition-colors">{{ __('Username') }}</label>
                <input type="text" x-model="username" placeholder="root"
                       class="flex h-11 w-full bg-muted/30 border-border/50 rounded-xl border border-input px-3 py-1 shadow-sm transition-all font-medium text-sm text-foreground placeholder:text-muted-foreground focus-visible:outline-none focus:border-primary/50 focus:ring-0" />
            </div>
            <div class="space-y-1.5 group">
                <label class="text-[10px] font-bold uppercase tracking-widest text-muted-foreground group-focus-within:text-primary transition-colors">{{ __('Password') }}</label>
                <input type="password" x-model="password"
                       class="flex h-11 w-full bg-muted/30 border-border/50 rounded-xl border border-input px-3 py-1 shadow-sm transition-all font-medium text-sm text-foreground placeholder:text-muted-foreground focus-visible:outline-none focus:border-primary/50 focus:ring-0" />
            </div>
        </div>
    </div>

    {{-- Test Connection --}}
    <div class="space-y-2">
        <button type="button" @click="testConnection()"
                :disabled="testing"
                class="w-full h-10 rounded-xl bg-muted/50 border border-border/50 hover:bg-muted transition-all text-sm font-bold text-foreground disabled:opacity-50 disabled:cursor-not-allowed flex items-center justify-center gap-2">
            <svg x-show="testing" class="animate-spin h-4 w-4" fill="none" viewBox="0 0 24 24">
                <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
                <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
            </svg>
            <span x-text="testing ? '{{ __('Testing...') }}' : '{{ __('Test Connection') }}'"></span>
        </button>

        <div x-show="testResult !== null" x-transition>
            <div x-show="testResult === true" class="rounded-xl border border-emerald-500/30 bg-emerald-500/10 px-4 py-2 text-xs font-medium text-emerald-400">
                <span x-text="testMessage"></span>
            </div>
            <div x-show="testResult === false" class="rounded-xl border border-red-500/30 bg-red-500/10 px-4 py-2 text-xs font-medium text-red-400">
                <span x-text="testMessage"></span>
            </div>
        </div>
    </div>

    {{-- Navigation --}}
    <div class="flex gap-3">
        <a href="{{ route('install.requirements') }}" class="h-11 px-5 rounded-xl bg-muted/30 border border-border/50 hover:bg-muted/50 text-sm font-bold transition-all text-foreground flex items-center justify-center gap-1.5">
            <svg class="h-4 w-4" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2"><path stroke-linecap="round" stroke-linejoin="round" d="M15 19l-7-7 7-7"/></svg>
            {{ __('Back') }}
        </a>
        <form method="POST" action="{{ route('install.database.save') }}" class="flex-1">
            @csrf
            <input type="hidden" name="driver" x-model="driver" />
            <input type="hidden" name="host" x-model="host" />
            <input type="hidden" name="port" x-model="port" />
            <input type="hidden" name="database" x-model="database" />
            <input type="hidden" name="username" x-model="username" />
            <input type="hidden" name="password" x-model="password" />

            <button type="submit" class="w-full h-11 rounded-xl bg-primary hover:bg-primary/90 text-sm font-bold shadow-lg shadow-primary/20 transition-all text-primary-foreground">
                {{ __('Continue') }}
            </button>
        </form>
    </div>
</div>

<script>
function databaseForm() {
    return {
        driver: 'mysql',
        host: '{{ $db["host"] ?? "127.0.0.1" }}',
        port: '{{ $db["port"] ?? "3306" }}',
        database: '{{ $db["database"] ?? "" }}',
        username: '{{ $db["username"] ?? "" }}',
        password: '{{ $db["password"] ?? "" }}',
        testing: false,
        testResult: null,
        testMessage: '',
        init() {},
        async testConnection() {
            this.testing = true;
            this.testResult = null;
            try {
                const res = await fetch('{{ route("install.database.test") }}', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': document.querySelector('meta[name=csrf-token]').content,
                        'Accept': 'application/json',
                    },
                    body: JSON.stringify({
                        driver: this.driver, host: this.host, port: this.port,
                        database: this.database, username: this.username, password: this.password,
                    })
                });
                const data = await res.json();
                this.testResult = data.success;
                this.testMessage = data.message;
            } catch (e) {
                this.testResult = false;
                this.testMessage = '{{ __('Connection failed:') }} ' + e.message;
            }
            this.testing = false;
        }
    }
}
</script>
@endsection
