<!DOCTYPE html>
<html lang="en" class="scroll-smooth">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <meta name="robots" content="noindex, nofollow">

    <title>@yield('title', __('Install')) - SnapNest</title>

    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:ital,wght@0,200..800;1,200..800&display=swap" rel="stylesheet">

    @vite(['resources/css/frontend.css', 'resources/js/app.js'])

    <style>
        :root { --font-sans: 'Plus Jakarta Sans', sans-serif; }
    </style>
</head>
<body class="min-h-screen bg-background font-sans antialiased text-foreground">
    <div class="h-screen flex overflow-hidden relative transition-colors duration-500">

        {{-- Left Side: Branding + Step Indicator --}}
        <div class="hidden lg:flex lg:w-[420px] relative flex-col justify-between p-16 overflow-hidden bg-muted/30 dark:bg-zinc-900/50 shrink-0">
            <div class="absolute inset-0 bg-[radial-gradient(circle_at_30%_50%,rgba(var(--primary),0.1),transparent)] pointer-events-none"></div>
            <div class="absolute top-0 right-0 w-px h-full bg-gradient-to-b from-transparent via-border to-transparent"></div>

            <div class="relative z-10 space-y-12">
                <div x-data="{ shown: false }" x-init="setTimeout(() => shown = true, 0)"
                     class="space-y-6 transition-all duration-700 transform"
                     :class="shown ? 'opacity-100 translate-x-0' : 'opacity-0 -translate-x-5'">
                    <h2 class="text-4xl font-bold leading-tight tracking-tight text-foreground">
                        SNAP<span class="text-primary italic">NEST</span>
                    </h2>
                    <p class="text-muted-foreground text-sm max-w-sm font-medium">
                        {{ __('Setup wizard will guide you through the installation process in a few simple steps.') }}
                    </p>
                </div>

                @include('install.partials.steps', ['currentStep' => $currentStep ?? 1])
            </div>

            <div class="relative z-10">
                <p class="text-muted-foreground/60 text-[10px] font-bold tracking-widest uppercase flex items-center gap-3">
                    <span class="h-px w-8 bg-border"></span>
                    {{ __('SnapNest Installation Wizard') }}
                </p>
            </div>
        </div>

        {{-- Right Side: Form Content --}}
        <div class="flex-1 flex flex-col justify-center items-center p-6 md:p-10 bg-background relative overflow-y-auto">
            <div class="absolute inset-0 overflow-hidden pointer-events-none">
                <div class="absolute top-[20%] right-[-10%] w-96 h-96 bg-primary/5 blur-[120px] rounded-full"></div>
            </div>

            <div class="w-full max-w-2xl space-y-8 relative z-10 text-foreground">
                {{-- Mobile step indicator --}}
                <div class="lg:hidden mb-6">
                    <div class="flex items-center justify-between text-xs text-muted-foreground font-bold uppercase tracking-widest mb-3">
                        <span>{{ __('Step') }} {{ $currentStep ?? 1 }} {{ __('of') }} 6</span>
                        <span class="text-primary">@yield('step-name', 'Welcome')</span>
                    </div>
                    <div class="w-full bg-muted/50 rounded-full h-1.5">
                        <div class="bg-primary h-1.5 rounded-full transition-all duration-500" style="width: {{ (($currentStep ?? 1) / 6) * 100 }}%"></div>
                    </div>
                </div>

                @yield('content')
            </div>
        </div>
    </div>
</body>
</html>
