@extends('install.layout')
@section('title', __('Welcome'))
@section('step-name', __('Welcome'))

@section('content')
<div class="space-y-6">
    {{-- Heading --}}
    <div class="space-y-2">
        <h1 class="text-2xl font-bold tracking-tight">
            {{ __('Welcome to') }} <span class="text-primary italic">SnapNest.</span>
        </h1>
        <p class="text-muted-foreground text-xs font-medium">{{ __("Let's set up your photography event management platform.") }}</p>
    </div>

    {{-- Feature Cards --}}
    <div class="grid grid-cols-4 gap-3">
        <div class="p-4 rounded-xl bg-muted/20 border border-border/50 hover:border-primary/20 transition-all group">
            <svg class="h-5 w-5 text-blue-500 mb-3 group-hover:scale-110 transition-transform" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                <ellipse cx="12" cy="5" rx="9" ry="3"/><path d="M3 5V19A9 3 0 0 0 21 19V5"/><path d="M3 12A9 3 0 0 0 21 12"/>
            </svg>
            <p class="text-[9px] font-bold tracking-widest uppercase text-muted-foreground">{{ __('Database') }}</p>
        </div>

        <div class="p-4 rounded-xl bg-muted/20 border border-border/50 hover:border-primary/20 transition-all group">
            <svg class="h-5 w-5 text-emerald-500 mb-3 group-hover:scale-110 transition-transform" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                <path d="M12 22s8-4 8-10V5l-8-3-8 3v7c0 6 8 10 8 10"/><path d="m9 12 2 2 4-4"/>
            </svg>
            <p class="text-[9px] font-bold tracking-widest uppercase text-muted-foreground">{{ __('Security') }}</p>
        </div>

        <div class="p-4 rounded-xl bg-muted/20 border border-border/50 hover:border-primary/20 transition-all group">
            <svg class="h-5 w-5 text-purple-500 mb-3 group-hover:scale-110 transition-transform" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                <path d="M14.5 4h-5L7 7H4a2 2 0 0 0-2 2v9a2 2 0 0 0 2 2h16a2 2 0 0 0 2-2V9a2 2 0 0 0-2-2h-3l-2.5-3z"/><circle cx="12" cy="13" r="3"/>
            </svg>
            <p class="text-[9px] font-bold tracking-widest uppercase text-muted-foreground">{{ __('Media') }}</p>
        </div>

        <div class="p-4 rounded-xl bg-muted/20 border border-border/50 hover:border-primary/20 transition-all group">
            <svg class="h-5 w-5 text-orange-500 mb-3 group-hover:scale-110 transition-transform" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                <path d="M19 21v-2a4 4 0 0 0-4-4H9a4 4 0 0 0-4 4v2"/><circle cx="12" cy="7" r="4"/>
            </svg>
            <p class="text-[9px] font-bold tracking-widest uppercase text-muted-foreground">{{ __('Admin') }}</p>
        </div>
    </div>

    {{-- Begin Installation Button --}}
    <a href="{{ route('install.requirements') }}" class="w-full h-11 rounded-xl bg-primary hover:bg-primary/90 text-sm font-bold shadow-lg shadow-primary/20 transition-all text-primary-foreground flex items-center justify-center">
        {{ __('Begin Installation') }}
    </a>
</div>
@endsection
