@props(['title' => 'Dashboard', 'subtitle' => null])

@php
    $brandName = trim((string) ($siteSettings['site_name'] ?? ''));
    $brandName = $brandName !== '' ? $brandName : config('app.name', 'SnapNest');
    $adminLogo = $siteSettings['admin_logo'] ?? null;
    $favicon = $siteSettings['favicon'] ?? null;
@endphp

<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}" dir="{{ $languageDirection ?? 'ltr' }}" class="h-full overflow-hidden" data-theme="light" data-admin-theme="default">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="csrf-token" content="{{ csrf_token() }}">

        <title>{{ $title }} - {{ $brandName }}</title>
        @if ($favicon)
            <link rel="icon" href="{{ asset('storage/' . $favicon) }}">
        @endif

        <link rel="preconnect" href="https://fonts.googleapis.com">
        <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
        <link href="https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:ital,wght@0,200..800;1,200..800&display=swap" rel="stylesheet">
        @vite(['resources/css/app.css', 'resources/js/app.js'])
        @include('partials.extensions-head')
        <script>if(localStorage.getItem('sidebar-collapsed')==='true')document.documentElement.setAttribute('data-sidebar-collapsed','true');</script>
    </head>
    <body class="h-full overflow-hidden font-sans text-ink bg-surface antialiased">
        <div class="fixed inset-0 bg-grid opacity-30 pointer-events-none"></div>

        <div class="relative flex h-full min-h-0">
            <aside class="admin-sidebar fixed inset-y-0 left-0 z-40 w-72 -translate-x-full overflow-y-auto overscroll-contain border-r border-border/70 bg-surface/95 backdrop-blur transition-all duration-300 lg:static lg:translate-x-0">
                <div class="px-4 pt-2 pb-1 flex items-center justify-between">
                    <a href="{{ route('admin.dashboard') }}" class="flex items-center gap-3 sidebar-brand">
                        @if ($adminLogo)
                            <img src="{{ asset('storage/' . $adminLogo) }}" alt="{{ $brandName }}" class="h-12 w-auto object-contain">
                        @else
                            <div class="flex h-9 w-9 shrink-0 items-center justify-center rounded-xl bg-accent text-white shadow-soft">
                                <svg viewBox="0 0 24 24" class="h-5 w-5" fill="none" stroke="currentColor" stroke-width="1.8" stroke-linecap="round" stroke-linejoin="round">
                                    <circle cx="12" cy="12" r="8"></circle>
                                    <circle cx="12" cy="12" r="3"></circle>
                                    <path d="M12 4l3.5 6h-7l3.5-6z"></path>
                                </svg>
                            </div>
                            <span class="text-lg font-bold tracking-tight text-ink truncate sidebar-label">{{ $brandName }}</span>
                        @endif
                    </a>
                    <button type="button" class="hidden lg:flex h-7 w-7 items-center justify-center rounded-lg text-muted hover:text-ink hover:bg-surface-2/80 transition" data-sidebar-collapse-toggle aria-label="{{ __('Toggle sidebar') }}">
                        <svg viewBox="0 0 24 24" class="h-4 w-4 sidebar-collapse-icon" fill="none" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round">
                            <rect x="3" y="3" width="18" height="18" rx="2"/>
                            <path d="M9 3v18"/>
                        </svg>
                    </button>
                </div>

                <nav class="px-4 pb-6">
                    @php $isAdmin = auth()->user()->hasRole(['Super Admin', 'Admin']); @endphp

                    {{-- Main --}}
                    <div>
                        <div class="mt-3 space-y-1">
                            <a href="{{ route('admin.dashboard') }}" @class(['nav-item', 'nav-item-active' => request()->routeIs('admin.dashboard')])>
                                <svg viewBox="0 0 24 24" class="h-4 w-4" fill="none" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round">
                                    <rect x="3" y="3" width="7" height="7" rx="1.5"></rect>
                                    <rect x="14" y="3" width="7" height="7" rx="1.5"></rect>
                                    <rect x="3" y="14" width="7" height="7" rx="1.5"></rect>
                                    <rect x="14" y="14" width="7" height="7" rx="1.5"></rect>
                                </svg>
                                <span>{{ __('Dashboard') }}</span>
                            </a>
                            @can('viewAny', \App\Models\Event::class)
                            <a href="{{ route('admin.events.index') }}" @class(['nav-item', 'nav-item-active' => request()->routeIs('admin.events.*')])>
                                <svg viewBox="0 0 24 24" class="h-4 w-4" fill="none" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round">
                                    <rect x="3" y="5" width="18" height="16" rx="2"></rect>
                                    <path d="M16 3v4"></path>
                                    <path d="M8 3v4"></path>
                                    <path d="M3 11h18"></path>
                                </svg>
                                <span>{{ __('Events') }}</span>
                            </a>
                            @endcan
                            @if(!$isAdmin)
                            <a href="{{ route('admin.usage.index') }}" @class(['nav-item', 'nav-item-active' => request()->routeIs('admin.usage.*')])>
                                <svg viewBox="0 0 24 24" class="h-4 w-4" fill="none" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round">
                                    <path d="M12 20v-6M6 20V10M18 20V4"></path>
                                </svg>
                                <span>{{ __('Plan Usage') }}</span>
                            </a>
                            @endif
                            <a href="{{ route('admin.orders.index') }}" @class(['nav-item', 'nav-item-active' => request()->routeIs('admin.orders.*')])>
                                <svg viewBox="0 0 24 24" class="h-4 w-4" fill="none" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round">
                                    <path d="M16 4h2a2 2 0 0 1 2 2v14a2 2 0 0 1-2 2H6a2 2 0 0 1-2-2V6a2 2 0 0 1 2-2h2"></path>
                                    <rect x="8" y="2" width="8" height="4" rx="1" ry="1"></rect>
                                    <path d="M9 14h6"></path>
                                    <path d="M9 18h6"></path>
                                    <path d="M9 10h6"></path>
                                </svg>
                                <span>{{ __('Orders') }}</span>
                            </a>
                        </div>
                    </div>

                    {{-- Support (users with support-ticket permissions) --}}
                    @if(!$isAdmin)
                    @can('viewAny', \App\Models\SupportTicket::class)
                    <div>
                        <p class="px-3 text-[11px] font-semibold uppercase tracking-widest text-muted/60">{{ __('Support') }}</p>
                        <div class="mt-2 space-y-1">
                            <a href="{{ route('admin.support-tickets.index') }}" @class(['nav-item', 'nav-item-active' => request()->routeIs('admin.support-tickets.*')])>
                                <svg viewBox="0 0 24 24" class="h-4 w-4" fill="none" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round">
                                    <path d="M21 15a2 2 0 0 1-2 2H7l-4 4V5a2 2 0 0 1 2-2h14a2 2 0 0 1 2 2z"></path>
                                </svg>
                                <span>{{ __('Support Tickets') }}</span>
                            </a>
                        </div>
                    </div>
                    @endcan
                    @endif

                    {{-- Users --}}
                    @canany('viewAny', [\App\Models\User::class, \App\Models\UserDeleteRequest::class, \Spatie\Permission\Models\Role::class])
                    <div>
                        <p class="px-3 text-[11px] font-semibold uppercase tracking-widest text-muted/60">{{ __('Users') }}</p>
                        <div class="mt-2 space-y-1">
                            @can('viewAny', \App\Models\User::class)
                            <a href="{{ route('admin.users.index') }}" @class(['nav-item', 'nav-item-active' => request()->routeIs('admin.users.*')])>
                                <svg viewBox="0 0 24 24" class="h-4 w-4" fill="none" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round">
                                    <circle cx="9" cy="8" r="3"></circle>
                                    <path d="M3 19c1.8-3 4.8-4.5 6-4.5s4.2 1.5 6 4.5"></path>
                                    <path d="M15.5 11a3 3 0 1 0 0-6"></path>
                                    <path d="M18 19c.6-1.1 1.6-2.2 3-3"></path>
                                </svg>
                                <span>{{ __('Users') }}</span>
                            </a>
                            @endcan
                            @can('viewAny', \App\Models\UserDeleteRequest::class)
                            <a href="{{ route('admin.user-delete-requests.index') }}" @class(['nav-item', 'nav-item-active' => request()->routeIs('admin.user-delete-requests.*')])>
                                <svg viewBox="0 0 24 24" class="h-4 w-4" fill="none" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round">
                                    <polyline points="3 6 5 6 21 6"></polyline>
                                    <path d="M19 6v14a2 2 0 0 1-2 2H7a2 2 0 0 1-2-2V6"></path>
                                    <path d="M10 11v6"></path>
                                    <path d="M14 11v6"></path>
                                    <path d="M9 6V4a1 1 0 0 1 1-1h4a1 1 0 0 1 1 1v2"></path>
                                </svg>
                                <span>{{ __('Delete Requests') }}</span>
                            </a>
                            @endcan
                            @php
                                $canViewRoles = \Illuminate\Support\Facades\Gate::allows('viewAny', \Spatie\Permission\Models\Role::class);
                                $canViewPermissions = \Illuminate\Support\Facades\Gate::allows('viewAny', \Spatie\Permission\Models\Permission::class);
                            @endphp
                            @if ($canViewRoles || $canViewPermissions)
                            <a href="{{ route('admin.roles.index') }}" @class(['nav-item', 'nav-item-active' => request()->routeIs('admin.roles.*', 'admin.permissions.*')])>
                                <svg viewBox="0 0 24 24" class="h-4 w-4" fill="none" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round">
                                    <path d="M12 3l7 4v5c0 4.2-3 7.9-7 9-4-1.1-7-4.8-7-9V7l7-4z"></path>
                                    <path d="M9 12l2 2 4-4"></path>
                                </svg>
                                <span>{{ __('Roles & Permissions') }}</span>
                            </a>
                            @endif
                        </div>
                    </div>
                    @endcanany

                    {{-- Business --}}
                    @canany('viewAny', [\App\Models\Plan::class, \App\Models\Coupon::class, \App\Models\PaymentGateway::class, \App\Models\Report::class])
                    <div>
                        <p class="px-3 text-[11px] font-semibold uppercase tracking-widest text-muted/60">{{ __('Business') }}</p>
                        <div class="mt-2 space-y-1">
                            @can('viewAny', \App\Models\Plan::class)
                            <a href="{{ route('admin.plans.index') }}" @class(['nav-item', 'nav-item-active' => request()->routeIs('admin.plans.*')])>
                                <svg viewBox="0 0 24 24" class="h-4 w-4" fill="none" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round">
                                    <path d="M7 7h10"></path>
                                    <path d="M7 12h10"></path>
                                    <path d="M7 17h6"></path>
                                    <rect x="4" y="3" width="16" height="18" rx="2"></rect>
                                </svg>
                                <span>{{ __('Plans') }}</span>
                            </a>
                            @endcan
                            @can('viewAny', \App\Models\Coupon::class)
                            <a href="{{ route('admin.coupons.index') }}" @class(['nav-item', 'nav-item-active' => request()->routeIs('admin.coupons.*')])>
                                <svg viewBox="0 0 24 24" class="h-4 w-4" fill="none" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round">
                                    <path d="M4 4h16v6a2 2 0 0 0 0 4v6H4v-6a2 2 0 0 0 0-4V4z"></path>
                                    <path d="M9 8h6"></path>
                                    <path d="M9 16h6"></path>
                                </svg>
                                <span>{{ __('Coupons') }}</span>
                            </a>
                            @endcan
                            @can('viewAny', \App\Models\PaymentGateway::class)
                            <a href="{{ route('admin.payment-gateways.index') }}" @class(['nav-item', 'nav-item-active' => request()->routeIs('admin.payment-gateways.*')])>
                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" class="h-4 w-4" fill="none" stroke="currentColor" stroke-width="1.8" stroke-linecap="round" stroke-linejoin="round"><rect width="20" height="14" x="2" y="5" rx="2"/><line x1="2" x2="22" y1="10" y2="10"/></svg>
                                <span>{{ __('Payment Gateways') }}</span>
                            </a>
                            @endcan
                            @can('viewAny', \App\Models\Report::class)
                            <a href="{{ route('admin.reports.index') }}" @class(['nav-item', 'nav-item-active' => request()->routeIs('admin.reports.*')])>
                                <svg viewBox="0 0 24 24" class="h-4 w-4" fill="none" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round">
                                    <path d="M3 3v18h18"></path>
                                    <path d="M7 14l4-4 3 3 5-6"></path>
                                </svg>
                                <span>{{ __('Reports') }}</span>
                            </a>
                            <a href="{{ route('admin.financial-report.index') }}" @class(['nav-item', 'nav-item-active' => request()->routeIs('admin.financial-report.*')])>
                                <svg viewBox="0 0 24 24" class="h-4 w-4" fill="none" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round">
                                    <path d="M12 2v20M17 5H9.5a3.5 3.5 0 0 0 0 7h5a3.5 3.5 0 0 1 0 7H6"></path>
                                </svg>
                                <span>{{ __('P&L Book') }}</span>
                            </a>
                            @endcan
                            @canany('viewAny', [\App\Models\Plan::class, \App\Models\Coupon::class, \App\Models\Report::class, \App\Models\NewsletterSubscriber::class])
                            <a href="{{ route('admin.operations.index') }}" @class(['nav-item', 'nav-item-active' => request()->routeIs('admin.operations.*', 'admin.support-tickets.*', 'admin.ticket-assignments.*', 'admin.faqs.*', 'admin.testimonials.*', 'admin.fact-stats.*', 'admin.blog-posts.*', 'admin.blog-categories.*', 'admin.countries.*', 'admin.states.*', 'admin.cities.*', 'admin.currencies.*', 'admin.languages.*', 'admin.newsletter-subscribers.*')])>
                                <svg viewBox="0 0 24 24" class="h-4 w-4" fill="none" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round">
                                    <rect x="3" y="3" width="7" height="7" rx="1.5"></rect>
                                    <rect x="14" y="3" width="7" height="7" rx="1.5"></rect>
                                    <rect x="3" y="14" width="7" height="7" rx="1.5"></rect>
                                    <path d="M17.5 14v7"></path>
                                    <path d="M14 17.5h7"></path>
                                </svg>
                                <span>{{ __('Operations') }}</span>
                            </a>
                            @endcanany
                        </div>
                    </div>
                    @endcanany

                    {{-- System --}}
                    @canany('viewAny', [\App\Models\SystemSetting::class, \App\Models\SecuritySetting::class, \App\Models\ActivityLog::class])
                    <div>
                        <p class="px-3 text-[11px] font-semibold uppercase tracking-widest text-muted/60">{{ __('System') }}</p>
                        <div class="mt-2 space-y-1">
                            @php
                                $systemSettingsOpen = request()->routeIs('admin.system-settings.*', 'admin.security-settings.*', 'admin.themes.*');
                            @endphp
                            <div x-data="{ open: {{ $systemSettingsOpen ? 'true' : 'false' }} }">
                                <button type="button" @click="open = !open" @class(['nav-item w-full justify-between', 'nav-item-active' => $systemSettingsOpen])>
                                    <span class="flex items-center gap-3">
                                        <svg viewBox="0 0 24 24" class="h-4 w-4" fill="none" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round">
                                            <circle cx="12" cy="12" r="3"></circle>
                                            <path d="M19.4 15a1.65 1.65 0 0 0 .33 1.82l.06.06a2 2 0 0 1-2.83 2.83l-.06-.06a1.65 1.65 0 0 0-1.82-.33 1.65 1.65 0 0 0-1 1.51V21a2 2 0 0 1-4 0v-.09A1.65 1.65 0 0 0 9 19.4a1.65 1.65 0 0 0-1.82.33l-.06.06a2 2 0 0 1-2.83-2.83l.06-.06A1.65 1.65 0 0 0 4.68 15a1.65 1.65 0 0 0-1.51-1H3a2 2 0 0 1 0-4h.09A1.65 1.65 0 0 0 4.6 9a1.65 1.65 0 0 0-.33-1.82l-.06-.06a2 2 0 0 1 2.83-2.83l.06.06A1.65 1.65 0 0 0 9 4.68a1.65 1.65 0 0 0 1-1.51V3a2 2 0 0 1 4 0v.09a1.65 1.65 0 0 0 1 1.51 1.65 1.65 0 0 0 1.82-.33l.06-.06a2 2 0 0 1 2.83 2.83l-.06.06A1.65 1.65 0 0 0 19.4 9a1.65 1.65 0 0 0 1.51 1H21a2 2 0 0 1 0 4h-.09a1.65 1.65 0 0 0-1.51 1z"></path>
                                        </svg>
                                        <span>{{ __('System Settings') }}</span>
                                    </span>
                                    <svg viewBox="0 0 24 24" class="h-4 w-4 transition-transform" :class="open ? 'rotate-90' : ''" fill="none" stroke="currentColor" stroke-width="1.6"><path d="M9 18l6-6-6-6"/></svg>
                                </button>
                                <div x-show="open" x-collapse class="ml-7 mt-1 space-y-1 border-l border-border/50 pl-3">
                                    @can('viewAny', \App\Models\SystemSetting::class)
                                    <a href="{{ route('admin.system-settings.index') }}" @class(['nav-item text-sm', 'nav-item-active' => request()->routeIs('admin.system-settings.*')])>
                                        <span>{{ __('System Config') }}</span>
                                    </a>
                                    @endcan
                                    @can('viewAny', \App\Models\SecuritySetting::class)
                                    <a href="{{ route('admin.security-settings.index') }}" @class(['nav-item text-sm', 'nav-item-active' => request()->routeIs('admin.security-settings.*')])>
                                        <span>{{ __('Security Settings') }}</span>
                                    </a>
                                    @endcan
                                    @can('viewAny', \App\Models\SystemSetting::class)
                                    <a href="{{ route('admin.themes.index') }}" @class(['nav-item text-sm', 'nav-item-active' => request()->routeIs('admin.themes.*')])>
                                        <span>{{ __('Theme') }}</span>
                                    </a>
                                    @endcan
                                </div>
                            </div>
                            <a href="{{ route('admin.system-hub.index') }}" @class(['nav-item', 'nav-item-active' => request()->routeIs('admin.system-hub.*', 'admin.pages.*', 'admin.activity-logs.*', 'admin.system-logs.*', 'admin.security-audit-logs.*', 'admin.blocked-ips.*', 'admin.blocked-locations.*', 'admin.extensions.*')])>
                                <svg viewBox="0 0 24 24" class="h-4 w-4" fill="none" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round">
                                    <rect x="3" y="3" width="7" height="7" rx="1.5"></rect>
                                    <rect x="14" y="3" width="7" height="7" rx="1.5"></rect>
                                    <rect x="3" y="14" width="7" height="7" rx="1.5"></rect>
                                    <path d="M17.5 14v7"></path>
                                    <path d="M14 17.5h7"></path>
                                </svg>
                                <span>{{ __('System Hub') }}</span>
                            </a>
                        </div>
                    </div>
                    @endcanany

                    {{-- Sidebar info panel (non-admin users) --}}
                    @if(!$isAdmin)
                    @php
                        $currentUser = auth()->user();
                        $currentPlan = $currentUser->plan;
                        $userEventsCount = \App\Models\Event::where('created_by', $currentUser->id)->count();
                        $userActiveEvents = \App\Models\Event::where('created_by', $currentUser->id)->where('is_active', true)->count();
                        $userMediaCount = \App\Models\EventMedia::whereHas('event', fn($q) => $q->where('created_by', $currentUser->id))->count();
                    @endphp
                    <div class="mt-6 space-y-3 sidebar-info-panel">
                        {{-- Quick Stats --}}
                        <div class="mx-1 rounded-xl border border-border/50 overflow-hidden">
                            <div class="px-3.5 py-2 bg-muted/40 border-b border-border/40">
                                <p class="text-[10px] font-semibold uppercase tracking-widest text-muted/80">{{ __('Overview') }}</p>
                            </div>
                            <div class="grid grid-cols-3 divide-x divide-border/40 bg-surface">
                                <div class="py-3 text-center">
                                    <p class="text-base font-bold text-ink leading-none">{{ $userEventsCount }}</p>
                                    <p class="text-[9px] text-muted mt-1 font-medium">{{ __('Events') }}</p>
                                </div>
                                <div class="py-3 text-center">
                                    <p class="text-base font-bold text-primary leading-none">{{ $userActiveEvents }}</p>
                                    <p class="text-[9px] text-muted mt-1 font-medium">{{ __('Active') }}</p>
                                </div>
                                <div class="py-3 text-center">
                                    <p class="text-base font-bold text-ink leading-none">{{ $userMediaCount }}</p>
                                    <p class="text-[9px] text-muted mt-1 font-medium">{{ __('Photos') }}</p>
                                </div>
                            </div>
                        </div>

                        {{-- Current Plan --}}
                        <div class="mx-1 rounded-xl border border-primary/20 overflow-hidden">
                            <div class="px-3.5 py-2 bg-primary/5 border-b border-primary/15 flex items-center justify-between">
                                <p class="text-[10px] font-semibold uppercase tracking-widest text-primary/80">{{ __('Current Plan') }}</p>
                                <span class="text-[9px] font-bold uppercase tracking-wider px-2 py-0.5 rounded-full bg-primary/10 text-primary border border-primary/20">{{ $currentPlan?->name ?? __('Free') }}</span>
                            </div>
                            <div class="px-3.5 py-2.5 bg-surface space-y-2">
                                <div class="flex justify-between items-center text-[11px]">
                                    <span class="text-muted flex items-center gap-1.5">
                                        <svg viewBox="0 0 24 24" class="h-3 w-3" fill="none" stroke="currentColor" stroke-width="1.8" stroke-linecap="round" stroke-linejoin="round"><rect x="3" y="5" width="18" height="16" rx="2"/><path d="M16 3v4"/><path d="M8 3v4"/><path d="M3 11h18"/></svg>
                                        {{ __('Events') }}
                                    </span>
                                    <span class="font-semibold text-ink text-[11px]">{{ $currentPlan?->max_events === -1 ? __('Unlimited') : ($currentPlan?->max_events ?? 0) }}</span>
                                </div>
                                <div class="flex justify-between items-center text-[11px]">
                                    <span class="text-muted flex items-center gap-1.5">
                                        <svg viewBox="0 0 24 24" class="h-3 w-3" fill="none" stroke="currentColor" stroke-width="1.8" stroke-linecap="round" stroke-linejoin="round"><path d="M21 15v4a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2v-4"/><polyline points="17 8 12 3 7 8"/><line x1="12" x2="12" y1="3" y2="15"/></svg>
                                        {{ __('Storage') }}
                                    </span>
                                    <span class="font-semibold text-ink text-[11px]">{{ $currentPlan?->max_storage === -1 ? __('Unlimited') : (($currentPlan?->max_storage ?? 0) . ' MB') }}</span>
                                </div>
                                @if($currentPlan?->has_watermark)
                                <div class="flex justify-between items-center text-[11px]">
                                    <span class="text-muted flex items-center gap-1.5">
                                        <svg viewBox="0 0 24 24" class="h-3 w-3" fill="none" stroke="currentColor" stroke-width="1.8" stroke-linecap="round" stroke-linejoin="round"><path d="M12 22s8-4 8-10V5l-8-3-8 3v7c0 6 8 10 8 10"/></svg>
                                        {{ __('Watermark') }}
                                    </span>
                                    <span class="text-[9px] font-bold uppercase px-1.5 py-0.5 rounded-full bg-green-500/10 text-green-600">{{ __('Enabled') }}</span>
                                </div>
                                @endif
                            </div>
                        </div>

                        {{-- Getting Started --}}
                        <div class="mx-1 rounded-xl border border-border/40 overflow-hidden">
                            <div class="px-3.5 py-2 bg-muted/30 border-b border-border/40">
                                <p class="text-[10px] font-semibold uppercase tracking-widest text-muted/80">{{ __('Getting Started') }}</p>
                            </div>
                            <div class="px-3.5 py-2.5 bg-surface">
                                <ul class="space-y-2">
                                    <li class="flex items-start gap-2.5 text-[11px] text-muted leading-relaxed">
                                        <span class="flex h-4 w-4 shrink-0 items-center justify-center rounded-full bg-primary/10 text-[8px] font-bold text-primary mt-0.5">1</span>
                                        <span>{{ __('Create your first event to start organizing photos.') }}</span>
                                    </li>
                                    <li class="flex items-start gap-2.5 text-[11px] text-muted leading-relaxed">
                                        <span class="flex h-4 w-4 shrink-0 items-center justify-center rounded-full bg-primary/10 text-[8px] font-bold text-primary mt-0.5">2</span>
                                        <span>{{ __('Upload photos via drag & drop, ZIP, or FTP.') }}</span>
                                    </li>
                                    <li class="flex items-start gap-2.5 text-[11px] text-muted leading-relaxed">
                                        <span class="flex h-4 w-4 shrink-0 items-center justify-center rounded-full bg-primary/10 text-[8px] font-bold text-primary mt-0.5">3</span>
                                        <span>{{ __('Share event links with your clients securely.') }}</span>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    @endif
                </nav>

                {{-- Brand icon pinned to bottom when sidebar is collapsed --}}
                <div class="sidebar-brand-bottom hidden">
                    <a href="{{ route('admin.dashboard') }}">
                        @if ($adminLogo)
                            <img src="{{ asset('storage/' . $adminLogo) }}" alt="{{ $brandName }}" class="h-8 w-auto object-contain">
                        @else
                            <div class="flex h-9 w-9 shrink-0 items-center justify-center rounded-xl bg-accent text-white shadow-soft">
                                <svg viewBox="0 0 24 24" class="h-5 w-5" fill="none" stroke="currentColor" stroke-width="1.8" stroke-linecap="round" stroke-linejoin="round">
                                    <circle cx="12" cy="12" r="8"></circle>
                                    <circle cx="12" cy="12" r="3"></circle>
                                    <path d="M12 4l3.5 6h-7l3.5-6z"></path>
                                </svg>
                            </div>
                        @endif
                    </a>
                </div>
            </aside>

            <div class="flex h-full min-h-0 flex-1 flex-col overflow-y-auto overscroll-contain" data-admin-scroll>
                <header class="sticky top-0 z-30 border-b border-border/60 bg-surface/90 backdrop-blur">
                    <div class="flex items-center justify-between gap-4 px-4 py-4 lg:px-6">
                        <div class="flex min-w-0 flex-1 items-center gap-3">
                            <button type="button" class="icon-button shrink-0 lg:hidden" data-sidebar-toggle aria-label="{{ __('Toggle sidebar') }}">
                                <svg viewBox="0 0 24 24" class="h-5 w-5" fill="none" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round">
                                    <path d="M4 6h16"></path>
                                    <path d="M4 12h16"></path>
                                    <path d="M4 18h16"></path>
                                </svg>
                            </button>
                            <div class="min-w-0 flex-1">
                                <p class="panel-heading hidden sm:block">{{ __('Admin Console') }}</p>
                                <h1 class="truncate text-lg font-semibold tracking-tight sm:mt-0.5 sm:text-2xl" title="{{ $title }}">{{ $title }}</h1>
                                @if ($subtitle)
                                    <p class="mt-0.5 hidden truncate text-xs text-muted sm:block sm:text-sm" title="{{ $subtitle }}">{{ $subtitle }}</p>
                                @endif
                            </div>
                        </div>

                        <div class="flex shrink-0 items-center gap-2 sm:gap-3">
                            <div class="relative hidden items-center gap-2 rounded-xl border border-border bg-surface-2/80 px-4 py-2 text-sm text-muted md:flex" data-admin-search data-admin-search-endpoint="{{ route('admin.search') }}">
                                <svg viewBox="0 0 24 24" class="h-4 w-4" fill="none" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round">
                                    <circle cx="11" cy="11" r="7"></circle>
                                    <path d="M20 20l-3.5-3.5"></path>
                                </svg>
                                <input class="w-64 border-0 bg-transparent text-sm text-ink placeholder:text-muted/70 outline-none focus:outline-none focus:ring-0" type="search" placeholder="{{ __('Search people, events, uploads') }}" autocomplete="off" data-admin-search-input />
                                <div class="absolute left-0 right-0 top-full z-40 mt-2 hidden max-h-80 overflow-y-auto rounded-2xl border border-border bg-surface-2/95 py-2 shadow-soft" data-admin-search-results></div>
                            </div>

                            @if ($multiLanguageEnabled && $languageOptions->isNotEmpty())
                                <form method="POST" action="{{ route('admin.locale.update') }}">
                                    @csrf
                                    <select name="locale" aria-label="{{ __('Select language') }}" class="rounded-xl border border-border bg-surface-2/80 px-2 py-1.5 text-xs text-ink focus:border-brand/40 focus:outline-none sm:px-3 sm:py-2 sm:text-sm" onchange="this.form.submit()">
                                        @foreach ($languageOptions as $language)
                                            <option value="{{ $language->code }}" @selected($currentLocale === $language->code)>{{ $language->native_name ?: $language->name }}</option>
                                        @endforeach
                                    </select>
                                </form>
                            @endif

                            <button type="button" class="icon-button hidden sm:inline-flex" data-fullscreen-toggle aria-label="{{ __('Toggle fullscreen') }}">
                                <svg viewBox="0 0 24 24" class="h-5 w-5" fill="none" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" data-fullscreen-icon="enter">
                                    <path d="M9 3H5v4"></path>
                                    <path d="M15 3h4v4"></path>
                                    <path d="M9 21H5v-4"></path>
                                    <path d="M15 21h4v-4"></path>
                                </svg>
                                <svg viewBox="0 0 24 24" class="h-5 w-5 hidden" fill="none" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" data-fullscreen-icon="exit">
                                    <path d="M9 9H5V5"></path>
                                    <path d="M15 9h4V5"></path>
                                    <path d="M9 15H5v4"></path>
                                    <path d="M15 15h4v4"></path>
                                </svg>
                            </button>

                            <button type="button" class="icon-button hidden sm:inline-flex" data-theme-toggle aria-label="{{ __('Toggle theme') }}">
                                <svg viewBox="0 0 24 24" class="h-5 w-5" fill="none" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" data-theme-icon="sun">
                                    <circle cx="12" cy="12" r="4"></circle>
                                    <path d="M12 3v2"></path>
                                    <path d="M12 19v2"></path>
                                    <path d="M5 5l1.5 1.5"></path>
                                    <path d="M17.5 17.5L19 19"></path>
                                    <path d="M3 12h2"></path>
                                    <path d="M19 12h2"></path>
                                    <path d="M5 19l1.5-1.5"></path>
                                    <path d="M17.5 6.5L19 5"></path>
                                </svg>
                                <svg viewBox="0 0 24 24" class="h-5 w-5 hidden" fill="none" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" data-theme-icon="moon">
                                    <path d="M21 12.5A8.5 8.5 0 1 1 11.5 3 7 7 0 0 0 21 12.5z"></path>
                                </svg>
                            </button>

                            @php
                                $notificationChannel = '';
                                if (auth()->check()) {
                                    $notificationChannel = \Illuminate\Support\Facades\Gate::allows('viewAny', \App\Models\ActivityLog::class)
                                        ? 'admin.notifications'
                                        : 'user.' . auth()->id() . '.notifications';
                                }
                            @endphp
                            <div data-notification-scope data-notification-endpoint="{{ route('admin.notifications') }}" data-notification-channel="{{ $notificationChannel }}">
                                <x-dropdown align="right" width="w-[30rem] max-w-[92vw]" content-classes="py-3 bg-surface-2/95">
                                    <x-slot name="trigger">
                                        <button type="button" class="icon-button relative" data-notification-toggle aria-label="{{ __('View notifications') }}">
                                            <svg viewBox="0 0 24 24" class="h-5 w-5" fill="none" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round">
                                                <path d="M6 9a6 6 0 0 1 12 0c0 6 2 7 2 7H4s2-1 2-7"></path>
                                                <path d="M9.5 19a2.5 2.5 0 0 0 5 0"></path>
                                            </svg>
                                            <span class="absolute -top-1 -right-1 hidden h-5 min-w-[0.25rem] items-center justify-center rounded-full bg-danger px-1 text-[10px] font-semibold text-white" data-notification-count></span>
                                        </button>
                                    </x-slot>

                                    <x-slot name="content">
                                        <div class="flex items-center justify-between px-4 pb-2">
                                            <p class="text-xs font-semibold uppercase tracking-widest text-muted">{{ __('Live Notifications') }}</p>
                                            @can('viewAny', \App\Models\ActivityLog::class)
                                                <a href="{{ route('admin.activity-logs.index') }}" class="text-xs font-semibold text-brand/80 transition hover:text-brand">{{ __('View all') }}</a>
                                            @else
                                                <a href="{{ route('admin.activity-logs.index', ['user' => auth()->id()]) }}" class="text-xs font-semibold text-brand/80 transition hover:text-brand">{{ __('View all') }}</a>
                                            @endcan
                                        </div>
                                        <div class="max-h-80 overflow-y-auto" data-notification-list>
                                            <p class="px-4 py-3 text-sm text-muted" data-notification-empty>{{ __('No notifications yet.') }}</p>
                                        </div>
                                    </x-slot>
                                </x-dropdown>
                            </div>

                            <x-dropdown align="right" width="w-48 sm:w-full" content-classes="py-2 bg-surface-2/95">
                                <x-slot name="trigger">
                                    <button type="button" class="flex items-center gap-2 rounded-xl border border-border bg-surface-2/90 px-2 py-1.5 text-sm text-ink/80 transition hover:border-brand/40 sm:gap-3 sm:px-3 sm:py-2">
                                        <span class="flex h-8 w-8 items-center justify-center rounded-full bg-brand/20 text-brand text-sm sm:h-9 sm:w-9">
                                            {{ strtoupper(substr(auth()->user()?->name ?? 'A', 0, 1)) }}
                                        </span>
                                        <span class="hidden text-left md:block">
                                            <div class="flex items-center gap-2">
                                                <span class="block max-w-[10rem] truncate text-sm font-semibold text-ink">{{ auth()->user()?->name ?? __('Admin') }}</span>
                                                <span class="inline-flex items-center rounded-md bg-slate-500/10 px-1.5 py-0.5 text-[10px] font-medium text-slate-600 ring-1 ring-inset ring-slate-500/20">
                                                    {{ auth()->user()->roles->first()?->name ?? __('User') }}
                                                </span>
                                            </div>
                                            <div class="flex items-center gap-1.5 mt-0.5">
                                                @if(!auth()->user()->hasRole(['Super Admin', 'Admin']))
                                                    <span class="inline-flex items-center rounded-md bg-brand/10 px-1.5 py-0.5 text-[10px] font-medium text-brand ring-1 ring-inset ring-brand/20">
                                                        {{ auth()->user()->plan?->name ?? __('No Plan') }}
                                                    </span>
                                                @endif
                                                <span class="block max-w-[12rem] truncate text-xs text-muted">{{ auth()->user()?->email ?? 'admin@studio.local' }}</span>
                                            </div>
                                        </span>
                                </button>
                                </x-slot>

                                <x-slot name="content">
                                    <div class="px-4 pb-2">
                                        <p class="text-xs font-semibold uppercase tracking-widest text-muted">{{ __('Account') }}</p>
                                    </div>
                                    <x-dropdown-link :href="route('profile.edit')">{{ __('Profile') }}</x-dropdown-link>
                                    <div class="my-2 border-t border-border/60"></div>
                                    <form method="POST" action="{{ route('logout') }}">
                                        @csrf
                                        <x-dropdown-link :href="route('logout')" onclick="event.preventDefault(); this.closest('form').submit();">
                                            {{ __('Log out') }}
                                        </x-dropdown-link>
                                    </form>
                                </x-slot>
                            </x-dropdown>
                        </div>
                    </div>
                </header>

                <main class="flex-1 min-h-0 px-4 py-6 lg:px-8">
                    {{ $slot }}
                </main>
            </div>
        </div>

        <div class="admin-overlay fixed inset-0 z-30 bg-ink/40 opacity-0 pointer-events-none transition lg:hidden" data-sidebar-overlay></div>
        @include('partials.gdpr-banner')
        @if (session('status') || session('error'))
            <div class="fixed bottom-6 right-6 z-50">
                <div
                    x-data="{ show: true }"
                    x-init="setTimeout(() => show = false, 3200)"
                    x-show="show"
                    x-transition
                    class="panel flex items-start gap-3 px-4 py-3 text-sm"
                >
                    <span class="mt-1 h-2.5 w-2.5 rounded-full {{ session('error') ? 'bg-danger' : 'bg-success' }}"></span>
                    <div>
                        <p class="font-semibold text-ink">{{ session('error') ? __('Action blocked') : __('Success') }}</p>
                        <p class="text-muted">{{ session('error') ?? session('status') }}</p>
                    </div>
                </div>
            </div>
        @endif
        @if (! empty($siteSettings['right_click_disable']))
            <script>
                document.addEventListener('contextmenu', function (event) {
                    event.preventDefault();
                });
            </script>
        @endif
        @stack('scripts')
    </body>
</html>
