<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}" dir="{{ $languageDirection ?? 'ltr' }}" class="scroll-smooth">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">

    @php
        $brandName = trim((string) ($siteSettings['site_name'] ?? ''));
        $brandName = $brandName !== '' ? $brandName : config('app.name', 'SnapNest');
        $favicon = $siteSettings['favicon'] ?? null;
    @endphp

    <title>@yield('title', $brandName)</title>
    <meta name="description" content="@yield('meta_description', __('The smartest way for photographers to share, sell, and manage event galleries. AI Face Recognition, cloud storage, and instant delivery.'))">

    @if ($favicon)
        <link rel="icon" href="{{ asset('storage/' . $favicon) }}">
    @endif

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:ital,wght@0,200..800;1,200..800&display=swap" rel="stylesheet">

    <!-- Styles -->
    @vite(['resources/css/app.css', 'resources/css/frontend.css', 'resources/js/app.js'])
    @include('partials.extensions-head')

    @if(!empty($pwaSettings['enabled']))
        @laravelPWA
    @endif

    <style>
        :root {
            --font-sans: 'Plus Jakarta Sans', sans-serif;
        }
    </style>
</head>
<body class="min-h-screen bg-background font-sans antialiased text-foreground">
    <div class="flex min-h-screen flex-col">
        @hasSection('hide_header')
        @else
            @include('components.frontend.header')
        @endif

        <main class="flex-1">
            @yield('content')
        </main>

        @hasSection('hide_footer')
        @else
            @include('components.frontend.footer')
        @endif
    </div>
    @include('partials.cookie-consent')
    @include('partials.pwa-install-prompt')
    @stack('scripts')
</body>
</html>
