@php
    $brandName = trim((string) ($siteSettings['site_name'] ?? ''));
    $brandName = $brandName !== '' ? $brandName : config('app.name', 'SnapNest');
    $favicon = $siteSettings['favicon'] ?? null;
@endphp

<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="csrf-token" content="{{ csrf_token() }}">

        <title>{{ $brandName }}</title>
        @if ($favicon)
            <link rel="icon" href="{{ asset('storage/' . $favicon) }}">
        @endif

        <link rel="preconnect" href="https://fonts.googleapis.com">
        <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
        <link href="https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:ital,wght@0,200..800;1,200..800&display=swap" rel="stylesheet">

        @vite(['resources/css/app.css', 'resources/js/app.js'])
        @include('partials.extensions-head')
    </head>
    <body class="font-sans text-ink antialiased">
        <div class="fixed inset-0 bg-grid opacity-20 pointer-events-none"></div>
        <div class="relative min-h-screen px-6 py-10 lg:px-12">
            <div class="mx-auto flex w-full max-w-6xl flex-col gap-10 lg:flex-row lg:items-center">
                <div class="flex-1">
                    <div class="inline-flex items-center gap-2 rounded-full border border-border bg-surface-2/80 px-4 py-2 text-xs font-semibold uppercase tracking-[0.2em] text-muted">
                        {{ __('Studio Access') }}
                    </div>
                    <h1 class="mt-6 text-4xl font-semibold leading-tight">
                        {{ __('Command center for high volume event photography.') }}
                    </h1>
                    <p class="mt-4 text-base text-muted">
                        {{ __('One login, multiple roles. From photographers to support, keep delivery, uploads, and approvals in a single flow.') }}
                    </p>
                    <div class="mt-8 grid gap-3 text-sm text-muted sm:grid-cols-2">
                        <div class="panel p-4">
                            <p class="panel-heading">{{ __('Live Uploads') }}</p>
                            <p class="mt-2 text-sm text-muted">{{ __('Chunked uploads, watermark queues, and dual resolution storage.') }}</p>
                        </div>
                        <div class="panel p-4">
                            <p class="panel-heading">{{ __('Secure Access') }}</p>
                            <p class="mt-2 text-sm text-muted">{{ __('Role based policies, 2FA for admins, and audit trails.') }}</p>
                        </div>
                        <div class="panel p-4">
                            <p class="panel-heading">{{ __('Event Delivery') }}</p>
                            <p class="mt-2 text-sm text-muted">{{ __('QR sharing, guest pins, and optimized galleries.') }}</p>
                        </div>
                        <div class="panel p-4">
                            <p class="panel-heading">{{ __('Operational Clarity') }}</p>
                            <p class="mt-2 text-sm text-muted">{{ __('Reports, exports, and real time tracking.') }}</p>
                        </div>
                    </div>
                </div>

                <div class="w-full max-w-xl">
                    <div class="panel p-8">
                        {{ $slot }}
                    </div>
                    @php
                        $supportEmail = trim((string) ($generalSettings['support_email'] ?? ''));
                        $supportPhone = trim((string) ($generalSettings['support_phone'] ?? ''));
                        $supportDetails = collect([$supportEmail, $supportPhone])->filter()->implode(' • ');
                    @endphp
                    <p class="mt-4 text-xs text-muted">
                        @if ($supportDetails !== '')
                            {{ __('Need help? Contact support at') }} {{ $supportDetails }}.
                        @else
                            {{ __('Need help? Reach out to your system administrator.') }}
                        @endif
                    </p>
                </div>
            </div>
        </div>
        @if (session('status') || session('error'))
            <div class="fixed bottom-6 right-6 z-50">
                <div
                    x-data="{ show: true }"
                    x-init="setTimeout(() => show = false, 3200)"
                    x-show="show"
                    x-transition
                    class="panel flex items-start gap-3 px-4 py-3 text-sm"
                >
                    <span class="mt-1 h-2.5 w-2.5 rounded-full {{ session('error') ? 'bg-danger' : 'bg-success' }}"></span>
                    <div>
                        <p class="font-semibold text-ink">{{ session('error') ? __('Action blocked') : __('Success') }}</p>
                        <p class="text-muted">{{ session('error') ?? session('status') }}</p>
                    </div>
                </div>
            </div>
        @endif
        @include('partials.gdpr-banner')
        @if (! empty($siteSettings['right_click_disable']))
            <script>
                document.addEventListener('contextmenu', function (event) {
                    event.preventDefault();
                });
            </script>
        @endif
        @stack('scripts')
    </body>
</html>
