<x-guest-layout>
    @php
        $supportEmail = trim((string) ($generalSettings['support_email'] ?? ''));
        if ($supportEmail === '') {
            $supportEmail = config('mail.from.address');
        }
    @endphp

    <div class="space-y-6">
        <div>
            <p class="text-xs uppercase tracking-[0.2em] text-muted">{{ __('Maintenance Mode') }}</p>
            <h2 class="mt-3 text-3xl font-semibold text-ink">{{ __('We will be back shortly.') }}</h2>
            <p class="mt-3 text-sm text-muted">{{ $message }}</p>
        </div>

        <div class="flex flex-wrap gap-3">
            <a href="{{ route('login') }}" class="btn-primary">{{ __('Admin login') }}</a>
            @if ($supportEmail)
                <a href="mailto:{{ $supportEmail }}" class="btn-secondary">{{ __('Contact support') }}</a>
            @endif
        </div>

        <div class="rounded-xl border border-dashed border-border/70 bg-surface-2/60 p-4 text-xs text-muted">
            <p>{{ __('We are applying updates to keep the gallery fast and secure.') }}</p>
        </div>
    </div>
</x-guest-layout>
