@php
    $extensions = $extensionSettings ?? [];
    $analytics = $extensions['analytics'] ?? [];
    $adsense = $extensions['adsense'] ?? [];
    $facebook = $extensions['facebook'] ?? [];
    $microsoft = $extensions['microsoft'] ?? [];
    $social = $extensions['social'] ?? [];
    $seo = $seoSettings ?? [];
    $gdpr = $gdprSettings ?? [];

    $gdprEnabled = filter_var($gdpr['gdpr_enabled'] ?? false, FILTER_VALIDATE_BOOLEAN);
    $gdprConsentValue = $gdprConsent ?? null;
    $trackingAllowed = ! $gdprEnabled || $gdprConsentValue === 'accepted';

    $ogEnabled = filter_var($social['og_enabled'] ?? false, FILTER_VALIDATE_BOOLEAN);
    $siteName = trim((string) ($siteSettings['site_name'] ?? ''));
    $fallbackTitle = $siteName !== '' ? $siteName : config('app.name', 'SnapNest');
    $metaTitle = trim((string) ($seo['meta_title'] ?? ''));
    $metaDescription = trim((string) ($seo['meta_description'] ?? ''));
    $metaKeywords = trim((string) ($seo['meta_keywords'] ?? ''));
    $metaTitle = $metaTitle !== '' ? $metaTitle : $fallbackTitle;
    $ogTitle = trim((string) ($social['og_title'] ?? ''));
    $ogDescription = trim((string) ($social['og_description'] ?? ''));
    $ogTitle = $ogTitle !== '' ? $ogTitle : $metaTitle;
    $ogDescription = $ogDescription !== '' ? $ogDescription : ($metaDescription !== '' ? $metaDescription : $fallbackTitle);
    $ogImage = $social['og_image'] ?? null;
    $ogImageUrl = '';
    if ($ogImage) {
        $ogImageUrl = \Illuminate\Support\Str::startsWith($ogImage, ['http://', 'https://'])
            ? $ogImage
            : asset('storage/' . ltrim($ogImage, '/'));
    }

    $googleEnabled = filter_var($analytics['google_enabled'] ?? false, FILTER_VALIDATE_BOOLEAN);
    $googleMeasurementId = trim((string) ($analytics['google_measurement_id'] ?? ''));

    $adsenseEnabled = filter_var($adsense['adsense_enabled'] ?? false, FILTER_VALIDATE_BOOLEAN);
    $adsenseClientId = trim((string) ($adsense['adsense_client_id'] ?? ''));

    $pixelEnabled = filter_var($facebook['pixel_enabled'] ?? false, FILTER_VALIDATE_BOOLEAN);
    $pixelId = trim((string) ($facebook['pixel_id'] ?? ''));

    $uetEnabled = filter_var($microsoft['uet_enabled'] ?? false, FILTER_VALIDATE_BOOLEAN);
    $uetTagId = trim((string) ($microsoft['uet_tag_id'] ?? ''));
@endphp

@if ($metaTitle !== '')
    <meta name="title" content="{{ $metaTitle }}">
@endif
@if ($metaDescription !== '')
    <meta name="description" content="{{ $metaDescription }}">
@endif
@if ($metaKeywords !== '')
    <meta name="keywords" content="{{ $metaKeywords }}">
@endif

@if ($ogEnabled)
    <meta property="og:title" content="{{ $ogTitle }}">
    <meta property="og:description" content="{{ $ogDescription }}">
    <meta property="og:type" content="website">
    <meta property="og:url" content="{{ url()->current() }}">
    <meta property="og:site_name" content="{{ $fallbackTitle }}">
    @if ($ogImageUrl)
        <meta property="og:image" content="{{ $ogImageUrl }}">
    @endif
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="{{ $ogTitle }}">
    <meta name="twitter:description" content="{{ $ogDescription }}">
    @if ($ogImageUrl)
        <meta name="twitter:image" content="{{ $ogImageUrl }}">
    @endif
@endif
<link rel="canonical" href="{{ url()->current() }}">

@if ($trackingAllowed && $googleEnabled && $googleMeasurementId)
    <script async src="https://www.googletagmanager.com/gtag/js?id={{ $googleMeasurementId }}"></script>
    <script>
        window.dataLayer = window.dataLayer || [];
        function gtag(){dataLayer.push(arguments);}
        gtag('js', new Date());
        gtag('config', '{{ $googleMeasurementId }}');
    </script>
@endif

@if ($trackingAllowed && $adsenseEnabled && $adsenseClientId)
    <script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client={{ $adsenseClientId }}" crossorigin="anonymous"></script>
@endif

@if ($trackingAllowed && $pixelEnabled && $pixelId)
    <script>
        !function(f,b,e,v,n,t,s){if(f.fbq)return;n=f.fbq=function(){n.callMethod?
        n.callMethod.apply(n,arguments):n.queue.push(arguments)};if(!f._fbq)f._fbq=n;
        n.push=n;n.loaded=!0;n.version='2.0';n.queue=[];t=b.createElement(e);t.async=!0;
        t.src=v;s=b.getElementsByTagName(e)[0];s.parentNode.insertBefore(t,s)}(window,
        document,'script','https://connect.facebook.net/en_US/fbevents.js');
        fbq('init', '{{ $pixelId }}');
        fbq('track', 'PageView');
    </script>
@endif

@if ($trackingAllowed && $uetEnabled && $uetTagId)
    <script>
        (function(w,d,t,r,u){var f,n,i;w[u]=w[u]||[];f=function(){var o={ti:"{{ $uetTagId }}"};o.q=w[u];w[u]=new UET(o);w[u].push("pageLoad")};n=d.createElement(t);n.src=r;n.async=1;n.onload=n.onreadystatechange=function(){var s=this.readyState;s&&s!=="loaded"&&s!=="complete"||(f(),n.onload=n.onreadystatechange=null)};i=d.getElementsByTagName(t)[0];i.parentNode.insertBefore(n,i)})(window,document,"script","//bat.bing.com/bat.js","uetq");
    </script>
    <noscript>
        <img src="https://bat.bing.com/action/0?ti={{ $uetTagId }}&Ver=2" height="0" width="0" class="tracking-pixel" alt="">
    </noscript>
@endif
