@if(!empty($pwaSettings['enabled']))
{{-- PWA Install Prompt --}}
<div id="pwa-install-prompt"
     class="pwa-prompt"
     style="display:none;"
     role="dialog"
     aria-modal="true"
     aria-label="{{ __('Install App') }}">

    {{-- Backdrop --}}
    <div id="pwa-backdrop" class="pwa-backdrop"></div>

    {{-- Card --}}
    <div class="pwa-card">

        {{-- Close button --}}
        <button id="pwa-close" class="pwa-close" aria-label="{{ __('Close') }}">
            <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24"
                 fill="none" stroke="currentColor" stroke-width="2.5"
                 stroke-linecap="round" stroke-linejoin="round">
                <line x1="18" y1="6" x2="6" y2="18"/><line x1="6" y1="6" x2="18" y2="18"/>
            </svg>
        </button>

        {{-- App identity --}}
        <div class="pwa-identity">
            <div class="pwa-icon-wrap">
                <img src="{{ asset('images/icons/icon-192x192.png') }}"
                     alt="{{ $brandName ?? config('app.name', 'SnapNest') }}"
                     class="pwa-icon"
                     loading="lazy">
            </div>
            <div class="pwa-identity-text">
                <p class="pwa-install-label">{{ __('Install') }}</p>
                <h2 class="pwa-app-name">{{ $brandName ?? config('app.name', 'SnapNest') }}</h2>
            </div>
        </div>

        {{-- Description --}}
        <p class="pwa-description">
            {{ __('Install the app for quick access, offline support, and a seamless native experience.') }}
        </p>

        {{-- Features --}}
        <ul class="pwa-features">
            <li>
                <span class="pwa-check">
                    <svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" viewBox="0 0 24 24"
                         fill="none" stroke="currentColor" stroke-width="3"
                         stroke-linecap="round" stroke-linejoin="round">
                        <polyline points="20 6 9 17 4 12"/>
                    </svg>
                </span>
                {{ __('Works offline after installation') }}
            </li>
            <li>
                <span class="pwa-check">
                    <svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" viewBox="0 0 24 24"
                         fill="none" stroke="currentColor" stroke-width="3"
                         stroke-linecap="round" stroke-linejoin="round">
                        <polyline points="20 6 9 17 4 12"/>
                    </svg>
                </span>
                {{ __('Faster loading & smoother experience') }}
            </li>
            <li>
                <span class="pwa-check">
                    <svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" viewBox="0 0 24 24"
                         fill="none" stroke="currentColor" stroke-width="3"
                         stroke-linecap="round" stroke-linejoin="round">
                        <polyline points="20 6 9 17 4 12"/>
                    </svg>
                </span>
                {{ __('Add to home screen for quick access') }}
            </li>
        </ul>

        {{-- Actions --}}
        <button id="pwa-install-btn" class="pwa-install-btn" type="button">
            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24"
                 fill="none" stroke="currentColor" stroke-width="2.5"
                 stroke-linecap="round" stroke-linejoin="round" style="flex-shrink:0;">
                <path d="M21 15v4a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2v-4"/>
                <polyline points="7 10 12 15 17 10"/>
                <line x1="12" y1="15" x2="12" y2="3"/>
            </svg>
            {{ __('Install App') }}
        </button>

        <button id="pwa-dismiss-btn" class="pwa-dismiss-btn" type="button">
            {{ __('Maybe later') }}
        </button>

    </div>
</div>

<style>
/* ── PWA Install Prompt ── */
.pwa-prompt {
    position: fixed;
    inset: 0;
    z-index: 9999;
    display: flex !important;
    align-items: flex-end;
    justify-content: center;
    padding: 1rem;
    pointer-events: none;
}
.pwa-prompt.pwa-hidden { display: none !important; }
.pwa-prompt.pwa-visible { pointer-events: auto; }

/* Backdrop */
.pwa-backdrop {
    position: fixed;
    inset: 0;
    background: rgba(0, 0, 0, 0.55);
    backdrop-filter: blur(4px);
    -webkit-backdrop-filter: blur(4px);
    opacity: 0;
    transition: opacity 0.3s ease;
}
.pwa-prompt.pwa-visible .pwa-backdrop { opacity: 1; }

/* Card */
.pwa-card {
    position: relative;
    width: 100%;
    max-width: 380px;
    background: #0f1923;
    border: 1px solid rgba(21, 96, 85, 0.35);
    border-radius: 16px;
    padding: 1.5rem;
    box-shadow: 0 8px 40px rgba(0, 0, 0, 0.6), 0 0 0 1px rgba(21, 96, 85, 0.15);
    transform: translateY(24px);
    opacity: 0;
    transition: transform 0.35s cubic-bezier(0.34, 1.56, 0.64, 1),
                opacity 0.3s ease;
    margin-bottom: 0.5rem;
    z-index: 1;
}
.pwa-prompt.pwa-visible .pwa-card {
    transform: translateY(0);
    opacity: 1;
}

/* Close */
.pwa-close {
    position: absolute;
    top: 0.875rem;
    right: 0.875rem;
    color: rgba(255,255,255,0.4);
    background: none;
    border: none;
    cursor: pointer;
    padding: 0.25rem;
    line-height: 1;
    border-radius: 6px;
    transition: color 0.2s, background 0.2s;
}
.pwa-close:hover {
    color: rgba(255,255,255,0.8);
    background: rgba(255,255,255,0.08);
}

/* Identity row */
.pwa-identity {
    display: flex;
    align-items: center;
    gap: 0.875rem;
    margin-bottom: 1rem;
}
.pwa-icon-wrap {
    flex-shrink: 0;
    width: 52px;
    height: 52px;
    border-radius: 12px;
    overflow: hidden;
    border: 1.5px solid rgba(21, 96, 85, 0.5);
    background: #0a1a16;
}
.pwa-icon {
    width: 100%;
    height: 100%;
    object-fit: cover;
}
.pwa-install-label {
    font-size: 0.7rem;
    font-weight: 600;
    letter-spacing: 0.08em;
    text-transform: uppercase;
    color: #4ec9b0;
    margin-bottom: 0.15rem;
}
.pwa-app-name {
    font-size: 1.1rem;
    font-weight: 700;
    color: #f0f0f0;
    line-height: 1.2;
}

/* Description */
.pwa-description {
    font-size: 0.82rem;
    color: rgba(255,255,255,0.55);
    line-height: 1.55;
    margin-bottom: 1rem;
}

/* Features */
.pwa-features {
    list-style: none;
    margin: 0 0 1.25rem 0;
    padding: 0;
    display: flex;
    flex-direction: column;
    gap: 0.5rem;
}
.pwa-features li {
    display: flex;
    align-items: center;
    gap: 0.6rem;
    font-size: 0.82rem;
    color: rgba(255,255,255,0.7);
}
.pwa-check {
    flex-shrink: 0;
    width: 20px;
    height: 20px;
    border-radius: 50%;
    background: rgba(21, 96, 85, 0.25);
    border: 1px solid rgba(21, 96, 85, 0.5);
    display: flex;
    align-items: center;
    justify-content: center;
    color: #4ec9b0;
}

/* Install button */
.pwa-install-btn {
    width: 100%;
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 0.5rem;
    padding: 0.75rem 1.25rem;
    background: #156055;
    color: #fff;
    border: none;
    border-radius: 10px;
    font-size: 0.9rem;
    font-weight: 600;
    cursor: pointer;
    transition: background 0.2s, transform 0.15s;
    margin-bottom: 0.6rem;
}
.pwa-install-btn:hover {
    background: #1a7a6a;
    transform: translateY(-1px);
}
.pwa-install-btn:active {
    background: #104840;
    transform: translateY(0);
}

/* Dismiss */
.pwa-dismiss-btn {
    width: 100%;
    background: none;
    border: none;
    color: rgba(255,255,255,0.35);
    font-size: 0.8rem;
    cursor: pointer;
    padding: 0.35rem;
    transition: color 0.2s;
    text-align: center;
}
.pwa-dismiss-btn:hover { color: rgba(255,255,255,0.6); }

/* Desktop: bottom-right corner */
@media (min-width: 640px) {
    .pwa-prompt {
        align-items: flex-end;
        justify-content: flex-end;
        padding: 1.5rem;
    }
    .pwa-card {
        margin-bottom: 0;
    }
}
</style>

<script>
(function () {
    'use strict';

    var STORAGE_KEY   = 'pwa_prompt_dismissed';
    var SHOW_DELAY_MS = 3500;
    var deferredPrompt = null;

    // ── Guards ──────────────────────────────────────────────────────
    if (localStorage.getItem(STORAGE_KEY)) return;
    if (window.matchMedia('(display-mode: standalone)').matches) return;
    if (window.navigator.standalone === true) return; // iOS Safari standalone

    var el         = document.getElementById('pwa-install-prompt');
    var installBtn = document.getElementById('pwa-install-btn');
    var dismissBtn = document.getElementById('pwa-dismiss-btn');
    var closeBtn   = document.getElementById('pwa-close');
    var backdrop   = document.getElementById('pwa-backdrop');
    if (!el) return;

    // ── Detect environment ──────────────────────────────────────────
    var isIOS     = /iphone|ipad|ipod/i.test(navigator.userAgent);
    var isSecure  = location.protocol === 'https:' || location.hostname === 'localhost' || location.hostname === '127.0.0.1';

    // ── Show / hide helpers ─────────────────────────────────────────
    function showPrompt() {
        el.style.display = 'flex';
        requestAnimationFrame(function () {
            requestAnimationFrame(function () { el.classList.add('pwa-visible'); });
        });
    }

    function hidePrompt(permanent) {
        el.classList.remove('pwa-visible');
        setTimeout(function () { el.style.display = 'none'; }, 350);
        if (permanent) localStorage.setItem(STORAGE_KEY, '1');
    }

    // ── iOS Safari: beforeinstallprompt never fires, show manual tip ─
    if (isIOS) {
        installBtn.textContent = '{{ __("Add to Home Screen") }}';
        installBtn.addEventListener('click', function () {
            installBtn.textContent = '{{ __("Tap") }} \u{1F4E4} {{ __("→ \"Add to Home Screen\"") }}';
            installBtn.disabled = true;
            installBtn.style.opacity = '0.7';
        });
        setTimeout(showPrompt, SHOW_DELAY_MS);
        setupDismiss();
        return;
    }

    // ── Non-secure origin (HTTP): hide prompt entirely ─────────────
    if (!isSecure) return;

    // ── HTTPS: standard beforeinstallprompt flow ────────────────────
    window.addEventListener('beforeinstallprompt', function (e) {
        e.preventDefault();
        deferredPrompt = e;
        setTimeout(showPrompt, SHOW_DELAY_MS);
    });

    installBtn.addEventListener('click', function () {
        hidePrompt(false);
        if (deferredPrompt) {
            deferredPrompt.prompt();
            deferredPrompt.userChoice.then(function (choice) {
                if (choice.outcome === 'accepted') localStorage.setItem(STORAGE_KEY, '1');
                deferredPrompt = null;
            });
        }
    });

    window.addEventListener('appinstalled', function () {
        localStorage.setItem(STORAGE_KEY, '1');
        hidePrompt(false);
    });

    setupDismiss();

    // ── Shared dismiss wiring ───────────────────────────────────────
    function setupDismiss() {
        function onDismiss() { hidePrompt(true); }
        if (dismissBtn) dismissBtn.addEventListener('click', onDismiss);
        if (closeBtn)   closeBtn.addEventListener('click', onDismiss);
        if (backdrop)   backdrop.addEventListener('click', onDismiss);
    }
}());
</script>
@endif
