<section class="space-y-6">
    @php
        $deleteRequest = $deleteRequest ?? null;
        $isPending = $deleteRequest && $deleteRequest->status === \App\Models\UserDeleteRequest::STATUS_PENDING;
        $isRejected = $deleteRequest && $deleteRequest->status === \App\Models\UserDeleteRequest::STATUS_REJECTED;
    @endphp
    <header>
        <h2 class="text-lg font-medium text-ink">
            {{ __('Delete Account') }}
        </h2>

        <p class="mt-1 text-sm text-muted">
            {{ __('Submitting a delete request sends it to an admin for approval. Your account will be removed only after it is accepted.') }}
        </p>
    </header>

    @if ($isPending)
        <div class="rounded-2xl border border-border/70 bg-surface-2/70 p-4 text-sm text-muted">
            {{ __('Your delete account request is pending admin approval.') }}
        </div>
    @else
        @if ($isRejected)
            <div class="rounded-2xl border border-border/70 bg-surface-2/70 p-4 text-sm text-muted">
                {{ __('Your last delete account request was rejected. You can submit a new request below.') }}
            </div>
        @endif

        <x-danger-button
            x-data=""
            x-on:click.prevent="$dispatch('open-modal', 'confirm-user-deletion')"
        >{{ __('Request Delete Account') }}</x-danger-button>
    @endif

    <x-modal name="confirm-user-deletion" :show="$errors->userDeletion->isNotEmpty()" focusable>
        <form method="post" action="{{ route('profile.destroy') }}" class="p-6">
            @csrf
            @method('delete')

            <h2 class="text-lg font-medium text-ink">
                {{ __('Submit a delete account request?') }}
            </h2>

            <p class="mt-1 text-sm text-muted">
                {{ __('Your request will be reviewed by an admin. Please enter your password to confirm you want to request deletion.') }}
            </p>

            <div class="mt-6">
                <x-input-label for="password" value="{{ __('Password') }}" class="sr-only" />

                <div class="relative mt-1">
                    <x-text-input
                        id="password"
                        name="password"
                        type="password"
                        class="pr-12"
                        placeholder="{{ __('Password') }}"
                    />
                    <button type="button" class="absolute inset-y-0 right-3 flex items-center text-muted/70 transition hover:text-ink" data-password-toggle data-target="password" aria-label="Toggle password visibility">
                        <svg viewBox="0 0 24 24" class="h-5 w-5" fill="none" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" data-password-icon="show">
                            <path d="M2 12s3.5-6 10-6 10 6 10 6-3.5 6-10 6-10-6-10-6z"></path>
                            <circle cx="12" cy="12" r="3"></circle>
                        </svg>
                        <svg viewBox="0 0 24 24" class="h-5 w-5 hidden" fill="none" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" data-password-icon="hide">
                            <path d="M3 5l16 16"></path>
                            <path d="M10.5 10.5a2.5 2.5 0 0 0 3 3"></path>
                            <path d="M7.5 7.5C5 9 3 12 3 12s3.5 6 9 6c1.6 0 3.1-.3 4.4-.9"></path>
                            <path d="M14.5 14.5c1.9-1.4 3.5-3.5 3.5-3.5s-1.3-2.3-3.5-3.8"></path>
                        </svg>
                    </button>
                </div>

                <x-input-error :messages="$errors->userDeletion->get('password')" class="mt-2" />
            </div>

            <div class="mt-6 flex justify-end">
                <x-secondary-button x-on:click="$dispatch('close')">
                    {{ __('Cancel') }}
                </x-secondary-button>

                <x-danger-button class="ms-3">
                    {{ __('Submit Request') }}
                </x-danger-button>
            </div>
        </form>
    </x-modal>
</section>
