<?php

use App\Http\Controllers\Api\ActivityLogController;
use App\Http\Controllers\Api\AuthController;
use App\Http\Controllers\Api\BlogCategoryController;
use App\Http\Controllers\Api\BlogPostController;
use App\Http\Controllers\Api\BlockedIpController;
use App\Http\Controllers\Api\BlockedLocationController;
use App\Http\Controllers\Api\CityController;
use App\Http\Controllers\Api\CountryController;
use App\Http\Controllers\Api\CouponController;
use App\Http\Controllers\Api\CurrencyController;
use App\Http\Controllers\Api\DashboardController;
use App\Http\Controllers\Api\EventMediaController;
use App\Http\Controllers\Api\EventShareController;
use App\Http\Controllers\Api\EventsController;
use App\Http\Controllers\Api\ExtensionsController;
use App\Http\Controllers\Api\FactStatController;
use App\Http\Controllers\Api\FaqController;
use App\Http\Controllers\Api\LanguageController;
use App\Http\Controllers\Api\PagesController;
use App\Http\Controllers\Api\PermissionsController;
use App\Http\Controllers\Api\PlanController;
use App\Http\Controllers\Api\PublicContentController;
use App\Http\Controllers\Api\PublicSettingsController;
use App\Http\Controllers\Api\PublicSupportController;
use App\Http\Controllers\Api\ReportController;
use App\Http\Controllers\Api\RolesController;
use App\Http\Controllers\Api\SecurityAuditLogController;
use App\Http\Controllers\Api\SecuritySettingsController;
use App\Http\Controllers\Api\StateController;
use App\Http\Controllers\Api\SupportTicketController;
use App\Http\Controllers\Api\SystemSettingsController;
use App\Http\Controllers\Api\SystemLogController;
use App\Http\Controllers\Api\TestimonialController;
use App\Http\Controllers\Api\TicketAssignmentController;
use App\Http\Controllers\Api\UsersController;
use Illuminate\Support\Facades\Route;

Route::middleware('api')->prefix('v1')->group(function () {
    Route::middleware('throttle:10,1')->group(function () {
        Route::post('auth/login', [AuthController::class, 'login']);
    });

    Route::middleware('throttle:5,1')->group(function () {
        Route::post('auth/register', [AuthController::class, 'register']);
    });

    Route::post('auth/forgot-password', [AuthController::class, 'forgotPassword']);
    Route::post('auth/reset-password', [AuthController::class, 'resetPassword']);

    Route::get('settings/public', [PublicSettingsController::class, 'show']);
    Route::get('content/faqs', [PublicContentController::class, 'faqs']);
    Route::get('content/testimonials', [PublicContentController::class, 'testimonials']);
    Route::get('content/facts', [PublicContentController::class, 'facts']);
    Route::get('content/plans', [PublicContentController::class, 'plans']);
    Route::get('content/pages', [PublicContentController::class, 'pages']);
    Route::get('content/pages/{slug}', [PublicContentController::class, 'page']);
    Route::get('content/blog/categories', [PublicContentController::class, 'blogCategories']);
    Route::get('content/blog/posts', [PublicContentController::class, 'blogPosts']);
    Route::get('content/blog/posts/{slug}', [PublicContentController::class, 'blogPost']);

    Route::middleware('throttle:3,1')->group(function () {
        Route::post('support/contact', [PublicSupportController::class, 'store']);
    });

    Route::get('events/share/{event:slug}', [EventShareController::class, 'show']);
    Route::post('events/share/{event:slug}/verify', [EventShareController::class, 'verifyPin']);

    Route::middleware('guest.token')->group(function () {
        Route::get('events/{event}/media', [EventMediaController::class, 'index']);
    });

    Route::middleware('auth:sanctum')->group(function () {
        // Auth profile routes - no additional permission check needed (user manages own profile)
        Route::get('auth/me', [AuthController::class, 'me']);
        Route::post('auth/logout', [AuthController::class, 'logout']);
        Route::patch('auth/profile', [AuthController::class, 'updateProfile']);
        Route::patch('auth/password', [AuthController::class, 'updatePassword']);
        Route::post('auth/2fa/challenge', [AuthController::class, 'twoFactorChallenge']);
        Route::get('auth/2fa/setup', [AuthController::class, 'twoFactorSetup']);
        Route::post('auth/2fa/setup', [AuthController::class, 'twoFactorSetupStore']);

        Route::get('dashboard', [DashboardController::class, 'index']);

        // Admin resource routes - require permission checks
        Route::middleware('api.permission')->group(function () {

        Route::get('settings/system', [SystemSettingsController::class, 'show']);
        Route::patch('settings/system/{group}', [SystemSettingsController::class, 'update']);
        Route::post('settings/system/smtp-test', [SystemSettingsController::class, 'testSmtp']);

        Route::get('settings/extensions', [ExtensionsController::class, 'show']);
        Route::patch('settings/extensions/{group}', [ExtensionsController::class, 'update']);

        Route::get('settings/security', [SecuritySettingsController::class, 'show']);
        Route::patch('settings/security', [SecuritySettingsController::class, 'update']);
        Route::post('settings/security/2fa/enable', [SecuritySettingsController::class, 'enableTwoFactor']);
        Route::post('settings/security/2fa/disable', [SecuritySettingsController::class, 'disableTwoFactor']);

        Route::delete('users/bulk', [UsersController::class, 'bulkDestroy']);
        Route::middleware('throttle:5,1')->group(function () {
            Route::get('users/export', [UsersController::class, 'export']);
        });
        Route::apiResource('users', UsersController::class);

        Route::delete('roles/bulk', [RolesController::class, 'bulkDestroy']);
        Route::middleware('throttle:5,1')->group(function () {
            Route::get('roles/export', [RolesController::class, 'export']);
        });
        Route::post('roles/import', [RolesController::class, 'import']);
        Route::apiResource('roles', RolesController::class);

        Route::delete('permissions/bulk', [PermissionsController::class, 'bulkDestroy']);
        Route::middleware('throttle:5,1')->group(function () {
            Route::get('permissions/export', [PermissionsController::class, 'export']);
        });
        Route::post('permissions/import', [PermissionsController::class, 'import']);
        Route::apiResource('permissions', PermissionsController::class);

        Route::delete('countries/bulk', [CountryController::class, 'bulkDestroy']);
        Route::middleware('throttle:5,1')->group(function () {
            Route::get('countries/export', [CountryController::class, 'export']);
        });
        Route::post('countries/import', [CountryController::class, 'import']);
        Route::apiResource('countries', CountryController::class);

        Route::delete('states/bulk', [StateController::class, 'bulkDestroy']);
        Route::middleware('throttle:5,1')->group(function () {
            Route::get('states/export', [StateController::class, 'export']);
        });
        Route::post('states/import', [StateController::class, 'import']);
        Route::apiResource('states', StateController::class);

        Route::delete('cities/bulk', [CityController::class, 'bulkDestroy']);
        Route::middleware('throttle:5,1')->group(function () {
            Route::get('cities/export', [CityController::class, 'export']);
        });
        Route::post('cities/import', [CityController::class, 'import']);
        Route::apiResource('cities', CityController::class);

        Route::delete('currencies/bulk', [CurrencyController::class, 'bulkDestroy']);
        Route::middleware('throttle:5,1')->group(function () {
            Route::get('currencies/export', [CurrencyController::class, 'export']);
        });
        Route::post('currencies/import', [CurrencyController::class, 'import']);
        Route::apiResource('currencies', CurrencyController::class);

        Route::delete('languages/bulk', [LanguageController::class, 'bulkDestroy']);
        Route::middleware('throttle:5,1')->group(function () {
            Route::get('languages/export', [LanguageController::class, 'export']);
        });
        Route::post('languages/import', [LanguageController::class, 'import']);
        Route::apiResource('languages', LanguageController::class);

        Route::delete('events/bulk', [EventsController::class, 'bulkDestroy']);
        Route::middleware('throttle:5,1')->group(function () {
            Route::get('events/export', [EventsController::class, 'export']);
        });
        Route::post('events/import', [EventsController::class, 'import']);
        Route::get('events/{event}/stats', [EventsController::class, 'stats']);
        Route::apiResource('events', EventsController::class);

        Route::middleware('throttle:30,1')->group(function () {
            Route::post('events/{event}/media', [EventMediaController::class, 'store']);
            Route::post('events/{event}/media/chunk', [EventMediaController::class, 'storeChunk']);
        });
        Route::post('events/{event}/media/ftp', [EventMediaController::class, 'ingestFtp']);
        Route::delete('events/{event}/media/bulk', [EventMediaController::class, 'bulkDestroy']);
        Route::delete('events/{event}/media/{media}', [EventMediaController::class, 'destroy']);
        Route::patch('events/{event}/media/{media}/cover', [EventMediaController::class, 'setCover']);
        Route::patch('events/{event}/media/{media}/featured', [EventMediaController::class, 'toggleFeatured']);
        Route::get('events/{event}/media/{media}/download', [EventMediaController::class, 'download']);

        Route::delete('plans/bulk', [PlanController::class, 'bulkDestroy']);
        Route::middleware('throttle:5,1')->group(function () {
            Route::get('plans/export', [PlanController::class, 'export']);
        });
        Route::post('plans/import', [PlanController::class, 'import']);
        Route::apiResource('plans', PlanController::class);

        Route::delete('coupons/bulk', [CouponController::class, 'bulkDestroy']);
        Route::middleware('throttle:5,1')->group(function () {
            Route::get('coupons/export', [CouponController::class, 'export']);
        });
        Route::post('coupons/import', [CouponController::class, 'import']);
        Route::apiResource('coupons', CouponController::class);

        Route::delete('support-tickets/bulk', [SupportTicketController::class, 'bulkDestroy']);
        Route::middleware('throttle:5,1')->group(function () {
            Route::get('support-tickets/export', [SupportTicketController::class, 'export']);
        });
        Route::post('support-tickets/import', [SupportTicketController::class, 'import']);
        Route::apiResource('support-tickets', SupportTicketController::class);

        Route::delete('faqs/bulk', [FaqController::class, 'bulkDestroy']);
        Route::middleware('throttle:5,1')->group(function () {
            Route::get('faqs/export', [FaqController::class, 'export']);
        });
        Route::post('faqs/import', [FaqController::class, 'import']);
        Route::apiResource('faqs', FaqController::class);

        Route::delete('pages/bulk', [PagesController::class, 'bulkDestroy']);
        Route::middleware('throttle:5,1')->group(function () {
            Route::get('pages/export', [PagesController::class, 'export']);
        });
        Route::post('pages/import', [PagesController::class, 'import']);
        Route::apiResource('pages', PagesController::class);

        Route::delete('testimonials/bulk', [TestimonialController::class, 'bulkDestroy']);
        Route::middleware('throttle:5,1')->group(function () {
            Route::get('testimonials/export', [TestimonialController::class, 'export']);
        });
        Route::post('testimonials/import', [TestimonialController::class, 'import']);
        Route::apiResource('testimonials', TestimonialController::class);

        Route::delete('fact-stats/bulk', [FactStatController::class, 'bulkDestroy']);
        Route::middleware('throttle:5,1')->group(function () {
            Route::get('fact-stats/export', [FactStatController::class, 'export']);
        });
        Route::post('fact-stats/import', [FactStatController::class, 'import']);
        Route::apiResource('fact-stats', FactStatController::class);

        Route::delete('blog-categories/bulk', [BlogCategoryController::class, 'bulkDestroy']);
        Route::middleware('throttle:5,1')->group(function () {
            Route::get('blog-categories/export', [BlogCategoryController::class, 'export']);
        });
        Route::post('blog-categories/import', [BlogCategoryController::class, 'import']);
        Route::apiResource('blog-categories', BlogCategoryController::class);

        Route::delete('blog-posts/bulk', [BlogPostController::class, 'bulkDestroy']);
        Route::middleware('throttle:5,1')->group(function () {
            Route::get('blog-posts/export', [BlogPostController::class, 'export']);
        });
        Route::post('blog-posts/import', [BlogPostController::class, 'import']);
        Route::apiResource('blog-posts', BlogPostController::class);

        Route::delete('ticket-assignments/bulk', [TicketAssignmentController::class, 'bulkDestroy']);
        Route::middleware('throttle:5,1')->group(function () {
            Route::get('ticket-assignments/export', [TicketAssignmentController::class, 'export']);
        });
        Route::post('ticket-assignments/import', [TicketAssignmentController::class, 'import']);
        Route::apiResource('ticket-assignments', TicketAssignmentController::class);

        Route::delete('blocked-ips/bulk', [BlockedIpController::class, 'bulkDestroy']);
        Route::middleware('throttle:5,1')->group(function () {
            Route::get('blocked-ips/export', [BlockedIpController::class, 'export']);
        });
        Route::post('blocked-ips/import', [BlockedIpController::class, 'import']);
        Route::apiResource('blocked-ips', BlockedIpController::class);

        Route::delete('blocked-locations/bulk', [BlockedLocationController::class, 'bulkDestroy']);
        Route::middleware('throttle:5,1')->group(function () {
            Route::get('blocked-locations/export', [BlockedLocationController::class, 'export']);
        });
        Route::post('blocked-locations/import', [BlockedLocationController::class, 'import']);
        Route::apiResource('blocked-locations', BlockedLocationController::class);

        Route::delete('system-logs/bulk', [SystemLogController::class, 'bulkDestroy']);
        Route::middleware('throttle:5,1')->group(function () {
            Route::get('system-logs/export', [SystemLogController::class, 'export']);
        });
        Route::post('system-logs/import', [SystemLogController::class, 'import']);
        Route::apiResource('system-logs', SystemLogController::class);

        Route::delete('activity-logs/bulk', [ActivityLogController::class, 'bulkDestroy']);
        Route::middleware('throttle:5,1')->group(function () {
            Route::get('activity-logs/export', [ActivityLogController::class, 'export']);
        });
        Route::post('activity-logs/import', [ActivityLogController::class, 'import']);
        Route::apiResource('activity-logs', ActivityLogController::class);

        Route::delete('security-audit-logs/bulk', [SecurityAuditLogController::class, 'bulkDestroy']);
        Route::middleware('throttle:5,1')->group(function () {
            Route::get('security-audit-logs/export', [SecurityAuditLogController::class, 'export']);
        });
        Route::post('security-audit-logs/import', [SecurityAuditLogController::class, 'import']);
        Route::apiResource('security-audit-logs', SecurityAuditLogController::class);

        Route::get('reports', [ReportController::class, 'index']);
        Route::get('reports/{report}', [ReportController::class, 'show']);
        Route::middleware('throttle:5,1')->group(function () {
            Route::get('reports/{report}/export', [ReportController::class, 'export']);
        });
        }); // end api.permission
    });
});
