<?php

use App\Http\Controllers\Admin\ActivityLogController;
use App\Http\Controllers\Admin\AdminSearchController;
use App\Http\Controllers\Admin\BlogCategoryController;
use App\Http\Controllers\Admin\BlogPostController;
use App\Http\Controllers\Admin\BlockedIpController;
use App\Http\Controllers\Admin\BlockedLocationController;
use App\Http\Controllers\Admin\CityController;
use App\Http\Controllers\Admin\CountryController;
use App\Http\Controllers\Admin\CouponController;
use App\Http\Controllers\Admin\CurrencyController;
use App\Http\Controllers\Admin\DashboardController;
use App\Http\Controllers\Admin\EventController;
use App\Http\Controllers\Admin\EventMediaController;
use App\Http\Controllers\Admin\ExtensionsController;
use App\Http\Controllers\Admin\FactStatController;
use App\Http\Controllers\Admin\FaqController;
use App\Http\Controllers\Admin\LanguageController;
use App\Http\Controllers\Admin\LocaleController;
use App\Http\Controllers\Admin\OrderController;
use App\Http\Controllers\Admin\PageController;
use App\Http\Controllers\Admin\PaymentGatewayController;
use App\Http\Controllers\Admin\PermissionController;
use App\Http\Controllers\Admin\PlanController;
use App\Http\Controllers\Admin\FinancialReportController;
use App\Http\Controllers\Admin\ReportController;
use App\Http\Controllers\Admin\RoleController;
use App\Http\Controllers\Admin\SecurityAuditLogController;
use App\Http\Controllers\Admin\SecuritySettingsController;
use App\Http\Controllers\Admin\StateController;
use App\Http\Controllers\Admin\SupportTicketController;
use App\Http\Controllers\Admin\SystemLogController;
use App\Http\Controllers\Admin\SystemSettingsController;
use App\Http\Controllers\Admin\NewsletterSubscriberController;
use App\Http\Controllers\Admin\TestimonialController;
use App\Http\Controllers\Admin\ThemeController;
use App\Http\Controllers\Admin\TicketAssignmentController;
use App\Http\Controllers\Admin\UsageController;
use App\Http\Controllers\Admin\UserController;
use App\Http\Controllers\Admin\UserDeleteRequestController;
use App\Http\Controllers\Admin\FrontendSettingsController;
use App\Http\Controllers\Admin\ContactQueryController;
use App\Http\Controllers\ContactFormController;
use App\Http\Controllers\InstallController;
use App\Http\Controllers\MediaPreviewController;
use App\Http\Controllers\NewsletterController;
use App\Http\Controllers\ProfileController;
use App\Http\Controllers\CheckoutController;
use App\Http\Controllers\EventShareController;
use Illuminate\Support\Facades\Route;

// ---------------------------------------------------------------
//  PWA Manifest override — use asset() for correct subdirectory paths
// ---------------------------------------------------------------
Route::get('/manifest.json', function () {
    $config = config('laravelpwa.manifest');
    $manifest = [
        'name'             => $config['name'],
        'short_name'       => $config['short_name'],
        'start_url'        => asset($config['start_url']),
        'display'          => $config['display'],
        'theme_color'      => $config['theme_color'],
        'background_color' => $config['background_color'],
        'orientation'      => $config['orientation'],
        'status_bar'       => $config['status_bar'],
    ];
    foreach ($config['icons'] as $size => $file) {
        $ext = pathinfo($file['path'], PATHINFO_EXTENSION);
        $manifest['icons'][] = [
            'src'     => asset($file['path']),
            'type'    => 'image/' . $ext,
            'sizes'   => $size,
            'purpose' => $file['purpose'],
        ];
    }
    foreach ($config['custom'] ?? [] as $key => $value) {
        if (in_array($key, ['scope', 'id']) && $value === '/') {
            $value = url('/');
        }
        $manifest[$key] = $value;
    }
    return response()->json($manifest);
})->name('laravelpwa.manifest');

// ---------------------------------------------------------------
//  Installer Routes (must be before all other routes)
// ---------------------------------------------------------------
Route::prefix('install')->name('install.')->middleware('install.session')->group(function () {
    Route::get('/', [InstallController::class, 'welcome'])->name('welcome');
    Route::get('/requirements', [InstallController::class, 'requirements'])->name('requirements');
    Route::post('/requirements', [InstallController::class, 'checkRequirements'])->name('requirements.check');
    Route::get('/database', [InstallController::class, 'database'])->name('database');
    Route::post('/database', [InstallController::class, 'saveDatabase'])->name('database.save');
    Route::post('/database/test', [InstallController::class, 'testDatabase'])->name('database.test');
    Route::get('/application', [InstallController::class, 'application'])->name('application');
    Route::post('/application', [InstallController::class, 'saveApplication'])->name('application.save');
    Route::get('/admin', [InstallController::class, 'admin'])->name('admin');
    Route::post('/admin', [InstallController::class, 'saveAdmin'])->name('admin.save');
    Route::get('/run', [InstallController::class, 'run'])->name('run');
    Route::post('/execute', [InstallController::class, 'execute'])->name('execute');
    Route::get('/complete', [InstallController::class, 'complete'])->name('complete');
});

Route::get('/', function () {
    $plans = \App\Models\Plan::where('is_active', true)->orderBy('price')->get();
    return view('frontend.home', compact('plans'));
})->name('home');

Route::get('/about', function () {
    $page = \App\Models\Page::firstOrCreate(['type' => 'about'], ['title' => 'About Us', 'slug' => 'about-us', 'is_active' => true]);
    return view('frontend.about', compact('page'));
})->name('about');

Route::get('/contact', function () {
    $page = \App\Models\Page::firstOrCreate(['type' => 'contact'], ['title' => 'Contact Us', 'slug' => 'contact-us', 'is_active' => true]);
    return view('frontend.contact', compact('page'));
})->name('contact');

Route::get('/legal/cookies', function () {
    $page = \App\Models\Page::firstOrCreate(['type' => 'cookie_policy'], ['title' => 'Cookie Policy', 'slug' => 'cookie-policy', 'is_active' => true]);
    return view('frontend.legal.cookies', compact('page'));
})->name('legal.cookies');

Route::get('/legal/privacy', function () {
    $page = \App\Models\Page::firstOrCreate(['type' => 'privacy_policy'], ['title' => 'Privacy Policy', 'slug' => 'privacy-policy', 'is_active' => true]);
    return view('frontend.legal.privacy', compact('page'));
})->name('legal.privacy');

Route::get('/legal/terms', function () {
    $page = \App\Models\Page::firstOrCreate(['type' => 'terms'], ['title' => 'Terms and Conditions', 'slug' => 'terms-and-conditions', 'is_active' => true]);
    return view('frontend.legal.terms', compact('page'));
})->name('legal.terms');

Route::get('/page/{page:slug}', function (\App\Models\Page $page) {
    abort_unless($page->is_active, 404);
    return view('frontend.page', compact('page'));
})->name('page.show');

Route::get('/blog', function () {
    $posts = \App\Models\BlogPost::with('category')
        ->where('is_active', true)
        ->whereNotNull('published_at')
        ->where('published_at', '<=', now())
        ->orderByDesc('published_at')
        ->paginate(12);
    return view('frontend.blog.index', compact('posts'));
})->name('blog.index');

Route::get('/blog/{slug}', function ($slug) {
    $post = \App\Models\BlogPost::with('category')
        ->where('slug', $slug)
        ->where('is_active', true)
        ->firstOrFail();
    $relatedPosts = \App\Models\BlogPost::where('category_id', $post->category_id)
        ->where('id', '!=', $post->id)
        ->where('is_active', true)
        ->limit(3)
        ->get();
    return view('frontend.blog.show', compact('post', 'relatedPosts'));
})->name('blog.show');

Route::get('/features', function () {
    return view('frontend.features');
})->name('features');

Route::get('/pricing', function () {
    $plans = \App\Models\Plan::where('is_active', true)->orderBy('price')->get();
    return view('frontend.pricing', compact('plans'));
})->name('pricing');

Route::get('/p/{id}', function ($id) {
    return view('frontend.p.show');
})->name('p.show');

Route::get('/events/{event:slug}', [EventShareController::class, 'show'])->name('events.share');
Route::post('/events/{event:slug}/access', [EventShareController::class, 'verifyPin'])->name('events.share.access');
Route::post('/events/{event:slug}/face-search', [EventShareController::class, 'faceSearch'])->name('events.share.face-search');
Route::post('/events/{event:slug}/guest-upload', [EventShareController::class, 'storeGuestUpload'])->name('events.share.guest-upload');
Route::get('/events/{event:slug}/face-image', [EventShareController::class, 'faceImage'])->name('events.share.face-image');
Route::get('/events/{event:slug}/media/{media}/download', [EventShareController::class, 'download'])->name('events.share.download');

// Client selections (guest proofing)
Route::post('/events/{event:slug}/selections/{media}/toggle', [\App\Http\Controllers\ClientSelectionController::class, 'toggle'])->name('events.share.selections.toggle');
Route::get('/events/{event:slug}/selections', [\App\Http\Controllers\ClientSelectionController::class, 'list'])->name('events.share.selections.list');

Route::post('/newsletter/subscribe', [NewsletterController::class, 'subscribe'])->name('newsletter.subscribe');
Route::post('/contact', [ContactFormController::class, 'store'])->name('contact.submit');
Route::post('/locale', [\App\Http\Controllers\Admin\LocaleController::class, 'update'])->name('frontend.locale.update');

Route::get('/media/{media}/preview', [MediaPreviewController::class, 'show'])
    ->name('media.preview')
    ->middleware('signed');

// ---------------------------------------------------------------
//  Checkout & Payment Routes
// ---------------------------------------------------------------

// Authenticated checkout flow (static routes before wildcard to avoid slug conflicts)
Route::middleware('auth')->group(function () {
    Route::get('/checkout/success/{order}', [CheckoutController::class, 'success'])->name('checkout.success');
    Route::get('/checkout/cancel', [CheckoutController::class, 'cancel'])->name('checkout.cancel');
    Route::post('/checkout/apply-coupon', [CheckoutController::class, 'applyCoupon'])->name('checkout.apply-coupon');
    Route::get('/checkout/{plan:slug}', [CheckoutController::class, 'show'])->name('checkout.show');
    Route::post('/checkout/{plan:slug}', [CheckoutController::class, 'process'])->name('checkout.process');
});

// Payment gateway callbacks (auth via session -- user returns from gateway)
Route::get('/payment/callback/{gateway}', [CheckoutController::class, 'callback'])->name('payment.callback');
Route::post('/payment/callback/{gateway}', [CheckoutController::class, 'callback']);

// Payment webhook (no auth, no CSRF -- gateway server-to-server)
Route::post('/payment/webhook/{gateway}', [CheckoutController::class, 'webhook'])->name('payment.webhook');

Route::middleware(['auth', 'verified'])->group(function () {
    Route::get('/dashboard', function () {
        return redirect()->route('admin.dashboard');
    })->name('dashboard');

    Route::prefix('admin')->name('admin.')->middleware(['admin.permission', \App\Http\Middleware\ProcessQueueOnRequest::class])->group(function () {
        Route::get('/', [DashboardController::class, 'index'])->name('dashboard');
        Route::get('/operations', function () {
            return view('admin.operations.index');
        })->name('operations.index');
        Route::get('/system-hub', function () {
            return view('admin.system-hub.index');
        })->name('system-hub.index');
        Route::delete('/users/bulk', [UserController::class, 'bulkDestroy'])->name('users.bulk-destroy');
        Route::get('/users/export', [UserController::class, 'export'])->name('users.export');
        Route::post('/users/import', [UserController::class, 'import'])->name('users.import');
        Route::resource('users', UserController::class);
        Route::delete('/roles/bulk', [RoleController::class, 'bulkDestroy'])->name('roles.bulk-destroy');
        Route::get('/roles/export', [RoleController::class, 'export'])->name('roles.export');
        Route::post('/roles/import', [RoleController::class, 'import'])->name('roles.import');
        Route::resource('roles', RoleController::class);
        Route::delete('/events/bulk', [EventController::class, 'bulkDestroy'])->name('events.bulk-destroy');
        Route::get('/events/export', [EventController::class, 'export'])->name('events.export');
        Route::post('/events/import', [EventController::class, 'import'])->name('events.import');
        Route::post('/queue/process', [EventMediaController::class, 'processQueue'])->name('queue.process');
        Route::post('/events/{event}/media', [EventMediaController::class, 'store'])->name('events.media.store');
        Route::post('/events/{event}/media/zip', [EventMediaController::class, 'storeZip'])->name('events.media.zip');
        Route::post('/events/{event}/media/chunk', [EventMediaController::class, 'storeChunk'])->name('events.media.chunk');
        Route::post('/events/{event}/media/ftp', [EventMediaController::class, 'ingestFtp'])->name('events.media.import');
        Route::post('/events/{event}/media/google-drive', [EventMediaController::class, 'importGoogleDrive'])->name('events.media.google-drive');
        Route::get('/events/{event}/media/google-drive/status', [EventMediaController::class, 'googleDriveStatus'])->name('events.media.google-drive.status');
        Route::post('/events/{event}/media/bulk-download', [EventMediaController::class, 'bulkDownload'])->name('events.media.bulk-download');
        Route::get('/events/{event}/media/export', [EventMediaController::class, 'export'])->name('events.media.export');
        Route::delete('/events/{event}/media/bulk', [EventMediaController::class, 'bulkDestroy'])->name('events.media.bulk-destroy');
        Route::delete('/events/{event}/media/{media}', [EventMediaController::class, 'destroy'])->name('events.media.destroy');
        Route::post('/events/{event}/media/{media}/cover', [EventMediaController::class, 'setCover'])->name('events.media.cover');
        Route::post('/events/{event}/media/{media}/featured', [EventMediaController::class, 'toggleFeatured'])->name('events.media.featured');
        Route::get('/events/{event}/media/{media}/download', [EventMediaController::class, 'download'])->name('events.media.download');
        Route::get('/events/{event}/invoice', [EventController::class, 'invoice'])->name('events.invoice.download');
        Route::get('/events/{event}/design', [EventController::class, 'design'])->name('events.design');
        Route::post('/events/{event}/design-update', [EventController::class, 'updateDesign'])->name('events.design.update');
        Route::resource('events', EventController::class);


        // Admin event selections
        Route::get('/events/{event}/selections', [EventController::class, 'selections'])->name('events.selections');

        Route::delete('/plans/bulk', [PlanController::class, 'bulkDestroy'])->name('plans.bulk-destroy');
        Route::get('/plans/export', [PlanController::class, 'export'])->name('plans.export');
        Route::post('/plans/import', [PlanController::class, 'import'])->name('plans.import');
        Route::resource('plans', PlanController::class);
        Route::delete('/coupons/bulk', [CouponController::class, 'bulkDestroy'])->name('coupons.bulk-destroy');
        Route::get('/coupons/export', [CouponController::class, 'export'])->name('coupons.export');
        Route::post('/coupons/import', [CouponController::class, 'import'])->name('coupons.import');
        Route::resource('coupons', CouponController::class);
        Route::get('/payment-gateways', [PaymentGatewayController::class, 'index'])->name('payment-gateways.index');
        Route::put('/payment-gateways/{paymentGateway}', [PaymentGatewayController::class, 'update'])->name('payment-gateways.update');
        Route::post('/payment-gateways/{paymentGateway}/toggle', [PaymentGatewayController::class, 'toggleActive'])->name('payment-gateways.toggle');
        Route::delete('/support-tickets/bulk', [SupportTicketController::class, 'bulkDestroy'])->name('support-tickets.bulk-destroy');
        Route::get('/support-tickets/export', [SupportTicketController::class, 'export'])->name('support-tickets.export');
        Route::post('/support-tickets/import', [SupportTicketController::class, 'import'])->name('support-tickets.import');
        Route::resource('support-tickets', SupportTicketController::class);
        Route::delete('/ticket-assignments/bulk', [TicketAssignmentController::class, 'bulkDestroy'])->name('ticket-assignments.bulk-destroy');
        Route::get('/ticket-assignments/export', [TicketAssignmentController::class, 'export'])->name('ticket-assignments.export');
        Route::post('/ticket-assignments/import', [TicketAssignmentController::class, 'import'])->name('ticket-assignments.import');
        Route::resource('ticket-assignments', TicketAssignmentController::class);
        Route::delete('/faqs/bulk', [FaqController::class, 'bulkDestroy'])->name('faqs.bulk-destroy');
        Route::get('/faqs/export', [FaqController::class, 'export'])->name('faqs.export');
        Route::post('/faqs/import', [FaqController::class, 'import'])->name('faqs.import');
        Route::resource('faqs', FaqController::class);
        Route::get('/system-settings', [SystemSettingsController::class, 'index'])->name('system-settings.index');
        Route::post('/system-settings/smtp/test', [SystemSettingsController::class, 'testSmtp'])->name('system-settings.smtp.test');
        Route::post('/system-settings/cloud-storage/test', [SystemSettingsController::class, 'testCloudStorage'])->name('system-settings.cloud-storage.test');
        Route::post('/system-settings/cloud-storage/migrate', [SystemSettingsController::class, 'startCloudStorageMigration'])->name('system-settings.cloud-storage.migrate');
        Route::post('/system-settings/{group}', [SystemSettingsController::class, 'update'])->name('system-settings.update');
        Route::get('/extensions', [ExtensionsController::class, 'index'])->name('extensions.index');
        Route::post('/extensions/{group}', [ExtensionsController::class, 'update'])->name('extensions.update');
        Route::get('/themes', [ThemeController::class, 'index'])->name('themes.index');
        Route::get('/search', AdminSearchController::class)->name('search');
        Route::post('/locale', [LocaleController::class, 'update'])->name('locale.update');
        Route::get('/security-settings', [SecuritySettingsController::class, 'index'])->name('security-settings.index');
        Route::post('/security-settings', [SecuritySettingsController::class, 'update'])->name('security-settings.update');
        Route::post('/security-settings/two-factor/enable', [SecuritySettingsController::class, 'enableTwoFactor'])->name('security-settings.two-factor.enable');
        Route::post('/security-settings/two-factor/disable', [SecuritySettingsController::class, 'disableTwoFactor'])->name('security-settings.two-factor.disable');
        Route::get('/frontend-settings', [FrontendSettingsController::class, 'index'])->name('frontend-settings.index');
        Route::get('/frontend-settings/{type}/edit', [FrontendSettingsController::class, 'edit'])->name('frontend-settings.edit');
        Route::put('/frontend-settings/{type}', [FrontendSettingsController::class, 'update'])->name('frontend-settings.update');
        Route::delete('/contact-queries/bulk', [ContactQueryController::class, 'bulkDestroy'])->name('contact-queries.bulk-destroy');
        Route::resource('contact-queries', ContactQueryController::class)->only(['index', 'show', 'destroy']);
        Route::delete('/pages/bulk', [PageController::class, 'bulkDestroy'])->name('pages.bulk-destroy');
        Route::get('/pages/export', [PageController::class, 'export'])->name('pages.export');
        Route::post('/pages/import', [PageController::class, 'import'])->name('pages.import');
        Route::resource('pages', PageController::class);
        Route::delete('/system-logs/bulk', [SystemLogController::class, 'bulkDestroy'])->name('system-logs.bulk-destroy');
        Route::get('/system-logs/export', [SystemLogController::class, 'export'])->name('system-logs.export');
        Route::post('/system-logs/import', [SystemLogController::class, 'import'])->name('system-logs.import');
        Route::resource('system-logs', SystemLogController::class);
        Route::delete('/activity-logs/bulk', [ActivityLogController::class, 'bulkDestroy'])->name('activity-logs.bulk-destroy');
        Route::get('/activity-logs/export', [ActivityLogController::class, 'export'])->name('activity-logs.export');
        Route::post('/activity-logs/import', [ActivityLogController::class, 'import'])->name('activity-logs.import');
        Route::get('/notifications', [ActivityLogController::class, 'notifications'])->name('notifications');
        Route::resource('activity-logs', ActivityLogController::class);
        Route::delete('/countries/bulk', [CountryController::class, 'bulkDestroy'])->name('countries.bulk-destroy');
        Route::get('/countries/export', [CountryController::class, 'export'])->name('countries.export');
        Route::post('/countries/import', [CountryController::class, 'import'])->name('countries.import');
        Route::resource('countries', CountryController::class);
        Route::delete('/states/bulk', [StateController::class, 'bulkDestroy'])->name('states.bulk-destroy');
        Route::get('/states/export', [StateController::class, 'export'])->name('states.export');
        Route::post('/states/import', [StateController::class, 'import'])->name('states.import');
        Route::resource('states', StateController::class);
        Route::delete('/cities/bulk', [CityController::class, 'bulkDestroy'])->name('cities.bulk-destroy');
        Route::get('/cities/export', [CityController::class, 'export'])->name('cities.export');
        Route::post('/cities/import', [CityController::class, 'import'])->name('cities.import');
        Route::resource('cities', CityController::class);
        Route::delete('/currencies/bulk', [CurrencyController::class, 'bulkDestroy'])->name('currencies.bulk-destroy');
        Route::get('/currencies/export', [CurrencyController::class, 'export'])->name('currencies.export');
        Route::post('/currencies/import', [CurrencyController::class, 'import'])->name('currencies.import');
        Route::post('/currencies/fetch-rates', [CurrencyController::class, 'fetchRates'])->name('currencies.fetch-rates');
        Route::resource('currencies', CurrencyController::class);
        Route::delete('/languages/bulk', [LanguageController::class, 'bulkDestroy'])->name('languages.bulk-destroy');
        Route::get('/languages/export', [LanguageController::class, 'export'])->name('languages.export');
        Route::post('/languages/import', [LanguageController::class, 'import'])->name('languages.import');
        Route::resource('languages', LanguageController::class);
        Route::delete('/testimonials/bulk', [TestimonialController::class, 'bulkDestroy'])->name('testimonials.bulk-destroy');
        Route::get('/testimonials/export', [TestimonialController::class, 'export'])->name('testimonials.export');
        Route::post('/testimonials/import', [TestimonialController::class, 'import'])->name('testimonials.import');
        Route::resource('testimonials', TestimonialController::class);
        Route::delete('/newsletter-subscribers/bulk', [NewsletterSubscriberController::class, 'bulkDestroy'])->name('newsletter-subscribers.bulk-destroy');
        Route::get('/newsletter-subscribers/export', [NewsletterSubscriberController::class, 'export'])->name('newsletter-subscribers.export');
        Route::resource('newsletter-subscribers', NewsletterSubscriberController::class)->only(['index', 'show', 'destroy']);
        Route::delete('/fact-stats/bulk', [FactStatController::class, 'bulkDestroy'])->name('fact-stats.bulk-destroy');
        Route::get('/fact-stats/export', [FactStatController::class, 'export'])->name('fact-stats.export');
        Route::post('/fact-stats/import', [FactStatController::class, 'import'])->name('fact-stats.import');
        Route::resource('fact-stats', FactStatController::class);
        Route::delete('/blog-categories/bulk', [BlogCategoryController::class, 'bulkDestroy'])->name('blog-categories.bulk-destroy');
        Route::get('/blog-categories/export', [BlogCategoryController::class, 'export'])->name('blog-categories.export');
        Route::post('/blog-categories/import', [BlogCategoryController::class, 'import'])->name('blog-categories.import');
        Route::resource('blog-categories', BlogCategoryController::class);
        Route::delete('/blog-posts/bulk', [BlogPostController::class, 'bulkDestroy'])->name('blog-posts.bulk-destroy');
        Route::get('/blog-posts/export', [BlogPostController::class, 'export'])->name('blog-posts.export');
        Route::post('/blog-posts/import', [BlogPostController::class, 'import'])->name('blog-posts.import');
        Route::resource('blog-posts', BlogPostController::class);
        Route::delete('/permissions/bulk', [PermissionController::class, 'bulkDestroy'])->name('permissions.bulk-destroy');
        Route::get('/permissions/export', [PermissionController::class, 'export'])->name('permissions.export');
        Route::post('/permissions/import', [PermissionController::class, 'import'])->name('permissions.import');
        Route::resource('permissions', PermissionController::class);
        Route::get('/reports', [ReportController::class, 'index'])->name('reports.index');
        Route::get('/reports/{report}/export/{format}', [ReportController::class, 'export'])->name('reports.export');
        Route::get('/reports/{report}', [ReportController::class, 'show'])->name('reports.show');
        Route::get('/financial-report', [FinancialReportController::class, 'index'])->name('financial-report.index');
        Route::delete('/blocked-ips/bulk', [BlockedIpController::class, 'bulkDestroy'])->name('blocked-ips.bulk-destroy');
        Route::get('/blocked-ips/export', [BlockedIpController::class, 'export'])->name('blocked-ips.export');
        Route::post('/blocked-ips/import', [BlockedIpController::class, 'import'])->name('blocked-ips.import');
        Route::resource('blocked-ips', BlockedIpController::class);
        Route::delete('/blocked-locations/bulk', [BlockedLocationController::class, 'bulkDestroy'])->name('blocked-locations.bulk-destroy');
        Route::get('/blocked-locations/export', [BlockedLocationController::class, 'export'])->name('blocked-locations.export');
        Route::post('/blocked-locations/import', [BlockedLocationController::class, 'import'])->name('blocked-locations.import');
        Route::resource('blocked-locations', BlockedLocationController::class);
        Route::delete('/security-audit-logs/bulk', [SecurityAuditLogController::class, 'bulkDestroy'])->name('security-audit-logs.bulk-destroy');
        Route::get('/security-audit-logs/export', [SecurityAuditLogController::class, 'export'])->name('security-audit-logs.export');
        Route::post('/security-audit-logs/import', [SecurityAuditLogController::class, 'import'])->name('security-audit-logs.import');
        Route::resource('security-audit-logs', SecurityAuditLogController::class);
        Route::get('/usage', [UsageController::class, 'index'])->name('usage.index');
        Route::get('/orders', [OrderController::class, 'index'])->name('orders.index');
        Route::get('/orders/{order}', [OrderController::class, 'show'])->name('orders.show');
        Route::patch('/orders/{order}/status', [OrderController::class, 'updateStatus'])->name('orders.update-status');
        Route::get('/user-delete-requests', [UserDeleteRequestController::class, 'index'])->name('user-delete-requests.index');
        Route::patch('/user-delete-requests/{userDeleteRequest}', [UserDeleteRequestController::class, 'update'])->name('user-delete-requests.update');
    });
});

Route::middleware('auth')->group(function () {
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
});

require __DIR__.'/auth.php';
