<section class="relative pt-32 pb-20 md:pt-40 md:pb-32 overflow-hidden bg-[radial-gradient(ellipse_at_top,_var(--tw-gradient-stops))] from-primary/10 via-background to-background"
    x-data="{ shown: false }"
    x-init="setTimeout(() => shown = true, 100)">

    <!-- Decorative background elements -->
    <div class="absolute top-0 left-1/2 -translate-x-1/2 w-full h-full -z-10 pointer-events-none">
        <div class="absolute top-[-10%] left-[-10%] w-[40%] h-[40%] bg-primary/20 blur-[120px] rounded-full"></div>
        <div class="absolute bottom-[-10%] right-[-10%] w-[40%] h-[40%] bg-accent/15 blur-[120px] rounded-full"></div>
    </div>

    <div class="container mx-auto px-4">
        <div class="flex flex-col items-center text-center max-w-5xl mx-auto space-y-10">

            <!-- Badge -->
            <div
                class="inline-flex items-center space-x-2 rounded-full border border-primary/20 bg-primary/5 px-4 py-1.5 text-sm font-medium text-primary backdrop-blur-md transition-all duration-700 transform"
                :class="shown ? 'opacity-100 translate-y-0' : 'opacity-0 translate-y-4'">
                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-4 w-4"><path d="m12 3-1.912 5.813a2 2 0 0 1-1.275 1.275L3 12l5.813 1.912a2 2 0 0 1 1.275 1.275L12 21l1.912-5.813a2 2 0 0 1 1.275-1.275L21 12l-5.813-1.912a2 2 0 0 1-1.275-1.275L12 3Z"/></svg>
                <span><?php echo e(__('SnapNest – Event Photo Sharing Platform with QR & Face Recognition')); ?></span>
            </div>

            <!-- Heading -->
            <h1
                class="text-5xl md:text-6xl lg:text-7xl font-bold tracking-tight text-balance transition-all duration-700 delay-100 transform"
                :class="shown ? 'opacity-100 translate-y-0' : 'opacity-0 translate-y-4'">
                <?php echo e(__('Memories Delivered')); ?> <br />
                <span class="bg-gradient-to-r from-primary via-accent to-primary bg-[length:200%_auto] animate-gradient bg-clip-text text-transparent italic tracking-tight"><?php echo e(__('Before They Fade.')); ?></span>
            </h1>

            <!-- Description -->
            <p
                class="text-lg md:text-xl text-muted-foreground max-w-2xl leading-relaxed text-balance transition-all duration-700 delay-200 transform"
                :class="shown ? 'opacity-100 translate-y-0' : 'opacity-0 translate-y-4'">
                <?php echo e(__('The elite sharing platform for professional photographers. Instant Face Search, cloud storage, FTP tethering, and customizable event galleries.')); ?>

            </p>

            <!-- Buttons -->
            <div
                class="flex flex-col sm:flex-row gap-5 w-full justify-center items-center transition-all duration-700 delay-300 transform"
                :class="shown ? 'opacity-100 translate-y-0' : 'opacity-0 translate-y-4'">
                <a href="<?php echo e(url('/register')); ?>" class="group h-14 px-10 text-lg font-semibold rounded-2xl shadow-xl shadow-primary/20 hover:shadow-primary/40 transition-all hover:-translate-y-1 inline-flex items-center justify-center bg-primary text-primary-foreground">
                    <?php echo e(__('Start Your Free Trial')); ?>

                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="ml-2 h-5 w-5 group-hover:translate-x-1 transition-transform"><path d="M5 12h14"/><path d="m12 5 7 7-7 7"/></svg>
                </a>
            </div>

            <!-- Features List -->
            <div
                class="flex flex-wrap items-center justify-center gap-x-10 gap-y-4 text-xs font-semibold text-muted-foreground pt-6 uppercase tracking-widest transition-all duration-700 delay-500 transform"
                :class="shown ? 'opacity-100' : 'opacity-0'">
                <div class="flex items-center gap-2.5">
                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-4 w-4 text-primary"><path d="M12 22c5.523 0 10-4.477 10-10S17.523 2 12 2 2 6.477 2 12s4.477 10 10 10Z"/><path d="m9 12 2 2 4-4"/></svg>
                    <?php echo e(__('Face Search')); ?>

                </div>
                <div class="flex items-center gap-2.5">
                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-4 w-4 text-primary"><path d="M12 22c5.523 0 10-4.477 10-10S17.523 2 12 2 2 6.477 2 12s4.477 10 10 10Z"/><path d="m9 12 2 2 4-4"/></svg>
                    <?php echo e(__('Cloud Storage')); ?>

                </div>
                <div class="flex items-center gap-2.5">
                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-4 w-4 text-primary"><path d="M12 22c5.523 0 10-4.477 10-10S17.523 2 12 2 2 6.477 2 12s4.477 10 10 10Z"/><path d="m9 12 2 2 4-4"/></svg>
                    <?php echo e(__('PIN Protected')); ?>

                </div>
            </div>
        </div>

        <!-- Dashboard Preview -->
        <div
            class="mt-24 relative max-w-6xl mx-auto px-4 md:px-12 transition-all duration-1000 delay-500 ease-out transform"
            :class="shown ? 'opacity-100 translate-y-0' : 'opacity-0 translate-y-12'">

            <!-- Ambient Light -->
            <div class="absolute top-1/2 left-1/2 -translate-x-1/2 -translate-y-1/2 w-[120%] h-[120%] bg-primary/5 blur-[160px] rounded-full -z-10 animate-pulse"></div>

            <div class="relative">
                <!-- Main Frame -->
                <div class="relative rounded-[2.5rem] p-1.5 md:p-3 bg-gradient-to-b from-border/50 to-transparent border border-border/50 shadow-2xl backdrop-blur-sm overflow-hidden group">
                    <div class="absolute inset-0 bg-primary/5 opacity-0 group-hover:opacity-100 transition-opacity duration-700"></div>

                    <div class="relative rounded-[2rem] bg-card border border-border/50 overflow-hidden aspect-[16/10] md:aspect-[21/9] flex flex-col shadow-inner">
                        <!-- Dashboard Header -->
                        <div class="h-16 border-b border-border/50 bg-muted/30 px-6 flex items-center justify-between">
                            <div class="flex items-center gap-4">
                                <div class="flex gap-1.5">
                                    <div class="h-2.5 w-2.5 rounded-full bg-red-500/20 border border-red-500/30"></div>
                                    <div class="h-2.5 w-2.5 rounded-full bg-amber-500/20 border border-amber-500/30"></div>
                                    <div class="h-2.5 w-2.5 rounded-full bg-emerald-500/20 border border-emerald-500/30"></div>
                                </div>
                                <div class="h-4 w-px bg-border mx-2"></div>
                                <div class="text-[10px] font-bold uppercase tracking-widest text-muted-foreground flex items-center gap-2">
                                    <div class="h-2 w-2 rounded-full bg-emerald-500 animate-pulse"></div>
                                    <?php echo e(__('Live Event: Wedding Gala 2026')); ?>

                                </div>
                            </div>
                            <div class="flex items-center gap-3">
                                <span class="font-bold text-lg"><?php echo e(trim($siteSettings['site_name'] ?? '') ?: config('app.name', 'SnapNest')); ?></span>
                            </div>
                        </div>

                        <!-- Dashboard Body -->
                        <div class="flex-1 flex overflow-hidden">
                            <!-- Sidebar -->
                            <div class="w-20 md:w-64 border-r border-border/50 bg-muted/10 p-4 hidden md:flex flex-col gap-3">
                                <div class="h-10 rounded-xl border border-border/50 bg-primary/5 border-primary/20"></div>
                                <div class="h-10 rounded-xl border border-border/50"></div>
                                <div class="h-10 rounded-xl border border-border/50"></div>
                                <div class="h-10 rounded-xl border border-border/50"></div>
                            </div>

                            <!-- Main Gallery Area -->
                            <div class="flex-1 p-6 overflow-hidden relative">
                                <div class="grid grid-cols-2 md:grid-cols-4 gap-4">
                                    <?php $__currentLoopData = range(1, 8); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="aspect-square rounded-2xl bg-muted/40 border border-border/50 overflow-hidden relative group/item">
                                        <div class="absolute inset-0 bg-gradient-to-t from-black/20 to-transparent"></div>
                                        <div class="absolute bottom-2 left-2 right-2 h-1 bg-white/20 rounded-full scale-x-0 group-hover/item:scale-x-100 transition-transform origin-left"></div>
                                    </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>

                                <!-- AI Scanning Overlay -->
                                <div class="absolute left-0 right-0 h-32 bg-gradient-to-b from-transparent via-primary/10 to-transparent pointer-events-none z-10 animate-[scan_6s_linear_infinite]"></div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Floating Cards -->
                <!-- AI Result Card -->
                <div class="hidden sm:flex absolute -top-6 right-2 md:right-4 p-4 md:p-5 bg-background/95 border border-border rounded-2xl md:rounded-3xl shadow-2xl z-30 items-center gap-3 md:gap-5 backdrop-blur-xl transition-all duration-700 delay-700 transform"
                    :class="shown ? 'opacity-100 translate-x-0' : 'opacity-0 translate-x-10'">
                    <div class="h-10 w-10 md:h-14 md:w-14 rounded-xl md:rounded-2xl bg-primary/10 flex items-center justify-center text-primary relative overflow-hidden shrink-0">
                        <div class="absolute inset-0 bg-primary/20 animate-pulse"></div>
                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-5 w-5 md:h-7 md:w-7 relative z-10"><path d="M3 7V5a2 2 0 0 1 2-2h2"/><path d="M17 3h2a2 2 0 0 1 2 2v2"/><path d="M21 17v2a2 2 0 0 1-2 2h-2"/><path d="M7 21H5a2 2 0 0 1-2-2v-2"/><path d="M8 14s1.5 2 4 2 4-2 4-2"/><path d="M9 9h.01"/><path d="M15 9h.01"/></svg>
                    </div>
                    <div>
                        <div class="flex items-center gap-2 mb-1">
                            <span class="text-[9px] font-bold text-primary uppercase tracking-widest"><?php echo e(__('Instant Match')); ?></span>
                            <div class="h-1 w-1 rounded-full bg-primary"></div>
                            <span class="text-[9px] font-bold text-muted-foreground uppercase tracking-widest">99.8%</span>
                        </div>
                        <p class="text-xs md:text-sm font-bold text-foreground leading-none"><?php echo e(__('Guest #402 Identified')); ?></p>
                    </div>
                </div>

                <!-- Upload Card -->
                <div class="hidden sm:flex absolute -bottom-6 left-2 md:left-6 p-3 md:p-4 bg-background/95 border border-border rounded-xl md:rounded-2xl shadow-2xl z-30 items-center gap-3 md:gap-4 backdrop-blur-xl transition-all duration-700 delay-1000 transform"
                    :class="shown ? 'opacity-100 translate-y-0' : 'opacity-0 translate-y-10'">
                    <div class="h-8 w-8 md:h-10 md:w-10 rounded-full bg-emerald-500/10 flex items-center justify-center text-emerald-500 shrink-0">
                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-4 w-4 md:h-5 md:w-5"><path d="M17.5 19H9a7 7 0 1 1 6.71-9h1.79a4.5 4.5 0 1 1 0 9Z"/><path d="M12 13v-8"/><path d="m8 9 4-4 4 4"/></svg>
                    </div>
                    <div>
                        <p class="text-xs font-bold text-foreground"><?php echo e(__('Cloud Synced')); ?></p>
                        <p class="text-[10px] text-muted-foreground font-medium"><?php echo e(__('248 photos uploaded to S3')); ?></p>
                    </div>
                    <div class="h-2 w-2 rounded-full bg-emerald-500 animate-pulse"></div>
                </div>

            </div>
        </div>
    </div>
</section>
<?php /**PATH /home/acehost1/public_html/photobee.acehosting.in/resources/views/components/frontend/hero.blade.php ENDPATH**/ ?>