<?php
    $brandName = config('app.name', 'Photography Admin');
?>
<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title><?php echo $__env->yieldContent('title'); ?> - <?php echo e($brandName); ?></title>

    <link rel="preconnect" href="https://fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=space+grotesk:400,500,600,700&display=swap" rel="stylesheet">

    <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css']); ?>
</head>
<body class="font-sans text-ink antialiased">
    <div class="fixed inset-0 bg-grid opacity-20 pointer-events-none"></div>
    <div class="relative flex min-h-screen items-center justify-center px-6 py-16">
        <div class="w-full max-w-lg text-center">
            <div class="inline-flex items-center justify-center rounded-full border border-border bg-surface-2/80 px-4 py-2 text-xs font-semibold uppercase tracking-[0.2em] text-muted">
                <?php echo $__env->yieldContent('badge', __('Error')); ?>
            </div>

            <p class="mt-8 text-8xl font-bold text-brand/20"><?php echo $__env->yieldContent('code'); ?></p>

            <h1 class="mt-4 text-3xl font-semibold text-ink"><?php echo $__env->yieldContent('heading'); ?></h1>

            <p class="mt-3 text-base text-muted"><?php echo $__env->yieldContent('message'); ?></p>

            <div class="mt-10 flex flex-wrap items-center justify-center gap-3">
                <?php echo $__env->yieldContent('actions'); ?>
            </div>

            <p class="mt-12 text-xs text-muted/60"><?php echo e($brandName); ?></p>
        </div>
    </div>
</body>
</html>
<?php /**PATH /home/acehost1/public_html/photobee.acehosting.in/resources/views/errors/layout.blade.php ENDPATH**/ ?>