<?php if (isset($component)) { $__componentOriginal91fdd17964e43374ae18c674f95cdaa3 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal91fdd17964e43374ae18c674f95cdaa3 = $attributes; } ?>
<?php $component = App\View\Components\AdminLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('admin-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\AdminLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(__('Dashboard')),'subtitle' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(__('Real time visibility into events, uploads, and client access.'))]); ?>
    <div class="space-y-6">

        
        <div class="grid gap-4 sm:grid-cols-2 lg:grid-cols-4">
            <div class="panel p-5">
                <p class="panel-heading">Active Events</p>
                <div class="mt-4 flex items-end justify-between">
                    <div>
                        <p class="text-3xl font-semibold text-ink"><?php echo e(number_format($metrics['active_events'])); ?></p>
                        <?php if($metrics['events_this_week'] > 0): ?>
                            <p class="mt-1 text-sm text-muted">+<?php echo e(number_format($metrics['events_this_week'])); ?> this week</p>
                        <?php else: ?>
                            <p class="mt-1 text-sm text-muted">No new events this week</p>
                        <?php endif; ?>
                    </div>
                    <span class="badge">Live</span>
                </div>
            </div>

            <div class="panel p-5">
                <p class="panel-heading">Total Media</p>
                <div class="mt-4 flex items-end justify-between">
                    <div>
                        <p class="text-3xl font-semibold text-ink"><?php echo e(number_format($metrics['total_media'])); ?></p>
                        <p class="mt-1 text-sm text-muted"><?php echo e($metrics['queue_count'] ? number_format($metrics['queue_count']) . ' processing' : 'Queue is clear'); ?></p>
                    </div>
                    <span class="badge">Assets</span>
                </div>
            </div>

            <div class="panel p-5">
                <p class="panel-heading">Storage Used</p>
                <div class="mt-4 flex items-end justify-between">
                    <div>
                        <p class="text-3xl font-semibold text-ink"><?php echo e($metrics['storage_percent']); ?>%</p>
                        <p class="mt-1 text-sm text-muted"><?php echo e($metrics['storage_used_label']); ?> of <?php echo e($metrics['storage_limit_label']); ?></p>
                        <?php if(! empty($metrics['storage_warning'])): ?>
                            <p class="mt-1 text-xs <?php echo e($metrics['storage_warning'] >= 90 ? 'text-danger' : 'text-warning'); ?>">
                                Warning (<?php echo e($metrics['storage_warning']); ?>%)
                            </p>
                        <?php endif; ?>
                    </div>
                    <span class="badge">Dual copy</span>
                </div>
            </div>

            <?php if($metrics['is_admin']): ?>
                <div class="panel p-5">
                    <p class="panel-heading">Active Users</p>
                    <div class="mt-4 flex items-end justify-between">
                        <div>
                            <p class="text-3xl font-semibold text-ink"><?php echo e(number_format($metrics['active_users'])); ?></p>
                            <?php if($metrics['new_users'] > 0): ?>
                                <p class="mt-1 text-sm text-muted">+<?php echo e(number_format($metrics['new_users'])); ?> this week</p>
                            <?php else: ?>
                                <p class="mt-1 text-sm text-muted">No new users this week</p>
                            <?php endif; ?>
                        </div>
                        <span class="badge">Users</span>
                    </div>
                </div>
            <?php else: ?>
                <div class="panel p-5">
                    <p class="panel-heading">Upload Queue</p>
                    <div class="mt-4 flex items-end justify-between">
                        <div>
                            <p class="text-3xl font-semibold text-ink"><?php echo e(number_format($metrics['queue_count'])); ?></p>
                            <p class="mt-1 text-sm text-muted"><?php echo e($metrics['queue_count'] ? 'Files processing' : 'Queue is clear'); ?></p>
                        </div>
                        <span class="badge">Chunked</span>
                    </div>
                </div>
            <?php endif; ?>
        </div>

        
        <?php if(isset($revenueStats)): ?>
            <div class="grid gap-4 sm:grid-cols-2 lg:grid-cols-4">
                <div class="panel p-5">
                    <p class="panel-heading">Total Revenue</p>
                    <div class="mt-4 flex items-end justify-between">
                        <div>
                            <p class="text-3xl font-semibold text-ink"><?php echo e($revenueStats['currency_symbol']); ?><?php echo e(number_format($revenueStats['total_revenue'], 2)); ?></p>
                            <p class="mt-1 text-sm text-muted">All time earnings</p>
                        </div>
                        <span class="badge">Revenue</span>
                    </div>
                </div>

                <div class="panel p-5">
                    <p class="panel-heading">This Month</p>
                    <div class="mt-4 flex items-end justify-between">
                        <div>
                            <p class="text-3xl font-semibold text-ink"><?php echo e($revenueStats['currency_symbol']); ?><?php echo e(number_format($revenueStats['revenue_this_month'], 2)); ?></p>
                            <p class="mt-1 text-sm text-muted"><?php echo e(now()->format('F Y')); ?></p>
                        </div>
                        <span class="badge">Monthly</span>
                    </div>
                </div>

                <div class="panel p-5">
                    <p class="panel-heading">Total Orders</p>
                    <div class="mt-4 flex items-end justify-between">
                        <div>
                            <p class="text-3xl font-semibold text-ink"><?php echo e(number_format($revenueStats['total_orders'])); ?></p>
                            <p class="mt-1 text-sm text-muted"><?php echo e(number_format($revenueStats['completed_orders'])); ?> completed</p>
                        </div>
                        <span class="badge">Orders</span>
                    </div>
                </div>

                <div class="panel p-5">
                    <p class="panel-heading">Pending Orders</p>
                    <div class="mt-4 flex items-end justify-between">
                        <div>
                            <p class="text-3xl font-semibold text-ink"><?php echo e(number_format($revenueStats['pending_orders'])); ?></p>
                            <p class="mt-1 text-sm text-muted"><?php echo e($revenueStats['pending_orders'] ? 'Awaiting payment' : 'All clear'); ?></p>
                        </div>
                        <span class="badge">Pending</span>
                    </div>
                </div>
            </div>
        <?php endif; ?>

        
        <div class="grid gap-6 <?php echo e($metrics['is_admin'] ? 'lg:grid-cols-5' : 'lg:grid-cols-1'); ?>">
            <div class="panel p-6 <?php echo e($metrics['is_admin'] ? 'lg:col-span-3' : ''); ?>">
                <div class="flex flex-wrap items-center justify-between gap-4">
                    <div>
                        <p class="panel-heading">Upload Throughput</p>
                        <p class="mt-1 text-sm text-muted">Image ingestion performance across live events.</p>
                    </div>
                    <div class="flex flex-wrap items-center gap-2">
                        <a href="<?php echo e(route('admin.events.create')); ?>" class="btn-primary">Create event</a>
                        <?php if($metrics['is_admin']): ?>
                            <a href="<?php echo e(route('admin.extensions.index')); ?>" class="btn-secondary">View analytics</a>
                        <?php endif; ?>
                    </div>
                </div>

                <?php
                    $chart = $throughput['chart'] ?? ['line' => '', 'fill' => '', 'points' => []];
                    $chartLine = $chart['line'] ?: 'M20 160 L500 160';
                    $chartFill = $chart['fill'] ?: 'M20 160 L500 160 L500 180 L20 180 Z';
                    $chartPoints = $chart['points'] ?: [['x' => 20, 'y' => 160], ['x' => 500, 'y' => 160]];
                ?>

                <div class="mt-6 rounded-2xl border border-border/60 bg-surface/80 p-4">
                    <svg viewBox="0 0 520 200" class="h-48 w-full">
                        <defs>
                            <linearGradient id="throughput-line" x1="0" y1="0" x2="0" y2="1">
                                <stop offset="0%" stop-color="rgb(var(--brand))" stop-opacity="0.35"></stop>
                                <stop offset="100%" stop-color="rgb(var(--brand))" stop-opacity="0"></stop>
                            </linearGradient>
                        </defs>
                        <path d="<?php echo e($chartLine); ?>" fill="none" stroke="rgb(var(--brand))" stroke-width="3" stroke-linecap="round"></path>
                        <path d="<?php echo e($chartFill); ?>" fill="url(#throughput-line)"></path>
                        <g fill="rgb(var(--accent))">
                            <?php $__currentLoopData = $chartPoints; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $point): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <circle cx="<?php echo e($point['x']); ?>" cy="<?php echo e($point['y']); ?>" r="4"></circle>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </g>
                    </svg>
                    <div class="mt-4 grid grid-cols-1 sm:grid-cols-3 gap-3">
                        <div>
                            <p class="text-xs text-muted">Avg / day</p>
                            <p class="mt-1 text-base font-semibold text-ink"><?php echo e(number_format($throughput['avg_per_day'])); ?> images</p>
                        </div>
                        <div>
                            <p class="text-xs text-muted">Peak day</p>
                            <p class="mt-1 text-base font-semibold text-ink"><?php echo e(number_format($throughput['peak_per_day'])); ?> images</p>
                        </div>
                        <div>
                            <p class="text-xs text-muted">Queue ETA</p>
                            <p class="mt-1 text-base font-semibold text-ink"><?php echo e($throughput['queue_eta_label']); ?></p>
                        </div>
                    </div>
                </div>
            </div>

            <div class="panel p-6 <?php echo e($metrics['is_admin'] ? 'lg:col-span-2' : ''); ?>">
                <p class="panel-heading">Live Event Health</p>
                <p class="mt-1 text-sm text-muted">Priority shoots and delivery status.</p>
                <div class="mt-6 space-y-3">
                    <?php $__empty_1 = true; $__currentLoopData = $eventHealth; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $event): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <div class="flex items-center justify-between rounded-xl border border-border/60 bg-surface/70 p-4">
                            <div class="min-w-0 flex-1">
                                <p class="text-sm font-semibold text-ink truncate"><?php echo e($event['name']); ?></p>
                                <p class="mt-1 text-xs text-muted"><?php echo e($event['subtitle']); ?></p>
                            </div>
                            <span class="badge ml-3 shrink-0"><?php echo e($event['status']); ?></span>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <div class="rounded-xl border border-dashed border-border/60 bg-surface/70 p-4 text-sm text-muted">
                            No events to display yet.
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        
        <div class="grid gap-6 <?php echo e($metrics['is_admin'] ? 'lg:grid-cols-3' : 'lg:grid-cols-1'); ?>">
            <div class="panel p-6 <?php echo e($metrics['is_admin'] ? 'lg:col-span-2' : ''); ?>">
                <div class="flex flex-wrap items-center justify-between gap-4">
                    <div>
                        <p class="panel-heading">Recent Deliveries</p>
                        <p class="mt-1 text-sm text-muted">Latest albums awaiting review or download.</p>
                    </div>
                    <a href="<?php echo e(route('admin.reports.index')); ?>" class="btn-secondary">Export report</a>
                </div>

                <div class="mt-6 overflow-x-auto">
                    <table class="w-full text-left text-sm">
                        <thead class="text-xs text-muted">
                            <tr>
                                <th class="pb-3">Event</th>
                                <th class="pb-3">Type</th>
                                <th class="pb-3">Status</th>
                                <th class="pb-3 text-right">Assets</th>
                            </tr>
                        </thead>
                        <tbody class="divide-y divide-border/60">
                            <?php $__empty_1 = true; $__currentLoopData = $recentDeliveries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $delivery): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td class="py-3">
                                        <p class="font-semibold text-ink"><?php echo e($delivery['name']); ?></p>
                                        <p class="text-xs text-muted"><?php echo e($delivery['expiry']); ?></p>
                                    </td>
                                    <td class="py-3 text-muted"><?php echo e($delivery['type']); ?></td>
                                    <td class="py-3"><span class="badge"><?php echo e($delivery['status']); ?></span></td>
                                    <td class="py-3 text-right text-ink"><?php echo e(number_format($delivery['assets'])); ?></td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="4" class="py-6 text-center text-sm text-muted">No deliveries yet.</td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>

            <?php if(isset($systemSnapshot)): ?>
                <div class="panel p-6">
                    <p class="panel-heading">System Snapshot</p>
                    <p class="mt-1 text-sm text-muted">Security, uptime, and queue status.</p>
                    <div class="mt-6 space-y-4">
                        <div class="flex items-center justify-between">
                            <span class="text-sm text-muted">Admin 2FA</span>
                            <span class="text-sm font-semibold text-ink"><?php echo e($systemSnapshot['two_factor']); ?></span>
                        </div>
                        <div class="flex items-center justify-between">
                            <span class="text-sm text-muted">Blocked IPs</span>
                            <span class="text-sm font-semibold text-ink"><?php echo e(number_format($systemSnapshot['blocked_ips'])); ?></span>
                        </div>
                        <div class="flex items-center justify-between">
                            <span class="text-sm text-muted">Blocked Locations</span>
                            <span class="text-sm font-semibold text-ink"><?php echo e(number_format($systemSnapshot['blocked_locations'])); ?></span>
                        </div>
                        <div class="flex items-center justify-between">
                            <span class="text-sm text-muted">Upload Queue</span>
                            <span class="text-sm font-semibold text-ink"><?php echo e(number_format($systemSnapshot['queue_pending'])); ?></span>
                        </div>
                        <div class="flex items-center justify-between">
                            <span class="text-sm text-muted">Social Login</span>
                            <span class="text-sm font-semibold text-ink"><?php echo e($systemSnapshot['social_login']); ?></span>
                        </div>
                    </div>
                    <div class="mt-6 rounded-xl border border-border/60 bg-surface/70 p-4 text-sm text-muted">
                        <?php if($metrics['queue_count'] > 0): ?>
                            Processing <span class="font-semibold text-ink"><?php echo e(number_format($metrics['queue_count'])); ?></span> upload(s). Watermarks are running in the background.
                        <?php else: ?>
                            No pending uploads. Background queue is idle.
                        <?php endif; ?>
                    </div>
                </div>
            <?php endif; ?>
        </div>

        
        <?php if($metrics['is_admin']): ?>
            <div class="grid gap-6 lg:grid-cols-3">
                
                <?php if(isset($recentActivity)): ?>
                    <div class="panel p-6 lg:col-span-2">
                        <div class="flex flex-wrap items-center justify-between gap-4">
                            <div>
                                <p class="panel-heading">Recent Activity</p>
                                <p class="mt-1 text-sm text-muted">Latest actions across the platform.</p>
                            </div>
                            <a href="<?php echo e(route('admin.extensions.index')); ?>" class="btn-secondary">View all</a>
                        </div>
                        <div class="mt-6 space-y-1">
                            <?php $__empty_1 = true; $__currentLoopData = $recentActivity; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $activity): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <div class="flex items-start gap-3 rounded-lg px-3 py-2.5 transition hover:bg-surface/80">
                                    <div class="mt-0.5 flex h-7 w-7 shrink-0 items-center justify-center rounded-full bg-brand/10 text-xs font-bold text-brand">
                                        <?php echo e(strtoupper(substr($activity['user'], 0, 1))); ?>

                                    </div>
                                    <div class="min-w-0 flex-1">
                                        <p class="text-sm text-ink">
                                            <span class="font-semibold"><?php echo e($activity['user']); ?></span>
                                            <span class="text-muted">&middot; <?php echo e($activity['action']); ?></span>
                                        </p>
                                        <p class="mt-0.5 text-xs text-muted truncate"><?php echo e($activity['description']); ?></p>
                                    </div>
                                    <span class="shrink-0 text-xs text-muted"><?php echo e($activity['time']); ?></span>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <div class="rounded-xl border border-dashed border-border/60 bg-surface/70 p-4 text-sm text-muted">
                                    No recent activity.
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                <?php endif; ?>

                
                <?php if(isset($planStats)): ?>
                    <div class="panel p-6">
                        <p class="panel-heading">Plan Distribution</p>
                        <p class="mt-1 text-sm text-muted">Orders by active plan.</p>
                        <div class="mt-6 space-y-3">
                            <?php $__empty_1 = true; $__currentLoopData = $planStats; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <?php
                                    $maxOrders = max(array_column($planStats, 'orders')) ?: 1;
                                    $barWidth = ($plan['orders'] / $maxOrders) * 100;
                                ?>
                                <div>
                                    <div class="flex items-center justify-between text-sm">
                                        <span class="font-medium text-ink"><?php echo e($plan['name']); ?></span>
                                        <span class="text-muted"><?php echo e(number_format($plan['orders'])); ?> orders</span>
                                    </div>
                                    <div class="mt-1.5 h-2 w-full overflow-hidden rounded-full bg-border/40">
                                        <div class="h-full rounded-full bg-brand/70 transition-all" style="width: <?php echo e($barWidth); ?>%"></div>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <div class="rounded-xl border border-dashed border-border/60 bg-surface/70 p-4 text-sm text-muted">
                                    No active plans.
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
        <?php endif; ?>

    </div>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal91fdd17964e43374ae18c674f95cdaa3)): ?>
<?php $attributes = $__attributesOriginal91fdd17964e43374ae18c674f95cdaa3; ?>
<?php unset($__attributesOriginal91fdd17964e43374ae18c674f95cdaa3); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal91fdd17964e43374ae18c674f95cdaa3)): ?>
<?php $component = $__componentOriginal91fdd17964e43374ae18c674f95cdaa3; ?>
<?php unset($__componentOriginal91fdd17964e43374ae18c674f95cdaa3); ?>
<?php endif; ?>
<?php /**PATH /home/acehost1/public_html/photobee.acehosting.in/resources/views/dashboard.blade.php ENDPATH**/ ?>