<?php if (isset($component)) { $__componentOriginal91fdd17964e43374ae18c674f95cdaa3 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal91fdd17964e43374ae18c674f95cdaa3 = $attributes; } ?>
<?php $component = App\View\Components\AdminLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('admin-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\AdminLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(__('P/L Book')),'subtitle' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(__('Profit and Loss Financial Report'))]); ?>
    <div class="space-y-6">

        
        <div class="panel p-6">
            <div class="flex flex-wrap items-center justify-between gap-4">
                <div>
                    <p class="panel-heading"><?php echo e(__('Financial Overview')); ?></p>
                    <p class="mt-2 text-sm text-muted"><?php echo e(__('Revenue, refunds, and profit breakdown.')); ?></p>
                </div>
                <button type="button" class="btn-secondary" onclick="window.print()"><?php echo e(__('Print')); ?></button>
            </div>

            <div class="mt-5 flex flex-wrap items-end gap-3">
                
                <?php for($y = now()->year - 2; $y <= now()->year; $y++): ?>
                    <a href="<?php echo e(route('admin.financial-report.index', ['year' => $y])); ?>"
                       class="<?php echo \Illuminate\Support\Arr::toCssClasses(['btn-secondary', 'ring-2 ring-brand/50 bg-brand/5' => $year === $y && !$startDate]); ?>">
                        <?php echo e($y); ?>

                    </a>
                <?php endfor; ?>

                
                <form method="get" action="<?php echo e(route('admin.financial-report.index')); ?>" class="flex flex-wrap items-end gap-3">
                    <div>
                        <label class="text-xs font-medium text-muted" for="start_date"><?php echo e(__('From')); ?></label>
                        <input type="date" id="start_date" name="start_date" value="<?php echo e($startDate); ?>" class="input-field mt-1">
                    </div>
                    <div>
                        <label class="text-xs font-medium text-muted" for="end_date"><?php echo e(__('To')); ?></label>
                        <input type="date" id="end_date" name="end_date" value="<?php echo e($endDate); ?>" class="input-field mt-1">
                    </div>
                    <button type="submit" class="btn-secondary"><?php echo e(__('Filter')); ?></button>
                    <a href="<?php echo e(route('admin.financial-report.index')); ?>" class="btn-secondary"><?php echo e(__('Reset')); ?></a>
                </form>
            </div>
        </div>

        
        <div class="grid gap-4 sm:grid-cols-2 lg:grid-cols-5">
            <div class="panel p-5">
                <p class="text-xs font-semibold uppercase tracking-widest text-muted"><?php echo e(__('Total Revenue')); ?></p>
                <p class="mt-2 text-2xl font-bold text-emerald-600"><?php echo e($currencySymbol); ?><?php echo e(number_format($totalRevenue, 2)); ?></p>
            </div>
            <div class="panel p-5">
                <p class="text-xs font-semibold uppercase tracking-widest text-muted"><?php echo e(__('Refunds')); ?></p>
                <p class="mt-2 text-2xl font-bold text-red-500"><?php echo e($currencySymbol); ?><?php echo e(number_format($totalRefunds, 2)); ?></p>
            </div>
            <div class="panel p-5">
                <p class="text-xs font-semibold uppercase tracking-widest text-muted"><?php echo e(__('Net Revenue')); ?></p>
                <p class="mt-2 text-2xl font-bold <?php echo e($netRevenue >= 0 ? 'text-emerald-600' : 'text-red-500'); ?>"><?php echo e($currencySymbol); ?><?php echo e(number_format($netRevenue, 2)); ?></p>
            </div>
            <div class="panel p-5">
                <p class="text-xs font-semibold uppercase tracking-widest text-muted"><?php echo e(__('Orders')); ?></p>
                <p class="mt-2 text-2xl font-bold text-ink"><?php echo e(number_format($totalOrders)); ?></p>
            </div>
            <div class="panel p-5">
                <p class="text-xs font-semibold uppercase tracking-widest text-muted"><?php echo e(__('Avg Order')); ?></p>
                <p class="mt-2 text-2xl font-bold text-ink"><?php echo e($currencySymbol); ?><?php echo e(number_format($avgOrderValue, 2)); ?></p>
            </div>
        </div>

        
        <div class="grid gap-6 md:grid-cols-2">
            <div class="panel p-6">
                <p class="text-sm font-semibold text-ink mb-4"><?php echo e(__('Monthly Revenue vs Refunds')); ?></p>
                <div id="revenue-bar-chart" class="w-full h-64"></div>
            </div>
            <div class="panel p-6">
                <p class="text-sm font-semibold text-ink mb-4"><?php echo e(__('Revenue by Plan')); ?></p>
                <?php if(count($revenueByPlan) > 0): ?>
                    <div id="plan-donut-chart" class="w-full h-64"></div>
                <?php else: ?>
                    <p class="text-sm text-muted py-10 text-center"><?php echo e(__('No data for this period.')); ?></p>
                <?php endif; ?>
            </div>
        </div>

        
        <div class="panel p-6">
            <p class="panel-heading mb-4"><?php echo e(__('Monthly Breakdown')); ?></p>
            <div class="overflow-x-auto">
                <table class="w-full text-left text-sm">
                    <thead class="text-xs uppercase tracking-[0.2em] text-muted">
                        <tr>
                            <th class="pb-3"><?php echo e(__('Month')); ?></th>
                            <th class="pb-3 text-right"><?php echo e(__('Revenue')); ?></th>
                            <th class="pb-3 text-right"><?php echo e(__('Refunds')); ?></th>
                            <th class="pb-3 text-right"><?php echo e(__('Net')); ?></th>
                            <th class="pb-3 text-right"><?php echo e(__('Orders')); ?></th>
                            <th class="pb-3 text-right"><?php echo e(__('Avg Order')); ?></th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-border/60">
                        <?php $__currentLoopData = $months; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $month): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr class="<?php echo e($month['revenue'] == 0 && $month['refunds'] == 0 ? 'text-muted/60' : ''); ?>">
                                <td class="py-3 font-medium"><?php echo e($month['label']); ?></td>
                                <td class="py-3 text-right text-emerald-600"><?php echo e($currencySymbol); ?><?php echo e(number_format($month['revenue'], 2)); ?></td>
                                <td class="py-3 text-right text-red-500"><?php echo e($currencySymbol); ?><?php echo e(number_format($month['refunds'], 2)); ?></td>
                                <td class="py-3 text-right font-medium <?php echo e($month['net'] >= 0 ? 'text-emerald-600' : 'text-red-500'); ?>"><?php echo e($currencySymbol); ?><?php echo e(number_format($month['net'], 2)); ?></td>
                                <td class="py-3 text-right"><?php echo e($month['orders']); ?></td>
                                <td class="py-3 text-right"><?php echo e($currencySymbol); ?><?php echo e(number_format($month['avg'], 2)); ?></td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                    <tfoot class="border-t-2 border-border font-semibold">
                        <tr>
                            <td class="py-3"><?php echo e(__('Total')); ?></td>
                            <td class="py-3 text-right text-emerald-600"><?php echo e($currencySymbol); ?><?php echo e(number_format($totalRevenue, 2)); ?></td>
                            <td class="py-3 text-right text-red-500"><?php echo e($currencySymbol); ?><?php echo e(number_format($totalRefunds, 2)); ?></td>
                            <td class="py-3 text-right <?php echo e($netRevenue >= 0 ? 'text-emerald-600' : 'text-red-500'); ?>"><?php echo e($currencySymbol); ?><?php echo e(number_format($netRevenue, 2)); ?></td>
                            <td class="py-3 text-right"><?php echo e(number_format($totalOrders)); ?></td>
                            <td class="py-3 text-right"><?php echo e($currencySymbol); ?><?php echo e(number_format($avgOrderValue, 2)); ?></td>
                        </tr>
                    </tfoot>
                </table>
            </div>
        </div>
    </div>

    <?php $__env->startPush('scripts'); ?>
    <script src="https://cdn.jsdelivr.net/npm/apexcharts"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Monthly Revenue vs Refunds bar chart
            const monthLabels = <?php echo json_encode(array_map(fn ($m) => $m['short'], $months), 512) ?>;
            const revenueData = <?php echo json_encode(array_map(fn ($m) => $m['revenue'], $months), 512) ?>;
            const refundData = <?php echo json_encode(array_map(fn ($m) => $m['refunds'], $months), 512) ?>;

            new ApexCharts(document.querySelector('#revenue-bar-chart'), {
                series: [
                    { name: 'Revenue', data: revenueData },
                    { name: 'Refunds', data: refundData }
                ],
                chart: {
                    type: 'bar',
                    height: 250,
                    toolbar: { show: false },
                    fontFamily: 'inherit'
                },
                plotOptions: {
                    bar: { borderRadius: 4, columnWidth: '60%' }
                },
                xaxis: { categories: monthLabels },
                colors: ['#10b981', '#ef4444'],
                dataLabels: { enabled: false },
                theme: { mode: document.documentElement.classList.contains('dark') ? 'dark' : 'light' }
            }).render();

            // Revenue by Plan donut
            <?php if(count($revenueByPlan) > 0): ?>
            new ApexCharts(document.querySelector('#plan-donut-chart'), {
                series: <?php echo json_encode(array_column($revenueByPlan, 'value'), 512) ?>,
                labels: <?php echo json_encode(array_column($revenueByPlan, 'label'), 512) ?>,
                chart: {
                    type: 'donut',
                    height: 250,
                    toolbar: { show: false },
                    fontFamily: 'inherit'
                },
                legend: { position: 'bottom' },
                colors: ['#3b82f6', '#10b981', '#f59e0b', '#ef4444', '#8b5cf6', '#ec4899', '#14b8a6', '#f97316'],
                dataLabels: { enabled: false },
                theme: { mode: document.documentElement.classList.contains('dark') ? 'dark' : 'light' }
            }).render();
            <?php endif; ?>
        });
    </script>
    <?php $__env->stopPush(); ?>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal91fdd17964e43374ae18c674f95cdaa3)): ?>
<?php $attributes = $__attributesOriginal91fdd17964e43374ae18c674f95cdaa3; ?>
<?php unset($__attributesOriginal91fdd17964e43374ae18c674f95cdaa3); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal91fdd17964e43374ae18c674f95cdaa3)): ?>
<?php $component = $__componentOriginal91fdd17964e43374ae18c674f95cdaa3; ?>
<?php unset($__componentOriginal91fdd17964e43374ae18c674f95cdaa3); ?>
<?php endif; ?>
<?php /**PATH /home/acehost1/public_html/photobee.acehosting.in/resources/views/admin/financial-report/index.blade.php ENDPATH**/ ?>