<?php $__env->startSection('title', __('Login') . ' - ' . config('app.name', 'SnapNest')); ?>
<?php $__env->startSection('hide_header', true); ?>
<?php $__env->startSection('hide_footer', true); ?>

<?php $__env->startSection('content'); ?>
<div class="h-screen bg-background text-foreground selection:bg-primary/30 flex overflow-hidden relative transition-colors duration-500">

    <!-- Top Controls (Optional since header might be present, but following design) -->
    <!-- <div class="absolute top-8 right-8 z-50 flex items-center gap-2 bg-background/50 backdrop-blur-xl p-1 rounded-2xl border border-border/50 shadow-2xl">...</div> -->

    <!-- Left Side: Immersive Visuals -->
    <div class="hidden lg:flex lg:w-1/2 relative flex-col justify-between p-16 overflow-hidden bg-muted/30 dark:bg-zinc-900/50">
        <div class="absolute inset-0 bg-[radial-gradient(circle_at_30%_50%,rgba(var(--primary),0.1),transparent)] pointer-events-none"></div>
        <div class="absolute top-0 right-0 w-px h-full bg-gradient-to-b from-transparent via-border to-transparent"></div>

        <div class="relative z-10 space-y-12">
            <div
                x-data="{ shown: false }"
                x-init="setTimeout(() => shown = true, 0)"
                class="space-y-6 transition-all duration-700 transform"
                :class="shown ? 'opacity-100 translate-x-0' : 'opacity-0 -translate-x-5'">
                <h2 class="text-5xl font-bold leading-tight tracking-tight text-foreground">
                    <?php echo e(__('THE STAGE')); ?> <br />
                    <span class="text-primary italic"><?php echo e(__('IS YOURS.')); ?></span>
                </h2>
                <p class="text-muted-foreground text-lg max-w-sm font-medium">
                    <?php echo e(__('Log in to access your elite studio dashboard and AI-powered delivery tools.')); ?>

                </p>
            </div>

            <div class="grid grid-cols-2 gap-4">
                <?php $__currentLoopData = [
                    ['label' => "FACE SEARCH", 'icon' => '<circle cx="11" cy="11" r="8"/><path d="m21 21-4.3-4.3"/>', 'color' => "text-blue-500"],
                    ['label' => "EVENT GALLERY", 'icon' => '<rect width="18" height="18" x="3" y="3" rx="2" ry="2"/><circle cx="9" cy="9" r="2"/><path d="m21 15-3.086-3.086a2 2 0 0 0-2.828 0L6 21"/>', 'color' => "text-purple-500"],
                    ['label' => "SECURE SHARE", 'icon' => '<path d="M12 22s8-4 8-10V5l-8-3-8 3v7c0 6 8 10 8 10"/><path d="m9 12 2 2 4-4"/>', 'color' => "text-emerald-500"],
                    ['label' => "WATERMARK", 'icon' => '<path d="M14.5 4h-5L7 7H4a2 2 0 0 0-2 2v9a2 2 0 0 0 2 2h16a2 2 0 0 0 2-2V9a2 2 0 0 0-2-2h-3l-2.5-3z"/><circle cx="12" cy="13" r="3"/>', 'color' => "text-orange-500"],
                ]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="p-4 rounded-xl bg-background/50 border border-border/50 hover:border-primary/20 transition-all group">
                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-4 w-4 <?php echo e($item['color']); ?> mb-3 group-hover:scale-110 transition-transform"><?php echo $item['icon']; ?></svg>
                        <p class="text-[9px] font-bold tracking-widest uppercase text-muted-foreground"><?php echo e($item['label']); ?></p>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>

        <div class="relative z-10">
            <p class="text-muted-foreground/60 text-[10px] font-bold tracking-widest uppercase flex items-center gap-3">
                <span class="h-px w-8 bg-border"></span>
                <?php echo e(__('Elite Photography Standards')); ?> <?php echo e(date('Y')); ?>

            </p>
        </div>
    </div>

    <!-- Right Side: Auth Form -->
    <div class="flex-1 flex flex-col justify-center items-center p-8 md:p-16 bg-background relative border-l border-border/50">
        <div class="absolute inset-0 overflow-hidden pointer-events-none">
            <div class="absolute top-[20%] right-[-10%] w-96 h-96 bg-primary/5 blur-[120px] rounded-full"></div>
        </div>

        <div class="w-full max-w-sm space-y-8 relative z-10 text-foreground">
            <div class="space-y-2 lg:hidden mb-12">
                 <a href="<?php echo e(url('/')); ?>">
                    <?php echo $__env->make('components.frontend.logo', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                </a>
            </div>

            <div class="space-y-3">
                <h1 class="text-3xl font-bold tracking-tight">
                    <?php echo e(__('Welcome')); ?> <br />
                    <span class="text-primary italic"><?php echo e(__('Back.')); ?></span>
                </h1>
                <p class="text-muted-foreground text-xs font-medium"><?php echo e(__('Welcome back, photographer. Let\'s get to work.')); ?></p>
            </div>

            <?php if(session('error')): ?>
                <div class="rounded-xl border border-red-200 bg-red-50 p-3 text-xs font-medium text-red-700 dark:border-red-800 dark:bg-red-900/30 dark:text-red-400">
                    <?php echo e(session('error')); ?>

                </div>
            <?php endif; ?>
            <?php if(session('status')): ?>
                <div class="rounded-xl border border-emerald-200 bg-emerald-50 p-3 text-xs font-medium text-emerald-700 dark:border-emerald-800 dark:bg-emerald-900/30 dark:text-emerald-400">
                    <?php echo e(session('status')); ?>

                </div>
            <?php endif; ?>

            <form method="POST" action="<?php echo e(route('login')); ?>" class="space-y-6">
                <?php echo csrf_field(); ?>
                <div class="space-y-4">
                    <div class="space-y-2 group">
                        <label class="text-[10px] font-bold uppercase tracking-widest text-muted-foreground group-focus-within:text-primary transition-colors flex items-center gap-2">
                           <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-3 w-3"><rect width="20" height="16" x="2" y="4" rx="2"/><path d="m22 7-8.97 5.7a1.94 1.94 0 0 1-2.06 0L2 7"/></svg> <?php echo e(__('Email Address')); ?>

                        </label>
                        <input
                            type="email"
                            name="email"
                            placeholder="<?php echo e(__('name@studio.com')); ?>"
                            class="flex h-12 w-full bg-muted/30 border-border/50 rounded-xl border border-input px-3 py-1 shadow-sm transition-all font-medium text-sm text-foreground placeholder:text-muted-foreground focus-visible:outline-none focus:border-primary/50 focus:ring-0"
                            required
                            autofocus
                            value="<?php echo e(old('email')); ?>"
                        />
                        <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span class="text-red-500 text-xs mt-1"><?php echo e($message); ?></span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div class="space-y-2 group">
                        <div class="flex justify-between items-center">
                            <label class="text-[10px] font-bold uppercase tracking-widest text-muted-foreground group-focus-within:text-primary transition-colors flex items-center gap-2">
                               <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-3 w-3"><rect width="18" height="11" x="3" y="11" rx="2" ry="2"/><path d="M7 11V7a5 5 0 0 1 10 0v4"/></svg> <?php echo e(__('Password')); ?>

                            </label>
                            <?php if(Route::has('password.request')): ?>
                                <a href="<?php echo e(route('password.request')); ?>" class="text-[10px] uppercase font-bold tracking-widest text-primary/60 hover:text-primary">
                                    <?php echo e(__('Forgot?')); ?>

                                </a>
                            <?php endif; ?>
                        </div>
                        <input
                            type="password"
                            name="password"
                            class="flex h-12 w-full bg-muted/30 border-border/50 rounded-xl border border-input px-3 py-1 shadow-sm transition-all text-sm text-foreground focus-visible:outline-none focus:border-primary/50 focus:ring-0"
                            required
                        />
                         <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span class="text-red-500 text-xs mt-1"><?php echo e($message); ?></span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                     <!-- Remember Me -->
                    <div class="block mt-4">
                        <label for="remember_me" class="inline-flex items-center">
                            <input id="remember_me" type="checkbox" class="rounded border-gray-300 text-indigo-600 shadow-sm focus:ring-indigo-500" name="remember">
                            <span class="ms-2 text-sm text-gray-600 dark:text-gray-400"><?php echo e(__('Remember me')); ?></span>
                        </label>
                    </div>
                </div>

                <?php if(!empty($captchaEnabled) && !empty($captchaSiteKey)): ?>
                    <div class="g-recaptcha" data-sitekey="<?php echo e($captchaSiteKey); ?>"></div>
                    <?php $__errorArgs = ['g-recaptcha-response'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <span class="text-red-500 text-xs"><?php echo e($message); ?></span>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                <?php endif; ?>

                <button type="submit" class="w-full h-12 rounded-xl bg-primary hover:bg-primary/90 text-base font-bold shadow-lg shadow-primary/20 transition-all text-primary-foreground">
                    <?php echo e(__('Enter Dashboard')); ?>

                </button>
            </form>

            <?php if(!empty($socialProviders) && count($socialProviders) > 0): ?>
                <div class="relative pt-2">
                    <div class="absolute inset-0 flex items-center">
                        <div class="w-full border-t border-border/50"></div>
                    </div>
                    <div class="relative flex justify-center text-[9px] font-bold uppercase tracking-widest">
                        <span class="bg-background px-4 text-muted-foreground"><?php echo e(__('Or continue with')); ?></span>
                    </div>
                </div>

                <div class="grid grid-cols-<?php echo e(min(count($socialProviders), 2)); ?> gap-3">
                    <?php $__currentLoopData = $socialProviders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sp): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <a href="<?php echo e(route('social.redirect', $sp['key'])); ?>" class="h-11 rounded-xl bg-muted/30 border border-border/50 flex items-center justify-center gap-2 hover:bg-muted/50 transition-all group">
                            <span class="text-[10px] font-bold uppercase tracking-widest text-muted-foreground group-hover:text-foreground transition-colors"><?php echo e($sp['label']); ?></span>
                        </a>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            <?php endif; ?>

            <p class="text-center text-[11px] font-medium text-zinc-600">
                <?php echo e(__('New to the platform?')); ?>

                <a href="<?php echo e(route('register')); ?>" class="text-primary font-bold hover:underline ml-1">
                    <?php echo e(__('Apply for Access')); ?>

                </a>
            </p>
        </div>
    </div>
</div>
<?php if(!empty($captchaEnabled) && !empty($captchaSiteKey)): ?>
    <script src="https://www.google.com/recaptcha/api.js" async defer></script>
<?php endif; ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.frontend', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/acehost1/public_html/photobee.acehosting.in/resources/views/auth/login.blade.php ENDPATH**/ ?>