<?php $__env->startSection('title', ($page->title ?? __('About Us')) . ' - ' . config('app.name', 'SnapNest')); ?>

<?php
    $c = $page->content ?? [];
?>

<?php $__env->startSection('content'); ?>
    <!-- Hero Section -->
    <section class="relative pt-32 pb-20 overflow-hidden">
        <div class="absolute top-0 left-1/2 -translate-x-1/2 w-full h-full -z-10">
            <div class="absolute top-0 right-0 w-[50%] h-[50%] bg-primary/5 blur-[120px] rounded-full"></div>
            <div class="absolute bottom-0 left-0 w-[50%] h-[50%] bg-accent/5 blur-[120px] rounded-full"></div>
        </div>

        <div class="container mx-auto px-4">
            <div class="max-w-4xl mx-auto text-center space-y-8">
                <div
                    x-data="{ shown: false }"
                    x-init="setTimeout(() => shown = true, 0)"
                    class="inline-flex items-center gap-2 px-4 py-1.5 rounded-full bg-primary/10 border border-primary/20 text-primary text-xs font-bold uppercase tracking-widest transition-all duration-700 transform"
                    :class="shown ? 'opacity-100 translate-y-0' : 'opacity-0 translate-y-5'">
                    <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-3.5 w-3.5"><path d="m12 3-1.912 5.813a2 2 0 0 1-1.275 1.275L3 12l5.813 1.912a2 2 0 0 1 1.275 1.275L12 21l1.912-5.813a2 2 0 0 1 1.275-1.275L21 12l-5.813-1.912a2 2 0 0 1-1.275-1.275L12 3Z"/></svg>
                    <?php echo e($c['badge_text'] ?? __('Our Mission')); ?>

                </div>

                <h1
                    x-data="{ shown: false }"
                    x-init="setTimeout(() => shown = true, 100)"
                    class="text-3xl sm:text-5xl md:text-7xl font-bold tracking-tight text-foreground text-balance transition-all duration-700 transform"
                    :class="shown ? 'opacity-100 translate-y-0' : 'opacity-0 translate-y-5'">
                    <?php echo e($c['hero_title'] ?? __('Redefining the')); ?> <br />
                    <span class="bg-gradient-to-r from-primary to-accent bg-clip-text text-transparent italic"><?php echo e($c['hero_title_highlight'] ?? __('Moment of Delivery.')); ?></span>
                </h1>

                <p
                    x-data="{ shown: false }"
                    x-init="setTimeout(() => shown = true, 200)"
                    class="text-xl text-muted-foreground leading-relaxed max-w-2xl mx-auto transition-all duration-700 transform"
                    :class="shown ? 'opacity-100 translate-y-0' : 'opacity-0 translate-y-5'">
                    <?php echo e($c['hero_description'] ?? __(config('app.name', 'SnapNest') . ' was born from a simple observation: photographers spend too much time on logistics and not enough time behind the lens. We\'re here to change that.')); ?>

                </p>
            </div>
        </div>
    </section>

    <!-- Stats Section -->
    <section class="py-20 bg-muted/30 border-y border-border/50">
        <div class="container mx-auto px-4">
            <div class="grid grid-cols-2 md:grid-cols-4 gap-8">
                <?php
                    $stats = $c['stats'] ?? [
                        ['label' => __('Photos Delivered'), 'value' => '50M+'],
                        ['label' => __('Active Studios'), 'value' => '2,000+'],
                        ['label' => __('Countries'), 'value' => '45+'],
                        ['label' => __('Uptime'), 'value' => '99.99%'],
                    ];
                    $statIcons = [
                        '<path d="M14.5 4h-5L7 7H4a2 2 0 0 0-2 2v9a2 2 0 0 0 2 2h16a2 2 0 0 0 2-2V9a2 2 0 0 0-2-2h-3l-2.5-3z"/><circle cx="12" cy="13" r="3"/>',
                        '<path d="M16 21v-2a4 4 0 0 0-4-4H6a4 4 0 0 0-4 4v2"/><circle cx="9" cy="7" r="4"/><path d="M22 21v-2a4 4 0 0 0-3-3.87"/><path d="M16 3.13a4 4 0 0 1 0 7.75"/>',
                        '<circle cx="12" cy="12" r="10"/><path d="M12 2a14.5 14.5 0 0 0 0 20 14.5 14.5 0 0 0 0-20"/><path d="M2 12h20"/>',
                        '<path d="M13 2L3 14h9l-1 8 10-12h-9l1-8z"/>',
                    ];
                ?>
                <?php $__currentLoopData = $stats; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $stat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div
                        x-data="{ shown: false }"
                        x-intersect="shown = true"
                        style="transition-delay: <?php echo e($index * 100); ?>ms"
                        class="text-center space-y-2 transition-all duration-700 transform"
                        :class="shown ? 'opacity-100 scale-100' : 'opacity-0 scale-90'">
                        <div class="mx-auto h-12 w-12 rounded-2xl bg-background border border-border/50 flex items-center justify-center text-primary shadow-sm mb-4">
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-6 w-6"><?php echo $statIcons[$index] ?? ''; ?></svg>
                        </div>
                        <p class="text-3xl font-bold text-foreground"><?php echo e($stat['value'] ?? ''); ?></p>
                        <p class="text-sm font-bold uppercase tracking-widest text-muted-foreground/60"><?php echo e($stat['label'] ?? ''); ?></p>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </section>

    <!-- Story Section -->
    <section class="py-16 md:py-32">
        <div class="container mx-auto px-4">
            <div class="grid grid-cols-1 lg:grid-cols-2 gap-12 lg:gap-20 items-center">
                <div class="space-y-8">
                    <h2 class="text-4xl font-bold tracking-tight"><?php echo e($c['story_title'] ?? __('How it started.')); ?></h2>
                    <div class="space-y-6 text-lg text-muted-foreground leading-relaxed">
                        <p>
                            <?php echo e($c['story_paragraph_1'] ?? __('In 2022, our founders noticed a recurring problem at high-profile events: guests would wait days, even weeks, to receive their professional photos. The "hype" of the event had long passed by the time the gallery link arrived.')); ?>

                        </p>
                        <p>
                            <?php echo e($c['story_paragraph_2'] ?? __('We built ' . config('app.name', 'SnapNest') . ' to bridge that gap. By leveraging advanced facial recognition and automated delivery workflows, we\'ve enabled photographers to share memories while they are still fresh—creating a "wow" moment for every guest.')); ?>

                        </p>
                    </div>

                    <div class="grid grid-cols-2 gap-6 pt-6">
                        <div class="p-6 rounded-3xl bg-card border border-border shadow-sm">
                            <svg xmlns="http://www.w3.org/2000/svg" width="32" height="32" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-8 w-8 text-primary mb-4"><path d="M19 14c1.49-1.28 3.6-2.34 4.54-3.26l.04-.04v-1.7C19.7 5.76 13.9.77 12 1.34c-1.9-.57-7.7 4.42-11.58 7.66v1.7l.04.04c.94.92 3.05 1.98 4.54 3.26C3 15.1 1 19.33 1 20.7V22h.3c.6 0 1.25-.13 1.91-.35C5.12 20.7 7.9 19 12 18.26c4.1.74 6.88 2.44 8.79 3.39.66.22 1.31.35 1.91.35h.3v-1.3c0-1.37-2-5.6-4-6.7Z"/></svg>
                            <h3 class="font-bold mb-2"><?php echo e($c['card_1_title'] ?? __('Passion First')); ?></h3>
                            <p class="text-sm text-muted-foreground"><?php echo e($c['card_1_description'] ?? __('We are photographers at heart, building for photographers.')); ?></p>
                        </div>
                        <div class="p-6 rounded-3xl bg-card border border-border shadow-sm">
                            <svg xmlns="http://www.w3.org/2000/svg" width="32" height="32" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-8 w-8 text-primary mb-4"><circle cx="12" cy="8" r="7"/><polyline points="8.21 13.89 7 23 12 20 17 23 15.79 13.88"/></svg>
                            <h3 class="font-bold mb-2"><?php echo e($c['card_2_title'] ?? __('Pixel Perfect')); ?></h3>
                            <p class="text-sm text-muted-foreground"><?php echo e($c['card_2_description'] ?? __('Every feature is crafted with meticulous attention to detail.')); ?></p>
                        </div>
                    </div>
                </div>

                <div class="relative">
                    <div class="aspect-square rounded-[3rem] bg-gradient-to-tr from-primary/20 via-primary/5 to-accent/20 border border-border/50 overflow-hidden relative group">
                        <div class="absolute inset-0 flex items-center justify-center">
                            <svg xmlns="http://www.w3.org/2000/svg" width="128" height="128" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" class="h-32 w-32 text-primary/10 group-hover:scale-110 transition-transform duration-700"><path d="M14.5 4h-5L7 7H4a2 2 0 0 0-2 2v9a2 2 0 0 0 2 2h16a2 2 0 0 0 2-2V9a2 2 0 0 0-2-2h-3l-2.5-3z"/><circle cx="12" cy="13" r="3"/></svg>
                        </div>
                        <!-- Floating accents -->
                        <div class="absolute top-10 right-10 p-4 bg-background/80 backdrop-blur-xl border border-border rounded-2xl shadow-2xl">
                            <div class="flex items-center gap-3">
                                <div class="h-2 w-2 rounded-full bg-emerald-500 animate-pulse"></div>
                                <span class="text-[10px] font-bold uppercase tracking-widest"><?php echo e(__('Global Nodes Online')); ?></span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.frontend', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/acehost1/public_html/photobee.acehosting.in/resources/views/frontend/about.blade.php ENDPATH**/ ?>