<?php $attributes ??= new \Illuminate\View\ComponentAttributeBag;

$__newAttributes = [];
$__propNames = \Illuminate\View\ComponentAttributeBag::extractPropNames((['title' => 'Dashboard', 'subtitle' => null]));

foreach ($attributes->all() as $__key => $__value) {
    if (in_array($__key, $__propNames)) {
        $$__key = $$__key ?? $__value;
    } else {
        $__newAttributes[$__key] = $__value;
    }
}

$attributes = new \Illuminate\View\ComponentAttributeBag($__newAttributes);

unset($__propNames);
unset($__newAttributes);

foreach (array_filter((['title' => 'Dashboard', 'subtitle' => null]), 'is_string', ARRAY_FILTER_USE_KEY) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
}

$__defined_vars = get_defined_vars();

foreach ($attributes->all() as $__key => $__value) {
    if (array_key_exists($__key, $__defined_vars)) unset($$__key);
}

unset($__defined_vars, $__key, $__value); ?>

<?php
    $brandName = trim((string) ($siteSettings['site_name'] ?? ''));
    $brandName = $brandName !== '' ? $brandName : config('app.name', 'SnapNest');
    $adminLogo = $siteSettings['admin_logo'] ?? null;
    $favicon = $siteSettings['favicon'] ?? null;
?>

<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>" dir="<?php echo e($languageDirection ?? 'ltr'); ?>" class="h-full overflow-hidden" data-theme="light" data-admin-theme="default">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

        <title><?php echo e($title); ?> - <?php echo e($brandName); ?></title>
        <?php if($favicon): ?>
            <link rel="icon" href="<?php echo e(asset('storage/' . $favicon)); ?>">
        <?php endif; ?>

        <link rel="preconnect" href="https://fonts.googleapis.com">
        <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
        <link href="https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:ital,wght@0,200..800;1,200..800&display=swap" rel="stylesheet">
        <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css', 'resources/js/app.js']); ?>
        <?php echo $__env->make('partials.extensions-head', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
        <script>if(localStorage.getItem('sidebar-collapsed')==='true')document.documentElement.setAttribute('data-sidebar-collapsed','true');</script>
    </head>
    <body class="h-full overflow-hidden font-sans text-ink bg-surface antialiased">
        <div class="fixed inset-0 bg-grid opacity-30 pointer-events-none"></div>

        <div class="relative flex h-full min-h-0">
            <aside class="admin-sidebar fixed inset-y-0 left-0 z-40 w-72 -translate-x-full overflow-y-auto overscroll-contain border-r border-border/70 bg-surface/95 backdrop-blur transition-all duration-300 lg:static lg:translate-x-0">
                <div class="px-4 pt-2 pb-1 flex items-center justify-between">
                    <a href="<?php echo e(route('admin.dashboard')); ?>" class="flex items-center gap-3 sidebar-brand">
                        <?php if($adminLogo): ?>
                            <img src="<?php echo e(asset('storage/' . $adminLogo)); ?>" alt="<?php echo e($brandName); ?>" class="h-12 w-auto object-contain">
                        <?php else: ?>
                            <div class="flex h-9 w-9 shrink-0 items-center justify-center rounded-xl bg-accent text-white shadow-soft">
                                <svg viewBox="0 0 24 24" class="h-5 w-5" fill="none" stroke="currentColor" stroke-width="1.8" stroke-linecap="round" stroke-linejoin="round">
                                    <circle cx="12" cy="12" r="8"></circle>
                                    <circle cx="12" cy="12" r="3"></circle>
                                    <path d="M12 4l3.5 6h-7l3.5-6z"></path>
                                </svg>
                            </div>
                            <span class="text-lg font-bold tracking-tight text-ink truncate sidebar-label"><?php echo e($brandName); ?></span>
                        <?php endif; ?>
                    </a>
                    <button type="button" class="hidden lg:flex h-7 w-7 items-center justify-center rounded-lg text-muted hover:text-ink hover:bg-surface-2/80 transition" data-sidebar-collapse-toggle aria-label="<?php echo e(__('Toggle sidebar')); ?>">
                        <svg viewBox="0 0 24 24" class="h-4 w-4 sidebar-collapse-icon" fill="none" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round">
                            <rect x="3" y="3" width="18" height="18" rx="2"/>
                            <path d="M9 3v18"/>
                        </svg>
                    </button>
                </div>

                <nav class="px-4 pb-6">
                    <?php $isAdmin = auth()->user()->hasRole(['Super Admin', 'Admin']); ?>

                    
                    <div>
                        <div class="mt-3 space-y-1">
                            <a href="<?php echo e(route('admin.dashboard')); ?>" class="<?php echo \Illuminate\Support\Arr::toCssClasses(['nav-item', 'nav-item-active' => request()->routeIs('admin.dashboard')]); ?>">
                                <svg viewBox="0 0 24 24" class="h-4 w-4" fill="none" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round">
                                    <rect x="3" y="3" width="7" height="7" rx="1.5"></rect>
                                    <rect x="14" y="3" width="7" height="7" rx="1.5"></rect>
                                    <rect x="3" y="14" width="7" height="7" rx="1.5"></rect>
                                    <rect x="14" y="14" width="7" height="7" rx="1.5"></rect>
                                </svg>
                                <span><?php echo e(__('Dashboard')); ?></span>
                            </a>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('viewAny', \App\Models\Event::class)): ?>
                            <a href="<?php echo e(route('admin.events.index')); ?>" class="<?php echo \Illuminate\Support\Arr::toCssClasses(['nav-item', 'nav-item-active' => request()->routeIs('admin.events.*')]); ?>">
                                <svg viewBox="0 0 24 24" class="h-4 w-4" fill="none" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round">
                                    <rect x="3" y="5" width="18" height="16" rx="2"></rect>
                                    <path d="M16 3v4"></path>
                                    <path d="M8 3v4"></path>
                                    <path d="M3 11h18"></path>
                                </svg>
                                <span><?php echo e(__('Events')); ?></span>
                            </a>
                            <?php endif; ?>
                            <?php if(!$isAdmin): ?>
                            <a href="<?php echo e(route('admin.usage.index')); ?>" class="<?php echo \Illuminate\Support\Arr::toCssClasses(['nav-item', 'nav-item-active' => request()->routeIs('admin.usage.*')]); ?>">
                                <svg viewBox="0 0 24 24" class="h-4 w-4" fill="none" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round">
                                    <path d="M12 20v-6M6 20V10M18 20V4"></path>
                                </svg>
                                <span><?php echo e(__('Plan Usage')); ?></span>
                            </a>
                            <?php endif; ?>
                            <a href="<?php echo e(route('admin.orders.index')); ?>" class="<?php echo \Illuminate\Support\Arr::toCssClasses(['nav-item', 'nav-item-active' => request()->routeIs('admin.orders.*')]); ?>">
                                <svg viewBox="0 0 24 24" class="h-4 w-4" fill="none" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round">
                                    <path d="M16 4h2a2 2 0 0 1 2 2v14a2 2 0 0 1-2 2H6a2 2 0 0 1-2-2V6a2 2 0 0 1 2-2h2"></path>
                                    <rect x="8" y="2" width="8" height="4" rx="1" ry="1"></rect>
                                    <path d="M9 14h6"></path>
                                    <path d="M9 18h6"></path>
                                    <path d="M9 10h6"></path>
                                </svg>
                                <span><?php echo e(__('Orders')); ?></span>
                            </a>
                        </div>
                    </div>

                    
                    <?php if(!$isAdmin): ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('viewAny', \App\Models\SupportTicket::class)): ?>
                    <div>
                        <p class="px-3 text-[11px] font-semibold uppercase tracking-widest text-muted/60"><?php echo e(__('Support')); ?></p>
                        <div class="mt-2 space-y-1">
                            <a href="<?php echo e(route('admin.support-tickets.index')); ?>" class="<?php echo \Illuminate\Support\Arr::toCssClasses(['nav-item', 'nav-item-active' => request()->routeIs('admin.support-tickets.*')]); ?>">
                                <svg viewBox="0 0 24 24" class="h-4 w-4" fill="none" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round">
                                    <path d="M21 15a2 2 0 0 1-2 2H7l-4 4V5a2 2 0 0 1 2-2h14a2 2 0 0 1 2 2z"></path>
                                </svg>
                                <span><?php echo e(__('Support Tickets')); ?></span>
                            </a>
                        </div>
                    </div>
                    <?php endif; ?>
                    <?php endif; ?>

                    
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any('viewAny', [\App\Models\User::class, \App\Models\UserDeleteRequest::class, \Spatie\Permission\Models\Role::class])): ?>
                    <div>
                        <p class="px-3 text-[11px] font-semibold uppercase tracking-widest text-muted/60"><?php echo e(__('Users')); ?></p>
                        <div class="mt-2 space-y-1">
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('viewAny', \App\Models\User::class)): ?>
                            <a href="<?php echo e(route('admin.users.index')); ?>" class="<?php echo \Illuminate\Support\Arr::toCssClasses(['nav-item', 'nav-item-active' => request()->routeIs('admin.users.*')]); ?>">
                                <svg viewBox="0 0 24 24" class="h-4 w-4" fill="none" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round">
                                    <circle cx="9" cy="8" r="3"></circle>
                                    <path d="M3 19c1.8-3 4.8-4.5 6-4.5s4.2 1.5 6 4.5"></path>
                                    <path d="M15.5 11a3 3 0 1 0 0-6"></path>
                                    <path d="M18 19c.6-1.1 1.6-2.2 3-3"></path>
                                </svg>
                                <span><?php echo e(__('Users')); ?></span>
                            </a>
                            <?php endif; ?>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('viewAny', \App\Models\UserDeleteRequest::class)): ?>
                            <a href="<?php echo e(route('admin.user-delete-requests.index')); ?>" class="<?php echo \Illuminate\Support\Arr::toCssClasses(['nav-item', 'nav-item-active' => request()->routeIs('admin.user-delete-requests.*')]); ?>">
                                <svg viewBox="0 0 24 24" class="h-4 w-4" fill="none" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round">
                                    <polyline points="3 6 5 6 21 6"></polyline>
                                    <path d="M19 6v14a2 2 0 0 1-2 2H7a2 2 0 0 1-2-2V6"></path>
                                    <path d="M10 11v6"></path>
                                    <path d="M14 11v6"></path>
                                    <path d="M9 6V4a1 1 0 0 1 1-1h4a1 1 0 0 1 1 1v2"></path>
                                </svg>
                                <span><?php echo e(__('Delete Requests')); ?></span>
                            </a>
                            <?php endif; ?>
                            <?php
                                $canViewRoles = \Illuminate\Support\Facades\Gate::allows('viewAny', \Spatie\Permission\Models\Role::class);
                                $canViewPermissions = \Illuminate\Support\Facades\Gate::allows('viewAny', \Spatie\Permission\Models\Permission::class);
                            ?>
                            <?php if($canViewRoles || $canViewPermissions): ?>
                            <a href="<?php echo e(route('admin.roles.index')); ?>" class="<?php echo \Illuminate\Support\Arr::toCssClasses(['nav-item', 'nav-item-active' => request()->routeIs('admin.roles.*', 'admin.permissions.*')]); ?>">
                                <svg viewBox="0 0 24 24" class="h-4 w-4" fill="none" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round">
                                    <path d="M12 3l7 4v5c0 4.2-3 7.9-7 9-4-1.1-7-4.8-7-9V7l7-4z"></path>
                                    <path d="M9 12l2 2 4-4"></path>
                                </svg>
                                <span><?php echo e(__('Roles & Permissions')); ?></span>
                            </a>
                            <?php endif; ?>
                        </div>
                    </div>
                    <?php endif; ?>

                    
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any('viewAny', [\App\Models\Plan::class, \App\Models\Coupon::class, \App\Models\PaymentGateway::class, \App\Models\Report::class])): ?>
                    <div>
                        <p class="px-3 text-[11px] font-semibold uppercase tracking-widest text-muted/60"><?php echo e(__('Business')); ?></p>
                        <div class="mt-2 space-y-1">
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('viewAny', \App\Models\Plan::class)): ?>
                            <a href="<?php echo e(route('admin.plans.index')); ?>" class="<?php echo \Illuminate\Support\Arr::toCssClasses(['nav-item', 'nav-item-active' => request()->routeIs('admin.plans.*')]); ?>">
                                <svg viewBox="0 0 24 24" class="h-4 w-4" fill="none" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round">
                                    <path d="M7 7h10"></path>
                                    <path d="M7 12h10"></path>
                                    <path d="M7 17h6"></path>
                                    <rect x="4" y="3" width="16" height="18" rx="2"></rect>
                                </svg>
                                <span><?php echo e(__('Plans')); ?></span>
                            </a>
                            <?php endif; ?>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('viewAny', \App\Models\Coupon::class)): ?>
                            <a href="<?php echo e(route('admin.coupons.index')); ?>" class="<?php echo \Illuminate\Support\Arr::toCssClasses(['nav-item', 'nav-item-active' => request()->routeIs('admin.coupons.*')]); ?>">
                                <svg viewBox="0 0 24 24" class="h-4 w-4" fill="none" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round">
                                    <path d="M4 4h16v6a2 2 0 0 0 0 4v6H4v-6a2 2 0 0 0 0-4V4z"></path>
                                    <path d="M9 8h6"></path>
                                    <path d="M9 16h6"></path>
                                </svg>
                                <span><?php echo e(__('Coupons')); ?></span>
                            </a>
                            <?php endif; ?>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('viewAny', \App\Models\PaymentGateway::class)): ?>
                            <a href="<?php echo e(route('admin.payment-gateways.index')); ?>" class="<?php echo \Illuminate\Support\Arr::toCssClasses(['nav-item', 'nav-item-active' => request()->routeIs('admin.payment-gateways.*')]); ?>">
                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" class="h-4 w-4" fill="none" stroke="currentColor" stroke-width="1.8" stroke-linecap="round" stroke-linejoin="round"><rect width="20" height="14" x="2" y="5" rx="2"/><line x1="2" x2="22" y1="10" y2="10"/></svg>
                                <span><?php echo e(__('Payment Gateways')); ?></span>
                            </a>
                            <?php endif; ?>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('viewAny', \App\Models\Report::class)): ?>
                            <a href="<?php echo e(route('admin.reports.index')); ?>" class="<?php echo \Illuminate\Support\Arr::toCssClasses(['nav-item', 'nav-item-active' => request()->routeIs('admin.reports.*')]); ?>">
                                <svg viewBox="0 0 24 24" class="h-4 w-4" fill="none" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round">
                                    <path d="M3 3v18h18"></path>
                                    <path d="M7 14l4-4 3 3 5-6"></path>
                                </svg>
                                <span><?php echo e(__('Reports')); ?></span>
                            </a>
                            <a href="<?php echo e(route('admin.financial-report.index')); ?>" class="<?php echo \Illuminate\Support\Arr::toCssClasses(['nav-item', 'nav-item-active' => request()->routeIs('admin.financial-report.*')]); ?>">
                                <svg viewBox="0 0 24 24" class="h-4 w-4" fill="none" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round">
                                    <path d="M12 2v20M17 5H9.5a3.5 3.5 0 0 0 0 7h5a3.5 3.5 0 0 1 0 7H6"></path>
                                </svg>
                                <span><?php echo e(__('P&L Book')); ?></span>
                            </a>
                            <?php endif; ?>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any('viewAny', [\App\Models\Plan::class, \App\Models\Coupon::class, \App\Models\Report::class, \App\Models\NewsletterSubscriber::class])): ?>
                            <a href="<?php echo e(route('admin.operations.index')); ?>" class="<?php echo \Illuminate\Support\Arr::toCssClasses(['nav-item', 'nav-item-active' => request()->routeIs('admin.operations.*', 'admin.support-tickets.*', 'admin.ticket-assignments.*', 'admin.faqs.*', 'admin.testimonials.*', 'admin.fact-stats.*', 'admin.blog-posts.*', 'admin.blog-categories.*', 'admin.countries.*', 'admin.states.*', 'admin.cities.*', 'admin.currencies.*', 'admin.languages.*', 'admin.newsletter-subscribers.*')]); ?>">
                                <svg viewBox="0 0 24 24" class="h-4 w-4" fill="none" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round">
                                    <rect x="3" y="3" width="7" height="7" rx="1.5"></rect>
                                    <rect x="14" y="3" width="7" height="7" rx="1.5"></rect>
                                    <rect x="3" y="14" width="7" height="7" rx="1.5"></rect>
                                    <path d="M17.5 14v7"></path>
                                    <path d="M14 17.5h7"></path>
                                </svg>
                                <span><?php echo e(__('Operations')); ?></span>
                            </a>
                            <?php endif; ?>
                        </div>
                    </div>
                    <?php endif; ?>

                    
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any('viewAny', [\App\Models\SystemSetting::class, \App\Models\SecuritySetting::class, \App\Models\ActivityLog::class])): ?>
                    <div>
                        <p class="px-3 text-[11px] font-semibold uppercase tracking-widest text-muted/60"><?php echo e(__('System')); ?></p>
                        <div class="mt-2 space-y-1">
                            <?php
                                $systemSettingsOpen = request()->routeIs('admin.system-settings.*', 'admin.security-settings.*', 'admin.themes.*');
                            ?>
                            <div x-data="{ open: <?php echo e($systemSettingsOpen ? 'true' : 'false'); ?> }">
                                <button type="button" @click="open = !open" class="<?php echo \Illuminate\Support\Arr::toCssClasses(['nav-item w-full justify-between', 'nav-item-active' => $systemSettingsOpen]); ?>">
                                    <span class="flex items-center gap-3">
                                        <svg viewBox="0 0 24 24" class="h-4 w-4" fill="none" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round">
                                            <circle cx="12" cy="12" r="3"></circle>
                                            <path d="M19.4 15a1.65 1.65 0 0 0 .33 1.82l.06.06a2 2 0 0 1-2.83 2.83l-.06-.06a1.65 1.65 0 0 0-1.82-.33 1.65 1.65 0 0 0-1 1.51V21a2 2 0 0 1-4 0v-.09A1.65 1.65 0 0 0 9 19.4a1.65 1.65 0 0 0-1.82.33l-.06.06a2 2 0 0 1-2.83-2.83l.06-.06A1.65 1.65 0 0 0 4.68 15a1.65 1.65 0 0 0-1.51-1H3a2 2 0 0 1 0-4h.09A1.65 1.65 0 0 0 4.6 9a1.65 1.65 0 0 0-.33-1.82l-.06-.06a2 2 0 0 1 2.83-2.83l.06.06A1.65 1.65 0 0 0 9 4.68a1.65 1.65 0 0 0 1-1.51V3a2 2 0 0 1 4 0v.09a1.65 1.65 0 0 0 1 1.51 1.65 1.65 0 0 0 1.82-.33l.06-.06a2 2 0 0 1 2.83 2.83l-.06.06A1.65 1.65 0 0 0 19.4 9a1.65 1.65 0 0 0 1.51 1H21a2 2 0 0 1 0 4h-.09a1.65 1.65 0 0 0-1.51 1z"></path>
                                        </svg>
                                        <span><?php echo e(__('System Settings')); ?></span>
                                    </span>
                                    <svg viewBox="0 0 24 24" class="h-4 w-4 transition-transform" :class="open ? 'rotate-90' : ''" fill="none" stroke="currentColor" stroke-width="1.6"><path d="M9 18l6-6-6-6"/></svg>
                                </button>
                                <div x-show="open" x-collapse class="ml-7 mt-1 space-y-1 border-l border-border/50 pl-3">
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('viewAny', \App\Models\SystemSetting::class)): ?>
                                    <a href="<?php echo e(route('admin.system-settings.index')); ?>" class="<?php echo \Illuminate\Support\Arr::toCssClasses(['nav-item text-sm', 'nav-item-active' => request()->routeIs('admin.system-settings.*')]); ?>">
                                        <span><?php echo e(__('System Config')); ?></span>
                                    </a>
                                    <?php endif; ?>
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('viewAny', \App\Models\SecuritySetting::class)): ?>
                                    <a href="<?php echo e(route('admin.security-settings.index')); ?>" class="<?php echo \Illuminate\Support\Arr::toCssClasses(['nav-item text-sm', 'nav-item-active' => request()->routeIs('admin.security-settings.*')]); ?>">
                                        <span><?php echo e(__('Security Settings')); ?></span>
                                    </a>
                                    <?php endif; ?>
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('viewAny', \App\Models\SystemSetting::class)): ?>
                                    <a href="<?php echo e(route('admin.themes.index')); ?>" class="<?php echo \Illuminate\Support\Arr::toCssClasses(['nav-item text-sm', 'nav-item-active' => request()->routeIs('admin.themes.*')]); ?>">
                                        <span><?php echo e(__('Theme')); ?></span>
                                    </a>
                                    <?php endif; ?>
                                </div>
                            </div>
                            <a href="<?php echo e(route('admin.system-hub.index')); ?>" class="<?php echo \Illuminate\Support\Arr::toCssClasses(['nav-item', 'nav-item-active' => request()->routeIs('admin.system-hub.*', 'admin.pages.*', 'admin.activity-logs.*', 'admin.system-logs.*', 'admin.security-audit-logs.*', 'admin.blocked-ips.*', 'admin.blocked-locations.*', 'admin.extensions.*')]); ?>">
                                <svg viewBox="0 0 24 24" class="h-4 w-4" fill="none" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round">
                                    <rect x="3" y="3" width="7" height="7" rx="1.5"></rect>
                                    <rect x="14" y="3" width="7" height="7" rx="1.5"></rect>
                                    <rect x="3" y="14" width="7" height="7" rx="1.5"></rect>
                                    <path d="M17.5 14v7"></path>
                                    <path d="M14 17.5h7"></path>
                                </svg>
                                <span><?php echo e(__('System Hub')); ?></span>
                            </a>
                        </div>
                    </div>
                    <?php endif; ?>

                    
                    <?php if(!$isAdmin): ?>
                    <?php
                        $currentUser = auth()->user();
                        $currentPlan = $currentUser->plan;
                        $userEventsCount = \App\Models\Event::where('created_by', $currentUser->id)->count();
                        $userActiveEvents = \App\Models\Event::where('created_by', $currentUser->id)->where('is_active', true)->count();
                        $userMediaCount = \App\Models\EventMedia::whereHas('event', fn($q) => $q->where('created_by', $currentUser->id))->count();
                    ?>
                    <div class="mt-6 space-y-3 sidebar-info-panel">
                        
                        <div class="mx-1 rounded-xl border border-border/50 overflow-hidden">
                            <div class="px-3.5 py-2 bg-muted/40 border-b border-border/40">
                                <p class="text-[10px] font-semibold uppercase tracking-widest text-muted/80"><?php echo e(__('Overview')); ?></p>
                            </div>
                            <div class="grid grid-cols-3 divide-x divide-border/40 bg-surface">
                                <div class="py-3 text-center">
                                    <p class="text-base font-bold text-ink leading-none"><?php echo e($userEventsCount); ?></p>
                                    <p class="text-[9px] text-muted mt-1 font-medium"><?php echo e(__('Events')); ?></p>
                                </div>
                                <div class="py-3 text-center">
                                    <p class="text-base font-bold text-primary leading-none"><?php echo e($userActiveEvents); ?></p>
                                    <p class="text-[9px] text-muted mt-1 font-medium"><?php echo e(__('Active')); ?></p>
                                </div>
                                <div class="py-3 text-center">
                                    <p class="text-base font-bold text-ink leading-none"><?php echo e($userMediaCount); ?></p>
                                    <p class="text-[9px] text-muted mt-1 font-medium"><?php echo e(__('Photos')); ?></p>
                                </div>
                            </div>
                        </div>

                        
                        <div class="mx-1 rounded-xl border border-primary/20 overflow-hidden">
                            <div class="px-3.5 py-2 bg-primary/5 border-b border-primary/15 flex items-center justify-between">
                                <p class="text-[10px] font-semibold uppercase tracking-widest text-primary/80"><?php echo e(__('Current Plan')); ?></p>
                                <span class="text-[9px] font-bold uppercase tracking-wider px-2 py-0.5 rounded-full bg-primary/10 text-primary border border-primary/20"><?php echo e($currentPlan?->name ?? __('Free')); ?></span>
                            </div>
                            <div class="px-3.5 py-2.5 bg-surface space-y-2">
                                <div class="flex justify-between items-center text-[11px]">
                                    <span class="text-muted flex items-center gap-1.5">
                                        <svg viewBox="0 0 24 24" class="h-3 w-3" fill="none" stroke="currentColor" stroke-width="1.8" stroke-linecap="round" stroke-linejoin="round"><rect x="3" y="5" width="18" height="16" rx="2"/><path d="M16 3v4"/><path d="M8 3v4"/><path d="M3 11h18"/></svg>
                                        <?php echo e(__('Events')); ?>

                                    </span>
                                    <span class="font-semibold text-ink text-[11px]"><?php echo e($currentPlan?->max_events === -1 ? __('Unlimited') : ($currentPlan?->max_events ?? 0)); ?></span>
                                </div>
                                <div class="flex justify-between items-center text-[11px]">
                                    <span class="text-muted flex items-center gap-1.5">
                                        <svg viewBox="0 0 24 24" class="h-3 w-3" fill="none" stroke="currentColor" stroke-width="1.8" stroke-linecap="round" stroke-linejoin="round"><path d="M21 15v4a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2v-4"/><polyline points="17 8 12 3 7 8"/><line x1="12" x2="12" y1="3" y2="15"/></svg>
                                        <?php echo e(__('Storage')); ?>

                                    </span>
                                    <span class="font-semibold text-ink text-[11px]"><?php echo e($currentPlan?->max_storage === -1 ? __('Unlimited') : (($currentPlan?->max_storage ?? 0) . ' MB')); ?></span>
                                </div>
                                <?php if($currentPlan?->has_watermark): ?>
                                <div class="flex justify-between items-center text-[11px]">
                                    <span class="text-muted flex items-center gap-1.5">
                                        <svg viewBox="0 0 24 24" class="h-3 w-3" fill="none" stroke="currentColor" stroke-width="1.8" stroke-linecap="round" stroke-linejoin="round"><path d="M12 22s8-4 8-10V5l-8-3-8 3v7c0 6 8 10 8 10"/></svg>
                                        <?php echo e(__('Watermark')); ?>

                                    </span>
                                    <span class="text-[9px] font-bold uppercase px-1.5 py-0.5 rounded-full bg-green-500/10 text-green-600"><?php echo e(__('Enabled')); ?></span>
                                </div>
                                <?php endif; ?>
                            </div>
                        </div>

                        
                        <div class="mx-1 rounded-xl border border-border/40 overflow-hidden">
                            <div class="px-3.5 py-2 bg-muted/30 border-b border-border/40">
                                <p class="text-[10px] font-semibold uppercase tracking-widest text-muted/80"><?php echo e(__('Getting Started')); ?></p>
                            </div>
                            <div class="px-3.5 py-2.5 bg-surface">
                                <ul class="space-y-2">
                                    <li class="flex items-start gap-2.5 text-[11px] text-muted leading-relaxed">
                                        <span class="flex h-4 w-4 shrink-0 items-center justify-center rounded-full bg-primary/10 text-[8px] font-bold text-primary mt-0.5">1</span>
                                        <span><?php echo e(__('Create your first event to start organizing photos.')); ?></span>
                                    </li>
                                    <li class="flex items-start gap-2.5 text-[11px] text-muted leading-relaxed">
                                        <span class="flex h-4 w-4 shrink-0 items-center justify-center rounded-full bg-primary/10 text-[8px] font-bold text-primary mt-0.5">2</span>
                                        <span><?php echo e(__('Upload photos via drag & drop, ZIP, or FTP.')); ?></span>
                                    </li>
                                    <li class="flex items-start gap-2.5 text-[11px] text-muted leading-relaxed">
                                        <span class="flex h-4 w-4 shrink-0 items-center justify-center rounded-full bg-primary/10 text-[8px] font-bold text-primary mt-0.5">3</span>
                                        <span><?php echo e(__('Share event links with your clients securely.')); ?></span>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <?php endif; ?>
                </nav>

                
                <div class="sidebar-brand-bottom hidden">
                    <a href="<?php echo e(route('admin.dashboard')); ?>">
                        <?php if($adminLogo): ?>
                            <img src="<?php echo e(asset('storage/' . $adminLogo)); ?>" alt="<?php echo e($brandName); ?>" class="h-8 w-auto object-contain">
                        <?php else: ?>
                            <div class="flex h-9 w-9 shrink-0 items-center justify-center rounded-xl bg-accent text-white shadow-soft">
                                <svg viewBox="0 0 24 24" class="h-5 w-5" fill="none" stroke="currentColor" stroke-width="1.8" stroke-linecap="round" stroke-linejoin="round">
                                    <circle cx="12" cy="12" r="8"></circle>
                                    <circle cx="12" cy="12" r="3"></circle>
                                    <path d="M12 4l3.5 6h-7l3.5-6z"></path>
                                </svg>
                            </div>
                        <?php endif; ?>
                    </a>
                </div>
            </aside>

            <div class="flex h-full min-h-0 flex-1 flex-col overflow-y-auto overscroll-contain" data-admin-scroll>
                <header class="sticky top-0 z-30 border-b border-border/60 bg-surface/90 backdrop-blur">
                    <div class="flex items-center justify-between gap-4 px-4 py-4 lg:px-6">
                        <div class="flex min-w-0 flex-1 items-center gap-3">
                            <button type="button" class="icon-button shrink-0 lg:hidden" data-sidebar-toggle aria-label="<?php echo e(__('Toggle sidebar')); ?>">
                                <svg viewBox="0 0 24 24" class="h-5 w-5" fill="none" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round">
                                    <path d="M4 6h16"></path>
                                    <path d="M4 12h16"></path>
                                    <path d="M4 18h16"></path>
                                </svg>
                            </button>
                            <div class="min-w-0 flex-1">
                                <p class="panel-heading hidden sm:block"><?php echo e(__('Admin Console')); ?></p>
                                <h1 class="truncate text-lg font-semibold tracking-tight sm:mt-0.5 sm:text-2xl" title="<?php echo e($title); ?>"><?php echo e($title); ?></h1>
                                <?php if($subtitle): ?>
                                    <p class="mt-0.5 hidden truncate text-xs text-muted sm:block sm:text-sm" title="<?php echo e($subtitle); ?>"><?php echo e($subtitle); ?></p>
                                <?php endif; ?>
                            </div>
                        </div>

                        <div class="flex shrink-0 items-center gap-2 sm:gap-3">
                            <div class="relative hidden items-center gap-2 rounded-xl border border-border bg-surface-2/80 px-4 py-2 text-sm text-muted md:flex" data-admin-search data-admin-search-endpoint="<?php echo e(route('admin.search')); ?>">
                                <svg viewBox="0 0 24 24" class="h-4 w-4" fill="none" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round">
                                    <circle cx="11" cy="11" r="7"></circle>
                                    <path d="M20 20l-3.5-3.5"></path>
                                </svg>
                                <input class="w-64 border-0 bg-transparent text-sm text-ink placeholder:text-muted/70 outline-none focus:outline-none focus:ring-0" type="search" placeholder="<?php echo e(__('Search people, events, uploads')); ?>" autocomplete="off" data-admin-search-input />
                                <div class="absolute left-0 right-0 top-full z-40 mt-2 hidden max-h-80 overflow-y-auto rounded-2xl border border-border bg-surface-2/95 py-2 shadow-soft" data-admin-search-results></div>
                            </div>

                            <?php if($multiLanguageEnabled && $languageOptions->isNotEmpty()): ?>
                                <form method="POST" action="<?php echo e(route('admin.locale.update')); ?>">
                                    <?php echo csrf_field(); ?>
                                    <select name="locale" aria-label="<?php echo e(__('Select language')); ?>" class="rounded-xl border border-border bg-surface-2/80 px-2 py-1.5 text-xs text-ink focus:border-brand/40 focus:outline-none sm:px-3 sm:py-2 sm:text-sm" onchange="this.form.submit()">
                                        <?php $__currentLoopData = $languageOptions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($language->code); ?>" <?php if($currentLocale === $language->code): echo 'selected'; endif; ?>><?php echo e($language->native_name ?: $language->name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </form>
                            <?php endif; ?>

                            <button type="button" class="icon-button hidden sm:inline-flex" data-fullscreen-toggle aria-label="<?php echo e(__('Toggle fullscreen')); ?>">
                                <svg viewBox="0 0 24 24" class="h-5 w-5" fill="none" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" data-fullscreen-icon="enter">
                                    <path d="M9 3H5v4"></path>
                                    <path d="M15 3h4v4"></path>
                                    <path d="M9 21H5v-4"></path>
                                    <path d="M15 21h4v-4"></path>
                                </svg>
                                <svg viewBox="0 0 24 24" class="h-5 w-5 hidden" fill="none" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" data-fullscreen-icon="exit">
                                    <path d="M9 9H5V5"></path>
                                    <path d="M15 9h4V5"></path>
                                    <path d="M9 15H5v4"></path>
                                    <path d="M15 15h4v4"></path>
                                </svg>
                            </button>

                            <button type="button" class="icon-button hidden sm:inline-flex" data-theme-toggle aria-label="<?php echo e(__('Toggle theme')); ?>">
                                <svg viewBox="0 0 24 24" class="h-5 w-5" fill="none" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" data-theme-icon="sun">
                                    <circle cx="12" cy="12" r="4"></circle>
                                    <path d="M12 3v2"></path>
                                    <path d="M12 19v2"></path>
                                    <path d="M5 5l1.5 1.5"></path>
                                    <path d="M17.5 17.5L19 19"></path>
                                    <path d="M3 12h2"></path>
                                    <path d="M19 12h2"></path>
                                    <path d="M5 19l1.5-1.5"></path>
                                    <path d="M17.5 6.5L19 5"></path>
                                </svg>
                                <svg viewBox="0 0 24 24" class="h-5 w-5 hidden" fill="none" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" data-theme-icon="moon">
                                    <path d="M21 12.5A8.5 8.5 0 1 1 11.5 3 7 7 0 0 0 21 12.5z"></path>
                                </svg>
                            </button>

                            <?php
                                $notificationChannel = '';
                                if (auth()->check()) {
                                    $notificationChannel = \Illuminate\Support\Facades\Gate::allows('viewAny', \App\Models\ActivityLog::class)
                                        ? 'admin.notifications'
                                        : 'user.' . auth()->id() . '.notifications';
                                }
                            ?>
                            <div data-notification-scope data-notification-endpoint="<?php echo e(route('admin.notifications')); ?>" data-notification-channel="<?php echo e($notificationChannel); ?>">
                                <?php if (isset($component)) { $__componentOriginaldf8083d4a852c446488d8d384bbc7cbe = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginaldf8083d4a852c446488d8d384bbc7cbe = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.dropdown','data' => ['align' => 'right','width' => 'w-[30rem] max-w-[92vw]','contentClasses' => 'py-3 bg-surface-2/95']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('dropdown'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['align' => 'right','width' => 'w-[30rem] max-w-[92vw]','content-classes' => 'py-3 bg-surface-2/95']); ?>
                                     <?php $__env->slot('trigger', null, []); ?> 
                                        <button type="button" class="icon-button relative" data-notification-toggle aria-label="<?php echo e(__('View notifications')); ?>">
                                            <svg viewBox="0 0 24 24" class="h-5 w-5" fill="none" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round">
                                                <path d="M6 9a6 6 0 0 1 12 0c0 6 2 7 2 7H4s2-1 2-7"></path>
                                                <path d="M9.5 19a2.5 2.5 0 0 0 5 0"></path>
                                            </svg>
                                            <span class="absolute -top-1 -right-1 hidden h-5 min-w-[0.25rem] items-center justify-center rounded-full bg-danger px-1 text-[10px] font-semibold text-white" data-notification-count></span>
                                        </button>
                                     <?php $__env->endSlot(); ?>

                                     <?php $__env->slot('content', null, []); ?> 
                                        <div class="flex items-center justify-between px-4 pb-2">
                                            <p class="text-xs font-semibold uppercase tracking-widest text-muted"><?php echo e(__('Live Notifications')); ?></p>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('viewAny', \App\Models\ActivityLog::class)): ?>
                                                <a href="<?php echo e(route('admin.activity-logs.index')); ?>" class="text-xs font-semibold text-brand/80 transition hover:text-brand"><?php echo e(__('View all')); ?></a>
                                            <?php else: ?>
                                                <a href="<?php echo e(route('admin.activity-logs.index', ['user' => auth()->id()])); ?>" class="text-xs font-semibold text-brand/80 transition hover:text-brand"><?php echo e(__('View all')); ?></a>
                                            <?php endif; ?>
                                        </div>
                                        <div class="max-h-80 overflow-y-auto" data-notification-list>
                                            <p class="px-4 py-3 text-sm text-muted" data-notification-empty><?php echo e(__('No notifications yet.')); ?></p>
                                        </div>
                                     <?php $__env->endSlot(); ?>
                                 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginaldf8083d4a852c446488d8d384bbc7cbe)): ?>
<?php $attributes = $__attributesOriginaldf8083d4a852c446488d8d384bbc7cbe; ?>
<?php unset($__attributesOriginaldf8083d4a852c446488d8d384bbc7cbe); ?>
<?php endif; ?>
<?php if (isset($__componentOriginaldf8083d4a852c446488d8d384bbc7cbe)): ?>
<?php $component = $__componentOriginaldf8083d4a852c446488d8d384bbc7cbe; ?>
<?php unset($__componentOriginaldf8083d4a852c446488d8d384bbc7cbe); ?>
<?php endif; ?>
                            </div>

                            <?php if (isset($component)) { $__componentOriginaldf8083d4a852c446488d8d384bbc7cbe = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginaldf8083d4a852c446488d8d384bbc7cbe = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.dropdown','data' => ['align' => 'right','width' => 'w-48 sm:w-full','contentClasses' => 'py-2 bg-surface-2/95']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('dropdown'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['align' => 'right','width' => 'w-48 sm:w-full','content-classes' => 'py-2 bg-surface-2/95']); ?>
                                 <?php $__env->slot('trigger', null, []); ?> 
                                    <button type="button" class="flex items-center gap-2 rounded-xl border border-border bg-surface-2/90 px-2 py-1.5 text-sm text-ink/80 transition hover:border-brand/40 sm:gap-3 sm:px-3 sm:py-2">
                                        <span class="flex h-8 w-8 items-center justify-center rounded-full bg-brand/20 text-brand text-sm sm:h-9 sm:w-9">
                                            <?php echo e(strtoupper(substr(auth()->user()?->name ?? 'A', 0, 1))); ?>

                                        </span>
                                        <span class="hidden text-left md:block">
                                            <div class="flex items-center gap-2">
                                                <span class="block max-w-[10rem] truncate text-sm font-semibold text-ink"><?php echo e(auth()->user()?->name ?? __('Admin')); ?></span>
                                                <span class="inline-flex items-center rounded-md bg-slate-500/10 px-1.5 py-0.5 text-[10px] font-medium text-slate-600 ring-1 ring-inset ring-slate-500/20">
                                                    <?php echo e(auth()->user()->roles->first()?->name ?? __('User')); ?>

                                                </span>
                                            </div>
                                            <div class="flex items-center gap-1.5 mt-0.5">
                                                <?php if(!auth()->user()->hasRole(['Super Admin', 'Admin'])): ?>
                                                    <span class="inline-flex items-center rounded-md bg-brand/10 px-1.5 py-0.5 text-[10px] font-medium text-brand ring-1 ring-inset ring-brand/20">
                                                        <?php echo e(auth()->user()->plan?->name ?? __('No Plan')); ?>

                                                    </span>
                                                <?php endif; ?>
                                                <span class="block max-w-[12rem] truncate text-xs text-muted"><?php echo e(auth()->user()?->email ?? 'admin@studio.local'); ?></span>
                                            </div>
                                        </span>
                                </button>
                                 <?php $__env->endSlot(); ?>

                                 <?php $__env->slot('content', null, []); ?> 
                                    <div class="px-4 pb-2">
                                        <p class="text-xs font-semibold uppercase tracking-widest text-muted"><?php echo e(__('Account')); ?></p>
                                    </div>
                                    <?php if (isset($component)) { $__componentOriginal68cb1971a2b92c9735f83359058f7108 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal68cb1971a2b92c9735f83359058f7108 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.dropdown-link','data' => ['href' => route('profile.edit')]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('dropdown-link'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['href' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(route('profile.edit'))]); ?><?php echo e(__('Profile')); ?> <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal68cb1971a2b92c9735f83359058f7108)): ?>
<?php $attributes = $__attributesOriginal68cb1971a2b92c9735f83359058f7108; ?>
<?php unset($__attributesOriginal68cb1971a2b92c9735f83359058f7108); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal68cb1971a2b92c9735f83359058f7108)): ?>
<?php $component = $__componentOriginal68cb1971a2b92c9735f83359058f7108; ?>
<?php unset($__componentOriginal68cb1971a2b92c9735f83359058f7108); ?>
<?php endif; ?>
                                    <div class="my-2 border-t border-border/60"></div>
                                    <form method="POST" action="<?php echo e(route('logout')); ?>">
                                        <?php echo csrf_field(); ?>
                                        <?php if (isset($component)) { $__componentOriginal68cb1971a2b92c9735f83359058f7108 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal68cb1971a2b92c9735f83359058f7108 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.dropdown-link','data' => ['href' => route('logout'),'onclick' => 'event.preventDefault(); this.closest(\'form\').submit();']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('dropdown-link'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['href' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(route('logout')),'onclick' => 'event.preventDefault(); this.closest(\'form\').submit();']); ?>
                                            <?php echo e(__('Log out')); ?>

                                         <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal68cb1971a2b92c9735f83359058f7108)): ?>
<?php $attributes = $__attributesOriginal68cb1971a2b92c9735f83359058f7108; ?>
<?php unset($__attributesOriginal68cb1971a2b92c9735f83359058f7108); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal68cb1971a2b92c9735f83359058f7108)): ?>
<?php $component = $__componentOriginal68cb1971a2b92c9735f83359058f7108; ?>
<?php unset($__componentOriginal68cb1971a2b92c9735f83359058f7108); ?>
<?php endif; ?>
                                    </form>
                                 <?php $__env->endSlot(); ?>
                             <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginaldf8083d4a852c446488d8d384bbc7cbe)): ?>
<?php $attributes = $__attributesOriginaldf8083d4a852c446488d8d384bbc7cbe; ?>
<?php unset($__attributesOriginaldf8083d4a852c446488d8d384bbc7cbe); ?>
<?php endif; ?>
<?php if (isset($__componentOriginaldf8083d4a852c446488d8d384bbc7cbe)): ?>
<?php $component = $__componentOriginaldf8083d4a852c446488d8d384bbc7cbe; ?>
<?php unset($__componentOriginaldf8083d4a852c446488d8d384bbc7cbe); ?>
<?php endif; ?>
                        </div>
                    </div>
                </header>

                <main class="flex-1 min-h-0 px-4 py-6 lg:px-8">
                    <?php echo e($slot); ?>

                </main>
            </div>
        </div>

        <div class="admin-overlay fixed inset-0 z-30 bg-ink/40 opacity-0 pointer-events-none transition lg:hidden" data-sidebar-overlay></div>
        <?php echo $__env->make('partials.gdpr-banner', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
        <?php if(session('status') || session('error')): ?>
            <div class="fixed bottom-6 right-6 z-50">
                <div
                    x-data="{ show: true }"
                    x-init="setTimeout(() => show = false, 3200)"
                    x-show="show"
                    x-transition
                    class="panel flex items-start gap-3 px-4 py-3 text-sm"
                >
                    <span class="mt-1 h-2.5 w-2.5 rounded-full <?php echo e(session('error') ? 'bg-danger' : 'bg-success'); ?>"></span>
                    <div>
                        <p class="font-semibold text-ink"><?php echo e(session('error') ? __('Action blocked') : __('Success')); ?></p>
                        <p class="text-muted"><?php echo e(session('error') ?? session('status')); ?></p>
                    </div>
                </div>
            </div>
        <?php endif; ?>
        <?php if(! empty($siteSettings['right_click_disable'])): ?>
            <script>
                document.addEventListener('contextmenu', function (event) {
                    event.preventDefault();
                });
            </script>
        <?php endif; ?>
        <?php echo $__env->yieldPushContent('scripts'); ?>
    </body>
</html>
<?php /**PATH /home/acehost1/public_html/photobee.acehosting.in/resources/views/layouts/admin.blade.php ENDPATH**/ ?>