<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>" dir="<?php echo e($languageDirection ?? 'ltr'); ?>" class="scroll-smooth">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <?php
        $brandName = trim((string) ($siteSettings['site_name'] ?? ''));
        $brandName = $brandName !== '' ? $brandName : config('app.name', 'SnapNest');
        $favicon = $siteSettings['favicon'] ?? null;
    ?>

    <title><?php echo $__env->yieldContent('title', $brandName); ?></title>
    <meta name="description" content="<?php echo $__env->yieldContent('meta_description', __('The smartest way for photographers to share, sell, and manage event galleries. AI Face Recognition, cloud storage, and instant delivery.')); ?>">

    <?php if($favicon): ?>
        <link rel="icon" href="<?php echo e(asset('storage/' . $favicon)); ?>">
    <?php endif; ?>

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:ital,wght@0,200..800;1,200..800&display=swap" rel="stylesheet">

    <!-- Styles -->
    <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css', 'resources/css/frontend.css', 'resources/js/app.js']); ?>
    <?php echo $__env->make('partials.extensions-head', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

    <?php if(!empty($pwaSettings['enabled'])): ?>
        <?php $config = (new \LaravelPWA\Services\ManifestService)->generate(); echo $__env->make( 'laravelpwa::meta' , ['config' => $config])->render(); ?>
    <?php endif; ?>

    <style>
        :root {
            --font-sans: 'Plus Jakarta Sans', sans-serif;
        }
    </style>
</head>
<body class="min-h-screen bg-background font-sans antialiased text-foreground">
    <div class="flex min-h-screen flex-col">
        <?php if (! empty(trim($__env->yieldContent('hide_header')))): ?>
        <?php else: ?>
            <?php echo $__env->make('components.frontend.header', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
        <?php endif; ?>

        <main class="flex-1">
            <?php echo $__env->yieldContent('content'); ?>
        </main>

        <?php if (! empty(trim($__env->yieldContent('hide_footer')))): ?>
        <?php else: ?>
            <?php echo $__env->make('components.frontend.footer', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
        <?php endif; ?>
    </div>
    <?php echo $__env->make('partials.cookie-consent', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    <?php echo $__env->make('partials.pwa-install-prompt', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    <?php echo $__env->yieldPushContent('scripts'); ?>
</body>
</html>
<?php /**PATH /home/acehost1/public_html/photobee.acehosting.in/resources/views/layouts/frontend.blade.php ENDPATH**/ ?>