<section class="py-16 md:py-32 relative overflow-hidden bg-background">
    <div class="absolute top-0 inset-x-0 h-px bg-gradient-to-r from-transparent via-primary/20 to-transparent"></div>
    <div class="absolute -top-24 left-1/2 -translate-x-1/2 w-full max-w-4xl h-64 bg-primary/5 blur-[120px] rounded-full pointer-events-none"></div>

    <div class="container mx-auto px-4 relative z-10 text-center">
            <div class="space-y-8">
                <!-- Camera icon badge -->
                <div class="flex items-center justify-center mb-4">
                    <div class="inline-flex items-center gap-2 px-4 py-2 rounded-full bg-primary/10 border border-primary/20 text-primary text-sm font-semibold">
                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M23 19a2 2 0 0 1-2 2H3a2 2 0 0 1-2-2V8a2 2 0 0 1 2-2h4l2-3h6l2 3h4a2 2 0 0 1 2 2z"/><circle cx="12" cy="13" r="4"/></svg>
                        <?php echo e(__('Built for Event Photographers')); ?>

                    </div>
                </div>

                <h2 class="text-4xl md:text-5xl lg:text-6xl font-bold tracking-tight text-balance">
                    <?php echo e(__('Create an Event Gallery.')); ?> <br />
                    <?php echo e(__('Guests Find Their Photos')); ?> <span class="italic text-primary"><?php echo e(__('by Selfie.')); ?></span>
                </h2>

                <p class="text-muted-foreground text-xl md:text-2xl max-w-3xl mx-auto leading-relaxed">
                    <?php echo e(__('Upload photos, share a link — your guests instantly find every photo they\'re in using AI face recognition. No searching, no sorting.')); ?>

                </p>

                <!-- Stats row -->
                <div class="flex flex-wrap items-center justify-center gap-8 pt-2">
                    <div class="text-center">
                        <div class="text-3xl font-bold text-foreground">AI</div>
                        <div class="text-sm text-muted-foreground mt-1"><?php echo e(__('Face Search')); ?></div>
                    </div>
                    <div class="w-px h-10 bg-border hidden sm:block"></div>
                    <div class="text-center">
                        <div class="text-3xl font-bold text-foreground">30+</div>
                        <div class="text-sm text-muted-foreground mt-1"><?php echo e(__('Payment Gateways')); ?></div>
                    </div>
                    <div class="w-px h-10 bg-border hidden sm:block"></div>
                    <div class="text-center">
                        <div class="text-3xl font-bold text-foreground">∞</div>
                        <div class="text-sm text-muted-foreground mt-1"><?php echo e(__('Events & Photos')); ?></div>
                    </div>
                </div>

                <div class="pt-4">
                    <a href="<?php echo e(url('/register')); ?>" class="inline-flex h-14 sm:h-16 px-8 sm:px-12 text-base sm:text-lg font-bold rounded-2xl shadow-2xl shadow-primary/30 transition-all hover:-translate-y-1 bg-primary hover:bg-primary/90 text-primary-foreground items-center justify-center">
                        <?php echo e(__('Create Your First Event Free')); ?>

                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="ml-2 h-6 w-6"><path d="M5 12h14"/><path d="m12 5 7 7-7 7"/></svg>
                    </a>
                    <p class="mt-6 text-sm font-bold text-muted-foreground uppercase tracking-widest"><?php echo e(__('No credit card required')); ?> &nbsp;·&nbsp; <?php echo e(__('Setup in minutes')); ?></p>
                </div>
            </div>
    </div>
</section>
<?php /**PATH /home/acehost1/public_html/photobee.acehosting.in/resources/views/components/frontend/cta.blade.php ENDPATH**/ ?>