<?php $__env->startSection('title', ($page->title ?? __('Privacy Policy')) . ' - ' . config('app.name', 'SnapNest')); ?>

<?php
    $c = $page->content ?? [];
    $sections = $c['sections'] ?? [
        ['title' => __('Information We Collect'), 'content' => __('We collect information you provide directly to us when you create an account, create a gallery, or communicate with us. This includes your name, email address, studio name, and any images you upload for the purpose of event delivery.')],
        ['title' => __('How We Use Face Search'), 'content' => __('Our Face Search technology is designed purely for one-to-many matching within your private galleries. We do not build global face databases. Biometric data is stored securely and is only used to help guests find their photos at specific events.')],
        ['title' => __('Data Security'), 'content' => __('We use industry-standard encryption and security protocols to protect your data and your clients\' images. All photos are stored on redundant, secure cloud servers with strict access controls.')],
        ['title' => __('Third-Party Sharing'), 'content' => __('We do not sell your data. We only share information with third-party services (like WhatsApp or Cloud Providers) as necessary to provide our core services and ensure the best experience for your clients.')],
    ];
    $sectionIcons = [
        '<path d="M2 12s3-7 10-7 10 7 10 7-3 7-10 7-10-7-10-7Z"/><circle cx="12" cy="12" r="3"/>',
        '<rect width="18" height="11" x="3" y="11" rx="2" ry="2"/><path d="M7 11V7a5 5 0 0 1 10 0v4"/>',
        '<path d="M12 22s8-4 8-10V5l-8-3-8 3v7c0 6 8 10 8 10"/><path d="m9 12 2 2 4-4"/>',
        '<circle cx="12" cy="12" r="10"/><path d="M12 2a14.5 14.5 0 0 0 0 20 14.5 14.5 0 0 0 0-20"/><path d="M2 12h20"/>',
    ];
?>

<?php $__env->startSection('content'); ?>
<main class="flex-1 py-32 bg-background selection:bg-primary/30">
    <div class="container mx-auto px-4">
        <div class="max-w-4xl mx-auto">
            <div
               x-data="{ shown: false }"
               x-init="setTimeout(() => shown = true, 0)"
               class="space-y-6 mb-20 text-center md:text-left transition-all duration-700 transform"
               :class="shown ? 'opacity-100 translate-y-0' : 'opacity-0 translate-y-5'">
                <h1 class="text-4xl md:text-6xl font-bold tracking-tight"><?php echo e($c['title'] ?? __('Privacy')); ?> <span class="text-primary italic"><?php echo e($c['title_highlight'] ?? __('Matters.')); ?></span></h1>
                <p class="text-xl text-muted-foreground leading-relaxed max-w-2xl">
                    <?php echo e($c['subtitle'] ?? __('We believe privacy is a fundamental human right. Here is how we protect yours and your clients\'.')); ?>

                </p>
                <div class="pt-4 flex flex-wrap gap-4 justify-center md:justify-start">
                    <div class="flex items-center gap-2 px-3 py-1 bg-muted/50 border border-border/50 rounded-full text-[10px] font-bold uppercase tracking-widest text-muted-foreground">
                        <svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-3 w-3"><path d="M14.5 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V7.5L14.5 2z"/><polyline points="14 2 14 8 20 8"/><path d="M16 13H8"/><path d="M16 17H8"/><path d="M10 9H8"/></svg> <?php echo e(__('Last Updated:')); ?> <?php echo e($c['last_updated'] ?? 'Oct 2023'); ?>

                    </div>
                    <div class="flex items-center gap-2 px-3 py-1 bg-muted/50 border border-border/50 rounded-full text-[10px] font-bold uppercase tracking-widest text-muted-foreground">
                        <svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-3 w-3"><rect width="20" height="8" x="2" y="2" rx="2" ry="2"/><rect width="20" height="8" x="2" y="14" rx="2" ry="2"/><line x1="6" x2="6.01" y1="6" y2="6"/><line x1="6" x2="6.01" y1="18" y2="18"/></svg> <?php echo e(__('GDPR Compliant')); ?>

                    </div>
                </div>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-2 gap-8">
                <?php $__currentLoopData = $sections; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $section): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div
                    x-data="{ shown: false }"
                    x-intersect="shown = true"
                    style="transition-delay: <?php echo e($index * 100); ?>ms"
                    class="p-8 rounded-[2rem] bg-card border border-border shadow-sm hover:shadow-xl transition-all group transform"
                    :class="shown ? 'opacity-100 translate-y-0' : 'opacity-0 translate-y-5'">
                    <div class="h-12 w-12 rounded-2xl bg-primary/10 border border-primary/20 flex items-center justify-center text-primary mb-6 group-hover:scale-110 transition-transform">
                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-6 w-6"><?php echo $sectionIcons[$index] ?? ''; ?></svg>
                    </div>
                    <h3 class="text-xl font-bold mb-4"><?php echo e($section['title'] ?? ''); ?></h3>
                    <p class="text-muted-foreground leading-relaxed text-sm">
                        <?php echo e($section['content'] ?? ''); ?>

                    </p>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>

            <div
               x-data="{ shown: false }"
               x-intersect="shown = true"
               class="mt-20 p-8 md:p-12 rounded-[2.5rem] bg-muted/30 border border-border/50 text-sm text-balance leading-relaxed text-muted-foreground space-y-6 transition-all duration-700 transform"
               :class="shown ? 'opacity-100' : 'opacity-0'">
                <p>
                    <?php echo e($c['bottom_paragraph_1'] ?? __('At ' . config('app.name', 'SnapNest') . ', we understand the sensitive nature of photography. Whether it is a private wedding, a high-stakes corporate gathering, or a family function, we prioritize the confidentiality and security of every image uploaded to our platform.')); ?>

                </p>
                <p>
                    <?php echo e($c['bottom_paragraph_2'] ?? __('Your images are your property. We only process them to enable the features you\'ve selected, such as face matching for instant delivery. We do not use your images for marketing purposes without explicit consent, and we provide robust tools for users to request data deletion.')); ?>

                </p>
            </div>
        </div>
    </div>
</main>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.frontend', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/acehost1/public_html/photobee.acehosting.in/resources/views/frontend/legal/privacy.blade.php ENDPATH**/ ?>