<?php
    $gdpr = $gdprSettings ?? [];
    $gdprEnabled = filter_var($gdpr['gdpr_enabled'] ?? false, FILTER_VALIDATE_BOOLEAN);
    $gdprConsentValue = $gdprConsent ?? null;

    $gdprMessage = trim((string) ($gdpr['gdpr_message'] ?? ''));
    if ($gdprMessage === '') {
        $gdprMessage = __('We use cookies to keep the admin panel secure and reliable.');
    }

    $acceptLabel = trim((string) ($gdpr['gdpr_accept_label'] ?? __('Accept')));
    $declineLabel = trim((string) ($gdpr['gdpr_decline_label'] ?? __('Decline')));
?>

<?php if($gdprEnabled && empty($gdprConsentValue)): ?>
    <div class="fixed bottom-6 left-6 z-40 hidden max-w-sm" data-gdpr-banner>
        <div class="panel space-y-4 p-5">
            <div>
                <p class="text-xs uppercase tracking-[0.2em] text-muted"><?php echo e(__('Cookie Preferences')); ?></p>
                <p class="mt-2 text-sm text-muted"><?php echo e($gdprMessage); ?></p>
            </div>
            <div class="flex flex-wrap gap-3">
                <button type="button" class="btn-primary" data-gdpr-accept><?php echo e($acceptLabel !== '' ? $acceptLabel : __('Accept')); ?></button>
                <button type="button" class="btn-secondary" data-gdpr-decline><?php echo e($declineLabel !== '' ? $declineLabel : __('Decline')); ?></button>
            </div>
        </div>
    </div>
    <script>
        (function () {
            var banner = document.querySelector('[data-gdpr-banner]');
            if (!banner) {
                return;
            }

            function getCookie(name) {
                var value = ('; ' + document.cookie).split('; ' + name + '=');
                if (value.length === 2) {
                    return value.pop().split(';').shift();
                }
                return null;
            }

            function setConsent(value) {
                var maxAge = 60 * 60 * 24 * 365;
                document.cookie = 'gdpr_consent=' + value + '; path=/; max-age=' + maxAge + '; samesite=lax';
                banner.remove();
                if (value === 'accepted') {
                    window.location.reload();
                }
            }

            if (getCookie('gdpr_consent')) {
                return;
            }

            banner.classList.remove('hidden');

            var accept = banner.querySelector('[data-gdpr-accept]');
            var decline = banner.querySelector('[data-gdpr-decline]');

            if (accept) {
                accept.addEventListener('click', function () {
                    setConsent('accepted');
                });
            }

            if (decline) {
                decline.addEventListener('click', function () {
                    setConsent('declined');
                });
            }
        })();
    </script>
<?php endif; ?>
<?php /**PATH /home/acehost1/public_html/photobee.acehosting.in/resources/views/partials/gdpr-banner.blade.php ENDPATH**/ ?>