<?php
    $gdpr = $gdprSettings ?? [];
    $gdprEnabled = filter_var($gdpr['gdpr_enabled'] ?? false, FILTER_VALIDATE_BOOLEAN);
    $gdprConsentValue = $gdprConsent ?? null;

    $gdprMessage = trim((string) ($gdpr['gdpr_message'] ?? ''));
    if ($gdprMessage === '') {
        $gdprMessage = __('We use cookies to enhance your shopping experience and analyze site traffic.');
    }

    $acceptLabel = trim((string) ($gdpr['gdpr_accept_label'] ?? ''));
    $declineLabel = trim((string) ($gdpr['gdpr_decline_label'] ?? ''));
?>

<?php if($gdprEnabled && empty($gdprConsentValue)): ?>
    <div class="fixed bottom-0 left-0 right-0 z-50 hidden" data-cookie-banner>
        <div class="border-t border-border bg-background/95 backdrop-blur-xl shadow-2xl">
            <div class="container mx-auto px-4 py-4 flex flex-col sm:flex-row items-center justify-between gap-4">
                <p class="text-sm text-muted-foreground text-center sm:text-left">
                    <?php echo e($gdprMessage); ?> <strong class="text-foreground"><?php echo e(__('Your privacy matters to us.')); ?></strong>
                </p>
                <div class="flex items-center gap-3 shrink-0">
                    <button type="button" data-cookie-decline class="h-10 px-6 rounded-xl text-sm font-bold border border-border text-foreground hover:bg-muted transition-colors">
                        <?php echo e($declineLabel !== '' ? $declineLabel : __('Decline')); ?>

                    </button>
                    <button type="button" data-cookie-accept class="h-10 px-6 rounded-xl text-sm font-bold bg-foreground text-background hover:bg-foreground/90 transition-colors">
                        <?php echo e($acceptLabel !== '' ? $acceptLabel : __('Accept All')); ?>

                    </button>
                </div>
            </div>
        </div>
    </div>
    <script>
        (function () {
            var banner = document.querySelector('[data-cookie-banner]');
            if (!banner) return;

            function getCookie(name) {
                var value = ('; ' + document.cookie).split('; ' + name + '=');
                if (value.length === 2) return value.pop().split(';').shift();
                return null;
            }

            function setConsent(value) {
                var maxAge = 60 * 60 * 24 * 365;
                document.cookie = 'gdpr_consent=' + value + '; path=/; max-age=' + maxAge + '; samesite=lax';
                banner.remove();
            }

            if (getCookie('gdpr_consent')) return;

            banner.classList.remove('hidden');

            var accept = banner.querySelector('[data-cookie-accept]');
            var decline = banner.querySelector('[data-cookie-decline]');

            if (accept) accept.addEventListener('click', function () { setConsent('accepted'); });
            if (decline) decline.addEventListener('click', function () { setConsent('declined'); });
        })();
    </script>
<?php endif; ?>
<?php /**PATH /home/acehost1/public_html/photobee.acehosting.in/resources/views/partials/cookie-consent.blade.php ENDPATH**/ ?>