<?php if (isset($component)) { $__componentOriginal91fdd17964e43374ae18c674f95cdaa3 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal91fdd17964e43374ae18c674f95cdaa3 = $attributes; } ?>
<?php $component = App\View\Components\AdminLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('admin-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\AdminLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(__('Payment Gateways')),'subtitle' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(__('Configure payment providers, credentials, and modes.'))]); ?>
    <div class="space-y-6" x-data="paymentGateways()">
        
        <div class="panel p-6">
            <div class="flex flex-wrap items-center justify-between gap-4">
                <div>
                    <p class="panel-heading"><?php echo e(__('Gateway Directory')); ?></p>
                    <p class="mt-2 text-sm text-muted"><?php echo e($gateways->count()); ?> <?php echo e(__('payment gateways available. Enable and configure the ones you need.')); ?></p>
                </div>
            </div>

            <div class="mt-5">
                <label class="sr-only" for="gateway-search"><?php echo e(__('Search gateways')); ?></label>
                <div class="relative">
                    <svg viewBox="0 0 24 24" class="absolute left-3 top-1/2 h-4 w-4 -translate-y-1/2 text-muted" fill="none" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round">
                        <circle cx="11" cy="11" r="7"></circle>
                        <path d="M20 20l-3.5-3.5"></path>
                    </svg>
                    <input
                        id="gateway-search"
                        type="search"
                        class="input-field pl-10"
                        placeholder="<?php echo e(__('Search by gateway name...')); ?>"
                        x-model="search"
                    >
                </div>
            </div>
        </div>

        
        <div class="space-y-3">
            <?php $__empty_1 = true; $__currentLoopData = $gateways; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $gateway): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <div
                    class="panel overflow-hidden"
                    x-data="{ expanded: false }"
                    x-show="! search || <?php echo e(Js::from(strtolower($gateway->name))); ?>.includes(search.toLowerCase()) || <?php echo e(Js::from(strtolower($gateway->slug))); ?>.includes(search.toLowerCase())"
                    x-transition
                >
                    
                    <div class="flex items-center justify-between gap-4 px-6 py-4">
                        <button
                            type="button"
                            class="flex min-w-0 flex-1 items-center gap-4 text-left"
                            @click="expanded = !expanded"
                        >
                            <div class="flex h-10 w-10 shrink-0 items-center justify-center rounded-xl bg-surface-2/70 text-muted">
                                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.8" stroke-linecap="round" stroke-linejoin="round"><rect width="20" height="14" x="2" y="5" rx="2"/><line x1="2" x2="22" y1="10" y2="10"/></svg>
                            </div>
                            <div class="min-w-0 flex-1">
                                <div class="flex items-center gap-2">
                                    <p class="truncate font-semibold text-ink"><?php echo e($gateway->name); ?></p>
                                    <?php if($gateway->is_active): ?>
                                        <span class="inline-flex items-center rounded-md bg-emerald-500/10 px-2 py-0.5 text-[11px] font-medium text-emerald-600 ring-1 ring-inset ring-emerald-500/20"><?php echo e(__('Active')); ?></span>
                                    <?php else: ?>
                                        <span class="inline-flex items-center rounded-md bg-slate-500/10 px-2 py-0.5 text-[11px] font-medium text-slate-500 ring-1 ring-inset ring-slate-500/20"><?php echo e(__('Inactive')); ?></span>
                                    <?php endif; ?>
                                    <?php if($gateway->mode === 'sandbox'): ?>
                                        <span class="inline-flex items-center rounded-md bg-amber-500/10 px-2 py-0.5 text-[11px] font-medium text-amber-600 ring-1 ring-inset ring-amber-500/20"><?php echo e(__('Sandbox')); ?></span>
                                    <?php else: ?>
                                        <span class="inline-flex items-center rounded-md bg-blue-500/10 px-2 py-0.5 text-[11px] font-medium text-blue-600 ring-1 ring-inset ring-blue-500/20"><?php echo e(__('Live')); ?></span>
                                    <?php endif; ?>
                                </div>
                                <?php if($gateway->description): ?>
                                    <p class="mt-0.5 truncate text-xs text-muted"><?php echo e($gateway->description); ?></p>
                                <?php endif; ?>
                                <?php if(! empty($gateway->supported_currencies)): ?>
                                    <div class="mt-1 flex flex-wrap gap-1">
                                        <?php $__currentLoopData = array_slice($gateway->supported_currencies, 0, 6); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cur): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <span class="inline-flex items-center rounded bg-surface-2/70 px-1.5 py-0.5 text-[10px] font-medium text-muted"><?php echo e($cur); ?></span>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php if(count($gateway->supported_currencies) > 6): ?>
                                            <span class="inline-flex items-center rounded bg-surface-2/70 px-1.5 py-0.5 text-[10px] font-medium text-muted">+<?php echo e(count($gateway->supported_currencies) - 6); ?> <?php echo e(__('more')); ?></span>
                                        <?php endif; ?>
                                    </div>
                                <?php elseif(in_array($gateway->slug, ['bank_transfer', 'offline'])): ?>
                                    <div class="mt-1">
                                        <span class="inline-flex items-center rounded bg-surface-2/70 px-1.5 py-0.5 text-[10px] font-medium text-muted"><?php echo e(__('All currencies')); ?></span>
                                    </div>
                                <?php endif; ?>
                            </div>
                            <svg
                                viewBox="0 0 24 24"
                                class="h-5 w-5 shrink-0 text-muted transition-transform duration-200"
                                :class="expanded && 'rotate-180'"
                                fill="none" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round"
                            >
                                <path d="M6 9l6 6 6-6"></path>
                            </svg>
                        </button>

                        
                        <form method="POST" action="<?php echo e(route('admin.payment-gateways.toggle', $gateway)); ?>" class="shrink-0">
                            <?php echo csrf_field(); ?>
                            <label class="inline-flex cursor-pointer items-center gap-2 text-sm text-muted">
                                <button type="submit" class="relative inline-flex h-6 w-11 items-center rounded-full transition <?php echo e($gateway->is_active ? 'bg-brand' : 'bg-border'); ?>" title="<?php echo e($gateway->is_active ? __('Click to disable') : __('Click to enable')); ?>">
                                    <span class="inline-block h-5 w-5 rounded-full bg-white shadow transition" style="transform: translateX(<?php echo e($gateway->is_active ? '1.25rem' : '0.125rem'); ?>)"></span>
                                </button>
                            </label>
                        </form>
                    </div>

                    
                    <div x-show="expanded" x-collapse>
                        <div class="border-t border-border/60 px-6 py-6">
                            <form method="POST" action="<?php echo e(route('admin.payment-gateways.update', $gateway)); ?>" class="space-y-6">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('PUT'); ?>

                                
                                <div class="panel p-5">
                                    <p class="panel-heading"><?php echo e(__('Environment')); ?></p>
                                    <div class="mt-4 grid gap-4 lg:grid-cols-2">
                                        <div>
                                            <?php if (isset($component)) { $__componentOriginale3da9d84bb64e4bc2eeebaafabfb2581 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginale3da9d84bb64e4bc2eeebaafabfb2581 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.input-label','data' => ['for' => 'mode_'.e($gateway->id).'','value' => __('Mode')]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('input-label'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['for' => 'mode_'.e($gateway->id).'','value' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(__('Mode'))]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginale3da9d84bb64e4bc2eeebaafabfb2581)): ?>
<?php $attributes = $__attributesOriginale3da9d84bb64e4bc2eeebaafabfb2581; ?>
<?php unset($__attributesOriginale3da9d84bb64e4bc2eeebaafabfb2581); ?>
<?php endif; ?>
<?php if (isset($__componentOriginale3da9d84bb64e4bc2eeebaafabfb2581)): ?>
<?php $component = $__componentOriginale3da9d84bb64e4bc2eeebaafabfb2581; ?>
<?php unset($__componentOriginale3da9d84bb64e4bc2eeebaafabfb2581); ?>
<?php endif; ?>
                                            <select id="mode_<?php echo e($gateway->id); ?>" name="mode" class="input-field mt-1">
                                                <option value="sandbox" <?php if($gateway->mode === 'sandbox'): echo 'selected'; endif; ?>><?php echo e(__('Sandbox / Test')); ?></option>
                                                <option value="live" <?php if($gateway->mode === 'live'): echo 'selected'; endif; ?>><?php echo e(__('Live / Production')); ?></option>
                                            </select>
                                        </div>
                                    </div>
                                </div>

                                
                                <?php if(! empty($gateway->supported_currencies)): ?>
                                    <div class="panel p-5">
                                        <p class="panel-heading"><?php echo e(__('Supported Currencies')); ?></p>
                                        <div class="mt-3 flex flex-wrap gap-1.5">
                                            <?php $__currentLoopData = $gateway->supported_currencies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cur): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <span class="inline-flex items-center rounded-lg bg-surface-2/70 px-2.5 py-1 text-xs font-medium text-ink ring-1 ring-inset ring-border/40"><?php echo e($cur); ?></span>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </div>
                                    </div>
                                <?php elseif(in_array($gateway->slug, ['bank_transfer', 'offline'])): ?>
                                    <div class="panel p-5">
                                        <p class="panel-heading"><?php echo e(__('Supported Currencies')); ?></p>
                                        <p class="mt-2 text-sm text-muted"><?php echo e(__('Accepts all currencies (manual verification by admin).')); ?></p>
                                    </div>
                                <?php endif; ?>

                                
                                <?php if(count($gateway->credentialFields) > 0): ?>
                                    <div class="panel p-5">
                                        <p class="panel-heading"><?php echo e(__('Credentials')); ?></p>
                                        <div class="mt-4 grid gap-4 lg:grid-cols-2">
                                            <?php $__currentLoopData = $gateway->credentialFields; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $field): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <div>
                                                    <?php if (isset($component)) { $__componentOriginale3da9d84bb64e4bc2eeebaafabfb2581 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginale3da9d84bb64e4bc2eeebaafabfb2581 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.input-label','data' => ['for' => 'cred_'.e($gateway->id).'_'.e($field['key']).'','value' => __($field['label'])]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('input-label'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['for' => 'cred_'.e($gateway->id).'_'.e($field['key']).'','value' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(__($field['label']))]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginale3da9d84bb64e4bc2eeebaafabfb2581)): ?>
<?php $attributes = $__attributesOriginale3da9d84bb64e4bc2eeebaafabfb2581; ?>
<?php unset($__attributesOriginale3da9d84bb64e4bc2eeebaafabfb2581); ?>
<?php endif; ?>
<?php if (isset($__componentOriginale3da9d84bb64e4bc2eeebaafabfb2581)): ?>
<?php $component = $__componentOriginale3da9d84bb64e4bc2eeebaafabfb2581; ?>
<?php unset($__componentOriginale3da9d84bb64e4bc2eeebaafabfb2581); ?>
<?php endif; ?>
                                                    <?php if(($field['type'] ?? 'text') === 'password'): ?>
                                                        <div class="relative mt-1">
                                                            <input
                                                                id="cred_<?php echo e($gateway->id); ?>_<?php echo e($field['key']); ?>"
                                                                name="credentials[<?php echo e($field['key']); ?>]"
                                                                type="password"
                                                                class="input-field pr-12"
                                                                autocomplete="new-password"
                                                                placeholder="<?php echo e(! empty($gateway->decryptedCredentials[$field['key']]) ? str_repeat("\u{2022}", 8) : ''); ?>"
                                                            />
                                                            <button
                                                                type="button"
                                                                class="absolute inset-y-0 right-3 flex items-center text-muted/70 transition hover:text-ink"
                                                                onclick="
                                                                    const inp = document.getElementById('cred_<?php echo e($gateway->id); ?>_<?php echo e($field['key']); ?>');
                                                                    inp.type = inp.type === 'password' ? 'text' : 'password';
                                                                "
                                                                aria-label="Toggle visibility"
                                                            >
                                                                <svg viewBox="0 0 24 24" class="h-5 w-5" fill="none" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round">
                                                                    <path d="M2 12s3.5-6 10-6 10 6 10 6-3.5 6-10 6-10-6-10-6z"></path>
                                                                    <circle cx="12" cy="12" r="3"></circle>
                                                                </svg>
                                                            </button>
                                                        </div>
                                                        <?php if(! empty($gateway->decryptedCredentials[$field['key']])): ?>
                                                            <p class="mt-1 text-xs text-muted"><?php echo e(__('Saved (hidden). Leave blank to keep current value.')); ?></p>
                                                        <?php endif; ?>
                                                    <?php elseif(($field['type'] ?? 'text') === 'textarea'): ?>
                                                        <textarea
                                                            id="cred_<?php echo e($gateway->id); ?>_<?php echo e($field['key']); ?>"
                                                            name="credentials[<?php echo e($field['key']); ?>]"
                                                            rows="4"
                                                            class="input-field mt-1"
                                                            data-no-wysiwyg
                                                        ><?php echo e(old('credentials.' . $field['key'], $gateway->decryptedCredentials[$field['key']] ?? '')); ?></textarea>
                                                    <?php elseif(($field['type'] ?? 'text') === 'select'): ?>
                                                        <select
                                                            id="cred_<?php echo e($gateway->id); ?>_<?php echo e($field['key']); ?>"
                                                            name="credentials[<?php echo e($field['key']); ?>]"
                                                            class="input-field mt-1"
                                                        >
                                                            <?php $__currentLoopData = ($field['options'] ?? []); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $optVal => $optLabel): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <option value="<?php echo e($optVal); ?>" <?php if(old('credentials.' . $field['key'], $gateway->decryptedCredentials[$field['key']] ?? '') === (string) $optVal): echo 'selected'; endif; ?>><?php echo e($optLabel); ?></option>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </select>
                                                    <?php else: ?>
                                                        <input
                                                            id="cred_<?php echo e($gateway->id); ?>_<?php echo e($field['key']); ?>"
                                                            name="credentials[<?php echo e($field['key']); ?>]"
                                                            type="text"
                                                            class="input-field mt-1"
                                                            value="<?php echo e(old('credentials.' . $field['key'], $gateway->decryptedCredentials[$field['key']] ?? '')); ?>"
                                                            <?php if(! empty($field['placeholder'])): ?> placeholder="<?php echo e($field['placeholder']); ?>" <?php endif; ?>
                                                        />
                                                    <?php endif; ?>
                                                    <?php if(! empty($field['hint'])): ?>
                                                        <p class="mt-1 text-xs text-muted"><?php echo e($field['hint']); ?></p>
                                                    <?php endif; ?>
                                                </div>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </div>
                                    </div>
                                <?php else: ?>
                                    <div class="rounded-2xl border border-dashed border-border/70 bg-surface-2/70 p-6 text-center text-sm text-muted">
                                        <?php echo e(__('No driver class found for')); ?> <span class="font-semibold text-ink"><?php echo e($gateway->slug); ?></span>. <?php echo e(__('Create')); ?> <code class="rounded bg-surface-2 px-1.5 py-0.5 text-xs font-mono">App\Services\Payment\Drivers\<?php echo e(\Illuminate\Support\Str::studly($gateway->slug)); ?>Driver</code> <?php echo e(__('with a static')); ?> <code class="rounded bg-surface-2 px-1.5 py-0.5 text-xs font-mono">credentialFields()</code> <?php echo e(__('method to configure credentials here.')); ?>

                                    </div>
                                <?php endif; ?>

                                
                                <div class="flex justify-end">
                                    <button type="submit" class="btn-primary"><?php echo e(__('Save')); ?> <?php echo e($gateway->name); ?></button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <div class="panel p-6 text-center">
                    <p class="text-sm text-muted"><?php echo e(__('No payment gateways found. Run the database seeder to populate gateways.')); ?></p>
                </div>
            <?php endif; ?>
        </div>
    </div>

    <?php $__env->startPush('scripts'); ?>
    <script>
        function paymentGateways() {
            return {
                search: '',
            };
        }
    </script>
    <?php $__env->stopPush(); ?>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal91fdd17964e43374ae18c674f95cdaa3)): ?>
<?php $attributes = $__attributesOriginal91fdd17964e43374ae18c674f95cdaa3; ?>
<?php unset($__attributesOriginal91fdd17964e43374ae18c674f95cdaa3); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal91fdd17964e43374ae18c674f95cdaa3)): ?>
<?php $component = $__componentOriginal91fdd17964e43374ae18c674f95cdaa3; ?>
<?php unset($__componentOriginal91fdd17964e43374ae18c674f95cdaa3); ?>
<?php endif; ?>
<?php /**PATH /home/acehost1/public_html/photobee.acehosting.in/resources/views/admin/payment-gateways/index.blade.php ENDPATH**/ ?>