<?php
    $footerPages = \App\Models\Page::where('is_active', true)->orderBy('title')->get();

    // Split pages into two columns: "Pages" (about, contact, other) and "Legal" (policies, terms)
    $legalTypes = ['privacy_policy', 'terms', 'cookie_policy'];
    $legalPages = $footerPages->whereIn('type', $legalTypes);
    $generalPages = $footerPages->whereNotIn('type', $legalTypes);

    // Map page types to URLs
    $pageUrl = function($page) {
        return match($page->type) {
            'about' => route('about'),
            'contact' => route('contact'),
            'privacy_policy' => route('legal.privacy'),
            'terms' => route('legal.terms'),
            'cookie_policy' => route('legal.cookies'),
            default => route('page.show', $page->slug),
        };
    };
?>
<footer class="relative bg-background border-t border-border/50 pt-24 pb-12 overflow-hidden">
    <!-- Decorative background elements -->
    <div class="absolute bottom-0 left-0 w-full h-[500px] bg-gradient-to-t from-primary/5 to-transparent pointer-events-none -z-10"></div>
    <div class="absolute top-0 right-0 w-[400px] h-[400px] bg-primary/5 blur-[120px] rounded-full -z-10"></div>

    <div class="container mx-auto px-4">
        <div class="grid grid-cols-1 lg:grid-cols-12 gap-16 mb-20">
            <!-- Brand Identity Section -->
            <div class="lg:col-span-4 space-y-8">
                <a href="<?php echo e(url('/')); ?>" class="inline-block transition-transform hover:scale-105">
                     <?php echo $__env->make('components.frontend.logo', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                </a>
                <p class="text-muted-foreground text-lg leading-relaxed max-w-sm">
                    <?php echo e(__('The professional choice for instant event delivery.')); ?>

                    <?php echo e(__('Built for photographers who value speed, privacy, and impeccable client experience.')); ?>

                </p>
                <?php $socials = $footerSettings['footer_social'] ?? []; ?>
                <div class="flex items-center gap-4">
                    <?php if(!empty($socials['instagram'])): ?>
                    <a href="<?php echo e($socials['instagram']); ?>" target="_blank" rel="noopener noreferrer" class="h-10 w-10 rounded-xl bg-muted/50 border border-border/50 flex items-center justify-center text-muted-foreground hover:bg-primary hover:text-primary-foreground hover:border-primary transition-all group">
                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-5 w-5 transition-transform group-hover:scale-110"><rect width="20" height="20" x="2" y="2" rx="5" ry="5"/><path d="M16 11.37A4 4 0 1 1 12.63 8 4 4 0 0 1 16 11.37z"/><line x1="17.5" x2="17.51" y1="6.5" y2="6.5"/></svg>
                    </a>
                    <?php endif; ?>
                    <?php if(!empty($socials['x'])): ?>
                    <a href="<?php echo e($socials['x']); ?>" target="_blank" rel="noopener noreferrer" class="h-10 w-10 rounded-xl bg-muted/50 border border-border/50 flex items-center justify-center text-muted-foreground hover:bg-primary hover:text-primary-foreground hover:border-primary transition-all group">
                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="currentColor" class="h-5 w-5 transition-transform group-hover:scale-110"><path d="M18.244 2.25h3.308l-7.227 8.26 8.502 11.24H16.17l-5.214-6.817L4.99 21.75H1.68l7.73-8.835L1.254 2.25H8.08l4.713 6.231zm-1.161 17.52h1.833L7.084 4.126H5.117z"/></svg>
                    </a>
                    <?php endif; ?>
                    <?php if(!empty($socials['linkedin'])): ?>
                    <a href="<?php echo e($socials['linkedin']); ?>" target="_blank" rel="noopener noreferrer" class="h-10 w-10 rounded-xl bg-muted/50 border border-border/50 flex items-center justify-center text-muted-foreground hover:bg-primary hover:text-primary-foreground hover:border-primary transition-all group">
                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-5 w-5 transition-transform group-hover:scale-110"><path d="M16 8a6 6 0 0 1 6 6v7h-4v-7a2 2 0 0 0-2-2 2 2 0 0 0-2 2v7h-4v-7a6 6 0 0 1 6-6z"/><rect width="4" height="12" x="2" y="9"/><circle cx="4" cy="4" r="2"/></svg>
                    </a>
                    <?php endif; ?>
                    <?php if(!empty($socials['facebook'])): ?>
                    <a href="<?php echo e($socials['facebook']); ?>" target="_blank" rel="noopener noreferrer" class="h-10 w-10 rounded-xl bg-muted/50 border border-border/50 flex items-center justify-center text-muted-foreground hover:bg-primary hover:text-primary-foreground hover:border-primary transition-all group">
                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-5 w-5 transition-transform group-hover:scale-110"><path d="M18 2h-3a5 5 0 0 0-5 5v3H7v4h3v8h4v-8h3l1-4h-4V7a1 1 0 0 1 1-1h3z"/></svg>
                    </a>
                    <?php endif; ?>
                    <?php if(!empty($socials['whatsapp'])): ?>
                    <a href="<?php echo e($socials['whatsapp']); ?>" target="_blank" rel="noopener noreferrer" class="h-10 w-10 rounded-xl bg-muted/50 border border-border/50 flex items-center justify-center text-muted-foreground hover:bg-primary hover:text-primary-foreground hover:border-primary transition-all group">
                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="currentColor" class="h-5 w-5 transition-transform group-hover:scale-110"><path d="M17.472 14.382c-.297-.149-1.758-.867-2.03-.967-.273-.099-.471-.148-.67.15-.197.297-.767.966-.94 1.164-.173.199-.347.223-.644.075-.297-.15-1.255-.463-2.39-1.475-.883-.788-1.48-1.761-1.653-2.059-.173-.297-.018-.458.13-.606.134-.133.298-.347.446-.52.149-.174.198-.298.298-.497.099-.198.05-.371-.025-.52-.075-.149-.669-1.612-.916-2.207-.242-.579-.487-.5-.669-.51-.173-.008-.371-.01-.57-.01-.198 0-.52.074-.792.372-.272.297-1.04 1.016-1.04 2.479 0 1.462 1.065 2.875 1.213 3.074.149.198 2.096 3.2 5.077 4.487.709.306 1.262.489 1.694.625.712.227 1.36.195 1.871.118.571-.085 1.758-.719 2.006-1.413.248-.694.248-1.289.173-1.413-.074-.124-.272-.198-.57-.347m-5.421 7.403h-.004a9.87 9.87 0 01-5.031-1.378l-.361-.214-3.741.982.998-3.648-.235-.374a9.86 9.86 0 01-1.51-5.26c.001-5.45 4.436-9.884 9.888-9.884 2.64 0 5.122 1.03 6.988 2.898a9.825 9.825 0 012.893 6.994c-.003 5.45-4.437 9.884-9.885 9.884m8.413-18.297A11.815 11.815 0 0012.05 0C5.495 0 .16 5.335.157 11.892c0 2.096.547 4.142 1.588 5.945L.057 24l6.305-1.654a11.882 11.882 0 005.683 1.448h.005c6.554 0 11.89-5.335 11.893-11.893a11.821 11.821 0 00-3.48-8.413z"/></svg>
                    </a>
                    <?php endif; ?>
                </div>
            </div>

            <!-- Navigation Columns -->
            <div class="lg:col-span-4 grid grid-cols-2 gap-8">
                <div class="space-y-6">
                    <h3 class="text-xs font-bold uppercase tracking-[0.2em] text-foreground"><?php echo e(__('Pages')); ?></h3>
                    <ul class="space-y-4">
                        <?php $__empty_1 = true; $__currentLoopData = $generalPages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $page): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <li>
                            <a href="<?php echo e($pageUrl($page)); ?>" class="text-sm font-medium text-muted-foreground hover:text-primary transition-colors flex items-center group">
                                <span class="h-px w-0 bg-primary mr-0 group-hover:w-3 group-hover:mr-2 transition-all"></span>
                                <?php echo e($page->title); ?>

                            </a>
                        </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <li>
                            <a href="<?php echo e(url('/about')); ?>" class="text-sm font-medium text-muted-foreground hover:text-primary transition-colors flex items-center group">
                                <span class="h-px w-0 bg-primary mr-0 group-hover:w-3 group-hover:mr-2 transition-all"></span>
                                <?php echo e(__('About Us')); ?>

                            </a>
                        </li>
                        <li>
                            <a href="<?php echo e(url('/contact')); ?>" class="text-sm font-medium text-muted-foreground hover:text-primary transition-colors flex items-center group">
                                <span class="h-px w-0 bg-primary mr-0 group-hover:w-3 group-hover:mr-2 transition-all"></span>
                                <?php echo e(__('Contact Us')); ?>

                            </a>
                        </li>
                        <?php endif; ?>
                        <li>
                            <a href="<?php echo e(route('features')); ?>" class="text-sm font-medium text-muted-foreground hover:text-primary transition-colors flex items-center group">
                                <span class="h-px w-0 bg-primary mr-0 group-hover:w-3 group-hover:mr-2 transition-all"></span>
                                <?php echo e(__('Features')); ?>

                            </a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('pricing')); ?>" class="text-sm font-medium text-muted-foreground hover:text-primary transition-colors flex items-center group">
                                <span class="h-px w-0 bg-primary mr-0 group-hover:w-3 group-hover:mr-2 transition-all"></span>
                                <?php echo e(__('Pricing')); ?>

                            </a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('blog.index')); ?>" class="text-sm font-medium text-muted-foreground hover:text-primary transition-colors flex items-center group">
                                <span class="h-px w-0 bg-primary mr-0 group-hover:w-3 group-hover:mr-2 transition-all"></span>
                                <?php echo e(__('Blog')); ?>

                            </a>
                        </li>
                    </ul>
                </div>
                <div class="space-y-6">
                    <h3 class="text-xs font-bold uppercase tracking-[0.2em] text-foreground"><?php echo e(__('Legal')); ?></h3>
                    <ul class="space-y-4">
                        <?php $__empty_1 = true; $__currentLoopData = $legalPages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $page): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <li>
                            <a href="<?php echo e($pageUrl($page)); ?>" class="text-sm font-medium text-muted-foreground hover:text-primary transition-colors flex items-center group">
                                <span class="h-px w-0 bg-primary mr-0 group-hover:w-3 group-hover:mr-2 transition-all"></span>
                                <?php echo e($page->title); ?>

                            </a>
                        </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <li>
                            <a href="<?php echo e(url('/legal/privacy')); ?>" class="text-sm font-medium text-muted-foreground hover:text-primary transition-colors flex items-center group">
                                <span class="h-px w-0 bg-primary mr-0 group-hover:w-3 group-hover:mr-2 transition-all"></span>
                                <?php echo e(__('Privacy Policy')); ?>

                            </a>
                        </li>
                        <li>
                            <a href="<?php echo e(url('/legal/terms')); ?>" class="text-sm font-medium text-muted-foreground hover:text-primary transition-colors flex items-center group">
                                <span class="h-px w-0 bg-primary mr-0 group-hover:w-3 group-hover:mr-2 transition-all"></span>
                                <?php echo e(__('Terms of Service')); ?>

                            </a>
                        </li>
                        <?php endif; ?>
                    </ul>
                </div>
            </div>

            <!-- Newsletter / CTA Section -->
            <div class="lg:col-span-4 lg:pl-8">
                <div class="p-8 rounded-[2rem] bg-muted/30 border border-border/50 relative overflow-hidden group" x-data="newsletterForm()">
                    <div class="relative z-10 space-y-6">
                        <div class="space-y-2">
                            <h3 class="text-xl font-bold tracking-tight"><?php echo e(__('Stay Ahead of the Curve')); ?></h3>
                            <p class="text-sm text-muted-foreground"><?php echo e(__('Get tips from elite photographers on scaling your studio business.')); ?></p>
                        </div>

                        <!-- Success message -->
                        <div x-show="success" x-transition x-cloak class="flex items-center gap-3 p-4 rounded-xl bg-emerald-500/10 border border-emerald-500/20">
                            <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="text-emerald-500 shrink-0"><path d="M20 6 9 17l-5-5"/></svg>
                            <p class="text-sm font-medium text-emerald-600 dark:text-emerald-400" x-text="message"></p>
                        </div>

                        <!-- Form -->
                        <form x-show="!success" @submit.prevent="subscribe" class="space-y-3">
                            <div class="relative">
                                <input
                                    type="email"
                                    x-model="email"
                                    placeholder="<?php echo e(__('studio@example.com')); ?>"
                                    required
                                    class="w-full bg-background/50 h-12 rounded-xl border-border/50 focus:border-primary px-4 transition-all outline-none border focus:ring-1 focus:ring-primary"
                                    :disabled="loading"
                                />
                            </div>
                            <p x-show="error" x-text="message" class="text-sm text-red-500 font-medium"></p>
                            <button type="submit" :disabled="loading" class="w-full h-12 rounded-xl font-bold bg-primary hover:bg-primary/90 text-primary-foreground shadow-lg shadow-primary/20 flex items-center justify-center transition-all disabled:opacity-50">
                                <template x-if="loading">
                                    <svg class="animate-spin h-5 w-5 mr-2" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"><circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle><path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path></svg>
                                </template>
                                <span x-text="loading ? 'Subscribing...' : 'Join the Inner Circle'"></span>
                                <svg x-show="!loading" xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="ml-2 h-4 w-4"><path d="M5 12h14"/><path d="m12 5 7 7-7 7"/></svg>
                            </button>
                        </form>
                    </div>
                    <div class="absolute top-0 right-0 -mr-8 -mt-8 h-32 w-32 bg-primary/5 blur-3xl rounded-full"></div>
                </div>
            </div>
        </div>

        <!-- Footer Bottom Wrapper -->
        <div class="pt-12 border-t border-border/50">
            <div class="flex flex-wrap justify-center items-center gap-x-6 gap-y-3 text-center">
                <p class="text-sm text-muted-foreground font-medium">
                    &copy; <?php echo e(date('Y')); ?> <?php echo e(trim($siteSettings['site_name'] ?? '') ?: config('app.name', 'SnapNest')); ?>

                </p>
                <div class="h-4 w-px bg-border hidden sm:block"></div>
                <div class="flex items-center gap-2 cursor-default">
                    <div class="h-2 w-2 rounded-full bg-emerald-500 animate-pulse"></div>
                    <span class="text-[10px] font-bold uppercase tracking-widest text-emerald-500/80"><?php echo e(__('All Systems Operational')); ?></span>
                </div>
                <div class="h-4 w-px bg-border hidden sm:block"></div>
                <div class="flex items-center gap-2 text-[11px] font-bold uppercase tracking-[0.15em] text-muted-foreground">
                    <svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-3 w-3"><circle cx="12" cy="12" r="10"/><path d="M12 2a14.5 14.5 0 0 0 0 20 14.5 14.5 0 0 0 0-20"/><path d="M2 12h20"/></svg>
                    <span><?php echo e(__('Global')); ?></span>
                </div>
                <div class="flex items-center gap-2 text-[11px] font-bold uppercase tracking-[0.15em] text-muted-foreground">
                    <svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="h-3 w-3"><path d="M20 13c0 5-3.5 7.5-7.66 8.95a1 1 0 0 1-.67-.01C7.5 20.5 4 18 4 13V6a1 1 0 0 1 1-1c2 0 4.5-1.2 6.24-2.72a1.17 1.17 0 0 1 1.52 0C14.51 3.81 17 5 19 5a1 1 0 0 1 1 1z"/><path d="m9 12 2 2 4-4"/></svg>
                    <span><?php echo e(__('Secure')); ?></span>
                </div>
            </div>
        </div>
    </div>
</footer>

<script>
function newsletterForm() {
    return {
        email: '',
        loading: false,
        success: false,
        error: false,
        message: '',
        async subscribe() {
            this.loading = true;
            this.error = false;
            this.message = '';
            try {
                const res = await fetch('<?php echo e(route("newsletter.subscribe")); ?>', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content,
                        'Accept': 'application/json',
                    },
                    body: JSON.stringify({ email: this.email }),
                });
                const data = await res.json();
                if (res.ok && data.success) {
                    this.success = true;
                    this.message = data.message;
                } else {
                    this.error = true;
                    this.message = data.message || (data.errors?.email?.[0]) || 'Something went wrong.';
                }
            } catch (e) {
                this.error = true;
                this.message = 'Network error. Please try again.';
            } finally {
                this.loading = false;
            }
        }
    };
}
</script>
<?php /**PATH /home/acehost1/public_html/photobee.acehosting.in/resources/views/components/frontend/footer.blade.php ENDPATH**/ ?>