<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Bigquery;

class CloneDefinition extends \Google\Model
{
  protected $baseTableReferenceType = TableReference::class;
  protected $baseTableReferenceDataType = '';
  /**
   * Required. The time at which the base table was cloned. This value is
   * reported in the JSON response using RFC3339 format.
   *
   * @var string
   */
  public $cloneTime;

  /**
   * Required. Reference describing the ID of the table that was cloned.
   *
   * @param TableReference $baseTableReference
   */
  public function setBaseTableReference(TableReference $baseTableReference)
  {
    $this->baseTableReference = $baseTableReference;
  }
  /**
   * @return TableReference
   */
  public function getBaseTableReference()
  {
    return $this->baseTableReference;
  }
  /**
   * Required. The time at which the base table was cloned. This value is
   * reported in the JSON response using RFC3339 format.
   *
   * @param string $cloneTime
   */
  public function setCloneTime($cloneTime)
  {
    $this->cloneTime = $cloneTime;
  }
  /**
   * @return string
   */
  public function getCloneTime()
  {
    return $this->cloneTime;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(CloneDefinition::class, 'Google_Service_Bigquery_CloneDefinition');
